/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.soap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.zclient.ZClientException;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Signature;
import com.zimbra.cs.account.soap.SoapEntry;
import com.zimbra.cs.account.soap.SoapProvisioning;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SoapSignature
extends Signature
implements SoapEntry {
    SoapSignature(Account acct, String name, String id, Map<String, Object> attrs, Provisioning prov) {
        super(acct, name, id, attrs, prov);
    }

    SoapSignature(Account acct, Element e, Provisioning prov) throws ServiceException {
        super(acct, e.getAttribute("name"), e.getAttribute("id"), SoapSignature.fromXML(e), prov);
    }

    @Override
    public void modifyAttrs(SoapProvisioning prov, Map<String, ? extends Object> attrs, boolean checkImmutable) throws ServiceException {
    }

    @Override
    public void reload(SoapProvisioning prov) throws ServiceException {
    }

    public static void toXML(Element signature, Map<String, Object> attrs) throws ServiceException {
        for (Map.Entry<String, Object> entry : attrs.entrySet()) {
            String attr = entry.getKey();
            String value = (String)entry.getValue();
            if (attr.equals("zimbraSignatureId") && !StringUtil.isNullOrEmpty(value)) {
                signature.addAttribute("id", value);
                continue;
            }
            if (attr.equals("zimbraSignatureName") && !StringUtil.isNullOrEmpty(value)) {
                signature.addAttribute("name", value);
                continue;
            }
            String mimeType = Signature.attrNameToMimeType(attr);
            if (mimeType == null) {
                throw ZClientException.CLIENT_ERROR("invalid attr: " + attr, null);
            }
            signature.addElement("content").addAttribute("type", mimeType).addText(value);
        }
    }

    private static Map<String, Object> fromXML(Element signature) throws ServiceException {
        List<Element> contents = signature.listElements("content");
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("zimbraSignatureId", signature.getAttribute("id"));
        attrs.put("zimbraSignatureName", signature.getAttribute("name"));
        for (Element eContent : contents) {
            String type = eContent.getAttribute("type");
            String attr = Signature.mimeTypeToAttrName(type);
            if (attr == null) continue;
            attrs.put(attr, eContent.getText());
        }
        return attrs;
    }

    @Override
    public Account getAccount() throws ServiceException {
        throw ServiceException.INVALID_REQUEST("unsupported, use getAccount(Provisioning)", null);
    }
}

