/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.soap;

import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AccountConstants;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.common.soap.SoapHttpTransport;
import com.zimbra.common.soap.SoapTransport;
import com.zimbra.common.util.AccountLogger;
import com.zimbra.common.util.CliUtil;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.zclient.ZClientException;
import com.zimbra.cs.account.AccessManager;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.CalendarResource;
import com.zimbra.cs.account.Config;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.EntrySearchFilter;
import com.zimbra.cs.account.GalContact;
import com.zimbra.cs.account.GlobalGrant;
import com.zimbra.cs.account.Identity;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.ShareInfoData;
import com.zimbra.cs.account.Signature;
import com.zimbra.cs.account.XMPPComponent;
import com.zimbra.cs.account.Zimlet;
import com.zimbra.cs.account.accesscontrol.Right;
import com.zimbra.cs.account.accesscontrol.RightCommand;
import com.zimbra.cs.account.accesscontrol.RightModifier;
import com.zimbra.cs.account.accesscontrol.ViaGrantImpl;
import com.zimbra.cs.account.auth.AuthContext;
import com.zimbra.cs.account.soap.SoapAccount;
import com.zimbra.cs.account.soap.SoapAccountInfo;
import com.zimbra.cs.account.soap.SoapAlias;
import com.zimbra.cs.account.soap.SoapCalendarResource;
import com.zimbra.cs.account.soap.SoapConfig;
import com.zimbra.cs.account.soap.SoapCos;
import com.zimbra.cs.account.soap.SoapDataSource;
import com.zimbra.cs.account.soap.SoapDistributionList;
import com.zimbra.cs.account.soap.SoapDomain;
import com.zimbra.cs.account.soap.SoapEntry;
import com.zimbra.cs.account.soap.SoapIdentity;
import com.zimbra.cs.account.soap.SoapServer;
import com.zimbra.cs.account.soap.SoapSignature;
import com.zimbra.cs.account.soap.SoapXMPPComponent;
import com.zimbra.cs.httpclient.URLUtil;
import com.zimbra.cs.mime.MimeTypeInfo;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapProvisioning
extends Provisioning {
    private int mTimeout = -1;
    private int mRetryCount;
    private SoapHttpTransport mTransport;
    private ZAuthToken mAuthToken;
    private long mAuthTokenLifetime;
    private long mAuthTokenExpiration;
    private SoapTransport.DebugListener mDebugListener;
    private SoapHttpTransport.HttpDebugListener mHttpDebugListener;
    private static final String DATA_DL_SET = "DL_SET";

    public SoapProvisioning() {
    }

    public SoapProvisioning(Options options) throws ServiceException {
        this.mTimeout = options.getTimeout();
        this.mRetryCount = options.getRetryCount();
        this.mDebugListener = options.getDebugListener();
        this.mAuthToken = options.getAuthToken();
        if (options.getUri() == null) {
            options.setUri(SoapProvisioning.getLocalConfigURI());
        }
        this.soapSetURI(options.getUri());
        if (options.getLocalConfigAuth()) {
            this.soapZimbraAdminAuthenticate();
        } else if (this.mAuthToken != null) {
            this.soapAdminAuthenticate(this.mAuthToken);
        } else if (options.getAccount() != null && options.getPassword() != null) {
            Element.XMLElement req = new Element.XMLElement(AdminConstants.AUTH_REQUEST);
            switch (options.getAccountBy()) {
                case name: {
                    req.addElement("name").setText(options.getAccount());
                    break;
                }
                default: {
                    Element account = req.addElement("account");
                    account.addAttribute("by", options.getAccountBy().name());
                    account.setText(options.getAccount());
                }
            }
            req.addElement("password").setText(options.getPassword());
            Element response = this.invoke(req);
            this.mAuthToken = new ZAuthToken(response.getElement("authToken"), true);
            this.mAuthTokenLifetime = response.getAttributeLong("lifetime");
            this.mAuthTokenExpiration = System.currentTimeMillis() + this.mAuthTokenLifetime;
            this.mTransport.setAuthToken(this.mAuthToken);
        } else {
            throw ZClientException.CLIENT_ERROR("no valid authentication method selected", null);
        }
    }

    public String toString() {
        return String.format("[%s %s]", this.getClass().getName(), this.mTransport == null ? "" : this.mTransport.getURI());
    }

    public void soapSetURI(String uri) {
        if (this.mTransport != null) {
            this.mTransport.shutdown();
        }
        this.mTransport = new SoapHttpTransport(uri);
        if (this.mTimeout >= 0) {
            this.mTransport.setTimeout(this.mTimeout);
        }
        if (this.mRetryCount > 0) {
            this.mTransport.setRetryCount(this.mRetryCount);
        }
        if (this.mAuthToken != null) {
            this.mTransport.setAuthToken(this.mAuthToken);
        }
        if (this.mDebugListener != null) {
            this.mTransport.setDebugListener(this.mDebugListener);
        }
    }

    public static String getLocalConfigURI() {
        String server = LC.zimbra_zmprov_default_soap_server.value();
        int port = LC.zimbra_admin_service_port.intValue();
        return LC.zimbra_admin_service_scheme.value() + server + ":" + port + "/service/admin/soap/";
    }

    public static SoapProvisioning getAdminInstance() throws ServiceException {
        Options opts = new Options();
        opts.setLocalConfigAuth(true);
        return new SoapProvisioning(opts);
    }

    public String soapGetURI() {
        return this.mTransport.getURI();
    }

    public void soapSetTransportTimeout(int timeout) {
        this.mTimeout = timeout;
        if (this.mTransport != null && timeout >= 0) {
            this.mTransport.setTimeout(timeout);
        }
    }

    public void soapSetTransportRetryCount(int retryCount) {
        this.mRetryCount = retryCount;
        if (this.mTransport != null && retryCount >= 0) {
            this.mTransport.setRetryCount(retryCount);
        }
    }

    public void soapSetTransportDebugListener(SoapTransport.DebugListener listener) {
        this.mDebugListener = listener;
        if (this.mTransport != null) {
            this.mTransport.setDebugListener(this.mDebugListener);
        }
    }

    public SoapTransport.DebugListener soapGetTransportDebugListener() {
        return this.mDebugListener;
    }

    public void soapSetHttpTransportDebugListener(SoapHttpTransport.HttpDebugListener listener) {
        this.mHttpDebugListener = listener;
        if (this.mTransport != null) {
            this.mTransport.setHttpDebugListener(listener);
        }
    }

    public SoapHttpTransport.HttpDebugListener soapGetHttpTransportDebugListener() {
        return this.mHttpDebugListener;
    }

    public ZAuthToken getAuthToken() {
        return this.mAuthToken;
    }

    public void setAuthToken(ZAuthToken authToken) {
        this.mAuthToken = authToken;
        if (this.mTransport != null) {
            this.mTransport.setAuthToken(authToken);
        }
    }

    public void soapAdminAuthenticate(String name, String password) throws ServiceException {
        if (this.mTransport == null) {
            throw ZClientException.CLIENT_ERROR("must call setURI before calling adminAuthenticate", null);
        }
        Element.XMLElement req = new Element.XMLElement(AdminConstants.AUTH_REQUEST);
        req.addElement("name").setText(name);
        req.addElement("password").setText(password);
        Element response = this.invoke(req);
        this.mAuthToken = new ZAuthToken(response.getElement("authToken"), true);
        this.mAuthTokenLifetime = response.getAttributeLong("lifetime");
        this.mAuthTokenExpiration = System.currentTimeMillis() + this.mAuthTokenLifetime;
        this.mTransport.setAuthToken(this.mAuthToken);
    }

    public void soapAdminAuthenticate(ZAuthToken zat) throws ServiceException {
        if (this.mTransport == null) {
            throw ZClientException.CLIENT_ERROR("must call setURI before calling adminAuthenticate", null);
        }
        Element.XMLElement req = new Element.XMLElement(AdminConstants.AUTH_REQUEST);
        zat.encodeAuthReq(req, true);
        Element response = this.invoke(req);
        this.mAuthToken = new ZAuthToken(response.getElement("authToken"), true);
        this.mAuthTokenLifetime = response.getAttributeLong("lifetime");
        this.mAuthTokenExpiration = System.currentTimeMillis() + this.mAuthTokenLifetime;
        this.mTransport.setAuthToken(this.mAuthToken);
    }

    public void soapZimbraAdminAuthenticate() throws ServiceException {
        this.soapAdminAuthenticate(LC.zimbra_ldap_user.value(), LC.zimbra_ldap_password.value());
    }

    private String serverName() {
        try {
            return new URI(this.mTransport.getURI()).getHost();
        }
        catch (URISyntaxException e) {
            return this.mTransport.getURI();
        }
    }

    private void checkTransport() throws ServiceException {
        if (this.mTransport == null) {
            throw ServiceException.FAILURE("transport has not been initialized", null);
        }
    }

    public synchronized Element invoke(Element request) throws ServiceException {
        this.checkTransport();
        try {
            return this.mTransport.invoke(request);
        }
        catch (SoapFaultException e) {
            throw e;
        }
        catch (IOException e) {
            throw ZClientException.IO_ERROR("invoke " + e.getMessage() + ", server: " + this.serverName(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized Element invokeOnTargetAccount(Element request, String targetId) throws ServiceException {
        Element element;
        this.checkTransport();
        String oldTarget = this.mTransport.getTargetAcctId();
        try {
            try {
                this.mTransport.setTargetAcctId(targetId);
                element = this.mTransport.invoke(request);
                Object var6_7 = null;
            }
            catch (SoapFaultException e) {
                throw e;
            }
            catch (IOException e) {
                throw ZClientException.IO_ERROR("invoke " + e.getMessage() + ", server: " + this.serverName(), e);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.mTransport.setTargetAcctId(oldTarget);
            throw throwable;
        }
        this.mTransport.setTargetAcctId(oldTarget);
        return element;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized Element invoke(Element request, String serverName) throws ServiceException {
        this.checkTransport();
        String oldUri = this.soapGetURI();
        String newUri = URLUtil.getAdminURL(serverName);
        boolean diff = !oldUri.equals(newUri);
        try {
            try {
                if (diff) {
                    this.soapSetURI(newUri);
                }
                Element element = this.mTransport.invoke(request);
                Object var8_9 = null;
                if (!diff) return element;
                this.soapSetURI(oldUri);
                return element;
            }
            catch (SoapFaultException e) {
                throw e;
            }
            catch (IOException e) {
                throw ZClientException.IO_ERROR("invoke " + e.getMessage() + ", server: " + serverName, e);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (!diff) throw throwable;
            this.soapSetURI(oldUri);
            throw throwable;
        }
    }

    static Map<String, Object> getAttrs(Element e) throws ServiceException {
        return SoapProvisioning.getAttrs(e, "n");
    }

    static Map<String, Object> getAttrs(Element e, String nameAttr) throws ServiceException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Element a : e.listElements("a")) {
            StringUtil.addToMultiMap(result, a.getAttribute(nameAttr), a.getText());
        }
        return result;
    }

    public static void addAttrElements(Element req, Map<String, ? extends Object> attrs) throws ServiceException {
        if (attrs == null) {
            return;
        }
        for (Map.Entry<String, ? extends Object> entry : attrs.entrySet()) {
            Element a;
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                a = req.addElement("a");
                a.addAttribute("n", key);
                a.setText((String)value);
                continue;
            }
            if (value instanceof String[]) {
                String[] values = (String[])value;
                if (values.length == 0) {
                    Element a2 = req.addElement("a");
                    a2.addAttribute("n", key);
                    continue;
                }
                for (String v : values) {
                    Element a3 = req.addElement("a");
                    a3.addAttribute("n", key);
                    a3.setText(v);
                }
                continue;
            }
            if (value == null) {
                a = req.addElement("a");
                a.addAttribute("n", key);
                continue;
            }
            throw ZClientException.CLIENT_ERROR("invalid attr type: " + key + " " + value.getClass().getName(), null);
        }
    }

    @Override
    public void addAlias(Account acct, String alias) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.ADD_ACCOUNT_ALIAS_REQUEST);
        req.addElement("id").setText(acct.getId());
        req.addElement("alias").setText(alias);
        this.invoke(req);
        this.reload(acct);
    }

    @Override
    public void addAlias(DistributionList dl, String alias) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.ADD_DISTRIBUTION_LIST_ALIAS_REQUEST);
        req.addElement("id").setText(dl.getId());
        req.addElement("alias").setText(alias);
        this.invoke(req);
        this.reload(dl);
    }

    @Override
    public void authAccount(Account acct, String password, AuthContext.Protocol proto) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AccountConstants.AUTH_REQUEST);
        Element a = req.addElement("account");
        a.addAttribute("by", "name");
        a.setText(acct.getName());
        req.addElement("password").setText(password);
        this.invoke(req);
    }

    @Override
    public void authAccount(Account acct, String password, AuthContext.Protocol proto, Map<String, Object> context) throws ServiceException {
        this.authAccount(acct, password, proto);
    }

    @Override
    public void changePassword(Account acct, String currentPassword, String newPassword) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AccountConstants.CHANGE_PASSWORD_REQUEST);
        Element a = req.addElement("account");
        a.addAttribute("by", "name");
        a.setText(acct.getName());
        req.addElement("oldPassword").setText(currentPassword);
        req.addElement("password").setText(newPassword);
        this.invoke(req);
    }

    @Override
    public Account createAccount(String emailAddress, String password, Map<String, Object> attrs) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.CREATE_ACCOUNT_REQUEST);
        req.addElement("name").setText(emailAddress);
        req.addElement("password").setText(password);
        SoapProvisioning.addAttrElements(req, attrs);
        return new SoapAccount(this.invoke(req).getElement("account"), this);
    }

    @Override
    public Account restoreAccount(String emailAddress, String password, Map<String, Object> attrs, Map<String, Object> origAttrs) throws ServiceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CalendarResource createCalendarResource(String emailAddress, String password, Map<String, Object> attrs) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.CREATE_CALENDAR_RESOURCE_REQUEST);
        req.addElement("name").setText(emailAddress);
        req.addElement("password").setText(password);
        SoapProvisioning.addAttrElements(req, attrs);
        return new SoapCalendarResource(this.invoke(req).getElement("calresource"), this);
    }

    @Override
    public Cos createCos(String name, Map<String, Object> attrs) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.CREATE_COS_REQUEST);
        req.addElement("name").setText(name);
        SoapProvisioning.addAttrElements(req, attrs);
        return new SoapCos(this.invoke(req).getElement("cos"), this);
    }

    @Override
    public Cos copyCos(String srcCosId, String destCosName) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.COPY_COS_REQUEST);
        req.addElement("name").setText(destCosName);
        req.addElement("cos").addAttribute("by", Provisioning.CosBy.id.name()).setText(srcCosId);
        return new SoapCos(this.invoke(req).getElement("cos"), this);
    }

    @Override
    public DistributionList createDistributionList(String listAddress, Map<String, Object> listAttrs) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.CREATE_DISTRIBUTION_LIST_REQUEST);
        req.addElement("name").setText(listAddress);
        SoapProvisioning.addAttrElements(req, listAttrs);
        return new SoapDistributionList(this.invoke(req).getElement("dl"), this);
    }

    @Override
    public Domain createDomain(String name, Map<String, Object> attrs) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.CREATE_DOMAIN_REQUEST);
        req.addElement("name").setText(name);
        SoapProvisioning.addAttrElements(req, attrs);
        return new SoapDomain(this.invoke(req).getElement("domain"), this);
    }

    @Override
    public Server createServer(String name, Map<String, Object> attrs) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.CREATE_SERVER_REQUEST);
        req.addElement("name").setText(name);
        SoapProvisioning.addAttrElements(req, attrs);
        return new SoapServer(this.invoke(req).getElement("server"), this);
    }

    @Override
    public Zimlet createZimlet(String name, Map<String, Object> attrs) throws ServiceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteAccount(String zimbraId) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.DELETE_ACCOUNT_REQUEST);
        req.addElement("id").setText(zimbraId);
        this.invoke(req);
    }

    @Override
    public void deleteCalendarResource(String zimbraId) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.DELETE_CALENDAR_RESOURCE_REQUEST);
        req.addElement("id").setText(zimbraId);
        this.invoke(req);
    }

    @Override
    public void deleteCos(String zimbraId) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.DELETE_COS_REQUEST);
        req.addElement("id").setText(zimbraId);
        this.invoke(req);
    }

    @Override
    public void deleteDistributionList(String zimbraId) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.DELETE_DISTRIBUTION_LIST_REQUEST);
        req.addElement("id").setText(zimbraId);
        this.invoke(req);
    }

    @Override
    public void deleteDomain(String zimbraId) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.DELETE_DOMAIN_REQUEST);
        req.addElement("id").setText(zimbraId);
        this.invoke(req);
    }

    @Override
    public void deleteServer(String zimbraId) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.DELETE_SERVER_REQUEST);
        req.addElement("id").setText(zimbraId);
        this.invoke(req);
    }

    @Override
    public void deleteZimlet(String name) throws ServiceException {
        throw new UnsupportedOperationException();
    }

    public DelegateAuthResponse delegateAuth(Provisioning.AccountBy keyType, String key, int durationSeconds) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.DELEGATE_AUTH_REQUEST);
        req.addAttribute("duration", durationSeconds);
        Element acct = req.addElement("account");
        acct.addAttribute("by", keyType.name());
        acct.setText(key);
        return new DelegateAuthResponse(this.invoke(req));
    }

    public SoapAccountInfo getAccountInfo(Provisioning.AccountBy keyType, String key) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_ACCOUNT_INFO_REQUEST);
        Element a = req.addElement("account");
        a.setText(key);
        a.addAttribute("by", keyType.name());
        return new SoapAccountInfo(this.invoke(req));
    }

    @Override
    public Account get(Provisioning.AccountBy keyType, String key) throws ServiceException {
        return this.get(keyType, key, true);
    }

    public Account getAccount(String key, boolean applyDefault) throws ServiceException {
        Account acct = null;
        if (Provisioning.isUUID(key)) {
            acct = this.get(Provisioning.AccountBy.id, key, applyDefault);
        } else {
            acct = this.get(Provisioning.AccountBy.name, key, applyDefault);
            if (acct == null) {
                acct = this.get(Provisioning.AccountBy.id, key, applyDefault);
            }
        }
        return acct;
    }

    @Override
    public Account get(Provisioning.AccountBy keyType, String key, boolean applyDefault) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_ACCOUNT_REQUEST);
        req.addAttribute("applyCos", applyDefault);
        Element a = req.addElement("account");
        a.setText(key);
        a.addAttribute("by", keyType.name());
        try {
            return new SoapAccount(this.invoke(req).getElement("account"), this);
        }
        catch (ServiceException e) {
            if (e.getCode().equals("account.NO_SUCH_ACCOUNT")) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public List<Account> getAllAdminAccounts() throws ServiceException {
        return this.getAllAdminAccounts(true);
    }

    public List<Account> getAllAdminAccounts(boolean applyDefault) throws ServiceException {
        ArrayList<Account> result = new ArrayList<Account>();
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_ALL_ADMIN_ACCOUNTS_REQUEST);
        req.addAttribute("applyCos", applyDefault);
        Element resp = this.invoke(req);
        for (Element a : resp.listElements("account")) {
            result.add(new SoapAccount(a, this));
        }
        return result;
    }

    @Override
    public List<Cos> getAllCos() throws ServiceException {
        ArrayList<Cos> result = new ArrayList<Cos>();
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_ALL_COS_REQUEST);
        Element resp = this.invoke(req);
        for (Element a : resp.listElements("cos")) {
            result.add(new SoapCos(a, this));
        }
        return result;
    }

    @Override
    public List<Domain> getAllDomains() throws ServiceException {
        return this.getAllDomains(true);
    }

    public List<Domain> getAllDomains(boolean applyDefault) throws ServiceException {
        ArrayList<Domain> result = new ArrayList<Domain>();
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_ALL_DOMAINS_REQUEST);
        req.addAttribute("applyConfig", applyDefault);
        Element resp = this.invoke(req);
        for (Element a : resp.listElements("domain")) {
            result.add(new SoapDomain(a, this));
        }
        return result;
    }

    @Override
    public List<Server> getAllServers() throws ServiceException {
        return this.getAllServers(null, true);
    }

    public List<QuotaUsage> getQuotaUsage(String server) throws ServiceException {
        ArrayList<QuotaUsage> result = new ArrayList<QuotaUsage>();
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_QUOTA_USAGE_REQUEST);
        Element resp = this.invoke(req, server);
        for (Element a : resp.listElements("account")) {
            result.add(new QuotaUsage(a));
        }
        return result;
    }

    public void addAccountLogger(Account account, String category, String level, String server) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.ADD_ACCOUNT_LOGGER_REQUEST);
        Element eAccount = req.addElement("account");
        eAccount.addAttribute("by", "id");
        eAccount.setText(account.getId());
        Element eLogger = req.addElement("logger");
        eLogger.addAttribute("category", category);
        eLogger.addAttribute("level", level);
        if (server == null) {
            server = this.getServer(account).getName();
        }
        this.invoke(req, server);
    }

    public List<AccountLogger> getAccountLoggers(Account account, String server) throws ServiceException {
        ArrayList<AccountLogger> result = new ArrayList<AccountLogger>();
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_ACCOUNT_LOGGERS_REQUEST);
        Element eAccount = req.addElement("account");
        eAccount.addAttribute("by", "id");
        eAccount.setText(account.getId());
        if (server == null) {
            server = this.getServer(account).getName();
        }
        Element resp = this.invoke(req, server);
        for (Element eLogger : resp.listElements("logger")) {
            String category = eLogger.getAttribute("category");
            Log.Level level = Log.Level.valueOf(eLogger.getAttribute("level"));
            result.add(new AccountLogger(category, account.getName(), level));
        }
        return result;
    }

    public Map<String, List<AccountLogger>> getAllAccountLoggers(String server) throws ServiceException {
        if (server == null) {
            server = this.getLocalServer().getName();
        }
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_ALL_ACCOUNT_LOGGERS_REQUEST);
        Element resp = this.invoke(req, server);
        HashMap<String, List<AccountLogger>> result = new HashMap<String, List<AccountLogger>>();
        for (Element eAccountLogger : resp.listElements("accountLogger")) {
            for (Element eLogger : eAccountLogger.listElements("logger")) {
                String accountName = eAccountLogger.getAttribute("name");
                String category = eLogger.getAttribute("category");
                Log.Level level = Log.Level.valueOf(eLogger.getAttribute("level"));
                if (!result.containsKey(accountName)) {
                    result.put(accountName, new ArrayList());
                }
                ((List)result.get(accountName)).add(new AccountLogger(category, accountName, level));
            }
        }
        return result;
    }

    public void removeAccountLoggers(Account account, String category, String server) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.REMOVE_ACCOUNT_LOGGER_REQUEST);
        if (account != null) {
            Element eAccount = req.addElement("account");
            eAccount.addAttribute("by", "id");
            eAccount.setText(account.getId());
        }
        if (category != null) {
            Element eLogger = req.addElement("logger");
            eLogger.addAttribute("category", category);
        }
        if (server == null) {
            server = account == null ? this.getLocalServer().getName() : this.getServer(account).getName();
        }
        this.invoke(req, server);
    }

    public MailboxInfo getMailbox(Account acct) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_MAILBOX_REQUEST);
        Element mboxReq = req.addElement("mbox");
        mboxReq.addAttribute("id", acct.getId());
        Server server = this.getServer(acct);
        String serviceHost = server.getAttr("zimbraServiceHostname");
        Element mbox = this.invoke(req, serviceHost).getElement("mbox");
        return new MailboxInfo(mbox.getAttribute("mbxid"), mbox.getAttributeLong("s"));
    }

    public ReIndexInfo reIndex(Account acct, String action, ReIndexBy by, String[] values) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.REINDEX_REQUEST);
        req.addAttribute("action", action);
        Element mboxReq = req.addElement("mbox");
        mboxReq.addAttribute("id", acct.getId());
        if (by != null) {
            String vals = StringUtil.join(",", values);
            if (by == ReIndexBy.types) {
                mboxReq.addAttribute("types", vals);
            } else {
                mboxReq.addAttribute("ids", vals);
            }
        }
        Server server = this.getServer(acct);
        String serviceHost = server.getAttr("zimbraServiceHostname");
        Element resp = this.invoke(req, serviceHost);
        ReIndexInfo.Progress progress = null;
        Element progressElem = resp.getOptionalElement("progress");
        if (progressElem != null) {
            progress = new ReIndexInfo.Progress(progressElem.getAttributeLong("numSucceeded"), progressElem.getAttributeLong("numFailed"), progressElem.getAttributeLong("numRemaining"));
        }
        return new ReIndexInfo(resp.getAttribute("status"), progress);
    }

    public long recalculateMailboxCounts(Account acct) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.RECALCULATE_MAILBOX_COUNTS_REQUEST);
        req.addElement("mbox").addAttribute("id", acct.getId());
        Server server = this.getServer(acct);
        Element resp = this.invoke(req, server.getAttr("zimbraServiceHostname"));
        return resp.getElement("mbox").getAttributeLong("used");
    }

    @Override
    public List<Server> getAllServers(String service) throws ServiceException {
        return this.getAllServers(service, true);
    }

    public List<Server> getAllServers(String service, boolean applyDefault) throws ServiceException {
        ArrayList<Server> result = new ArrayList<Server>();
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_ALL_SERVERS_REQUEST);
        if (service != null) {
            req.addAttribute("service", service);
        }
        req.addAttribute("applyConfig", applyDefault);
        Element resp = this.invoke(req);
        for (Element a : resp.listElements("server")) {
            result.add(new SoapServer(a, this));
        }
        return result;
    }

    @Override
    public CalendarResource get(Provisioning.CalendarResourceBy keyType, String key) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_CALENDAR_RESOURCE_REQUEST);
        Element a = req.addElement("calresource");
        a.setText(key);
        a.addAttribute("by", keyType.name());
        try {
            return new SoapCalendarResource(this.invoke(req).getElement("calresource"), this);
        }
        catch (ServiceException e) {
            if (e.getCode().equals("account.NO_SUCH_CALENDAR_RESOURCE")) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public Config getConfig() throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_ALL_CONFIG_REQUEST);
        return new SoapConfig(this.invoke(req), (Provisioning)this);
    }

    @Override
    public GlobalGrant getGlobalGrant() throws ServiceException {
        throw ServiceException.FAILURE("not supported", null);
    }

    @Override
    public Cos get(Provisioning.CosBy keyType, String key) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_COS_REQUEST);
        Element a = req.addElement("cos");
        a.setText(key);
        a.addAttribute("by", keyType.name());
        try {
            return new SoapCos(this.invoke(req).getElement("cos"), this);
        }
        catch (ServiceException e) {
            if (e.getCode().equals("account.NO_SUCH_COS")) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public DistributionList get(Provisioning.DistributionListBy keyType, String key) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_DISTRIBUTION_LIST_REQUEST);
        Element a = req.addElement("dl");
        a.setText(key);
        a.addAttribute("by", keyType.name());
        try {
            return new SoapDistributionList(this.invoke(req).getElement("dl"), this);
        }
        catch (ServiceException e) {
            if (e.getCode().equals("account.NO_SUCH_DISTRIBUTION_LIST")) {
                return null;
            }
            throw e;
        }
    }

    public Domain getDomainInfo(Provisioning.DomainBy keyType, String key) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_DOMAIN_INFO_REQUEST);
        Element a = req.addElement("domain");
        a.setText(key);
        a.addAttribute("by", keyType.name());
        try {
            Element d = this.invoke(req).getOptionalElement("domain");
            return d == null ? null : new SoapDomain(d, this);
        }
        catch (ServiceException e) {
            if (e.getCode().equals("account.NO_SUCH_DOMAIN")) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public Domain get(Provisioning.DomainBy keyType, String key) throws ServiceException {
        return this.get(keyType, key, true);
    }

    public Domain get(Provisioning.DomainBy keyType, String key, boolean applyDefault) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_DOMAIN_REQUEST);
        req.addAttribute("applyConfig", applyDefault);
        Element a = req.addElement("domain");
        a.setText(key);
        a.addAttribute("by", keyType.name());
        try {
            return new SoapDomain(this.invoke(req).getElement("domain"), this);
        }
        catch (ServiceException e) {
            if (e.getCode().equals("account.NO_SUCH_DOMAIN")) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public Server getLocalServer() throws ServiceException {
        String hostname = LC.zimbra_server_hostname.value();
        if (hostname == null) {
            throw ServiceException.FAILURE("zimbra_server_hostname not specified in localconfig.xml", null);
        }
        Server local = this.get(Provisioning.ServerBy.name, hostname);
        if (local == null) {
            throw ServiceException.FAILURE("Could not find an LDAP entry for server '" + hostname + "'", null);
        }
        return local;
    }

    @Override
    public List<MimeTypeInfo> getMimeTypes(String name) throws ServiceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<MimeTypeInfo> getAllMimeTypes() throws ServiceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Zimlet> getObjectTypes() throws ServiceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Server get(Provisioning.ServerBy keyType, String key) throws ServiceException {
        return this.get(keyType, key, true);
    }

    public Server get(Provisioning.ServerBy keyType, String key, boolean applyDefault) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_SERVER_REQUEST);
        req.addAttribute("applyConfig", applyDefault);
        Element a = req.addElement("server");
        a.setText(key);
        a.addAttribute("by", keyType.name());
        try {
            return new SoapServer(this.invoke(req).getElement("server"), this);
        }
        catch (ServiceException e) {
            if (e.getCode().equals("account.NO_SUCH_SERVER")) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public Zimlet getZimlet(String name) throws ServiceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean healthCheck() throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.CHECK_HEALTH_REQUEST);
        Element response = this.invoke(req);
        return response.getAttributeBool("healthy");
    }

    @Override
    public List<Zimlet> listAllZimlets() throws ServiceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void modifyAccountStatus(Account acct, String newStatus) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAccountStatus", newStatus);
        this.modifyAttrs(acct, attrs);
    }

    @Override
    public void preAuthAccount(Account acct, String accountName, String accountBy, long timestamp, long expires, String preAuth, Map<String, Object> authCtxt) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AccountConstants.AUTH_REQUEST);
        Element a = req.addElement("account");
        a.addAttribute("by", "name");
        a.setText(accountName);
        Element p = req.addElement("preauth");
        p.addAttribute("timestamp", timestamp);
        p.addAttribute("by", accountBy);
        p.addAttribute("expires", expires);
        p.setText(preAuth);
        this.invoke(req);
    }

    @Override
    public void removeAlias(Account acct, String alias) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.REMOVE_ACCOUNT_ALIAS_REQUEST);
        if (acct != null) {
            req.addElement("id").setText(acct.getId());
        }
        req.addElement("alias").setText(alias);
        this.invoke(req);
        if (acct != null) {
            this.reload(acct);
        }
    }

    @Override
    public void removeAlias(DistributionList dl, String alias) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.REMOVE_DISTRIBUTION_LIST_ALIAS_REQUEST);
        if (dl != null) {
            req.addElement("id").setText(dl.getId());
        }
        req.addElement("alias").setText(alias);
        this.invoke(req);
        if (dl != null) {
            this.reload(dl);
        }
    }

    @Override
    public void renameAccount(String zimbraId, String newName) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.RENAME_ACCOUNT_REQUEST);
        req.addElement("id").setText(zimbraId);
        req.addElement("newName").setText(newName);
        this.invoke(req);
    }

    @Override
    public void renameCalendarResource(String zimbraId, String newName) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.RENAME_CALENDAR_RESOURCE_REQUEST);
        req.addElement("id").setText(zimbraId);
        req.addElement("newName").setText(newName);
        this.invoke(req);
    }

    @Override
    public void renameCos(String zimbraId, String newName) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.RENAME_COS_REQUEST);
        req.addElement("id").setText(zimbraId);
        req.addElement("newName").setText(newName);
        this.invoke(req);
    }

    @Override
    public void renameDistributionList(String zimbraId, String newName) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.RENAME_DISTRIBUTION_LIST_REQUEST);
        req.addElement("id").setText(zimbraId);
        req.addElement("newName").setText(newName);
        this.invoke(req);
    }

    @Override
    public List<NamedEntry> searchAccounts(String query, String[] returnAttrs, String sortAttr, boolean sortAscending, int flags) throws ServiceException {
        return this.searchAccounts(null, query, returnAttrs, sortAttr, sortAscending, flags);
    }

    @Override
    public List<NamedEntry> searchCalendarResources(EntrySearchFilter filter, String[] returnAttrs, String sortAttr, boolean sortAscending) throws ServiceException {
        return this.searchCalendarResources(null, filter, returnAttrs, sortAttr, sortAscending);
    }

    @Override
    public void setCOS(Account acct, Cos cos) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCOSId", cos.getId());
        this.modifyAttrs(acct, attrs);
    }

    @Override
    public void setPassword(Account acct, String newPassword) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.SET_PASSWORD_REQUEST);
        req.addElement("id").setText(acct.getId());
        req.addElement("newPassword").setText(newPassword);
        this.invoke(req);
    }

    @Override
    public void checkPasswordStrength(Account acct, String password) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.CHECK_PASSWORD_STRENGTH_REQUEST);
        req.addElement("id").setText(acct.getId());
        req.addElement("password").setText(password);
        this.invoke(req);
    }

    @Override
    public void modifyAttrs(Entry e, Map<String, ? extends Object> attrs, boolean checkImmutable) throws ServiceException {
        SoapEntry se = (SoapEntry)((Object)e);
        se.modifyAttrs(this, attrs, checkImmutable);
    }

    @Override
    public void modifyAttrs(Entry e, Map<String, ? extends Object> attrs, boolean checkImmutable, boolean allowCallback) throws ServiceException {
        this.modifyAttrs(e, attrs, checkImmutable);
    }

    @Override
    public void reload(Entry e) throws ServiceException {
        SoapEntry se = (SoapEntry)((Object)e);
        se.reload(this);
    }

    @Override
    public Set<String> getDistributionLists(Account acct) throws ServiceException {
        Set<String> dls = (HashSet)acct.getCachedData(DATA_DL_SET);
        if (dls != null) {
            return dls;
        }
        dls = new HashSet();
        List<DistributionList> lists = this.getDistributionLists(acct, false, null);
        for (DistributionList dl : lists) {
            dls.add(dl.getId());
        }
        dls = Collections.unmodifiableSet(dls);
        acct.setCachedData(DATA_DL_SET, dls);
        return dls;
    }

    @Override
    public List<DistributionList> getDistributionLists(Account acct, boolean directOnly, Map<String, String> via) throws ServiceException {
        ArrayList<DistributionList> result = new ArrayList<DistributionList>();
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_ACCOUNT_MEMBERSHIP_REQUEST);
        Element acctEl = req.addElement("account");
        acctEl.addAttribute("by", Provisioning.AccountBy.id.name());
        acctEl.setText(acct.getId());
        Element resp = this.invoke(req);
        for (Element a : resp.listElements("dl")) {
            String viaList = a.getAttribute("via", null);
            if (directOnly && viaList != null) continue;
            SoapDistributionList dl = new SoapDistributionList(a, this);
            if (via != null && viaList != null) {
                via.put(dl.getName(), viaList);
            }
            result.add(dl);
        }
        return result;
    }

    @Override
    public boolean inDistributionList(Account acct, String zimbraId) throws ServiceException {
        return this.getDistributionLists(acct).contains(zimbraId);
    }

    @Override
    public List<DistributionList> getDistributionLists(DistributionList list, boolean directOnly, Map<String, String> via) throws ServiceException {
        ArrayList<DistributionList> result = new ArrayList<DistributionList>();
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_DISTRIBUTION_LIST_MEMBERSHIP_REQUEST);
        Element acctEl = req.addElement("dl");
        acctEl.addAttribute("by", Provisioning.DistributionListBy.id.name());
        acctEl.setText(list.getId());
        Element resp = this.invoke(req);
        for (Element a : resp.listElements("dl")) {
            String viaList = a.getAttribute("via", null);
            if (directOnly && viaList != null) continue;
            SoapDistributionList dl = new SoapDistributionList(a, this);
            if (via != null && viaList != null) {
                via.put(dl.getName(), viaList);
            }
            result.add(dl);
        }
        return result;
    }

    @Override
    public List getAllAccounts(Domain d) throws ServiceException {
        ArrayList<SoapAccount> result = new ArrayList<SoapAccount>();
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_ALL_ACCOUNTS_REQUEST);
        if (d != null && d.getId() != null) {
            Element domainEl = req.addElement("domain");
            domainEl.addAttribute("by", Provisioning.DomainBy.id.name());
            domainEl.setText(d.getId());
        }
        Element resp = this.invoke(req);
        for (Element a : resp.listElements("account")) {
            result.add(new SoapAccount(a, this));
        }
        return result;
    }

    @Override
    public void getAllAccounts(Domain d, NamedEntry.Visitor visitor) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_ALL_ACCOUNTS_REQUEST);
        Element domainEl = req.addElement("domain");
        domainEl.addAttribute("by", Provisioning.DomainBy.id.name());
        domainEl.setText(d.getId());
        Element resp = this.invoke(req);
        for (Element a : resp.listElements("account")) {
            visitor.visit(new SoapAccount(a, this));
        }
    }

    @Override
    public void getAllAccounts(Domain d, Server s, NamedEntry.Visitor visitor) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_ALL_ACCOUNTS_REQUEST);
        Element domainEl = req.addElement("domain");
        domainEl.addAttribute("by", Provisioning.DomainBy.id.name());
        domainEl.setText(d.getId());
        if (s != null) {
            Element serverEl = req.addElement("server");
            serverEl.addAttribute("by", Provisioning.ServerBy.id.name());
            serverEl.setText(s.getId());
        }
        Element resp = this.invoke(req);
        for (Element a : resp.listElements("account")) {
            visitor.visit(new SoapAccount(a, this));
        }
    }

    @Override
    public List getAllCalendarResources(Domain d) throws ServiceException {
        ArrayList<SoapCalendarResource> result = new ArrayList<SoapCalendarResource>();
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_ALL_CALENDAR_RESOURCES_REQUEST);
        Element domainEl = req.addElement("domain");
        domainEl.addAttribute("by", Provisioning.CalendarResourceBy.id.name());
        domainEl.setText(d.getId());
        Element resp = this.invoke(req);
        for (Element a : resp.listElements("calresource")) {
            result.add(new SoapCalendarResource(a, this));
        }
        return result;
    }

    @Override
    public void getAllCalendarResources(Domain d, NamedEntry.Visitor visitor) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_ALL_CALENDAR_RESOURCES_REQUEST);
        Element domainEl = req.addElement("domain");
        domainEl.addAttribute("by", Provisioning.CalendarResourceBy.id.name());
        domainEl.setText(d.getId());
        Element resp = this.invoke(req);
        for (Element a : resp.listElements("calresource")) {
            visitor.visit(new SoapCalendarResource(a, this));
        }
    }

    @Override
    public void getAllCalendarResources(Domain d, Server s, NamedEntry.Visitor visitor) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_ALL_CALENDAR_RESOURCES_REQUEST);
        Element domainEl = req.addElement("domain");
        domainEl.addAttribute("by", Provisioning.CalendarResourceBy.id.name());
        domainEl.setText(d.getId());
        if (s != null) {
            Element serverEl = req.addElement("server");
            serverEl.addAttribute("by", Provisioning.ServerBy.id.name());
            serverEl.setText(s.getId());
        }
        Element resp = this.invoke(req);
        for (Element a : resp.listElements("calresource")) {
            visitor.visit(new SoapCalendarResource(a, this));
        }
    }

    @Override
    public List getAllDistributionLists(Domain d) throws ServiceException {
        ArrayList<SoapDistributionList> result = new ArrayList<SoapDistributionList>();
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_ALL_DISTRIBUTION_LISTS_REQUEST);
        Element domainEl = req.addElement("domain");
        domainEl.addAttribute("by", Provisioning.DomainBy.id.name());
        domainEl.setText(d.getId());
        Element resp = this.invoke(req);
        for (Element a : resp.listElements("dl")) {
            result.add(new SoapDistributionList(a, this));
        }
        return result;
    }

    @Override
    public Provisioning.SearchGalResult autoCompleteGal(Domain d, String query, Provisioning.GAL_SEARCH_TYPE type, int limit) throws ServiceException {
        String typeStr = null;
        typeStr = type == Provisioning.GAL_SEARCH_TYPE.ALL ? "all" : (type == Provisioning.GAL_SEARCH_TYPE.USER_ACCOUNT ? "account" : (type == Provisioning.GAL_SEARCH_TYPE.CALENDAR_RESOURCE ? "resource" : "all"));
        Element.XMLElement req = new Element.XMLElement(AdminConstants.AUTO_COMPLETE_GAL_REQUEST);
        req.addElement("name").setText(query);
        req.addAttribute("domain", d.getName());
        req.addAttribute("type", typeStr);
        req.addAttribute("limit", limit);
        Element resp = this.invoke(req);
        Provisioning.SearchGalResult result = Provisioning.SearchGalResult.newSearchGalResult(null);
        result.setHadMore(resp.getAttributeBool("more"));
        result.setTokenizeKey(resp.getAttribute("tokenizeKey", null));
        for (Element e : resp.listElements("cn")) {
            result.addMatch(new GalContact("id", SoapProvisioning.getAttrs(e)));
        }
        return result;
    }

    @Override
    public List<NamedEntry> searchAccounts(Domain d, String query, String[] returnAttrs, String sortAttr, boolean sortAscending, int flags) throws ServiceException {
        ArrayList<NamedEntry> result = new ArrayList<NamedEntry>();
        Element.XMLElement req = new Element.XMLElement(AdminConstants.SEARCH_ACCOUNTS_REQUEST);
        req.addElement("query").setText(query);
        if (d != null) {
            req.addAttribute("domain", d.getName());
        }
        if (sortAttr != null) {
            req.addAttribute("sortBy", sortAttr);
        }
        if (flags != 0) {
            req.addAttribute("types", Provisioning.searchAccountMaskToString(flags));
        }
        req.addAttribute("sortAscending", sortAscending ? "1" : "0");
        if (returnAttrs != null) {
            req.addAttribute("attrs", StringUtil.join(",", returnAttrs));
        }
        Element resp = this.invoke(req);
        for (Element e : resp.listElements("dl")) {
            result.add(new SoapDistributionList(e, this));
        }
        for (Element e : resp.listElements("alias")) {
            result.add(new SoapAlias(e, this));
        }
        for (Element e : resp.listElements("account")) {
            result.add(new SoapAccount(e, this));
        }
        return result;
    }

    @Override
    public List<NamedEntry> searchDirectory(Provisioning.SearchOptions options) throws ServiceException {
        ArrayList<NamedEntry> result = new ArrayList<NamedEntry>();
        Element.XMLElement req = new Element.XMLElement(AdminConstants.SEARCH_DIRECTORY_REQUEST);
        req.addElement("query").setText(options.getQuery());
        if (options.getMaxResults() != 0) {
            req.addAttribute("maxResults", options.getMaxResults());
        }
        if (options.getDomain() != null) {
            req.addAttribute("domain", options.getDomain().getName());
        }
        if (options.getSortAttr() != null) {
            req.addAttribute("sortBy", options.getSortAttr());
        }
        if (options.getFlags() != 0) {
            req.addAttribute("types", Provisioning.searchAccountMaskToString(options.getFlags()));
        }
        req.addAttribute("sortAscending", options.isSortAscending() ? "1" : "0");
        if (options.getReturnAttrs() != null) {
            req.addAttribute("attrs", StringUtil.join(",", options.getReturnAttrs()));
        }
        Element resp = this.invoke(req);
        for (Element e : resp.listElements("dl")) {
            result.add(new SoapDistributionList(e, this));
        }
        for (Element e : resp.listElements("alias")) {
            result.add(new SoapAlias(e, this));
        }
        for (Element e : resp.listElements("account")) {
            result.add(new SoapAccount(e, this));
        }
        for (Element e : resp.listElements("domain")) {
            result.add(new SoapDomain(e, this));
        }
        return result;
    }

    public List searchCalendarResources(Domain d, EntrySearchFilter filter, String[] returnAttrs, String sortAttr, boolean sortAscending) throws ServiceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Provisioning.SearchGalResult searchGal(Domain d, String query, Provisioning.GAL_SEARCH_TYPE type, String token) throws ServiceException {
        return this.searchGal(d, query, type, token, 0, 0, null);
    }

    public Provisioning.SearchGalResult searchGal(Domain d, String query, Provisioning.GAL_SEARCH_TYPE type, String token, int limit, int offset, String sortBy) throws ServiceException {
        String typeStr = null;
        typeStr = type == Provisioning.GAL_SEARCH_TYPE.ALL ? "all" : (type == Provisioning.GAL_SEARCH_TYPE.USER_ACCOUNT ? "account" : (type == Provisioning.GAL_SEARCH_TYPE.CALENDAR_RESOURCE ? "resource" : "all"));
        Element.XMLElement req = new Element.XMLElement(AdminConstants.SEARCH_GAL_REQUEST);
        req.addElement("name").setText(query);
        req.addAttribute("domain", d.getName());
        req.addAttribute("type", typeStr);
        if (limit > 0) {
            req.addAttribute("limit", limit);
        }
        if (offset > 0) {
            req.addAttribute("offset", limit);
        }
        if (sortBy != null) {
            req.addAttribute("sortBy", sortBy);
        }
        if (token != null) {
            req.addAttribute("token", token);
        }
        Element resp = this.invoke(req);
        Provisioning.SearchGalResult result = Provisioning.SearchGalResult.newSearchGalResult(null);
        result.setToken(resp.getAttribute("token", null));
        result.setHadMore(resp.getAttributeBool("more"));
        result.setTokenizeKey(resp.getAttribute("tokenizeKey", null));
        for (Element e : resp.listElements("cn")) {
            result.addMatch(new GalContact("id", SoapProvisioning.getAttrs(e)));
        }
        return result;
    }

    @Override
    public void addMembers(DistributionList list, String[] members) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.ADD_DISTRIBUTION_LIST_MEMBER_REQUEST);
        req.addElement("id").setText(list.getId());
        for (String m : members) {
            req.addElement("dlm").setText(m);
        }
        this.invoke(req);
        this.reload(list);
    }

    @Override
    public void removeMembers(DistributionList list, String[] members) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.REMOVE_DISTRIBUTION_LIST_MEMBER_REQUEST);
        req.addElement("id").setText(list.getId());
        for (String m : members) {
            req.addElement("dlm").setText(m);
        }
        this.invoke(req);
        this.reload(list);
    }

    static void addAttrElementsMailService(Element req, Map<String, ? extends Object> attrs) throws ServiceException {
        if (attrs == null) {
            return;
        }
        for (Map.Entry<String, ? extends Object> entry : attrs.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                Element a = req.addElement("a");
                a.addAttribute("name", key);
                a.setText((String)value);
                continue;
            }
            if (value instanceof String[]) {
                String[] values;
                for (String v : values = (String[])value) {
                    Element a = req.addElement("a");
                    a.addAttribute("name", key);
                    a.setText(v);
                }
                continue;
            }
            throw ZClientException.CLIENT_ERROR("invalid attr type: " + key + " " + value.getClass().getName(), null);
        }
    }

    @Override
    public Identity createIdentity(Account account, String identityName, Map<String, Object> attrs) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AccountConstants.CREATE_IDENTITY_REQUEST);
        Element identity = req.addElement("identity");
        identity.addAttribute("name", identityName);
        SoapProvisioning.addAttrElementsMailService(identity, attrs);
        Element response = this.invokeOnTargetAccount(req, account.getId()).getElement("identity");
        return new SoapIdentity(account, response, (Provisioning)this);
    }

    @Override
    public Identity restoreIdentity(Account account, String identityName, Map<String, Object> attrs) throws ServiceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteIdentity(Account account, String identityName) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AccountConstants.DELETE_IDENTITY_REQUEST);
        Element identity = req.addElement("identity");
        identity.addAttribute("name", identityName);
        this.invokeOnTargetAccount(req, account.getId());
    }

    @Override
    public List<Identity> getAllIdentities(Account account) throws ServiceException {
        ArrayList<Identity> result = new ArrayList<Identity>();
        Element.XMLElement req = new Element.XMLElement(AccountConstants.GET_IDENTITIES_REQUEST);
        Element resp = this.invokeOnTargetAccount(req, account.getId());
        for (Element identity : resp.listElements("identity")) {
            result.add(new SoapIdentity(account, identity, (Provisioning)this));
        }
        return result;
    }

    @Override
    public void modifyIdentity(Account account, String identityName, Map<String, Object> attrs) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AccountConstants.MODIFY_IDENTITY_REQUEST);
        Element identity = req.addElement("identity");
        identity.addAttribute("name", identityName);
        SoapProvisioning.addAttrElementsMailService(identity, attrs);
        this.invokeOnTargetAccount(req, account.getId());
    }

    @Override
    public Signature createSignature(Account account, String signatureName, Map<String, Object> attrs) throws ServiceException {
        if (attrs.get("zimbraSignatureName") != null) {
            throw ZClientException.CLIENT_ERROR("invalid attr: zimbraSignatureName", null);
        }
        Element.XMLElement req = new Element.XMLElement(AccountConstants.CREATE_SIGNATURE_REQUEST);
        Element signature = req.addElement("signature");
        signature.addAttribute("name", signatureName);
        SoapSignature.toXML(signature, attrs);
        Element response = this.invokeOnTargetAccount(req, account.getId()).getElement("signature");
        return new SoapSignature(account, response, (Provisioning)this);
    }

    @Override
    public Signature restoreSignature(Account account, String signatureName, Map<String, Object> attrs) throws ServiceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void modifySignature(Account account, String signatureId, Map<String, Object> attrs) throws ServiceException {
        if (attrs.get("zimbraSignatureId") != null) {
            throw ZClientException.CLIENT_ERROR("invalid attr: zimbraSignatureId", null);
        }
        Element.XMLElement req = new Element.XMLElement(AccountConstants.MODIFY_SIGNATURE_REQUEST);
        Element signature = req.addElement("signature");
        signature.addAttribute("id", signatureId);
        SoapSignature.toXML(signature, attrs);
        this.invokeOnTargetAccount(req, account.getId());
    }

    @Override
    public void deleteSignature(Account account, String signatureId) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AccountConstants.DELETE_SIGNATURE_REQUEST);
        Element signature = req.addElement("signature");
        signature.addAttribute("id", signatureId);
        this.invokeOnTargetAccount(req, account.getId());
    }

    @Override
    public List<Signature> getAllSignatures(Account account) throws ServiceException {
        ArrayList<Signature> result = new ArrayList<Signature>();
        Element.XMLElement req = new Element.XMLElement(AccountConstants.GET_SIGNATURES_REQUEST);
        Element resp = this.invokeOnTargetAccount(req, account.getId());
        for (Element signature : resp.listElements("signature")) {
            result.add(new SoapSignature(account, signature, (Provisioning)this));
        }
        return result;
    }

    @Override
    public DataSource createDataSource(Account account, DataSource.Type dsType, String dsName, Map<String, Object> attrs) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.CREATE_DATA_SOURCE_REQUEST);
        req.addElement("id").setText(account.getId());
        Element ds = req.addElement("dataSource");
        ds.addAttribute("name", dsName);
        ds.addAttribute("type", dsType.name());
        SoapProvisioning.addAttrElements(ds, attrs);
        Element response = this.invoke(req).getElement("dataSource");
        return new SoapDataSource(account, response, (Provisioning)this);
    }

    @Override
    public DataSource createDataSource(Account account, DataSource.Type dsType, String dsName, Map<String, Object> attrs, boolean passwdAlreadyEncrypted) throws ServiceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataSource restoreDataSource(Account account, DataSource.Type dsType, String dsName, Map<String, Object> attrs) throws ServiceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteDataSource(Account account, String dataSourceId) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.DELETE_DATA_SOURCE_REQUEST);
        req.addElement("id").setText(account.getId());
        Element ds = req.addElement("dataSource");
        ds.addAttribute("id", dataSourceId);
        this.invoke(req);
    }

    @Override
    public List<DataSource> getAllDataSources(Account account) throws ServiceException {
        ArrayList<DataSource> result = new ArrayList<DataSource>();
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_DATA_SOURCES_REQUEST);
        req.addElement("id").setText(account.getId());
        Element resp = this.invoke(req);
        for (Element dataSource : resp.listElements("dataSource")) {
            result.add(new SoapDataSource(account, dataSource, (Provisioning)this));
        }
        return result;
    }

    @Override
    public void modifyDataSource(Account account, String dataSourceId, Map<String, Object> attrs) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.MODIFY_DATA_SOURCE_REQUEST);
        req.addElement("id").setText(account.getId());
        Element ds = req.addElement("dataSource");
        ds.addAttribute("id", dataSourceId);
        SoapProvisioning.addAttrElements(ds, attrs);
        this.invoke(req);
    }

    @Override
    public DataSource get(Account account, Provisioning.DataSourceBy keyType, String key) throws ServiceException {
        switch (keyType) {
            case name: {
                for (DataSource source : this.getAllDataSources(account)) {
                    if (!source.getName().equalsIgnoreCase(key)) continue;
                    return source;
                }
                return null;
            }
            case id: {
                for (DataSource source : this.getAllDataSources(account)) {
                    if (!source.getId().equalsIgnoreCase(key)) continue;
                    return source;
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public List<XMPPComponent> getAllXMPPComponents() throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_ALL_XMPPCOMPONENTS_REQUEST);
        Element response = this.invoke(req);
        ArrayList<XMPPComponent> toRet = new ArrayList<XMPPComponent>();
        for (Element e : response.listElements("xmppcomponent")) {
            toRet.add(new SoapXMPPComponent(e, this));
        }
        return toRet;
    }

    @Override
    public XMPPComponent createXMPPComponent(String name, Domain domain, Server server, Map<String, Object> attrs) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.CREATE_XMPPCOMPONENT_REQUEST);
        Element c = req.addElement("xmppcomponent");
        c.addAttribute("name", name);
        Element domainElt = c.addElement("domain");
        domainElt.addAttribute("by", "id");
        domainElt.setText(domain.getId());
        Element serverElt = c.addElement("server");
        serverElt.addAttribute("by", "id");
        serverElt.setText(server.getId());
        SoapProvisioning.addAttrElements(c, attrs);
        Element response = this.invoke(req);
        response = response.getElement("xmppcomponent");
        return new SoapXMPPComponent(response, this);
    }

    @Override
    public XMPPComponent get(Provisioning.XMPPComponentBy keyType, String key) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_XMPPCOMPONENT_REQUEST);
        Element c = req.addElement("xmppcomponent");
        c.addAttribute("by", keyType.name());
        c.setText(key);
        Element response = this.invoke(req);
        response = response.getElement("xmppcomponent");
        return new SoapXMPPComponent(response, this);
    }

    @Override
    public void deleteXMPPComponent(XMPPComponent comp) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.DELETE_XMPPCOMPONENT_REQUEST);
        Element c = req.addElement("xmppcomponent");
        c.addAttribute("by", "id");
        c.setText(comp.getId());
        this.invoke(req);
    }

    @Override
    public Identity get(Account account, Provisioning.IdentityBy keyType, String key) throws ServiceException {
        switch (keyType) {
            case name: {
                for (Identity identity : this.getAllIdentities(account)) {
                    if (!identity.getName().equalsIgnoreCase(key)) continue;
                    return identity;
                }
                return null;
            }
            case id: {
                for (Identity identity : this.getAllIdentities(account)) {
                    if (!identity.getId().equalsIgnoreCase(key)) continue;
                    return identity;
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public Signature get(Account account, Provisioning.SignatureBy keyType, String key) throws ServiceException {
        switch (keyType) {
            case name: {
                for (Signature signature : this.getAllSignatures(account)) {
                    if (!signature.getName().equalsIgnoreCase(key)) continue;
                    return signature;
                }
                return null;
            }
            case id: {
                for (Signature signature : this.getAllSignatures(account)) {
                    if (!signature.getId().equalsIgnoreCase(key)) continue;
                    return signature;
                }
                return null;
            }
        }
        return null;
    }

    public void deleteMailbox(String accountId) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.DELETE_MAILBOX_REQUEST);
        req.addElement("mbox").addAttribute("id", accountId);
        Element resp = this.invoke(req);
    }

    private Element toXML(Element req, String targetType, Provisioning.TargetBy targetBy, String target) {
        Element eTarget = req.addElement("target");
        eTarget.addAttribute("type", targetType);
        if (target != null) {
            eTarget.addAttribute("by", targetBy.toString());
            eTarget.setText(target);
        }
        return eTarget;
    }

    private Element toXML(Element req, String granteeType, Provisioning.GranteeBy granteeBy, String grantee) {
        Element eGrantee = req.addElement("grantee");
        if (granteeType != null) {
            eGrantee.addAttribute("type", granteeType);
        }
        eGrantee.addAttribute("by", granteeBy.toString());
        eGrantee.setText(grantee);
        return eGrantee;
    }

    private Element toXML(Element req, String right, RightModifier rightModifier) {
        Element eRight = req.addElement("right");
        if (rightModifier != null) {
            eRight.addAttribute(rightModifier.getSoapAttrMapping(), true);
        }
        eRight.setText(right);
        return eRight;
    }

    @Override
    public Map<String, List<Provisioning.RightsDoc>> getRightsDoc(String[] pkgs) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_RIGHTS_DOC_REQUEST);
        if (pkgs != null) {
            for (String pkg : pkgs) {
                req.addElement("package").addAttribute("name", pkg);
            }
        }
        Element resp = this.invoke(req);
        TreeMap<String, List<Provisioning.RightsDoc>> allDocs = new TreeMap<String, List<Provisioning.RightsDoc>>();
        for (Element ePkg : resp.listElements("package")) {
            ArrayList<Provisioning.RightsDoc> docs = new ArrayList<Provisioning.RightsDoc>();
            allDocs.put(ePkg.getAttribute("name"), docs);
            for (Element eCmd : ePkg.listElements("cmd")) {
                Provisioning.RightsDoc doc = new Provisioning.RightsDoc(eCmd.getAttribute("name"));
                Element eRights = eCmd.getElement("rights");
                for (Element eRight : eRights.listElements("right")) {
                    doc.addRight(eRight.getAttribute("name"));
                }
                Element eDesc = eCmd.getElement("desc");
                for (Element eNote : eDesc.listElements("note")) {
                    doc.addNote(eNote.getText());
                }
                docs.add(doc);
            }
        }
        return allDocs;
    }

    @Override
    public Right getRight(String rightName, boolean expandAllAttrs) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_RIGHT_REQUEST);
        req.addAttribute("expandAllAttrs", expandAllAttrs);
        req.addElement("right").setText(rightName);
        Element resp = this.invoke(req);
        Element eRight = resp.getElement("right");
        Right right = RightCommand.XMLToRight(eRight);
        return right;
    }

    @Override
    public List<Right> getAllRights(String targetType, boolean expandAllAttrs) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_ALL_RIGHTS_REQUEST);
        req.addAttribute("targetType", targetType);
        req.addAttribute("expandAllAttrs", expandAllAttrs);
        Element resp = this.invoke(req);
        ArrayList<Right> rights = new ArrayList<Right>();
        for (Element eRight : resp.listElements("right")) {
            rights.add(RightCommand.XMLToRight(eRight));
        }
        return rights;
    }

    @Override
    public boolean checkRight(String targetType, Provisioning.TargetBy targetBy, String target, Provisioning.GranteeBy granteeBy, String grantee, String right, Map<String, Object> attrs, AccessManager.ViaGrant via) throws ServiceException {
        Element eVia;
        Element.XMLElement req = new Element.XMLElement(AdminConstants.CHECK_RIGHT_REQUEST);
        this.toXML((Element)req, targetType, targetBy, target);
        this.toXML((Element)req, null, granteeBy, grantee);
        this.toXML(req, right, null);
        SoapProvisioning.addAttrElements(req, attrs);
        Element resp = this.invoke(req);
        boolean result = resp.getAttributeBool("allow");
        if (via != null && (eVia = resp.getOptionalElement("via")) != null) {
            Element eTarget = eVia.getElement("target");
            Element eGrantee = eVia.getElement("grantee");
            Element eRight = eVia.getElement("right");
            via.setImpl(new ViaGrantImpl(eTarget.getAttribute("type"), eTarget.getText(), eGrantee.getAttribute("type"), eGrantee.getText(), eRight.getText(), eRight.getAttributeBool("deny", false)));
        }
        return result;
    }

    @Override
    public RightCommand.AllEffectiveRights getAllEffectiveRights(String granteeType, Provisioning.GranteeBy granteeBy, String grantee, boolean expandSetAttrs, boolean expandGetAttrs) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_ALL_EFFECTIVE_RIGHTS_REQUEST);
        String expandAttrs = null;
        if (expandSetAttrs && expandGetAttrs) {
            expandAttrs = "setAttrs,getAttrs";
        } else if (expandSetAttrs) {
            expandAttrs = "setAttrs";
        } else if (expandGetAttrs) {
            expandAttrs = "getAttrs";
        }
        if (expandAttrs != null) {
            req.addAttribute("expandAllAttrs", expandAttrs);
        }
        if (granteeType != null && granteeBy != null && grantee != null) {
            this.toXML((Element)req, granteeType, granteeBy, grantee);
        }
        Element resp = this.invoke(req);
        return RightCommand.AllEffectiveRights.fromXML(resp);
    }

    @Override
    public RightCommand.EffectiveRights getEffectiveRights(String targetType, Provisioning.TargetBy targetBy, String target, Provisioning.GranteeBy granteeBy, String grantee, boolean expandSetAttrs, boolean expandGetAttrs) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_EFFECTIVE_RIGHTS_REQUEST);
        String expandAttrs = null;
        if (expandSetAttrs && expandGetAttrs) {
            expandAttrs = "setAttrs,getAttrs";
        } else if (expandSetAttrs) {
            expandAttrs = "setAttrs";
        } else if (expandGetAttrs) {
            expandAttrs = "getAttrs";
        }
        if (expandAttrs != null) {
            req.addAttribute("expandAllAttrs", expandAttrs);
        }
        this.toXML((Element)req, targetType, targetBy, target);
        if (granteeBy != null && grantee != null) {
            this.toXML((Element)req, null, granteeBy, grantee);
        }
        Element resp = this.invoke(req);
        return RightCommand.EffectiveRights.fromXML_EffectiveRights(resp);
    }

    @Override
    public RightCommand.EffectiveRights getCreateObjectAttrs(String targetType, Provisioning.DomainBy domainBy, String domain, Provisioning.CosBy cosBy, String cos, Provisioning.GranteeBy granteeBy, String grantee) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_CREATE_OBJECT_ATTRS_REQUEST);
        Element eTarget = req.addElement("target");
        eTarget.addAttribute("type", targetType);
        if (domainBy != null && domain != null) {
            Element eDomain = req.addElement("domain");
            eDomain.addAttribute("by", domainBy.toString());
            eDomain.setText(domain);
        }
        if (cosBy != null && cos != null) {
            Element eCos = req.addElement("cos");
            eCos.addAttribute("by", cosBy.toString());
            eCos.setText(cos);
        }
        Element resp = this.invoke(req);
        return RightCommand.EffectiveRights.fromXML_CreateObjectAttrs(resp);
    }

    @Override
    public RightCommand.Grants getGrants(String targetType, Provisioning.TargetBy targetBy, String target, String granteeType, Provisioning.GranteeBy granteeBy, String grantee, boolean granteeIncludeGroupsGranteeBelongs) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_GRANTS_REQUEST);
        if (targetType != null) {
            this.toXML((Element)req, targetType, targetBy, target);
        }
        if (granteeType != null) {
            Element eGrantee = this.toXML((Element)req, granteeType, granteeBy, grantee);
            eGrantee.addAttribute("all", granteeIncludeGroupsGranteeBelongs);
        }
        Element resp = this.invoke(req);
        return new RightCommand.Grants(resp);
    }

    @Override
    public void grantRight(String targetType, Provisioning.TargetBy targetBy, String target, String granteeType, Provisioning.GranteeBy granteeBy, String grantee, String right, RightModifier rightModifier) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GRANT_RIGHT_REQUEST);
        this.toXML((Element)req, targetType, targetBy, target);
        this.toXML((Element)req, granteeType, granteeBy, grantee);
        this.toXML(req, right, rightModifier);
        Element resp = this.invoke(req);
    }

    @Override
    public void revokeRight(String targetType, Provisioning.TargetBy targetBy, String target, String granteeType, Provisioning.GranteeBy granteeBy, String grantee, String right, RightModifier rightModifier) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.REVOKE_RIGHT_REQUEST);
        this.toXML((Element)req, targetType, targetBy, target);
        this.toXML((Element)req, granteeType, granteeBy, grantee);
        this.toXML(req, right, rightModifier);
        Element resp = this.invoke(req);
    }

    @Override
    public void flushCache(Provisioning.CacheEntryType type, Provisioning.CacheEntry[] entries) throws ServiceException {
        this.flushCache(type.name(), entries);
    }

    public void flushCache(String type, Provisioning.CacheEntry[] entries) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.FLUSH_CACHE_REQUEST);
        Element eCache = req.addElement("cache").addAttribute("type", type);
        if (entries != null) {
            for (Provisioning.CacheEntry entry : entries) {
                eCache.addElement("entry").addAttribute("by", entry.mEntryBy.name()).addText(entry.mEntryIdentity);
            }
        }
        this.invoke(req);
    }

    @Override
    public Provisioning.CountAccountResult countAccount(Domain domain) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.COUNT_ACCOUNT_REQUEST);
        Element eDomain = req.addElement("domain");
        eDomain.setText(domain.getId());
        eDomain.addAttribute("by", Provisioning.DomainBy.id.name());
        Element resp = this.invoke(req);
        Provisioning.CountAccountResult result = new Provisioning.CountAccountResult();
        for (Element eCos : resp.listElements("cos")) {
            result.addCountAccountByCosResult(eCos.getAttribute("id"), eCos.getAttribute("name"), Long.valueOf(eCos.getText()));
        }
        return result;
    }

    @Override
    public void purgeAccountCalendarCache(String accountId) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.PURGE_ACCOUNT_CALENDAR_CACHE_REQUEST);
        req.addAttribute("id", accountId);
        this.invoke(req);
    }

    @Override
    public void reloadMemcachedClientConfig() throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.RELOAD_MEMCACHED_CLIENT_CONFIG_REQUEST);
        this.invoke(req);
    }

    public MemcachedClientConfig getMemcachedClientConfig() throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_MEMCACHED_CLIENT_CONFIG_REQUEST);
        Element resp = this.invoke(req);
        MemcachedClientConfig config = new MemcachedClientConfig();
        config.serverList = resp.getAttribute("serverList", null);
        config.hashAlgorithm = resp.getAttribute("hashAlgorithm", null);
        config.binaryProtocol = resp.getAttributeBool("binaryProtocol", false);
        config.defaultExpirySeconds = (int)resp.getAttributeLong("defaultExpirySeconds", 0L);
        config.defaultTimeoutMillis = resp.getAttributeLong("defaultTimeoutMillis", 0L);
        return config;
    }

    @Override
    public void publishShareInfo(DistributionList dl, Provisioning.PublishShareInfoAction action, Account ownerAcct, String folderIdOrPath) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.PUBLISH_SHARE_INFO_REQUEST);
        Element eDL = req.addElement("dl");
        eDL.addAttribute("by", Provisioning.DistributionListBy.id.name());
        eDL.setText(dl.getId());
        Element eShare = req.addElement("share");
        eShare.addAttribute("action", action.name());
        eShare.addElement("owner").addAttribute("by", Provisioning.AccountBy.id.name()).setText(ownerAcct.getId());
        eShare.addElement("folder").addAttribute("pathOrId", folderIdOrPath);
        this.invoke(req);
    }

    @Override
    public void getPublishedShareInfo(DistributionList dl, Account ownerAcct, Provisioning.PublishedShareInfoVisitor visitor) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_PUBLISHED_SHARE_INFO_REQUEST);
        Element eDL = req.addElement("dl");
        eDL.addAttribute("by", Provisioning.DistributionListBy.id.name());
        eDL.setText(dl.getId());
        if (ownerAcct != null) {
            req.addElement("owner").addAttribute("by", Provisioning.AccountBy.id.name()).setText(ownerAcct.getId());
        }
        Element resp = this.invoke(req);
        for (Element eShare : resp.listElements("share")) {
            ShareInfoData sid = ShareInfoData.fromXML(eShare);
            visitor.visit(sid);
        }
    }

    @Override
    public void getShareInfo(Account ownerAcct, Provisioning.PublishedShareInfoVisitor visitor) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_SHARE_INFO_REQUEST);
        req.addElement("owner").addAttribute("by", Provisioning.AccountBy.id.name()).setText(ownerAcct.getId());
        Element resp = this.invoke(req);
        for (Element eShare : resp.listElements("share")) {
            ShareInfoData sid = ShareInfoData.fromXML(eShare);
            visitor.visit(sid);
        }
    }

    public static void main(String[] args) throws Exception {
        CliUtil.toolSetup();
        SoapProvisioning prov = new SoapProvisioning();
        prov.soapSetURI("https://localhost:7071/service/admin/soap/");
        prov.soapZimbraAdminAuthenticate();
        HashMap<String, String[]> acctAttrs = new HashMap<String, String[]>();
        acctAttrs.put("zimbraForeignPrincipal", new String[0]);
        Account acct = prov.get(Provisioning.AccountBy.name, "user1");
        prov.modifyAttrs(acct, acctAttrs);
    }

    public class MemcachedClientConfig {
        public String serverList;
        public String hashAlgorithm;
        public boolean binaryProtocol;
        public int defaultExpirySeconds;
        public long defaultTimeoutMillis;
    }

    public static class ReIndexInfo {
        private String mStatus;
        private Progress mProgress;

        public String getStatus() {
            return this.mStatus;
        }

        public Progress getProgress() {
            return this.mProgress;
        }

        ReIndexInfo(String status, Progress progress) {
            this.mStatus = status;
            this.mProgress = progress;
        }

        public static class Progress {
            private long mNumSucceeded;
            private long mNumFailed;
            private long mNumRemaining;

            public long getNumSucceeded() {
                return this.mNumSucceeded;
            }

            public long getNumFailed() {
                return this.mNumFailed;
            }

            public long getNumRemaining() {
                return this.mNumRemaining;
            }

            Progress() {
            }

            Progress(long numSucceeded, long numFailed, long numRemaining) {
                this.mNumSucceeded = numSucceeded;
                this.mNumFailed = numFailed;
                this.mNumRemaining = numRemaining;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReIndexBy {
        types,
        ids;

    }

    public static class MailboxInfo {
        private long mUsed;
        private String mMboxId;

        public long getUsed() {
            return this.mUsed;
        }

        public String getMailboxId() {
            return this.mMboxId;
        }

        public MailboxInfo(String id, long used) {
            this.mMboxId = id;
            this.mUsed = used;
        }
    }

    public static class QuotaUsage {
        public String mName;
        public String mId;
        long mUsed;
        long mLimit;

        public String getName() {
            return this.mName;
        }

        public String getId() {
            return this.mId;
        }

        public long getUsed() {
            return this.mUsed;
        }

        public long getLimit() {
            return this.mLimit;
        }

        QuotaUsage(Element e) throws ServiceException {
            this.mName = e.getAttribute("name");
            this.mId = e.getAttribute("id");
            this.mUsed = e.getAttributeLong("used");
            this.mLimit = e.getAttributeLong("limit");
        }
    }

    public static class DelegateAuthResponse {
        private ZAuthToken mAuthToken;
        private long mExpires;
        private long mLifetime;

        DelegateAuthResponse(Element e) throws ServiceException {
            this.mAuthToken = new ZAuthToken(e.getElement("authToken"), false);
            this.mLifetime = e.getAttributeLong("lifetime");
            this.mExpires = System.currentTimeMillis() + this.mLifetime;
            Element re = e.getOptionalElement("refer");
        }

        public ZAuthToken getAuthToken() {
            return this.mAuthToken;
        }

        public long getExpires() {
            return this.mExpires;
        }

        public long getLifetime() {
            return this.mLifetime;
        }
    }

    public static class Options {
        private String mAccount;
        private Provisioning.AccountBy mAccountBy = Provisioning.AccountBy.name;
        private String mPassword;
        private ZAuthToken mAuthToken;
        private String mUri;
        private int mTimeout = -1;
        private int mRetryCount = -1;
        private SoapTransport.DebugListener mDebugListener;
        private boolean mLocalConfigAuth;

        public Options() {
        }

        public Options(String account, Provisioning.AccountBy accountBy, String password, String uri) {
            this.mAccount = account;
            this.mAccountBy = accountBy;
            this.mPassword = password;
            this.mUri = uri;
        }

        public Options(String authToken, String uri) {
            this.mAuthToken = new ZAuthToken(null, authToken, null);
            this.mUri = uri;
        }

        public Options(ZAuthToken authToken, String uri) {
            this.mAuthToken = authToken;
            this.mUri = uri;
        }

        public String getAccount() {
            return this.mAccount;
        }

        public void setAccount(String account) {
            this.mAccount = account;
        }

        public Provisioning.AccountBy getAccountBy() {
            return this.mAccountBy;
        }

        public void setAccountBy(Provisioning.AccountBy accountBy) {
            this.mAccountBy = accountBy;
        }

        public String getPassword() {
            return this.mPassword;
        }

        public void setPassword(String password) {
            this.mPassword = password;
        }

        public ZAuthToken getAuthToken() {
            return this.mAuthToken;
        }

        public void setAuthToken(ZAuthToken authToken) {
            this.mAuthToken = authToken;
        }

        public void setAuthToken(String authToken) {
            this.mAuthToken = new ZAuthToken(null, authToken, null);
        }

        public String getUri() {
            return this.mUri;
        }

        public void setUri(String uri) {
            this.mUri = uri;
        }

        public int getTimeout() {
            return this.mTimeout;
        }

        public void setTimeout(int timeout) {
            this.mTimeout = timeout;
        }

        public int getRetryCount() {
            return this.mRetryCount;
        }

        public void setRetryCount(int retryCount) {
            this.mRetryCount = retryCount;
        }

        public SoapTransport.DebugListener getDebugListener() {
            return this.mDebugListener;
        }

        public void setDebugListener(SoapTransport.DebugListener liistener) {
            this.mDebugListener = liistener;
        }

        public boolean getLocalConfigAuth() {
            return this.mLocalConfigAuth;
        }

        public void setLocalConfigAuth(boolean auth) {
            this.mLocalConfigAuth = auth;
        }
    }
}

