/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.soap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.soap.SoapEntry;
import com.zimbra.cs.account.soap.SoapProvisioning;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SoapDistributionList
extends DistributionList
implements SoapEntry {
    SoapDistributionList(String name, String id, Map<String, Object> attrs, Provisioning prov) {
        super(name, id, attrs, prov);
    }

    SoapDistributionList(Element e, Provisioning prov) throws ServiceException {
        super(e.getAttribute("name"), e.getAttribute("id"), SoapProvisioning.getAttrs(e), prov);
        this.addDlm(e, this.getRawAttrs());
    }

    private void addDlm(Element e, Map<String, Object> attrs) {
        ArrayList<String> list = new ArrayList<String>();
        for (Element dlm : e.listElements("dlm")) {
            list.add(dlm.getText());
        }
        attrs.put("zimbraMailForwardingAddress", list.toArray(new String[list.size()]));
    }

    @Override
    public void modifyAttrs(SoapProvisioning prov, Map<String, ? extends Object> attrs, boolean checkImmutable) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.MODIFY_DISTRIBUTION_LIST_REQUEST);
        req.addElement("id").setText(this.getId());
        SoapProvisioning.addAttrElements(req, attrs);
        Element dl = prov.invoke(req).getElement("dl");
        Map<String, Object> newAttrs = SoapProvisioning.getAttrs(dl);
        this.addDlm(dl, newAttrs);
        this.setAttrs(newAttrs);
    }

    @Override
    public void reload(SoapProvisioning prov) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_DISTRIBUTION_LIST_REQUEST);
        Element a = req.addElement("dl");
        a.setText(this.getId());
        a.addAttribute("by", Provisioning.DistributionListBy.id.name());
        Element dl = prov.invoke(req).getElement("dl");
        Map<String, Object> attrs = SoapProvisioning.getAttrs(dl);
        this.addDlm(dl, attrs);
        this.setAttrs(attrs);
    }
}

