/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.soap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.soap.SoapEntry;
import com.zimbra.cs.account.soap.SoapProvisioning;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SoapCos
extends Cos
implements SoapEntry {
    SoapCos(String name, String id, Map<String, Object> attrs, Provisioning prov) {
        super(name, id, attrs, prov);
    }

    SoapCos(Element e, Provisioning prov) throws ServiceException {
        super(e.getAttribute("name"), e.getAttribute("id"), SoapProvisioning.getAttrs(e), prov);
    }

    @Override
    public void modifyAttrs(SoapProvisioning prov, Map<String, ? extends Object> attrs, boolean checkImmutable) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.MODIFY_COS_REQUEST);
        req.addElement("id").setText(this.getId());
        SoapProvisioning.addAttrElements(req, attrs);
        this.setAttrs(SoapProvisioning.getAttrs(prov.invoke(req).getElement("cos")));
    }

    @Override
    public void reload(SoapProvisioning prov) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_COS_REQUEST);
        Element a = req.addElement("cos");
        a.setText(this.getId());
        a.addAttribute("by", Provisioning.CosBy.id.name());
        this.setAttrs(SoapProvisioning.getAttrs(prov.invoke(req).getElement("cos")));
    }
}

