/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.soap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.CalendarResource;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.soap.SoapEntry;
import com.zimbra.cs.account.soap.SoapProvisioning;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SoapCalendarResource
extends CalendarResource
implements SoapEntry {
    SoapCalendarResource(String name, String id, Map<String, Object> attrs, Provisioning prov) {
        super(name, id, attrs, null, prov);
    }

    SoapCalendarResource(Element e, Provisioning prov) throws ServiceException {
        super(e.getAttribute("name"), e.getAttribute("id"), SoapProvisioning.getAttrs(e), null, prov);
    }

    @Override
    public void modifyAttrs(SoapProvisioning prov, Map<String, ? extends Object> attrs, boolean checkImmutable) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.MODIFY_CALENDAR_RESOURCE_REQUEST);
        req.addElement("id").setText(this.getId());
        SoapProvisioning.addAttrElements(req, attrs);
        this.setAttrs(SoapProvisioning.getAttrs(prov.invoke(req).getElement("calresource")));
    }

    @Override
    public void reload(SoapProvisioning prov) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_CALENDAR_RESOURCE_REQUEST);
        Element a = req.addElement("calresource");
        a.setText(this.getId());
        a.addAttribute("by", Provisioning.CalendarResourceBy.id.name());
        this.setAttrs(SoapProvisioning.getAttrs(prov.invoke(req).getElement("calresource")));
    }
}

