/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.soap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.soap.SoapProvisioning;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapAccountInfo {
    private Map<String, Object> mAttrs;
    private String mName;
    private List<String> mSoapURL;
    private String mAdminSoapURL;

    SoapAccountInfo(Element e) throws ServiceException {
        this.mAttrs = SoapProvisioning.getAttrs(e);
        this.mName = e.getElement("name").getText();
        this.mSoapURL = new ArrayList<String>();
        for (Element su : e.listElements("soapURL")) {
            this.mSoapURL.add(su.getText());
        }
        this.mAdminSoapURL = e.getElement("adminSoapURL").getText();
    }

    public List<String> getSoapURL() {
        return this.mSoapURL;
    }

    public String getAdminSoapURL() {
        return this.mAdminSoapURL;
    }

    public String getAttr(String name) {
        Object v = this.mAttrs.get(name);
        if (v instanceof String) {
            return (String)v;
        }
        if (v instanceof String[]) {
            String[] a = (String[])v;
            return a.length > 0 ? a[0] : null;
        }
        return null;
    }

    public String getAttr(String name, String defaultValue) {
        String v = this.getAttr(name);
        return v == null ? defaultValue : v;
    }
}

