/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.soap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.soap.SoapEntry;
import com.zimbra.cs.account.soap.SoapProvisioning;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SoapAccount
extends Account
implements SoapEntry {
    SoapAccount(String name, String id, Map<String, Object> attrs, Provisioning prov) {
        super(name, id, attrs, null, prov);
    }

    SoapAccount(Element e, Provisioning prov) throws ServiceException {
        super(e.getAttribute("name"), e.getAttribute("id"), SoapProvisioning.getAttrs(e), null, prov);
    }

    @Override
    public void modifyAttrs(SoapProvisioning prov, Map<String, ? extends Object> attrs, boolean checkImmutable) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.MODIFY_ACCOUNT_REQUEST);
        req.addElement("id").setText(this.getId());
        SoapProvisioning.addAttrElements(req, attrs);
        this.setAttrs(SoapProvisioning.getAttrs(prov.invoke(req).getElement("account")));
    }

    @Override
    public void reload(SoapProvisioning prov) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_ACCOUNT_REQUEST);
        Element a = req.addElement("account");
        a.setText(this.getId());
        a.addAttribute("by", Provisioning.AccountBy.id.name());
        this.setAttrs(SoapProvisioning.getAttrs(prov.invoke(req).getElement("account")));
    }
}

