/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.names;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.Config;
import com.zimbra.cs.account.Provisioning;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class NameUtil {
    private static boolean isDot(int c) {
        return c == 46 || c == 12290 || c == 65294 || c == 65377;
    }

    private static boolean containsNonLDH(String input) {
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (NameUtil.isDot(c) || !(c <= ',' || c >= '.' && c <= '/' || c >= ':' && c <= '@' || c >= '[' && c <= '`') && (c < '{' || c > '\u007f')) continue;
            return true;
        }
        return false;
    }

    public static void validEmailAddress(String addr) throws ServiceException {
        try {
            InternetAddress ia = new InternetAddress(addr, true);
            if (ia.getPersonal() != null && !ia.getPersonal().equals("")) {
                throw ServiceException.INVALID_REQUEST("invalid email address", null);
            }
        }
        catch (AddressException e) {
            throw ServiceException.INVALID_REQUEST("invalid email address", e);
        }
    }

    public static void validNewDomainName(String domain) throws ServiceException {
        String email = "test@" + domain;
        try {
            NameUtil.validEmailAddress(email);
        }
        catch (ServiceException e) {
            throw ServiceException.INVALID_REQUEST("invalid domain name " + domain, null);
        }
        Config config = Provisioning.getInstance().getConfig();
        boolean allowNonLDH = config.getBooleanAttr("zimbraAllowNonLDHCharsInDomain", true);
        if (!allowNonLDH && NameUtil.containsNonLDH(domain)) {
            throw ServiceException.INVALID_REQUEST("invalid domain name " + domain + ": " + " containing non-LDH characters and " + "zimbraAllowNonLDHCharsInDomain" + " is false", null);
        }
    }
}

