/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.ldap.upgrade;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.ldap.LdapDIT;
import com.zimbra.cs.account.ldap.LdapUtil;
import com.zimbra.cs.account.ldap.ZimbraLdapContext;
import com.zimbra.cs.account.ldap.upgrade.LdapUpgrade;
import java.io.IOException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class ZimbraPrefFromDisplay
extends LdapUpgrade {
    ZimbraPrefFromDisplay() throws ServiceException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void doUpgrade() throws ServiceException {
        NamingEnumeration<SearchResult> ne;
        byte[] cookie;
        int pageSize;
        SearchControls searchControls;
        LdapDIT dit = this.mProv.getDIT();
        String[] returnAttrs = new String[]{"objectClass", "cn", "uid", "displayName", "zimbraPrefFromDisplay"};
        String base = dit.mailBranchBaseDN();
        String query = "(&(objectclass=zimbraAccount)(!(objectclass=zimbraCalendarResource)))";
        int maxResults = 0;
        ZimbraLdapContext zlc = null;
        ZimbraLdapContext modZlc = null;
        int numModified = 0;
        try {
            try {
                zlc = new ZimbraLdapContext(true, false);
                modZlc = new ZimbraLdapContext(true);
                searchControls = new SearchControls(2, maxResults, 0, returnAttrs, false, false);
                pageSize = LdapUtil.adjustPageSize(maxResults, 1000);
                cookie = null;
                ne = null;
                try {}
                catch (Throwable throwable) {
                    Object var23_25 = null;
                    if (ne == null) throw throwable;
                    ne.close();
                    throw throwable;
                }
            }
            catch (NamingException e) {
                throw ServiceException.FAILURE("unable to list all objects", e);
            }
            catch (IOException e) {
                throw ServiceException.FAILURE("unable to list all objects", e);
            }
        }
        catch (Throwable throwable) {
            Object var25_28 = null;
            ZimbraLdapContext.closeContext(zlc);
            ZimbraLdapContext.closeContext(modZlc);
            System.out.println("\nModified " + numModified + " objects");
            throw throwable;
        }
        do {
            zlc.setPagedControl(pageSize, cookie, true);
            ne = zlc.searchDir(base, query, searchControls);
            while (ne != null && ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.nextElement();
                String dn = sr.getNameInNamespace();
                Attributes attrs = sr.getAttributes();
                String zpfd = LdapUtil.getAttrString(attrs, "zimbraPrefFromDisplay");
                if (zpfd != null) continue;
                String displayName = LdapUtil.getAttrString(attrs, "displayName");
                String cn = LdapUtil.getAttrString(attrs, "cn");
                String uid = LdapUtil.getAttrString(attrs, "uid");
                String display = displayName;
                if (display == null) {
                    display = cn;
                }
                if (display == null || display.trim().equals("") || display.equals(uid)) {
                    display = null;
                }
                if (display == null) continue;
                System.out.println("Setting zimbraPrefFromDisplay on dn [" + dn + "] to [" + display + "]");
                BasicAttributes modAttrs = new BasicAttributes(true);
                modAttrs.put("zimbraPrefFromDisplay", display);
                modZlc.replaceAttributes(dn, modAttrs);
                ++numModified;
            }
        } while ((cookie = zlc.getCookie()) != null);
        Object var23_24 = null;
        if (ne != null) {
            ne.close();
        }
        Object var25_27 = null;
        ZimbraLdapContext.closeContext(zlc);
        ZimbraLdapContext.closeContext(modZlc);
        System.out.println("\nModified " + numModified + " objects");
    }
}

