/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.ldap.upgrade;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.AttributeClass;
import com.zimbra.cs.account.Config;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.ZAttrProvisioning;
import com.zimbra.cs.account.ldap.ZimbraLdapContext;
import com.zimbra.cs.account.ldap.upgrade.LdapUpgrade;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZimbraMtaAuthEnabled
extends LdapUpgrade {
    private static final String TLSLEVEL_ENCRYPT = ZAttrProvisioning.MtaTlsSecurityLevel.may.toString();
    private static final String TLSLEVEL_MAY = ZAttrProvisioning.MtaTlsSecurityLevel.may.toString();
    private static final String TLSLEVEL_NONE = ZAttrProvisioning.MtaTlsSecurityLevel.none.toString();

    ZimbraMtaAuthEnabled() throws ServiceException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doUpgrade() throws ServiceException {
        ZimbraLdapContext zlc = new ZimbraLdapContext(true);
        try {
            this.doGlobalConfig(zlc);
            this.doAllServers(zlc);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ZimbraLdapContext.closeContext(zlc);
            throw throwable;
        }
        ZimbraLdapContext.closeContext(zlc);
    }

    private void doMtaTlsSecurityLevelOnGlobalConfig(Entry entry, Map<String, Object> attrValues) {
        String zimbraMtaAuthEnabled = entry.getAttr("zimbraMtaAuthEnabled", false);
        String zimbraMtaTlsAuthOnly = entry.getAttr("zimbraMtaTlsAuthOnly", false);
        String value = null;
        value = "TRUE".equals(zimbraMtaAuthEnabled) ? ("TRUE".equals(zimbraMtaTlsAuthOnly) ? TLSLEVEL_ENCRYPT : TLSLEVEL_MAY) : TLSLEVEL_NONE;
        attrValues.put("zimbraMtaTlsSecurityLevel", value);
    }

    private void doMtaTlsSecurityLevelOnServer(Entry entry, Map<String, Object> attrValues) {
        String zimbraMtaAuthEnabledOnServer = entry.getAttr("zimbraMtaAuthEnabled", false);
        String zimbraMtaTlsAuthOnlyOnServer = entry.getAttr("zimbraMtaTlsAuthOnly", false);
        String zimbraMtaAuthEnabled = entry.getAttr("zimbraMtaAuthEnabled");
        String zimbraMtaTlsAuthOnly = entry.getAttr("zimbraMtaTlsAuthOnly");
        String value = null;
        if ("TRUE".equals(zimbraMtaAuthEnabledOnServer)) {
            value = "TRUE".equals(zimbraMtaTlsAuthOnly) ? TLSLEVEL_ENCRYPT : TLSLEVEL_MAY;
        } else if ("FALSE".equals(zimbraMtaAuthEnabledOnServer)) {
            value = TLSLEVEL_NONE;
        } else if ("TRUE".equals(zimbraMtaAuthEnabled)) {
            if ("TRUE".equals(zimbraMtaTlsAuthOnlyOnServer)) {
                value = TLSLEVEL_ENCRYPT;
            } else if ("FALSE".equals(zimbraMtaTlsAuthOnlyOnServer)) {
                value = TLSLEVEL_MAY;
            }
        }
        if (value != null) {
            attrValues.put("zimbraMtaTlsSecurityLevel", value);
        }
    }

    private void doEntry(ZimbraLdapContext zlc, Entry entry, String entryName, AttributeClass klass) throws ServiceException {
        System.out.println();
        System.out.println("------------------------------");
        System.out.println("Checking " + entryName + ": ");
        StringBuilder msg = new StringBuilder();
        try {
            HashMap<String, Object> attrValues = new HashMap<String, Object>();
            String zimbraMtaAuthEnabled = entry.getAttr("zimbraMtaAuthEnabled", false);
            String zimbraMtaTlsAuthOnly = entry.getAttr("zimbraMtaTlsAuthOnly", false);
            System.out.println("zimbraMtaAuthEnabled: " + zimbraMtaAuthEnabled);
            System.out.println("zimbraMtaTlsAuthOnly: " + zimbraMtaTlsAuthOnly);
            System.out.println();
            String zimbraMtaTlsSecurityLevel = entry.getAttr("zimbraMtaTlsSecurityLevel", false);
            String zimbraMtaSaslAuthEnable = entry.getAttr("zimbraMtaSaslAuthEnable", false);
            if (zimbraMtaTlsSecurityLevel == null) {
                if (entry instanceof Server) {
                    this.doMtaTlsSecurityLevelOnServer(entry, attrValues);
                } else {
                    this.doMtaTlsSecurityLevelOnGlobalConfig(entry, attrValues);
                }
            } else {
                System.out.println("Not updating zimbraMtaTlsSecurityLevel because there is already a value: " + zimbraMtaTlsSecurityLevel);
            }
            if (zimbraMtaSaslAuthEnable == null) {
                if (zimbraMtaAuthEnabled != null) {
                    attrValues.put("zimbraMtaSaslAuthEnable", zimbraMtaAuthEnabled);
                }
            } else {
                System.out.println("Not updating zimbraMtaSaslAuthEnable because there is already a value: " + zimbraMtaSaslAuthEnable);
            }
            if (!attrValues.isEmpty()) {
                boolean first = true;
                for (Map.Entry attr : attrValues.entrySet()) {
                    if (!first) {
                        msg.append(", ");
                    }
                    msg.append((String)attr.getKey() + "=>" + (String)attr.getValue());
                    first = false;
                }
                System.out.println("Updating " + entryName + ": " + msg.toString());
                LdapUpgrade.modifyAttrs(entry, zlc, attrValues);
            }
        }
        catch (ServiceException e) {
            System.out.println("Caught ServiceException while modifying " + entryName + ": " + msg.toString());
            e.printStackTrace();
        }
        catch (NamingException e) {
            System.out.println("Caught NamingException while modifying " + entryName + ": " + msg.toString());
            e.printStackTrace();
        }
    }

    private void doGlobalConfig(ZimbraLdapContext zlc) throws ServiceException {
        Config config = this.mProv.getConfig();
        this.doEntry(zlc, config, "global config", AttributeClass.globalConfig);
    }

    private void doAllServers(ZimbraLdapContext zlc) throws ServiceException {
        List<Server> servers = this.mProv.getAllServers();
        for (Server server : servers) {
            this.doEntry(zlc, server, "server " + server.getName(), AttributeClass.server);
        }
    }
}

