/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.ldap.upgrade;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.Config;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.ldap.ZimbraLdapContext;
import com.zimbra.cs.account.ldap.upgrade.LdapUpgrade;
import java.util.HashMap;
import java.util.List;

public class ZimbraMessageCacheSize
extends LdapUpgrade {
    ZimbraMessageCacheSize() throws ServiceException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doUpgrade() throws ServiceException {
        ZimbraLdapContext zlc = new ZimbraLdapContext(true);
        try {
            this.doGlobalConfig(zlc);
            this.doAllServers(zlc);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ZimbraLdapContext.closeContext(zlc);
            throw throwable;
        }
        ZimbraLdapContext.closeContext(zlc);
    }

    private void doEntry(ZimbraLdapContext zlc, Entry entry, String entryName) throws ServiceException {
        String attrName = "zimbraMessageCacheSize";
        String newValue = "2000";
        System.out.println();
        System.out.println("------------------------------");
        System.out.println("Checking " + attrName + " on " + entryName);
        String curValue = entry.getAttr(attrName, false);
        if (curValue != null) {
            System.out.println("    Setting " + attrName + " on " + entryName + " from " + curValue + " to " + newValue);
            HashMap<String, String> attr = new HashMap<String, String>();
            attr.put("zimbraMessageCacheSize", newValue);
            this.mProv.modifyAttrs(entry, attr);
        }
    }

    private void doGlobalConfig(ZimbraLdapContext zlc) throws ServiceException {
        Config config = this.mProv.getConfig();
        this.doEntry(zlc, config, "global config");
    }

    private void doAllServers(ZimbraLdapContext zlc) throws ServiceException {
        List<Server> servers = this.mProv.getAllServers();
        for (Server server : servers) {
            this.doEntry(zlc, server, "server " + server.getName());
        }
    }
}

