/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.ldap.upgrade;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.ldap.ZimbraLdapContext;
import com.zimbra.cs.account.ldap.upgrade.LdapUpgrade;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.naming.NamingException;

public class ZimbraMailQuota_constraint
extends LdapUpgrade {
    ZimbraMailQuota_constraint() throws ServiceException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doUpgrade() throws ServiceException {
        ZimbraLdapContext zlc = new ZimbraLdapContext(true);
        try {
            this.doAllCos(zlc);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ZimbraLdapContext.closeContext(zlc);
            throw throwable;
        }
        ZimbraLdapContext.closeContext(zlc);
    }

    private void setZimbraMailQuotaConstraint(ZimbraLdapContext zlc, Cos cos) {
        String quotaLimitOnCosStr = cos.getAttr("zimbraDomainAdminMaxMailQuota");
        System.out.println("Cos " + cos.getName() + ": " + "zimbraDomainAdminMaxMailQuota" + "=" + quotaLimitOnCosStr);
        if (quotaLimitOnCosStr == null) {
            System.out.println("Skip setting constraint for zimbraMailQuota on cos " + cos.getName());
            return;
        }
        long quotaLimitOnCos = Long.parseLong(quotaLimitOnCosStr);
        if (quotaLimitOnCos == 0L) {
            System.out.println("Skip setting constraint for zimbraMailQuota on cos " + cos.getName());
            return;
        }
        if (quotaLimitOnCos == -1L) {
            System.out.println("Skip setting constraint for zimbraMailQuota on cos " + cos.getName());
            return;
        }
        Set<String> constraints = cos.getMultiAttrSet("zimbraConstraint");
        for (String constraint : constraints) {
            if (!constraint.startsWith("zimbraMailQuota")) continue;
            System.out.println("Skip setting constraint for zimbraMailQuota on cos " + cos.getName() + ", it is currently set to " + constraint);
            return;
        }
        String value = "zimbraMailQuota:max=" + quotaLimitOnCos;
        constraints.add(value);
        HashMap<String, String[]> newValues = new HashMap<String, String[]>();
        newValues.put("zimbraConstraint", constraints.toArray(new String[constraints.size()]));
        try {
            System.out.println("Modifying zimbraConstraint on cos " + cos.getName() + ", adding value " + value);
            LdapUpgrade.modifyAttrs(cos, zlc, newValues);
        }
        catch (ServiceException e) {
            System.out.println("Caught ServiceException while modifying zimbraConstraint attribute ");
            e.printStackTrace();
        }
        catch (NamingException e) {
            System.out.println("Caught NamingException while modifying zimbraConstraint attribute ");
            e.printStackTrace();
        }
    }

    private void doAllCos(ZimbraLdapContext zlc) throws ServiceException {
        List<Cos> coses = this.mProv.getAllCos();
        for (Cos cos : coses) {
            this.setZimbraMailQuotaConstraint(zlc, cos);
        }
    }
}

