/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.ldap.upgrade;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.Config;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.ldap.ZimbraLdapContext;
import com.zimbra.cs.account.ldap.upgrade.LdapUpgrade;
import java.util.HashMap;
import java.util.List;

public class ZimbraHsmPolicy
extends LdapUpgrade {
    ZimbraHsmPolicy() throws ServiceException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doUpgrade() throws ServiceException {
        ZimbraLdapContext zlc = new ZimbraLdapContext(true);
        try {
            this.doGlobalConfig(zlc);
            this.doAllServers(zlc);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ZimbraLdapContext.closeContext(zlc);
            throw throwable;
        }
        ZimbraLdapContext.closeContext(zlc);
    }

    private void doEntry(ZimbraLdapContext zlc, Entry entry, String entryName) throws ServiceException {
        String oldAttr = "zimbraHsmAge";
        String newAttr = "zimbraHsmPolicy";
        System.out.println();
        System.out.println("Checking " + entryName);
        String oldValue = entry.getAttr(oldAttr, false);
        String newValue = entry.getAttr(newAttr, false);
        if (oldValue != null) {
            if (newValue == null) {
                newValue = String.format("message,document:before:-%dminutes", entry.getTimeInterval(oldAttr, 0L) / 60000L);
                System.out.println("    Setting " + newAttr + " on " + entryName + " from " + oldAttr + " value: [" + oldValue + "]" + " to [" + newValue + "]");
                HashMap<String, String> attr = new HashMap<String, String>();
                attr.put(newAttr, newValue);
                this.mProv.modifyAttrs(entry, attr);
            } else {
                System.out.println("    " + newAttr + " already has a value: [" + newValue + "], skipping");
            }
        }
    }

    private void doGlobalConfig(ZimbraLdapContext zlc) throws ServiceException {
        Config config = this.mProv.getConfig();
        this.doEntry(zlc, config, "global config");
    }

    private void doAllServers(ZimbraLdapContext zlc) throws ServiceException {
        List<Server> servers = this.mProv.getAllServers();
        for (Server server : servers) {
            this.doEntry(zlc, server, "server " + server.getName());
        }
    }
}

