/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.ldap.upgrade;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.ldap.LdapDIT;
import com.zimbra.cs.account.ldap.LdapUtil;
import com.zimbra.cs.account.ldap.ZimbraLdapContext;
import com.zimbra.cs.account.ldap.upgrade.LdapUpgrade;
import java.io.IOException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;

public class ZimbraCreateTimestamp
extends LdapUpgrade {
    private Type mType;

    ZimbraCreateTimestamp() throws ServiceException {
    }

    boolean parseCommandLine(CommandLine cl) {
        String[] args = cl.getArgs();
        if (args.length == 1) {
            try {
                this.mType = Type.fromString(args[0]);
            }
            catch (ServiceException e) {
                LdapUpgrade.usage(null, this, "invalid type: " + args[0]);
                return false;
            }
        } else if (args.length != 0) {
            LdapUpgrade.usage(null, this, "invalid arg");
            return false;
        }
        return true;
    }

    void usage(HelpFormatter helpFormatter) {
        System.out.println();
        System.out.println("args for bug " + this.mBug + ":");
        System.out.println("    [type]");
        System.out.println();
        System.out.println("type can be: (if omitted, it means all objects)");
        for (Type t : Type.values()) {
            System.out.println("    " + t.name());
        }
        System.out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void doUpgrade() throws ServiceException {
        NamingEnumeration<SearchResult> ne;
        byte[] cookie;
        int pageSize;
        SearchControls searchControls;
        String query;
        String base;
        LdapDIT dit = this.mProv.getDIT();
        String[] returnAttrs = new String[]{"objectClass", "zimbraCreateTimestamp", "createTimestamp"};
        if (this.mType == null) {
            System.out.println("Checking all objects\n");
            base = dit.zimbraBaseDN();
            query = "(|(objectclass=zimbraAccount)(objectclass=zimbraAlias)(objectclass=zimbraCalendarResource)(objectclass=zimbraGlobalConfig)(objectclass=zimbraCOS)(objectclass=zimbraDataSource)(objectclass=zimbraDistributionList)(objectclass=zimbraDomain)(objectclass=zimbraIdentity)(objectclass=zimbraServer)(objectclass=zimbraSignature)(objectclass=zimbraXMPPComponent)(objectclass=zimbraZimletEntry))";
        } else {
            System.out.println("Checking " + this.mType.name() + " objects...\n");
            switch (this.mType) {
                case account: {
                    base = dit.mailBranchBaseDN();
                    query = "(&(objectclass=zimbraAccount)(!(objectclass=zimbraCalendarResource)))";
                    break;
                }
                case alias: {
                    base = dit.mailBranchBaseDN();
                    query = "(objectclass=zimbraAlias)";
                    break;
                }
                case calendarresource: {
                    base = dit.mailBranchBaseDN();
                    query = "(objectclass=zimbraCalendarResource)";
                    break;
                }
                case config: {
                    base = dit.configDN();
                    query = "(objectclass=zimbraGlobalConfig)";
                    break;
                }
                case cos: {
                    base = dit.cosBaseDN();
                    query = "(objectclass=zimbraCOS)";
                    break;
                }
                case datasource: {
                    base = dit.mailBranchBaseDN();
                    query = "(objectclass=zimbraDataSource)";
                    break;
                }
                case distributionlist: {
                    base = dit.mailBranchBaseDN();
                    query = "(objectclass=zimbraDistributionList)";
                    break;
                }
                case domain: {
                    base = dit.domainBaseDN();
                    query = "(objectclass=zimbraDomain)";
                    break;
                }
                case identity: {
                    base = dit.mailBranchBaseDN();
                    query = "(objectclass=zimbraIdentity)";
                    break;
                }
                case server: {
                    base = dit.serverBaseDN();
                    query = "(objectclass=zimbraServer)";
                    break;
                }
                case signature: {
                    base = dit.mailBranchBaseDN();
                    query = "(objectclass=zimbraSignature)";
                    break;
                }
                case xmppcomponent: {
                    base = dit.xmppcomponentBaseDN();
                    query = "(objectclass=zimbraXMPPComponent)";
                    break;
                }
                case zimlet: {
                    base = dit.zimletBaseDN();
                    query = "(objectclass=zimbraZimletEntry)";
                    break;
                }
                default: {
                    throw ServiceException.FAILURE("", null);
                }
            }
        }
        query = "(&(!(zimbraCreateTimestamp=*))" + query + ")";
        int maxResults = 0;
        ZimbraLdapContext zlc = null;
        ZimbraLdapContext modZlc = null;
        int numModified = 0;
        try {
            try {
                zlc = new ZimbraLdapContext(true, false);
                modZlc = new ZimbraLdapContext(true);
                searchControls = new SearchControls(2, maxResults, 0, returnAttrs, false, false);
                pageSize = LdapUtil.adjustPageSize(maxResults, 1000);
                cookie = null;
                ne = null;
                try {}
                catch (Throwable throwable) {
                    Object var19_21 = null;
                    if (ne == null) throw throwable;
                    ne.close();
                    throw throwable;
                }
            }
            catch (NamingException e) {
                throw ServiceException.FAILURE("unable to list all objects", e);
            }
            catch (IOException e) {
                throw ServiceException.FAILURE("unable to list all objects", e);
            }
        }
        catch (Throwable throwable) {
            Object var21_24 = null;
            ZimbraLdapContext.closeContext(zlc);
            ZimbraLdapContext.closeContext(modZlc);
            System.out.println("\nModified " + numModified + " objects");
            throw throwable;
        }
        do {
            zlc.setPagedControl(pageSize, cookie, true);
            ne = zlc.searchDir(base, query, searchControls);
            while (ne != null && ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.nextElement();
                String dn = sr.getNameInNamespace();
                Attributes attrs = sr.getAttributes();
                String createTime = LdapUtil.getAttrString(attrs, "createTimestamp");
                System.out.println(dn + " (" + createTime + ")");
                BasicAttributes modAttrs = new BasicAttributes(true);
                modAttrs.put("zimbraCreateTimestamp", createTime);
                modZlc.replaceAttributes(dn, modAttrs);
                ++numModified;
            }
        } while ((cookie = zlc.getCookie()) != null);
        Object var19_20 = null;
        if (ne != null) {
            ne.close();
        }
        Object var21_23 = null;
        ZimbraLdapContext.closeContext(zlc);
        ZimbraLdapContext.closeContext(modZlc);
        System.out.println("\nModified " + numModified + " objects");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        account,
        alias,
        calendarresource,
        config,
        cos,
        datasource,
        distributionlist,
        domain,
        identity,
        server,
        signature,
        xmppcomponent,
        zimlet;


        public static Type fromString(String s) throws ServiceException {
            try {
                return Type.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ServiceException.INVALID_REQUEST("unknown type: " + s, e);
            }
        }
    }
}

