/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.ldap.upgrade;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.ldap.upgrade.AdminRights;
import com.zimbra.cs.account.ldap.upgrade.CosAndGlobalConfigDefault;
import com.zimbra.cs.account.ldap.upgrade.DomainObjectClassAmavisAccount;
import com.zimbra.cs.account.ldap.upgrade.DomainPublicServiceProtocolAndPort;
import com.zimbra.cs.account.ldap.upgrade.LdapUpgrade;
import com.zimbra.cs.account.ldap.upgrade.ZimbraCreateTimestamp;
import com.zimbra.cs.account.ldap.upgrade.ZimbraGalLdapFilterDef_zimbraAutoComplete_zimbraSearch;
import com.zimbra.cs.account.ldap.upgrade.ZimbraGalLdapFilterDef_zimbraSync;
import com.zimbra.cs.account.ldap.upgrade.ZimbraHsmPolicy;
import com.zimbra.cs.account.ldap.upgrade.ZimbraMailQuota_constraint;
import com.zimbra.cs.account.ldap.upgrade.ZimbraMessageCacheSize;
import com.zimbra.cs.account.ldap.upgrade.ZimbraMtaAuthEnabled;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum UpgradeTask {
    BUG_14531(ZimbraGalLdapFilterDef_zimbraSync.class),
    BUG_18277(AdminRights.class),
    BUG_22033(ZimbraCreateTimestamp.class),
    BUG_27075(CosAndGlobalConfigDefault.class),
    BUG_29978(DomainPublicServiceProtocolAndPort.class),
    BUG_31694(ZimbraMessageCacheSize.class),
    BUG_32557(DomainObjectClassAmavisAccount.class),
    BUG_32719(ZimbraHsmPolicy.class),
    BUG_33814(ZimbraMtaAuthEnabled.class),
    BUG_41000(ZimbraGalLdapFilterDef_zimbraAutoComplete_zimbraSearch.class),
    BUG_42896(ZimbraMailQuota_constraint.class);

    private Class mUpgradeClass;

    private UpgradeTask(Class klass) {
        this.mUpgradeClass = klass;
    }

    static UpgradeTask fromString(String bugNumber) throws ServiceException {
        String bug = "BUG_" + bugNumber;
        try {
            return UpgradeTask.valueOf(bug);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    String getBugNumber() {
        String bug = this.name();
        return bug.substring(4);
    }

    LdapUpgrade getUpgrader() throws ServiceException {
        try {
            Object obj = this.mUpgradeClass.newInstance();
            if (obj instanceof LdapUpgrade) {
                LdapUpgrade ldapUpgrade = (LdapUpgrade)obj;
                ldapUpgrade.setBug(this.getBugNumber());
                return ldapUpgrade;
            }
        }
        catch (IllegalAccessException e) {
            throw ServiceException.FAILURE("IllegalAccessException", e);
        }
        catch (InstantiationException e) {
            throw ServiceException.FAILURE("InstantiationException", e);
        }
        throw ServiceException.FAILURE("unable to instantiate upgrade object", null);
    }

    public static void main(String[] args) throws ServiceException {
        for (UpgradeTask upgradeTask : UpgradeTask.values()) {
            LdapUpgrade upgrade = upgradeTask.getUpgrader();
            System.out.println("====================================");
            System.out.println("Testing " + upgrade.getBug() + " ");
            upgrade.setVerbose(true);
            upgrade.doUpgrade();
        }
    }
}

