/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.ldap.upgrade;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.CliUtil;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.ldap.LdapEntry;
import com.zimbra.cs.account.ldap.LdapProvisioning;
import com.zimbra.cs.account.ldap.LdapUtil;
import com.zimbra.cs.account.ldap.ZimbraLdapContext;
import com.zimbra.cs.account.ldap.upgrade.UpgradeTask;
import java.io.PrintWriter;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

abstract class LdapUpgrade {
    protected String mBug;
    protected boolean mVerbose;
    protected LdapProvisioning mProv;
    private static String O_HELP = "h";
    private static String O_BUG = "b";
    private static String O_VERBOSE = "v";

    LdapUpgrade() throws ServiceException {
        Provisioning prov = Provisioning.getInstance();
        if (!(prov instanceof LdapProvisioning)) {
            throw ServiceException.FAILURE("Provisioning is not instance of LdapProvisioning", null);
        }
        this.mProv = (LdapProvisioning)prov;
    }

    String getBug() {
        return this.mBug;
    }

    void setBug(String bug) {
        this.mBug = bug;
    }

    boolean getVerbose() {
        return this.mVerbose;
    }

    void setVerbose(boolean verbose) {
        this.mVerbose = verbose;
    }

    abstract void doUpgrade() throws ServiceException;

    boolean parseCommandLine(CommandLine cl) {
        return true;
    }

    void usage(HelpFormatter helpFormatter) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void modifyAttrs(Entry entry, ZimbraLdapContext initZlc, Map attrs) throws NamingException, ServiceException {
        ZimbraLdapContext zlc = initZlc;
        try {
            if (zlc == null) {
                zlc = new ZimbraLdapContext(true);
            }
            LdapUtil.modifyAttrs(zlc, ((LdapEntry)((Object)entry)).getDN(), attrs, entry);
            Object var5_4 = null;
            if (initZlc != null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (initZlc != null) throw throwable;
            ZimbraLdapContext.closeContext(zlc);
            throw throwable;
        }
        ZimbraLdapContext.closeContext(zlc);
    }

    private static Options getAllOptions() {
        Options options = new Options();
        options.addOption(O_HELP, "help", false, "print usage");
        options.addOption(O_VERBOSE, "verbose", false, "be verbose");
        options.addOption(O_BUG, "bug", true, "bug number this upgrade is for");
        return options;
    }

    private static String getCommandUsage() {
        return "com.zimbra.cs.account.ldap.upgrade.LdapUpgrade <options> [args]";
    }

    static void usage() {
        LdapUpgrade.usage(null, null, null);
    }

    static void usage(ParseException e, LdapUpgrade ldapUpgrade, String errMsg) {
        if (e != null) {
            System.out.println("Error parsing command line arguments: " + e.getMessage());
        }
        if (errMsg != null) {
            System.out.println(errMsg);
            System.out.println();
        }
        Options opts = LdapUpgrade.getAllOptions();
        PrintWriter pw = new PrintWriter(System.out, true);
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(pw, formatter.getWidth(), LdapUpgrade.getCommandUsage(), null, opts, formatter.getLeftPadding(), formatter.getDescPadding(), null);
        pw.flush();
        if (ldapUpgrade != null) {
            ldapUpgrade.usage(formatter);
        }
    }

    public static void main(String[] args) throws ServiceException {
        CliUtil.toolSetup();
        CommandLine cl = null;
        try {
            GnuParser parser = new GnuParser();
            Options options = LdapUpgrade.getAllOptions();
            cl = parser.parse(options, args);
            if (cl == null) {
                throw new ParseException("");
            }
        }
        catch (ParseException e) {
            LdapUpgrade.usage(e, null, null);
            System.exit(1);
        }
        if (cl.hasOption(O_HELP)) {
            LdapUpgrade.usage();
            System.exit(0);
        }
        if (!cl.hasOption(O_BUG)) {
            LdapUpgrade.usage();
            System.exit(1);
        }
        String bug = cl.getOptionValue(O_BUG);
        boolean verbose = cl.hasOption(O_VERBOSE);
        UpgradeTask upgradeTask = UpgradeTask.fromString(bug);
        if (upgradeTask == null) {
            System.out.println("unrecognized bug number");
            System.exit(1);
        }
        LdapUpgrade upgrade = upgradeTask.getUpgrader();
        upgrade.setVerbose(verbose);
        if (!upgrade.parseCommandLine(cl)) {
            System.exit(1);
        }
        upgrade.doUpgrade();
        System.out.println("\n\n--------------");
        System.out.println("all done");
    }

    static abstract class UpgradeVisitor {
        boolean mVerbose;
        LdapProvisioning mProv;
        ZimbraLdapContext mZlcForMod;

        UpgradeVisitor(LdapProvisioning prov, ZimbraLdapContext zlcForMod, boolean verbose) {
            this.mVerbose = verbose;
            this.mProv = prov;
            this.mZlcForMod = zlcForMod;
        }

        abstract void reportStat();
    }
}

