/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.ldap.upgrade;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.StringUtil;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.ldap.LdapProvisioning;
import com.zimbra.cs.account.ldap.ZimbraLdapContext;
import com.zimbra.cs.account.ldap.upgrade.LdapUpgrade;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DomainPublicServiceProtocolAndPort
extends LdapUpgrade {
    private static final int NUM_DOMAIN_SETS = 1;

    DomainPublicServiceProtocolAndPort() throws ServiceException {
    }

    private static String genQuery(List<Server> servers) {
        StringBuffer q = new StringBuffer();
        int numValues = 0;
        for (Server server : servers) {
            String serviceName = server.getAttr("zimbraServiceHostname");
            if (StringUtil.isNullOrEmpty(serviceName)) continue;
            q.append("(zimbraPublicServiceHostname=" + serviceName + ")");
            ++numValues;
        }
        String query = numValues > 1 ? "(|" + q.toString() + ")" : q.toString();
        return "(&(objectClass=zimbraDomain)" + query + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doUpgrade() throws ServiceException {
        List<Server> servers = this.mProv.getAllServers();
        String query = DomainPublicServiceProtocolAndPort.genQuery(servers);
        String[] bases = this.mProv.getSearchBases(16);
        String[] attrs = new String[]{"objectClass", "zimbraId", "zimbraDomainName", "zimbraPublicServiceHostname", "zimbraPublicServiceProtocol", "zimbraPublicServicePort"};
        ZimbraLdapContext zlc = null;
        DomainPuclicServiceProtocolAndPortVisitor visitor = null;
        try {
            zlc = new ZimbraLdapContext(true);
            visitor = new DomainPuclicServiceProtocolAndPortVisitor(this.mProv, zlc, servers, this.mVerbose);
            for (String base : bases) {
                if (this.mVerbose) {
                    System.out.println("LDAP search base: " + base);
                    System.out.println("LDAP search query: " + query);
                    System.out.println();
                }
                this.mProv.searchObjects(query, attrs, base, 192, visitor, 0, false, true);
            }
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            ZimbraLdapContext.closeContext(zlc);
            if (visitor != null) {
                visitor.reportStat();
            }
            throw throwable;
        }
        ZimbraLdapContext.closeContext(zlc);
        if (visitor != null) {
            visitor.reportStat();
        }
    }

    private Server createTestServer(String serverName, String mailMode, String mailPort, String mailSSLPort) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("zimbraServiceHostname", serverName + "-serviceName");
        if (mailMode != null) {
            attrs.put("zimbraMailMode", mailMode);
        }
        if (mailPort != null) {
            attrs.put("zimbraMailPort", mailPort);
        }
        if (mailSSLPort != null) {
            attrs.put("zimbraMailSSLPort", mailSSLPort);
        }
        System.out.println("Creating server " + serverName);
        return this.mProv.createServer(serverName, attrs);
    }

    private Domain createTestDomain(String domainName, String publicServiceHostname) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        if (publicServiceHostname != null) {
            attrs.put("zimbraPublicServiceHostname", publicServiceHostname);
        }
        System.out.println("Creating domain " + domainName);
        return this.mProv.createDomain(domainName, attrs);
    }

    private Domain createTestDomain(String domainName, String publicServiceHostname, String publicServiceProtocol, String publicServicePort) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        if (publicServiceHostname != null) {
            attrs.put("zimbraPublicServiceHostname", publicServiceHostname);
        }
        if (publicServiceProtocol != null) {
            attrs.put("zimbraPublicServiceProtocol", publicServiceProtocol);
        }
        if (publicServicePort != null) {
            attrs.put("zimbraPublicServicePort", publicServicePort);
        }
        System.out.println("Creating domain " + domainName);
        return this.mProv.createDomain(domainName, attrs);
    }

    private void populateTestData() throws ServiceException {
        for (Server s : this.mProv.getAllServers()) {
            if (s.getName().equals("phoebe.mac")) continue;
            try {
                this.mProv.deleteServer(s.getId());
                System.out.println("Deleted server " + s.getName());
            }
            catch (ServiceException e) {}
        }
        System.out.println();
        Server http = this.createTestServer("http.server", Provisioning.MailMode.http.toString(), "1000", "1001");
        Server http_portis0 = this.createTestServer("http_portis0.server", Provisioning.MailMode.http.toString(), "0", "1001");
        Server http_noport = this.createTestServer("http_noport.server", Provisioning.MailMode.http.toString(), null, "1001");
        Server https = this.createTestServer("https.server", Provisioning.MailMode.https.toString(), "2000", "2001");
        Server https_portis0 = this.createTestServer("https_portis0.server", Provisioning.MailMode.https.toString(), "2000", "0");
        Server https_noport = this.createTestServer("https_noport.server", Provisioning.MailMode.https.toString(), "2000", null);
        Server mixed = this.createTestServer("mixed.server", Provisioning.MailMode.mixed.toString(), "3000", "3001");
        Server both = this.createTestServer("both.server", Provisioning.MailMode.both.toString(), "4000", "4001");
        Server redirect = this.createTestServer("redirect.server", Provisioning.MailMode.redirect.toString(), "5000", "5001");
        Server nomailmode = this.createTestServer("nomailmode.server", null, "7000", "7001");
        for (int i = 0; i < 1; ++i) {
            this.createTestDomain("http_" + i + ".test", http.getAttr("zimbraServiceHostname"));
            this.createTestDomain("http_portis0_" + i + ".test", http_portis0.getAttr("zimbraServiceHostname"));
            this.createTestDomain("http_noport_" + i + ".test", http_noport.getAttr("zimbraServiceHostname"));
            this.createTestDomain("https_" + i + ".test", https.getAttr("zimbraServiceHostname"));
            this.createTestDomain("https_portis0_" + i + ".test", https_portis0.getAttr("zimbraServiceHostname"));
            this.createTestDomain("https_noport_" + i + ".test", https_noport.getAttr("zimbraServiceHostname"));
            this.createTestDomain("mixed_" + i + ".test", mixed.getAttr("zimbraServiceHostname"));
            this.createTestDomain("both_" + i + ".test", both.getAttr("zimbraServiceHostname"));
            this.createTestDomain("redirect_" + i + ".test", redirect.getAttr("zimbraServiceHostname"));
            this.createTestDomain("nomailmode_" + i + ".test", nomailmode.getAttr("zimbraServiceHostname"));
            this.createTestDomain("notmatch" + i + ".test", "notmatch");
            this.createTestDomain("no_PSH" + i + ".test", null);
            this.createTestDomain("proto_present_" + i + ".test", http.getAttr("zimbraServiceHostname"), "https", null);
            this.createTestDomain("port_present_" + i + ".test", http.getAttr("zimbraServiceHostname"), null, "8888");
        }
        System.out.println("\ndone");
    }

    public static void main(String[] args) throws ServiceException {
        DomainPublicServiceProtocolAndPort upgrade = new DomainPublicServiceProtocolAndPort();
        upgrade.setVerbose(true);
        upgrade.populateTestData();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DomainPuclicServiceProtocolAndPortVisitor
    extends LdapUpgrade.UpgradeVisitor
    implements NamedEntry.Visitor {
        Map<String, ServerInfo> mServerMap = new HashMap<String, ServerInfo>();
        int mDomainsVisited;

        DomainPuclicServiceProtocolAndPortVisitor(LdapProvisioning prov, ZimbraLdapContext zlcForMod, List<Server> servers, boolean verbose) {
            super(prov, zlcForMod, verbose);
            for (Server server : servers) {
                String serviceName = server.getAttr("zimbraServiceHostname");
                if (StringUtil.isNullOrEmpty(serviceName)) continue;
                ServerInfo sInfo = this.mServerMap.get(serviceName);
                if (sInfo != null) {
                    System.out.println("Found duplicated zimbraServiceHostname, server honored:" + sInfo.mServerName + ", server ignored:" + server.getName());
                    continue;
                }
                String mailModeStr = server.getAttr("zimbraMailMode");
                Provisioning.MailMode mailMode = null;
                if (mailModeStr == null) continue;
                try {
                    mailMode = Provisioning.MailMode.fromString(mailModeStr);
                }
                catch (ServiceException e) {
                    continue;
                }
                String proto = null;
                String port = null;
                if (mailMode == Provisioning.MailMode.http) {
                    proto = "http";
                    port = server.getAttr("zimbraMailPort");
                } else if (mailMode == Provisioning.MailMode.https) {
                    proto = "https";
                    port = server.getAttr("zimbraMailSSLPort");
                }
                if (proto == null) continue;
                this.mServerMap.put(server.getAttr("zimbraServiceHostname"), new ServerInfo(server.getName(), proto, port));
            }
        }

        @Override
        public void visit(NamedEntry entry) {
            if (!(entry instanceof Domain)) {
                System.out.println("Encountered non domain object: " + entry.getName() + ", skipping");
                return;
            }
            ++this.mDomainsVisited;
            Domain domain = (Domain)entry;
            String domainPublicHostname = domain.getAttr("zimbraPublicServiceHostname");
            String domainPublicProtocol = domain.getAttr("zimbraPublicServiceProtocol");
            String domainPublicPort = domain.getAttr("zimbraPublicServicePort");
            if (StringUtil.isNullOrEmpty(domainPublicHostname)) {
                if (this.mVerbose) {
                    System.out.format("Not updating domain %d: domain does not have %s\n", domain.getName(), "zimbraPublicServiceHostname");
                }
                return;
            }
            if (domainPublicProtocol != null) {
                if (this.mVerbose) {
                    System.out.format("Not updating domain %s: %s already set to %s on domain\n", domain.getName(), "zimbraPublicServiceProtocol", domainPublicProtocol);
                }
                return;
            }
            if (domainPublicPort != null) {
                if (this.mVerbose) {
                    System.out.format("Not updating domain %s: %s already set to %s on domain\n", domain.getName(), "zimbraPublicServicePort", domainPublicPort);
                }
                return;
            }
            ServerInfo serverInfo = this.mServerMap.get(domainPublicHostname);
            if (serverInfo == null) {
                if (this.mVerbose) {
                    System.out.format("Not updating domain %s\n", domain.getName());
                }
                return;
            }
            HashMap<String, String> attrs = new HashMap<String, String>();
            if (serverInfo.mProto != null) {
                attrs.put("zimbraPublicServiceProtocol", serverInfo.mProto);
            }
            if (serverInfo.mPort != null && !"0".equals(serverInfo.mPort)) {
                attrs.put("zimbraPublicServicePort", serverInfo.mPort);
            }
            try {
                System.out.format("Updating domain %-30s: proto => %-5s   port => %-5s\n", domain.getName(), attrs.get("zimbraPublicServiceProtocol"), attrs.get("zimbraPublicServicePort"));
                LdapUpgrade.modifyAttrs(domain, this.mZlcForMod, attrs);
            }
            catch (ServiceException e) {
                System.out.println("Caught ServiceException while modifying domain " + domain.getName());
                e.printStackTrace();
            }
            catch (NamingException e) {
                System.out.println("Caught NamingException while modifying domain " + domain.getName());
                e.printStackTrace();
            }
        }

        @Override
        void reportStat() {
            System.out.println();
            System.out.println("Number of domains found = " + this.mDomainsVisited);
            System.out.println();
        }

        class ServerInfo {
            String mServerName;
            String mProto;
            String mPort;

            ServerInfo(String serverName, String proto, String port) {
                this.mServerName = serverName;
                this.mProto = proto;
                this.mPort = port;
            }
        }
    }
}

