/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.ldap.upgrade;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.ldap.LdapProvisioning;
import com.zimbra.cs.account.ldap.ZimbraLdapContext;
import com.zimbra.cs.account.ldap.upgrade.LdapUpgrade;
import java.util.HashMap;
import javax.naming.NamingException;

public class DomainObjectClassAmavisAccount
extends LdapUpgrade {
    DomainObjectClassAmavisAccount() throws ServiceException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doUpgrade() throws ServiceException {
        String query = "(&(objectClass=zimbraDomain)(!(objectClass=amavisAccount)))";
        String[] bases = this.mProv.getSearchBases(16);
        String[] attrs = new String[]{"objectClass", "zimbraId", "zimbraDomainName"};
        ZimbraLdapContext zlc = null;
        AddDomainObjectClassAmavisAccountVisitor visitor = null;
        try {
            zlc = new ZimbraLdapContext(true);
            visitor = new AddDomainObjectClassAmavisAccountVisitor(this.mProv, zlc, this.mVerbose);
            for (String base : bases) {
                if (this.mVerbose) {
                    System.out.println("LDAP search base: " + base);
                    System.out.println("LDAP search query: " + query);
                    System.out.println();
                }
                this.mProv.searchObjects(query, attrs, base, 192, visitor, 0, false, true);
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            ZimbraLdapContext.closeContext(zlc);
            if (visitor != null) {
                visitor.reportStat();
            }
            throw throwable;
        }
        ZimbraLdapContext.closeContext(zlc);
        if (visitor != null) {
            visitor.reportStat();
        }
    }

    public static void main(String[] args) {
    }

    static class AddDomainObjectClassAmavisAccountVisitor
    extends LdapUpgrade.UpgradeVisitor
    implements NamedEntry.Visitor {
        int mDomainsVisited;

        AddDomainObjectClassAmavisAccountVisitor(LdapProvisioning prov, ZimbraLdapContext zlcForMod, boolean verbose) {
            super(prov, zlcForMod, verbose);
        }

        public void visit(NamedEntry entry) {
            if (!(entry instanceof Domain)) {
                System.out.println("Encountered non domain object: " + entry.getName() + ", skipping");
                return;
            }
            ++this.mDomainsVisited;
            Domain domain = (Domain)entry;
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put("+objectClass", "amavisAccount");
            try {
                System.out.format("Updating domain %-30s: objectClass=amavisAccount\n", domain.getName());
                LdapUpgrade.modifyAttrs(domain, this.mZlcForMod, attrs);
            }
            catch (ServiceException e) {
                System.out.println("Caught ServiceException while modifying domain " + domain.getName());
                e.printStackTrace();
            }
            catch (NamingException e) {
                System.out.println("Caught NamingException while modifying domain " + domain.getName());
                e.printStackTrace();
            }
        }

        void reportStat() {
            System.out.println();
            System.out.println("Number of domains modified = " + this.mDomainsVisited);
            System.out.println();
        }
    }
}

