/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.ldap.upgrade;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.AttributeCardinality;
import com.zimbra.cs.account.AttributeClass;
import com.zimbra.cs.account.AttributeInfo;
import com.zimbra.cs.account.AttributeManager;
import com.zimbra.cs.account.Config;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.ldap.ZimbraLdapContext;
import com.zimbra.cs.account.ldap.upgrade.LdapUpgrade;
import com.zimbra.cs.util.BuildInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CosAndGlobalConfigDefault
extends LdapUpgrade {
    private BuildInfo.Version mSince;

    CosAndGlobalConfigDefault() throws ServiceException {
    }

    @Override
    boolean parseCommandLine(CommandLine cl) {
        String[] args = cl.getArgs();
        if (args == null || args.length != 1) {
            LdapUpgrade.usage(null, this, "missing required argument: since");
            return false;
        }
        try {
            this.mSince = new BuildInfo.Version(args[0]);
        }
        catch (ServiceException e) {
            LdapUpgrade.usage(null, this, "invalid version: " + args[0]);
            return false;
        }
        return true;
    }

    @Override
    void usage(HelpFormatter helpFormatter) {
        System.out.println();
        System.out.println("args for bug " + this.mBug + ":");
        System.out.println("    {since}  (e.g. 5.0.12)");
        System.out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doUpgrade() throws ServiceException {
        ZimbraLdapContext zlc = new ZimbraLdapContext(true);
        try {
            this.doGlobalConfig(zlc);
            this.doAllCos(zlc);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ZimbraLdapContext.closeContext(zlc);
            throw throwable;
        }
        ZimbraLdapContext.closeContext(zlc);
    }

    private String formatMultiValue(Collection<String> values) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String v : values) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(v);
            first = false;
        }
        return sb.toString();
    }

    private boolean needsUpgrade(AttributeManager am, String attr, BuildInfo.Version attrVersion) throws ServiceException {
        String since = this.mSince.toString();
        if (attrVersion == null) {
            return false;
        }
        if (!am.inVersion(attr, since) && !attrVersion.isFuture()) {
            return true;
        }
        if (attrVersion.compare("5.0.17") == 0) {
            boolean fromATroubledInstall;
            boolean bl = fromATroubledInstall = this.mSince.compare("6.0.0_BETA1") == 0 || this.mSince.compare("6.0.0_BETA2") == 0;
            if (fromATroubledInstall) {
                return true;
            }
        }
        return false;
    }

    private void doEntry(ZimbraLdapContext zlc, Entry entry, String entryName, AttributeClass klass) throws ServiceException {
        System.out.println();
        System.out.println("------------------------------");
        System.out.println("Upgrading " + entryName + ": ");
        AttributeManager am = AttributeManager.getInstance();
        String since = this.mSince.toString();
        Set<String> attrs = am.getAttrsInClass(klass);
        HashMap<String, Object> attrValues = new HashMap<String, Object>();
        for (String attr : attrs) {
            String curVal;
            BuildInfo.Version attrVersion;
            AttributeInfo ai = am.getAttributeInfo(attr);
            if (ai == null || !this.needsUpgrade(am, attr, attrVersion = ai.getSince())) continue;
            if (this.mVerbose) {
                System.out.println("");
                System.out.println("Checking " + entryName + " attribute: " + attr + "(" + attrVersion + ")");
            }
            if ((curVal = entry.getAttr(attr)) != null) {
                if (!this.mVerbose) continue;
                if (ai.getCardinality() == AttributeCardinality.multi) {
                    curVal = this.formatMultiValue(entry.getMultiAttrSet(attr));
                }
                System.out.println("    skipping - already has value: " + curVal);
                continue;
            }
            List<String> values = null;
            if (klass == AttributeClass.globalConfig) {
                values = ai.getGlobalConfigValuesUpgrade();
                if (values == null) {
                    values = ai.getGlobalConfigValues();
                }
            } else if (klass == AttributeClass.cos) {
                values = ai.getDefaultCosValuesUpgrade();
                if (values == null) {
                    values = ai.getDefaultCosValues();
                }
            } else {
                System.out.println("Internal error: invalid attribute class " + klass.name());
                return;
            }
            if (values == null || values.size() == 0) {
                if (!this.mVerbose) continue;
                System.out.println("    skipping - does not have a default value");
                continue;
            }
            attrValues.clear();
            if (ai.getCardinality() != AttributeCardinality.multi) {
                System.out.println("    setting " + entryName + " attribute " + attr + "(" + attrVersion + ")" + " to: " + values.get(0));
                attrValues.put(attr, values.get(0));
            } else {
                System.out.println("    setting " + entryName + " attribute " + attr + "(" + attrVersion + ")" + " to: " + this.formatMultiValue(values));
                attrValues.put(attr, values.toArray(new String[0]));
            }
            try {
                LdapUpgrade.modifyAttrs(entry, zlc, attrValues);
            }
            catch (ServiceException e) {
                System.out.println("Caught ServiceException while modifying " + entryName + " attribute " + attr);
                e.printStackTrace();
            }
            catch (NamingException e) {
                System.out.println("Caught NamingException while modifying " + entryName + " attribute " + attr);
                e.printStackTrace();
            }
        }
    }

    private void doBug38425(Entry entry, String entryName) {
        String curVal;
        String theAttr = "zimbraPrefMailDefaultCharset";
        String sinceVer = this.mSince.toString();
        String thisVer = BuildInfo.VERSION;
        if (sinceVer.startsWith("6.0.0_BETA1") && thisVer.startsWith("6.0.0_BETA2") && "UTF-8".equalsIgnoreCase(curVal = entry.getAttr(theAttr))) {
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put(theAttr, "");
            try {
                System.out.println("Unsetting " + theAttr + " on " + entryName);
                this.mProv.modifyAttrs(entry, attrs);
            }
            catch (ServiceException e) {
                System.out.println("Caught ServiceException while unsetting " + theAttr + " on " + entryName);
                e.printStackTrace();
            }
        }
    }

    private void doGlobalConfig(ZimbraLdapContext zlc) throws ServiceException {
        Config config = this.mProv.getConfig();
        this.doEntry(zlc, config, "global config", AttributeClass.globalConfig);
    }

    private void doAllCos(ZimbraLdapContext zlc) throws ServiceException {
        List<Cos> coses = this.mProv.getAllCos();
        for (Cos cos : coses) {
            String name = "cos " + cos.getName();
            this.doEntry(zlc, cos, name, AttributeClass.cos);
            this.doBug38425(cos, name);
        }
    }
}

