/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.ldap.upgrade;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.GranteeType;
import com.zimbra.cs.account.accesscontrol.InlineAttrRight;
import com.zimbra.cs.account.accesscontrol.RightModifier;
import com.zimbra.cs.account.accesscontrol.TargetType;
import com.zimbra.cs.account.ldap.LdapDIT;
import com.zimbra.cs.account.ldap.LdapUtil;
import com.zimbra.cs.account.ldap.ZimbraLdapContext;
import com.zimbra.cs.account.ldap.upgrade.LdapUpgrade;
import com.zimbra.cs.account.ldap.upgrade.UpgradeTask;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminRights
extends LdapUpgrade {
    private static String[] sAdminUICompForAllDomainAdmins = new String[]{"accountListView", "aliasListView", "DLListView", "resourceListView", "saveSearch"};
    private static String[] sAdminUICompForAllGlobalAdmins = new String[]{"cartBlancheUI"};

    AdminRights() throws ServiceException {
    }

    @Override
    void doUpgrade() throws ServiceException {
        HashSet<String> domainAdminIds = new HashSet<String>();
        HashSet<String> globalAdminIds = new HashSet<String>();
        this.getAllDomainOrGlobalAdmins(domainAdminIds, globalAdminIds);
        for (String domainAdminId : domainAdminIds) {
            try {
                Domain domain;
                Account domainAdmin = this.mProv.get(Provisioning.AccountBy.id, domainAdminId);
                if (domainAdmin == null || (domain = this.mProv.getDomain(domainAdmin)) == null) continue;
                System.out.println("Upgrading domain admin: " + domainAdmin.getName());
                this.grantRights(domain, domainAdmin);
            }
            catch (ServiceException e) {
                System.out.println("Skipped upgrading global admin " + domainAdminId + " (Encountered error: " + e.getMessage() + ")");
            }
        }
        for (String globalAdminId : globalAdminIds) {
            try {
                Account globalAdmin = this.mProv.get(Provisioning.AccountBy.id, globalAdminId);
                if (globalAdmin == null) continue;
                System.out.println("Upgrading global admin: " + globalAdmin.getName());
                this.setGlobalAdminUIComp(globalAdmin);
            }
            catch (ServiceException e) {
                System.out.println("Skipped upgrading global admin " + globalAdminId + " (Encountered error: " + e.getMessage() + ")");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getAllDomainOrGlobalAdmins(Set<String> domainAdminIds, Set<String> globalAdminIds) throws ServiceException {
        NamingEnumeration<SearchResult> ne;
        byte[] cookie;
        int pageSize;
        SearchControls searchControls;
        LdapDIT dit = this.mProv.getDIT();
        String[] returnAttrs = new String[]{"objectClass", "zimbraId", "zimbraIsAdminAccount", "zimbraIsDomainAdminAccount", "zimbraIsDelegatedAdminAccount"};
        String configBranchBaseDn = dit.configBranchBaseDN();
        String base = dit.mailBranchBaseDN();
        String query = "(&(objectclass=zimbraAccount)(|(zimbraIsDomainAdminAccount=TRUE)(zimbraIsAdminAccount=TRUE)))";
        int maxResults = 0;
        ZimbraLdapContext zlc = null;
        try {
            try {
                zlc = new ZimbraLdapContext(true, new ZimbraLdapContext.LdapConfig(Boolean.FALSE, null, ZimbraLdapContext.LdapConfig.NO_TIMEOUT));
                searchControls = new SearchControls(2, maxResults, 0, returnAttrs, false, false);
                pageSize = LdapUtil.adjustPageSize(maxResults, 1000);
                cookie = null;
                ne = null;
                try {}
                catch (Throwable throwable) {
                    Object var20_22 = null;
                    if (ne == null) throw throwable;
                    ne.close();
                    throw throwable;
                }
            }
            catch (NamingException e) {
                throw ServiceException.FAILURE("unable to list all objects", e);
            }
            catch (IOException e) {
                throw ServiceException.FAILURE("unable to list all objects", e);
            }
        }
        catch (Throwable throwable) {
            Object var22_25 = null;
            ZimbraLdapContext.closeContext(zlc);
            throw throwable;
        }
        do {
            zlc.setPagedControl(pageSize, cookie, true);
            ne = zlc.searchDir(base, query, searchControls);
            while (ne != null && ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.nextElement();
                String dn = sr.getNameInNamespace();
                Attributes attrs = sr.getAttributes();
                if (dn.endsWith(configBranchBaseDn)) continue;
                String globalAdminId = this.getZimbraIdIfGlobalAdmin(attrs);
                if (globalAdminId != null) {
                    globalAdminIds.add(globalAdminId);
                    continue;
                }
                String domainAdminId = this.getZimbraIdIfDomainOnlyAdmin(attrs);
                if (domainAdminId == null) continue;
                domainAdminIds.add(domainAdminId);
            }
        } while ((cookie = zlc.getCookie()) != null);
        Object var20_21 = null;
        if (ne != null) {
            ne.close();
        }
        Object var22_24 = null;
        ZimbraLdapContext.closeContext(zlc);
    }

    String getZimbraIdIfDomainOnlyAdmin(Attributes attrs) throws NamingException {
        String isAdmin = LdapUtil.getAttrString(attrs, "zimbraIsAdminAccount");
        String isDomainAdmin = LdapUtil.getAttrString(attrs, "zimbraIsDomainAdminAccount");
        String isDelegatedAdmin = LdapUtil.getAttrString(attrs, "zimbraIsDelegatedAdminAccount");
        if ("TRUE".equals(isDomainAdmin) && !"TRUE".equals(isAdmin) && !"TRUE".equals(isDelegatedAdmin)) {
            return LdapUtil.getAttrString(attrs, "zimbraId");
        }
        return null;
    }

    String getZimbraIdIfGlobalAdmin(Attributes attrs) throws NamingException {
        String isAdmin = LdapUtil.getAttrString(attrs, "zimbraIsAdminAccount");
        if ("TRUE".equals(isAdmin)) {
            return LdapUtil.getAttrString(attrs, "zimbraId");
        }
        return null;
    }

    private void grantRights(Domain domain, Account domainAdmin) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraIsDelegatedAdminAccount", "TRUE");
        this.mProv.modifyAttrs(domainAdmin, attrs);
        this.mProv.grantRight(TargetType.domain.getCode(), Provisioning.TargetBy.id, domain.getId(), GranteeType.GT_USER.getCode(), Provisioning.GranteeBy.id, domainAdmin.getId(), "domainAdminConsoleRights", RightModifier.RM_CAN_DELEGATE);
        this.grantCosRights(domain, domainAdmin);
        this.mProv.grantRight(TargetType.global.getCode(), null, null, GranteeType.GT_USER.getCode(), Provisioning.GranteeBy.id, domainAdmin.getId(), "listZimlet", RightModifier.RM_CAN_DELEGATE);
        this.mProv.grantRight(TargetType.global.getCode(), null, null, GranteeType.GT_USER.getCode(), Provisioning.GranteeBy.id, domainAdmin.getId(), "getZimlet", RightModifier.RM_CAN_DELEGATE);
        this.setDomainAdminUIComp(domainAdmin);
        long maxQuota = domainAdmin.getLongAttr("zimbraDomainAdminMaxMailQuota", -1L);
        if (maxQuota == -1L) {
            this.mProv.grantRight(TargetType.domain.getCode(), Provisioning.TargetBy.id, domain.getId(), GranteeType.GT_USER.getCode(), Provisioning.GranteeBy.id, domainAdmin.getId(), InlineAttrRight.composeSetRight(TargetType.account, "zimbraMailQuota"), RightModifier.RM_DENY);
        }
    }

    private void grantCosRights(Domain domain, Account domainAdmin) throws ServiceException {
        Set<String> allowedCoses = domain.getMultiAttrSet("zimbraDomainCOSMaxAccounts");
        for (String c : allowedCoses) {
            String[] parts = c.split(":");
            if (parts.length != 2) continue;
            String cosId = parts[0];
            Cos cos = this.mProv.get(Provisioning.CosBy.id, cosId);
            if (cos == null) {
                System.out.println("    cannot find cos " + cosId + ", skipping granting cos right to " + domainAdmin.getName());
                continue;
            }
            this.mProv.grantRight(TargetType.cos.getCode(), Provisioning.TargetBy.id, cosId, GranteeType.GT_USER.getCode(), Provisioning.GranteeBy.id, domainAdmin.getId(), "listCos", RightModifier.RM_CAN_DELEGATE);
            this.mProv.grantRight(TargetType.cos.getCode(), Provisioning.TargetBy.id, cosId, GranteeType.GT_USER.getCode(), Provisioning.GranteeBy.id, domainAdmin.getId(), "getCos", RightModifier.RM_CAN_DELEGATE);
            this.mProv.grantRight(TargetType.cos.getCode(), Provisioning.TargetBy.id, cosId, GranteeType.GT_USER.getCode(), Provisioning.GranteeBy.id, domainAdmin.getId(), "assignCos", RightModifier.RM_CAN_DELEGATE);
        }
    }

    private void setDomainAdminUIComp(Account domainAdmin) throws ServiceException {
        this.setAdminUIComp(domainAdmin, sAdminUICompForAllDomainAdmins);
    }

    private void setGlobalAdminUIComp(Account globalAdmin) throws ServiceException {
        this.setAdminUIComp(globalAdmin, sAdminUICompForAllGlobalAdmins);
    }

    private void setAdminUIComp(Account admin, String[] adminUIComp) throws ServiceException {
        String attrName = "zimbraAdminConsoleUIComponents";
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("+" + attrName, adminUIComp);
        this.mProv.modifyAttrs(admin, attrs);
    }

    public static void main(String[] args) throws ServiceException {
        UpgradeTask upgradeTask = UpgradeTask.fromString("18277");
        LdapUpgrade upgrade = upgradeTask.getUpgrader();
        upgrade.setVerbose(true);
        upgrade.doUpgrade();
    }
}

