/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.ldap.custom;

import com.zimbra.common.localconfig.KnownKey;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.ldap.LdapDIT;
import com.zimbra.cs.account.ldap.LdapProvisioning;
import com.zimbra.cs.account.ldap.LdapUtil;
import com.zimbra.cs.account.ldap.SpecialAttrs;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomLdapDIT
extends LdapDIT {
    private final String DEFAULT_BASE_RDN_DOMAIN = "cn=domains";
    private String BASE_DN_DOMAIN;

    public CustomLdapDIT(LdapProvisioning prov) {
        super(prov);
    }

    private String getLC(KnownKey key, String defaultValue) {
        String lcValue = key.value();
        if (StringUtil.isNullOrEmpty(lcValue)) {
            return defaultValue;
        }
        return lcValue;
    }

    private String getLCAndValidateUnderConfigBranchDN(KnownKey key, String defaultValue) {
        String dn = this.getLC(key, defaultValue);
        if (!this.validateUnderDN(this.BASE_DN_CONFIG_BRANCH, dn)) {
            ZimbraLog.account.warn("dn " + dn + " must be under " + this.BASE_DN_CONFIG_BRANCH + ", localconfig value " + dn + " ignored, using default value " + defaultValue);
            dn = defaultValue;
        }
        return dn;
    }

    @Override
    protected void init() {
        this.BASE_DN_CONFIG_BRANCH = this.getLC(CustomLdapDITLC.ldap_dit_base_dn_config, "cn=zimbra");
        this.BASE_DN_MAIL_BRANCH = this.getLC(CustomLdapDITLC.ldap_dit_base_dn_mail, "").toLowerCase();
        this.BASE_RDN_ACCOUNT = "";
        this.NAMING_RDN_ATTR_USER = this.getLC(CustomLdapDITLC.ldap_dit_naming_rdn_attr_user, "uid");
        this.NAMING_RDN_ATTR_COS = this.getLC(CustomLdapDITLC.ldap_dit_naming_rdn_attr_cos, "cn");
        this.NAMING_RDN_ATTR_GLOBALCONFIG = this.getLC(CustomLdapDITLC.ldap_dit_naming_rdn_attr_globalconfig, "cn");
        this.NAMING_RDN_ATTR_GLOBALGRANT = this.getLC(CustomLdapDITLC.ldap_dit_naming_rdn_attr_globalgrant, "cn");
        this.NAMING_RDN_ATTR_MIME = this.getLC(CustomLdapDITLC.ldap_dit_naming_rdn_attr_mime, "cn");
        this.NAMING_RDN_ATTR_SERVER = this.getLC(CustomLdapDITLC.ldap_dit_naming_rdn_attr_server, "cn");
        this.NAMING_RDN_ATTR_XMPPCOMPONENT = this.getLC(CustomLdapDITLC.ldap_dit_naming_rdn_attr_xmppcomponent, "cn");
        this.NAMING_RDN_ATTR_ZIMLET = this.getLC(CustomLdapDITLC.ldap_dit_naming_rdn_attr_zimlet, "cn");
        this.DN_GLOBALCONFIG = this.NAMING_RDN_ATTR_GLOBALCONFIG + "=config" + "," + this.BASE_DN_CONFIG_BRANCH;
        this.DN_GLOBALGRANT = this.NAMING_RDN_ATTR_GLOBALGRANT + "=globalgrant" + "," + this.BASE_DN_CONFIG_BRANCH;
        this.BASE_DN_ADMIN = this.getLCAndValidateUnderConfigBranchDN(CustomLdapDITLC.ldap_dit_base_dn_admin, "cn=admins," + this.BASE_DN_CONFIG_BRANCH);
        this.BASE_DN_APPADMIN = this.getLCAndValidateUnderConfigBranchDN(CustomLdapDITLC.ldap_dit_base_dn_appadmin, "cn=appaccts," + this.BASE_DN_CONFIG_BRANCH);
        this.BASE_DN_COS = this.getLCAndValidateUnderConfigBranchDN(CustomLdapDITLC.ldap_dit_base_dn_cos, "cn=cos," + this.BASE_DN_CONFIG_BRANCH);
        this.BASE_DN_MIME = this.getLCAndValidateUnderConfigBranchDN(CustomLdapDITLC.ldap_dit_base_dn_mime, "cn=mime," + this.DN_GLOBALCONFIG);
        this.BASE_DN_SERVER = this.getLCAndValidateUnderConfigBranchDN(CustomLdapDITLC.ldap_dit_base_dn_server, "cn=servers," + this.BASE_DN_CONFIG_BRANCH);
        this.BASE_DN_XMPPCOMPONENT = this.getLCAndValidateUnderConfigBranchDN(CustomLdapDITLC.ldap_dit_base_dn_xmppcomponent, "cn=xmppcomponents," + this.BASE_DN_CONFIG_BRANCH);
        this.BASE_DN_ZIMLET = this.getLCAndValidateUnderConfigBranchDN(CustomLdapDITLC.ldap_dit_base_dn_zimlet, "cn=zimlets," + this.BASE_DN_CONFIG_BRANCH);
        this.BASE_DN_DOMAIN = this.getLCAndValidateUnderConfigBranchDN(CustomLdapDITLC.ldap_dit_base_dn_domain, "cn=domains," + this.BASE_DN_CONFIG_BRANCH);
        this.BASE_DN_ZIMBRA = this.computeZimbraBaseDN();
    }

    private String computeZimbraBaseDN() {
        String[] rdns1 = this.BASE_DN_CONFIG_BRANCH.split(",");
        String[] rdns2 = this.BASE_DN_MAIL_BRANCH.split(",");
        int idx1 = rdns1.length - 1;
        int idx2 = rdns2.length - 1;
        int shorter = rdns1.length < rdns2.length ? rdns1.length : rdns2.length;
        String commonDn = null;
        int i = 0;
        while (i < shorter && rdns1[idx1].equalsIgnoreCase(rdns2[idx2])) {
            commonDn = commonDn == null ? rdns1[idx1] : rdns1[idx1] + "," + commonDn;
            ++i;
            --idx1;
            --idx2;
        }
        return commonDn;
    }

    private ServiceException UNSUPPORTED(String msg) {
        return ServiceException.FAILURE(msg + " unsupported in " + this.getClass().getCanonicalName(), null);
    }

    private boolean validateUnderDN(String parentDn, String dn) {
        return this.isUnder(parentDn, dn);
    }

    private void validateMailBranchEntryDN(String dn) throws ServiceException {
        if (!this.validateUnderDN(this.BASE_DN_MAIL_BRANCH, dn)) {
            throw ServiceException.INVALID_REQUEST("dn " + dn + " must be under " + this.BASE_DN_MAIL_BRANCH, null);
        }
    }

    private String defaultDomain() throws ServiceException {
        String defaultDomain = this.mProv.getConfig().getAttr("zimbraDefaultDomainName", null);
        if (StringUtil.isNullOrEmpty(defaultDomain)) {
            throw this.UNSUPPORTED("default domain is empty");
        }
        return defaultDomain;
    }

    private String acctAndDLDNCreate(String baseDn, Attributes attrs) throws ServiceException, NamingException {
        String rdnAttr = this.NAMING_RDN_ATTR_USER;
        String rdnValue = LdapUtil.getAttrString(attrs, rdnAttr);
        if (rdnValue == null) {
            throw ServiceException.FAILURE("missing rdn attribute" + rdnAttr, null);
        }
        this.validateMailBranchEntryDN(baseDn);
        return rdnAttr + "=" + LdapUtil.escapeRDNValue(rdnValue) + "," + baseDn;
    }

    public String emailToDN(String localPart, String domain) throws ServiceException {
        throw this.UNSUPPORTED("function emailToDN");
    }

    public String emailToDN(String email) throws ServiceException {
        throw this.UNSUPPORTED("function emailToDN");
    }

    @Override
    public String accountDNCreate(String baseDn, Attributes attrs, String localPart, String domain) throws ServiceException, NamingException {
        if (baseDn == null) {
            throw ServiceException.INVALID_REQUEST("base dn is required in DIT impl " + this.getClass().getCanonicalName(), null);
        }
        return this.acctAndDLDNCreate(baseDn, attrs);
    }

    @Override
    public String accountDNRename(String oldDn, String newLocalPart, String newDomain) throws ServiceException, NamingException {
        return oldDn;
    }

    @Override
    public String dnToEmail(String dn, Attributes attrs) throws ServiceException, NamingException {
        String localPart = LdapUtil.getAttrString(attrs, "uid");
        return localPart + "@" + this.defaultDomain();
    }

    @Override
    public String filterAccountsByDomain(Domain domain, boolean includeObjectClass) {
        String filter = "(zimbraMailDeliveryAddress=*@" + domain.getName() + ")";
        if (includeObjectClass) {
            return "(&(objectclass=zimbraAccount)" + filter + ")";
        }
        return filter;
    }

    @Override
    public String aliasDN(String targetDn, String targetDomain, String aliasLocalPart, String aliasDomain) throws ServiceException {
        if (targetDn == null || targetDomain == null) {
            throw this.UNSUPPORTED("alias DN without target dn or target domain");
        }
        String allowedDomain = this.defaultDomain();
        if (!aliasDomain.equals(allowedDomain)) {
            throw this.UNSUPPORTED("alias DN not in default domain(alias domain=" + aliasDomain + ", default domain=" + allowedDomain + ")");
        }
        if (!targetDomain.equals(aliasDomain)) {
            throw this.UNSUPPORTED("alias DN with different target domain and alias domain(alias domain=" + aliasDomain + ", target domain=" + targetDomain + ")");
        }
        String[] parts = LdapUtil.dnToRdnAndBaseDn(targetDn);
        return this.NAMING_RDN_ATTR_USER + "=" + LdapUtil.escapeRDNValue(aliasLocalPart) + "," + parts[1];
    }

    @Override
    public String aliasDNRename(String targetNewDn, String targetNewDomain, String newAliasEmail) throws ServiceException {
        if (targetNewDn == null || targetNewDomain == null) {
            throw this.UNSUPPORTED("alias DN rename without target dn or target domain");
        }
        String allowedDomain = this.defaultDomain();
        if (!targetNewDomain.equals(allowedDomain)) {
            throw this.UNSUPPORTED("alias DN rename not in default domain(alias domain=" + targetNewDomain + ", default domain=" + allowedDomain + ")");
        }
        return targetNewDn;
    }

    @Override
    public String filterCalendarResourcesByDomain(Domain domain, boolean includeObjectClass) {
        String filter = "(zimbraMailDeliveryAddress=*@" + domain.getName() + ")";
        if (includeObjectClass) {
            return "(&(objectclass=zimbraCalendarResource)" + filter + ")";
        }
        return filter;
    }

    @Override
    public String distributionListDNCreate(String baseDn, Attributes attrs, String localPart, String domain) throws ServiceException, NamingException {
        if (baseDn == null) {
            throw ServiceException.INVALID_REQUEST("base dn is required in DIT impl " + this.getClass().getCanonicalName(), null);
        }
        String allowedDomain = this.defaultDomain();
        if (!domain.equals(allowedDomain)) {
            throw this.UNSUPPORTED("DL DN not in default domain(DL domain=" + domain + ", default domain=" + allowedDomain + ")");
        }
        return this.acctAndDLDNCreate(baseDn, attrs);
    }

    @Override
    public String distributionListDNRename(String oldDn, String newLocalPart, String newDomain) throws ServiceException, NamingException {
        return oldDn;
    }

    @Override
    public String domainBaseDN() {
        return this.BASE_DN_DOMAIN;
    }

    @Override
    public String[] domainToDNs(String[] parts) {
        return this.domainToDNsInternal(parts, this.BASE_DN_DOMAIN);
    }

    @Override
    public String domainToAccountSearchDN(String domain) throws ServiceException {
        return this.BASE_DN_MAIL_BRANCH;
    }

    @Override
    public String domainDNToAccountSearchDN(String domainDN) throws ServiceException {
        return this.BASE_DN_MAIL_BRANCH;
    }

    @Override
    protected SpecialAttrs handleSpecialAttrs(Map<String, Object> attrs) throws ServiceException {
        if (SpecialAttrs.getSingleValuedAttr(attrs, "ldap.baseDN") == null) {
            throw ServiceException.INVALID_REQUEST("missing required attribute ldap.baseDN", null);
        }
        if (!this.NAMING_RDN_ATTR_USER.equals("uid") && SpecialAttrs.getSingleValuedAttr(attrs, this.NAMING_RDN_ATTR_USER) == null) {
            throw ServiceException.INVALID_REQUEST("missing required attribute " + this.NAMING_RDN_ATTR_USER, null);
        }
        SpecialAttrs specialAttrs = new SpecialAttrs();
        if (attrs != null) {
            specialAttrs.handleZimbraId(attrs);
            specialAttrs.handleLdapBaseDn(attrs);
        }
        return specialAttrs;
    }

    static class CustomLdapDITLC {
        public static final KnownKey ldap_dit_base_dn_admin = new KnownKey("ldap_dit_base_dn_admin", "", "LDAP Custom DIT base DN for LDAP admin entries");
        public static final KnownKey ldap_dit_base_dn_appadmin = new KnownKey("ldap_dit_base_dn_appadmin", "", "LDAP Custom DIT base DN for LDAP app admin entries");
        public static final KnownKey ldap_dit_base_dn_config = new KnownKey("ldap_dit_base_dn_config", "", "LDAP Custom DIT base DN for config branch");
        public static final KnownKey ldap_dit_base_dn_cos = new KnownKey("ldap_dit_base_dn_cos", "", "LDAP Custom DIT base DN for cos entries");
        public static final KnownKey ldap_dit_base_dn_domain = new KnownKey("ldap_dit_base_dn_domain", "", "LDAP Custom DIT base DN for domain entries");
        public static final KnownKey ldap_dit_base_dn_mail = new KnownKey("ldap_dit_base_dn_mail", "", "LDAP Custom DIT base DN for mail(accounts, aliases, DLs, resources) entries");
        public static final KnownKey ldap_dit_base_dn_mime = new KnownKey("ldap_dit_base_dn_mime", "", "LDAP Custom DIT base DN for mime entries");
        public static final KnownKey ldap_dit_base_dn_server = new KnownKey("ldap_dit_base_dn_server", "", "LDAP Custom DIT base DN for server entries");
        public static final KnownKey ldap_dit_base_dn_xmppcomponent = new KnownKey("ldap_dit_base_dn_xmppcomponent", "", "LDAP Custom DIT base DN for xmpp component entries");
        public static final KnownKey ldap_dit_base_dn_zimlet = new KnownKey("ldap_dit_base_dn_zimlet", "", "LDAP Custom DIT base DN for zimlet entries");
        public static final KnownKey ldap_dit_naming_rdn_attr_cos = new KnownKey("ldap_dit_naming_rdn_attr_cos", "", "LDAP Custom DIT RDN attr for cos entries");
        public static final KnownKey ldap_dit_naming_rdn_attr_globalconfig = new KnownKey("ldap_dit_naming_rdn_attr_globalconfig", "", "LDAP Custom DIT RDN attr for globalconfig entry");
        public static final KnownKey ldap_dit_naming_rdn_attr_globalgrant = new KnownKey("ldap_dit_naming_rdn_attr_globalgrant", "", "LDAP Custom DIT RDN attr for globalgrant entry");
        public static final KnownKey ldap_dit_naming_rdn_attr_mime = new KnownKey("ldap_dit_naming_rdn_attr_mime", "", "LDAP Custom DIT RDN attr for mime entries");
        public static final KnownKey ldap_dit_naming_rdn_attr_server = new KnownKey("ldap_dit_naming_rdn_attr_server", "", "LDAP Custom DIT RDN attr for server entries");
        public static final KnownKey ldap_dit_naming_rdn_attr_user = new KnownKey("ldap_dit_naming_rdn_attr_user", "", "LDAP Custom DIT RDN attr for account, calendar resource, and distribution list entries");
        public static final KnownKey ldap_dit_naming_rdn_attr_xmppcomponent = new KnownKey("ldap_dit_naming_rdn_attr_xmppcomponent", "", "LDAP Custom DIT RDN attr for xmpp component entries");
        public static final KnownKey ldap_dit_naming_rdn_attr_zimlet = new KnownKey("ldap_dit_naming_rdn_attr_zimlet", "", "LDAP Custom DIT RDN attr for zimlet entries");

        CustomLdapDITLC() {
        }
    }
}

