/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.ldap;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.EasySSLSocketFactory;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.ldap.LdapGalCredential;
import com.zimbra.cs.account.ldap.LdapUtil;
import com.zimbra.cs.stats.ZimbraPerf;
import java.io.IOException;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidAttributeIdentifierException;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.InvalidAttributesException;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SchemaViolationException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZimbraLdapContext {
    private static String sLdapURL = LC.ldap_url.value().trim();
    private static String sLdapMasterURL;
    private static ConnType sConnType;
    private static ConnType sMasterConnType;
    private static String sStartTLSDebugText;
    private static Hashtable<String, String> sEnvMasterAuth;
    private static Hashtable<String, String> sEnvAuth;
    private static SSLSocketFactory sEasySSLSocketFactory;
    private LdapContext mDirContext;
    private StartTlsResponse mTlsResp;
    private static final int CHECK_LDAP_SLEEP_MILLIS = 5000;

    public static synchronized void forceMasterURL() {
        sLdapURL = sLdapMasterURL;
        sConnType = sMasterConnType;
    }

    public static String getLdapURL() {
        return sLdapURL;
    }

    public static boolean requireStartTLS(String[] urls, boolean startTLSEnabled) {
        if (startTLSEnabled) {
            for (String url : urls) {
                if (!url.toLowerCase().contains("ldaps://")) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static synchronized Hashtable<String, String> getDefaultEnv(boolean master) {
        Hashtable<String, String> sEnv = null;
        if (master) {
            if (sEnvMasterAuth != null) {
                return sEnvMasterAuth;
            }
            sEnvMasterAuth = new Hashtable<String, String>();
            sEnv = sEnvMasterAuth;
        } else {
            if (sEnvAuth != null) {
                return sEnvAuth;
            }
            sEnvAuth = new Hashtable();
            sEnv = sEnvAuth;
        }
        sEnv.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        sEnv.put("java.naming.provider.url", master ? sLdapMasterURL : sLdapURL);
        sEnv.put("java.naming.referral", "follow");
        sEnv.put("com.sun.jndi.ldap.connect.timeout", LC.ldap_connect_timeout.value());
        sEnv.put("com.sun.jndi.ldap.read.timeout", LC.ldap_read_timeout.value());
        if (ConnType.isSTARTTLS(master)) {
            sEnv.put("com.sun.jndi.ldap.connect.pool", "false");
        } else {
            if (master) {
                sEnv.put("com.sun.jndi.ldap.connect.pool", LC.ldap_connect_pool_master.value());
            } else {
                sEnv.put("com.sun.jndi.ldap.connect.pool", "true");
            }
            sEnv.put("java.naming.security.authentication", "simple");
            sEnv.put("java.naming.security.principal", LC.zimbra_ldap_userdn.value());
            sEnv.put("java.naming.security.credentials", LC.zimbra_ldap_password.value());
            if (ConnType.isLDAPS(master) && LC.ssl_allow_untrusted_certs.booleanValue()) {
                sEnv.put("java.naming.ldap.factory.socket", "com.zimbra.common.util.EasySSLSocketFactory");
            }
        }
        return sEnv;
    }

    private static synchronized Hashtable<String, String> getCustomEnv(boolean master, LdapConfig ldapConfig) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", master ? sLdapMasterURL : sLdapURL);
        env.put("java.naming.referral", "follow");
        env.put("com.sun.jndi.ldap.connect.timeout", ldapConfig.connTimeout());
        env.put("com.sun.jndi.ldap.read.timeout", ldapConfig.readTimeout());
        if (ConnType.isSTARTTLS(master)) {
            env.put("com.sun.jndi.ldap.connect.pool", "false");
        } else {
            if (master) {
                env.put("com.sun.jndi.ldap.connect.pool", LC.ldap_connect_pool_master.value());
            } else {
                env.put("com.sun.jndi.ldap.connect.pool", ldapConfig.useConnPool());
            }
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", LC.zimbra_ldap_userdn.value());
            env.put("java.naming.security.credentials", LC.zimbra_ldap_password.value());
            if (ConnType.isLDAPS(master) && LC.ssl_allow_untrusted_certs.booleanValue()) {
                env.put("java.naming.ldap.factory.socket", "com.zimbra.common.util.EasySSLSocketFactory");
            }
        }
        return env;
    }

    private static String joinURLS(String[] urls) {
        if (urls.length == 1) {
            return urls[0];
        }
        StringBuffer url = new StringBuffer();
        for (int i = 0; i < urls.length; ++i) {
            if (i > 0) {
                url.append(' ');
            }
            url.append(urls[i]);
        }
        return url.toString();
    }

    private static void tlsNegotiate(StartTlsResponse tlsResp) throws IOException {
        ZimbraLog.ldap.debug(sStartTLSDebugText);
        if (LC.ssl_allow_mismatched_certs.booleanValue()) {
            tlsResp.setHostnameVerifier(new DummyHostVerifier());
        }
        if (LC.ssl_allow_untrusted_certs.booleanValue()) {
            tlsResp.negotiate(sEasySSLSocketFactory);
        } else {
            tlsResp.negotiate();
        }
    }

    public ZimbraLdapContext() throws ServiceException {
        this(false, null);
    }

    public ZimbraLdapContext(boolean master) throws ServiceException {
        this(master, null);
    }

    public ZimbraLdapContext(boolean master, boolean useConnPool) throws ServiceException {
        this(master, useConnPool ? null : new LdapConfig(useConnPool, null, null));
    }

    public ZimbraLdapContext(boolean master, LdapConfig ldapConfig) throws ServiceException {
        try {
            Hashtable<String, String> env = ldapConfig == null ? ZimbraLdapContext.getDefaultEnv(master) : ZimbraLdapContext.getCustomEnv(master, ldapConfig);
            boolean startTLS = ConnType.isSTARTTLS(master);
            long start = ZimbraPerf.STOPWATCH_LDAP_DC.start();
            if (ZimbraLog.ldap.isDebugEnabled()) {
                ZimbraLog.ldap.debug("GET DIR CTXT: url=" + env.get("java.naming.provider.url") + ", binddn=" + env.get("java.naming.security.principal") + ", startTLS=" + startTLS);
            }
            this.mDirContext = new InitialLdapContext(env, null);
            if (startTLS) {
                this.mTlsResp = (StartTlsResponse)this.mDirContext.extendedOperation(new StartTlsRequest());
                ZimbraLdapContext.tlsNegotiate(this.mTlsResp);
                this.mDirContext.addToEnvironment("java.naming.security.authentication", "simple");
                this.mDirContext.addToEnvironment("java.naming.security.principal", LC.zimbra_ldap_userdn.value());
                this.mDirContext.addToEnvironment("java.naming.security.credentials", LC.zimbra_ldap_password.value());
            }
            ZimbraPerf.STOPWATCH_LDAP_DC.stop(start);
        }
        catch (NamingException e) {
            throw ServiceException.FAILURE("ZimbraLdapContext", e);
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("ZimbraLdapContext", e);
        }
    }

    public ZimbraLdapContext(String[] urls, boolean requireStartTLS, String bindDn, String bindPassword, String note) throws NamingException, IOException {
        this(urls, requireStartTLS, null, bindDn, bindPassword, note);
    }

    public ZimbraLdapContext(String[] urls, boolean requireStartTLS, LdapGalCredential credential, String note) throws NamingException, IOException {
        this(urls, requireStartTLS, credential.getAuthMech(), credential.getBindDn(), credential.getBindPassword(), note);
    }

    public ZimbraLdapContext(String[] urls, boolean requireStartTLS, String authMech, String bindDn, String bindPassword, String note) throws NamingException, IOException {
        boolean startTLS;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", ZimbraLdapContext.joinURLS(urls));
        env.put("java.naming.referral", "follow");
        env.put("com.sun.jndi.ldap.connect.timeout", LC.ldap_connect_timeout.value());
        env.put("com.sun.jndi.ldap.read.timeout", LC.ldap_read_timeout.value());
        String derefAliases = LC.ldap_deref_aliases.value();
        if (!StringUtil.isNullOrEmpty(derefAliases)) {
            env.put("java.naming.ldap.derefAliases", LC.ldap_deref_aliases.value());
        }
        if (authMech == null) {
            authMech = bindDn != null && bindPassword != null ? "simple" : "none";
        }
        boolean bl = startTLS = requireStartTLS && authMech.equals("simple");
        if (authMech.equals("none")) {
            env.put("java.naming.security.authentication", "none");
        } else if (authMech.equals("simple")) {
            if (!startTLS) {
                env.put("java.naming.security.authentication", "simple");
                if (bindDn != null) {
                    env.put("java.naming.security.principal", bindDn);
                }
                if (bindPassword != null) {
                    env.put("java.naming.security.credentials", bindPassword);
                }
            }
        } else if (authMech.equals("kerberos5")) {
            env.put("java.naming.security.authentication", "GSSAPI");
            env.put("javax.security.sasl.qop", "auth-conf");
        }
        if (!startTLS) {
            env.put("com.sun.jndi.ldap.connect.pool", "true");
        }
        try {
            if (ZimbraLog.ldap.isDebugEnabled()) {
                ZimbraLog.ldap.debug("GET DIR CTXT(" + note + "): " + "url=" + (String)env.get("java.naming.provider.url") + ", binddn=" + bindDn + ", authMech=" + authMech + ", startTLS=" + requireStartTLS);
            }
            this.mDirContext = new InitialLdapContext(env, null);
            if (startTLS) {
                this.mTlsResp = (StartTlsResponse)this.mDirContext.extendedOperation(new StartTlsRequest());
                ZimbraLdapContext.tlsNegotiate(this.mTlsResp);
                this.mDirContext.addToEnvironment("java.naming.security.authentication", "simple");
                if (bindDn != null) {
                    this.mDirContext.addToEnvironment("java.naming.security.principal", bindDn);
                }
                if (bindPassword != null) {
                    this.mDirContext.addToEnvironment("java.naming.security.credentials", bindPassword);
                }
            }
        }
        catch (NamingException e) {
            ZimbraLog.ldap.debug((Object)("GET DIR CTXT(" + note + ") failed"), e);
            throw e;
        }
        catch (IOException e) {
            ZimbraLog.ldap.debug((Object)("GET DIR CTXT(" + note + ") failed"), e);
            throw e;
        }
    }

    public static void ldapAuthenticate(String principal, String password) throws NamingException, IOException {
        String[] urls = new String[]{ZimbraLdapContext.getLdapURL()};
        ZimbraLdapContext.ldapAuthenticate(urls, ConnType.isSTARTTLS(false), principal, password, "Zimbra LDAP auth, password not SSHA");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void ldapAuthenticate(String[] urls, boolean requireStartTLS, String principal, String password, String note) throws NamingException, IOException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", ZimbraLdapContext.joinURLS(urls));
        env.put("com.sun.jndi.ldap.connect.timeout", LC.ldap_connect_timeout.value());
        env.put("com.sun.jndi.ldap.read.timeout", LC.ldap_read_timeout.value());
        String derefAliases = LC.ldap_deref_aliases.value();
        if (!StringUtil.isNullOrEmpty(derefAliases)) {
            env.put("java.naming.ldap.derefAliases", LC.ldap_deref_aliases.value());
        }
        if (!requireStartTLS) {
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", principal);
            env.put("java.naming.security.credentials", password);
        }
        InitialLdapContext context = null;
        StartTlsResponse tlsResp = null;
        try {
            if (ZimbraLog.ldap.isDebugEnabled()) {
                ZimbraLog.ldap.debug("GET DIR CTXT(" + note + "): " + "url=" + (String)env.get("java.naming.provider.url") + ", binddn=" + principal + ", authMech=" + "simple" + ", startTLS=" + requireStartTLS);
            }
            context = new InitialLdapContext(env, null);
            if (requireStartTLS) {
                LdapContext ldapCtxt = context;
                tlsResp = (StartTlsResponse)ldapCtxt.extendedOperation(new StartTlsRequest());
                ZimbraLdapContext.tlsNegotiate(tlsResp);
                ldapCtxt.addToEnvironment("java.naming.security.authentication", "simple");
                ldapCtxt.addToEnvironment("java.naming.security.principal", principal);
                ldapCtxt.addToEnvironment("java.naming.security.credentials", password);
                ldapCtxt.reconnect(null);
            }
        }
        catch (NamingException e) {
            try {
                ZimbraLog.ldap.debug((Object)("GET DIR CTXT(" + note + ") failed"), e);
                throw e;
                catch (IOException e2) {
                    ZimbraLog.ldap.debug((Object)("GET DIR CTXT(" + note + ") failed"), e2);
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                ZimbraLdapContext.closeContext(context, tlsResp);
                throw throwable;
            }
        }
        ZimbraLdapContext.closeContext(context, tlsResp);
    }

    public LdapContext getLdapContext() {
        return this.mDirContext;
    }

    private static void closeContext(Context ctxt) {
        ZimbraLdapContext.closeContext(ctxt, null);
    }

    private static void closeContext(Context ctxt, StartTlsResponse tlsResp) {
        try {
            if (tlsResp != null) {
                ZimbraLog.ldap.debug("STOP TLS");
                tlsResp.close();
            }
        }
        catch (IOException e) {
            ZimbraLog.ldap.error((Object)"failed to close tls", e);
        }
        try {
            if (ctxt != null) {
                ZimbraLog.ldap.debug("CLOSE DIR CTXT");
                ctxt.close();
            }
        }
        catch (NamingException e) {
            ZimbraLog.ldap.error((Object)"failed to close dir context", e);
        }
    }

    public static void closeContext(ZimbraLdapContext zlc) {
        if (zlc != null) {
            zlc.closeContext();
        }
    }

    private void closeContext() {
        ZimbraLdapContext.closeContext(this.mDirContext, this.mTlsResp);
    }

    public DirContext getSchema() throws NamingException {
        return this.mDirContext.getSchema("");
    }

    public Attributes getAttributes(String dn) throws NamingException {
        Name cpName = new CompositeName().add(dn);
        if (ZimbraLog.ldap.isDebugEnabled()) {
            ZimbraLog.ldap.debug("GET ATTRS: dn=" + dn);
        }
        return this.mDirContext.getAttributes(cpName);
    }

    public void modifyAttributes(String dn, ModificationItem[] mods) throws NamingException {
        Name cpName = new CompositeName().add(dn);
        if (ZimbraLog.ldap.isDebugEnabled()) {
            ZimbraLog.ldap.debug("MODIFY ATTRS: dn=" + dn + ", mods=" + ZimbraLdapContext.dumpMods(mods));
        }
        this.mDirContext.modifyAttributes(cpName, mods);
    }

    public void replaceAttributes(String dn, Attributes attrs) throws NamingException {
        Name cpName = new CompositeName().add(dn);
        if (ZimbraLog.ldap.isDebugEnabled()) {
            ZimbraLog.ldap.debug("REPLACE ATTRS: dn=" + dn + ", mods=" + attrs.toString());
        }
        this.mDirContext.modifyAttributes(cpName, 2, attrs);
    }

    public NamingEnumeration<SearchResult> searchDir(String base, String filter, SearchControls cons) throws NamingException {
        if (ZimbraLog.ldap.isDebugEnabled()) {
            ZimbraLog.ldap.debug("SEARCH: base=" + base + ", filter=" + filter);
        }
        if (base.length() == 0) {
            return this.mDirContext.search(base, filter, cons);
        }
        Name cpName = new CompositeName().add(base);
        return this.mDirContext.search(cpName, filter, cons);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createEntry(String dn, Attributes attrs, String method) throws NameAlreadyBoundException, ServiceException {
        DirContext newCtxt = null;
        try {
            Name cpName = new CompositeName().add(dn);
            if (ZimbraLog.ldap.isDebugEnabled()) {
                ZimbraLog.ldap.debug("CREATE ENTRY: method=" + method + ", dn=" + dn + ", attrs=" + attrs.toString());
            }
            newCtxt = this.mDirContext.createSubcontext(cpName, attrs);
        }
        catch (NameAlreadyBoundException e) {
            try {
                throw e;
                catch (NameNotFoundException e2) {
                    throw ServiceException.INVALID_REQUEST(method + " dn not found: " + LdapUtil.dnToRdnAndBaseDn(dn)[1] + e2.getMessage(), e2);
                }
                catch (InvalidAttributeIdentifierException e3) {
                    throw AccountServiceException.INVALID_ATTR_NAME(method + " invalid attr name: " + e3.getMessage(), e3);
                }
                catch (InvalidAttributeValueException e4) {
                    throw AccountServiceException.INVALID_ATTR_VALUE(method + " invalid attr value: " + e4.getMessage(), e4);
                }
                catch (InvalidAttributesException e5) {
                    throw ServiceException.INVALID_REQUEST(method + " invalid set of attributes: " + e5.getMessage(), e5);
                }
                catch (InvalidNameException e6) {
                    throw ServiceException.INVALID_REQUEST(method + " invalid name: " + e6.getMessage(), e6);
                }
                catch (SchemaViolationException e7) {
                    throw ServiceException.INVALID_REQUEST(method + " invalid schema change: " + e7.getMessage(), e7);
                }
                catch (NamingException e8) {
                    throw ServiceException.FAILURE(method, e8);
                }
            }
            catch (Throwable throwable) {
                ZimbraLdapContext.closeContext(newCtxt);
                throw throwable;
            }
        }
        ZimbraLdapContext.closeContext(newCtxt);
    }

    void simpleCreate(String dn, Object objectClass, String[] attrs) throws NamingException {
        BasicAttributes battrs = new BasicAttributes(true);
        if (objectClass instanceof String) {
            battrs.put("objectClass", objectClass);
        } else if (objectClass instanceof String[]) {
            String[] oclasses = (String[])objectClass;
            BasicAttribute a = new BasicAttribute("objectClass");
            for (int i = 0; i < oclasses.length; ++i) {
                a.add(oclasses[i]);
            }
            battrs.put(a);
        }
        for (int i = 0; i < attrs.length; i += 2) {
            battrs.put(attrs[i], attrs[i + 1]);
        }
        Name cpName = new CompositeName().add(dn);
        if (ZimbraLog.ldap.isDebugEnabled()) {
            ZimbraLog.ldap.debug("CREATE ENTRY: dn=" + dn + ", attrs=" + ((Object)battrs).toString());
        }
        DirContext newCtxt = this.mDirContext.createSubcontext(cpName, (Attributes)battrs);
        newCtxt.close();
    }

    public void unbindEntry(String dn) throws NamingException {
        Name cpName = new CompositeName().add(dn);
        if (ZimbraLog.ldap.isDebugEnabled()) {
            ZimbraLog.ldap.debug("DELETE ENTRY: dn=" + dn);
        }
        this.mDirContext.unbind(cpName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveChildren(String oldDn, String newDn) throws ServiceException {
        NamingEnumeration<SearchResult> ne = null;
        try {
            SearchControls sc = new SearchControls(1, 0L, 0, null, false, false);
            String query = "(objectclass=*)";
            ne = this.searchDir(oldDn, query, sc);
            NameParser ldapParser = this.mDirContext.getNameParser("");
            while (ne.hasMore()) {
                SearchResult sr = ne.next();
                String oldChildDn = sr.getNameInNamespace();
                Name oldChildName = ldapParser.parse(oldChildDn);
                Name newChildName = ldapParser.parse(newDn).add(oldChildName.get(oldChildName.size() - 1));
                if (ZimbraLog.ldap.isDebugEnabled()) {
                    ZimbraLog.ldap.debug("RENAME ENTRY: old=" + oldChildName + ", new=" + newChildName);
                }
                this.mDirContext.rename(oldChildName, newChildName);
            }
        }
        catch (NamingException e) {
            ZimbraLog.account.warn((Object)"unable to move children", e);
        }
        finally {
            LdapUtil.closeEnumContext(ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteChildren(String dn) throws ServiceException {
        NamingEnumeration<SearchResult> ne = null;
        try {
            SearchControls sc = new SearchControls(1, 0L, 0, null, false, false);
            String query = "(objectclass=*)";
            ne = this.searchDir(dn, query, sc);
            while (ne.hasMore()) {
                SearchResult sr = ne.next();
                this.unbindEntry(sr.getNameInNamespace());
            }
        }
        catch (NamingException e) {
            ZimbraLog.account.warn((Object)"unable to remove children", e);
        }
        finally {
            LdapUtil.closeEnumContext(ne);
        }
    }

    public void renameEntry(String oldDn, String newDn) throws NamingException {
        Name oldCpName = new CompositeName().add(oldDn);
        Name newCpName = new CompositeName().add(newDn);
        if (ZimbraLog.ldap.isDebugEnabled()) {
            ZimbraLog.ldap.debug("RENAME ENTRY: old=" + oldCpName + ", new=" + newCpName);
        }
        this.mDirContext.rename(oldCpName, newCpName);
    }

    public void setPagedControl(int pageSize, byte[] cookie, boolean critical) throws NamingException, IOException {
        this.mDirContext.setRequestControls(new Control[]{new PagedResultsControl(pageSize, cookie, critical)});
    }

    public byte[] getCookie() throws NamingException {
        Control[] controls = this.mDirContext.getResponseControls();
        if (controls != null) {
            for (int i = 0; i < controls.length; ++i) {
                if (!(controls[i] instanceof PagedResultsResponseControl)) continue;
                PagedResultsResponseControl prrc = (PagedResultsResponseControl)controls[i];
                return prrc.getCookie();
            }
        }
        return null;
    }

    private static String dumpMods(ModificationItem[] mods) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < mods.length; ++i) {
            sb.append(mods[i].toString() + ", ");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForServer() {
        while (true) {
            ZimbraLdapContext zlc = null;
            try {
                zlc = new ZimbraLdapContext();
            }
            catch (ServiceException e) {
                System.err.println(new Date() + ": error communicating with LDAP (will retry)");
                e.printStackTrace();
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
            finally {
                ZimbraLdapContext.closeContext(zlc);
                continue;
            }
            break;
        }
    }

    static {
        if (sLdapURL.length() == 0) {
            String ldapHost = LC.ldap_host.value();
            String ldapPort = LC.ldap_port.value();
            sLdapURL = "ldap://" + ldapHost + ":" + ldapPort + "/";
        }
        if ((sLdapMasterURL = LC.ldap_master_url.value().trim()).length() == 0) {
            sLdapMasterURL = sLdapURL;
        }
        System.setProperty("com.sun.jndi.ldap.connect.pool.debug", LC.ldap_connect_pool_debug.value());
        System.setProperty("com.sun.jndi.ldap.connect.pool.initsize", LC.ldap_connect_pool_initsize.value());
        System.setProperty("com.sun.jndi.ldap.connect.pool.maxsize", LC.ldap_connect_pool_maxsize.value());
        System.setProperty("com.sun.jndi.ldap.connect.pool.prefsize", LC.ldap_connect_pool_prefsize.value());
        System.setProperty("com.sun.jndi.ldap.connect.pool.timeout", LC.ldap_connect_pool_timeout.value());
        System.setProperty("com.sun.jndi.ldap.connect.pool.protocol", "plain ssl");
        sConnType = ConnType.getConnType(ZimbraLdapContext.sLdapURL);
        sMasterConnType = ConnType.getConnType(ZimbraLdapContext.sLdapMasterURL);
        sEasySSLSocketFactory = EasySSLSocketFactory.getDefault();
        StringBuffer startTLSDebugText = new StringBuffer("START TLS");
        sStartTLSDebugText = "START TLS";
        if (LC.ssl_allow_mismatched_certs.booleanValue()) {
            startTLSDebugText.append(", allow mismatched certs");
        }
        if (LC.ssl_allow_untrusted_certs.booleanValue()) {
            startTLSDebugText.append(", allow untrusted certs");
        }
        sStartTLSDebugText = startTLSDebugText.toString();
    }

    private static class DummyHostVerifier
    implements HostnameVerifier {
        private DummyHostVerifier() {
        }

        public boolean verify(String hostname, SSLSession session) {
            try {
                Certificate[] cert = session.getPeerCertificates();
                for (int i = 0; i < cert.length; ++i) {
                }
            }
            catch (SSLPeerUnverifiedException e) {
                return false;
            }
            return true;
        }
    }

    public static class LdapConfig {
        public static final Integer NO_TIMEOUT = 0;
        private Boolean mUseConnPool;
        private Integer mConnTimeout;
        private Integer mReadTimeout;

        public LdapConfig(Boolean useConnPool, Integer connTimeout, Integer readTimeout) {
            this.mUseConnPool = useConnPool;
            this.mConnTimeout = connTimeout;
            this.mReadTimeout = readTimeout;
        }

        private String useConnPool() {
            return this.mUseConnPool == null ? "true" : this.mUseConnPool.toString();
        }

        private String connTimeout() {
            return this.mConnTimeout == null ? LC.ldap_connect_timeout.value() : String.valueOf(this.mConnTimeout);
        }

        private String readTimeout() {
            return this.mReadTimeout == null ? LC.ldap_read_timeout.value() : String.valueOf(this.mReadTimeout);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ConnType {
        PLAIN,
        LDAPS,
        STARTTLS;


        private static ConnType getConnType(String urls) {
            if (urls.toLowerCase().contains("ldaps://")) {
                return LDAPS;
            }
            boolean ldap_starttls_supported = "1".equals(LC.ldap_starttls_supported.value());
            boolean zimbra_require_interprocess_security = "1".equals(LC.zimbra_require_interprocess_security.value());
            if (ldap_starttls_supported && zimbra_require_interprocess_security) {
                return STARTTLS;
            }
            return PLAIN;
        }

        private static boolean isLDAPS(boolean master) {
            if (master) {
                return sMasterConnType == LDAPS;
            }
            return sConnType == LDAPS;
        }

        private static boolean isSTARTTLS(boolean master) {
            if (master) {
                return sMasterConnType == STARTTLS;
            }
            return sConnType == STARTTLS;
        }
    }
}

