/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.ldap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.ldap.LdapFilter;
import com.zimbra.cs.account.ldap.LdapProvisioning;
import com.zimbra.cs.account.ldap.ZimbraLdapContext;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Validators {
    public static void init() {
        LdapProvisioning.register(new DomainAccountValidator());
        LdapProvisioning.register(new DomainMaxAccountsValidator());
    }

    private static boolean isSystemProperty(Map<String, Object> attrs) {
        HashSet<String> ocs;
        if (attrs == null) {
            return false;
        }
        Object o = attrs.get("zimbraIsSystemResource");
        if (o != null && "true".equalsIgnoreCase(o.toString())) {
            return true;
        }
        o = attrs.get("objectClass");
        return o instanceof String[] && (ocs = new HashSet<String>(Arrays.asList((String[])o))).contains("zimbraCalendarResource");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DomainMaxAccountsValidator
    implements LdapProvisioning.ProvisioningValidator {
        private DomainMaxAccountsValidator() {
        }

        @Override
        public void refresh() {
        }

        @Override
        public void validate(LdapProvisioning prov, String action, Object ... args) throws ServiceException {
            Cos defaultCos;
            if (!"createAccountCheckDomainCosAndFeature".equals(action) && !"modifyAccountCheckDomainCosAndFeature".equals(action)) {
                return;
            }
            if (args.length < 2) {
                return;
            }
            HashMap<String, Integer> cosCountMap = new HashMap<String, Integer>();
            HashMap<String, Integer> cosLimitMap = new HashMap<String, Integer>();
            HashMap<String, Integer> featureCountMap = new HashMap<String, Integer>();
            HashMap<String, Integer> featureLimitMap = new HashMap<String, Integer>();
            HashMap<String, Set<String>> cosFeatureMap = new HashMap<String, Set<String>>();
            String emailAddress = (String)args[0];
            if (emailAddress == null) {
                return;
            }
            Map attrs = (Map)args[1];
            if (Validators.isSystemProperty(attrs)) {
                return;
            }
            Account account = null;
            if (args.length == 3) {
                account = (Account)args[2];
            }
            String domainName = null;
            int index = emailAddress.indexOf(64);
            if (index != -1) {
                domainName = emailAddress.substring(index + 1);
            }
            if (domainName == null) {
                return;
            }
            Domain domain = prov.get(Provisioning.DomainBy.name, domainName);
            if (domain == null) {
                return;
            }
            String defaultCosId = domain.getAttr("zimbraDomainDefaultCOSId");
            if (defaultCosId == null && (defaultCos = prov.get(Provisioning.CosBy.name, "default")) != null) {
                defaultCosId = defaultCos.getId();
            }
            Set<String> cosLimit = domain.getMultiAttrSet("zimbraDomainCOSMaxAccounts");
            Set<String> featureLimit = domain.getMultiAttrSet("zimbraDomainFeatureMaxAccounts");
            if (cosLimit.size() == 0 && featureLimit.size() == 0) {
                return;
            }
            for (String string : cosLimit) {
                DomainMaxAccountsValidator.parseLimit(cosLimitMap, string);
            }
            for (String string : featureLimit) {
                DomainMaxAccountsValidator.parseLimit(featureLimitMap, string);
            }
            for (Map.Entry entry : cosLimitMap.entrySet()) {
                cosCountMap.put((String)entry.getKey(), 0);
            }
            for (Map.Entry entry : featureLimitMap.entrySet()) {
                featureCountMap.put((String)entry.getKey(), 0);
            }
            String desiredCosId = (String)attrs.get("zimbraCOSId");
            if (desiredCosId == null) {
                desiredCosId = defaultCosId;
            }
            Set<String> set = DomainMaxAccountsValidator.getCosFeatures(prov, cosFeatureMap, desiredCosId, defaultCosId);
            HashSet<String> desiredFeatures = new HashSet<String>();
            for (Map.Entry entry : attrs.entrySet()) {
                String k = (String)entry.getKey();
                if (!featureLimitMap.containsKey(k) || !"true".equalsIgnoreCase(entry.getValue().toString())) continue;
                desiredFeatures.add(k);
            }
            if (set != null) {
                for (String feature : set) {
                    if (!featureLimitMap.containsKey(feature)) continue;
                    desiredFeatures.add(feature);
                }
            }
            if (ZimbraLog.account.isDebugEnabled()) {
                ZimbraLog.account.debug("Desired features (incl. cos): %s + %s", desiredFeatures, set);
            }
            String originalCosId = null;
            if (account != null) {
                Set<String> features;
                originalCosId = account.getAttr("zimbraCOSId");
                if (originalCosId == null) {
                    originalCosId = defaultCosId;
                }
                if ((features = DomainMaxAccountsValidator.getCosFeatures(prov, cosFeatureMap, originalCosId, defaultCosId)) != null) {
                    desiredFeatures.removeAll(features);
                }
            }
            if (desiredFeatures.size() > 0 && account != null) {
                Map<String, Object> acctAttrs = account.getAttrs(false);
                Iterator i = desiredFeatures.iterator();
                while (i.hasNext()) {
                    String feature = (String)i.next();
                    if (!acctAttrs.containsKey(feature) || !"true".equalsIgnoreCase(acctAttrs.get(feature).toString())) continue;
                    i.remove();
                }
            }
            if (desiredCosId != null && !desiredCosId.equals(originalCosId) && cosLimitMap.containsKey(desiredCosId) || desiredFeatures.size() > 0) {
                if (ZimbraLog.account.isDebugEnabled()) {
                    ZimbraLog.account.debug("COS change info [%s:%s], desired features %s", originalCosId, desiredCosId, desiredFeatures);
                }
                this.buildDomainCounts(prov, domainName, defaultCosId, cosCountMap, featureCountMap, cosFeatureMap);
                if (ZimbraLog.account.isDebugEnabled()) {
                    ZimbraLog.account.debug("COS/Feature limits: %s + %s", cosLimitMap, featureLimitMap);
                }
                if (desiredCosId != null && !desiredCosId.equals(originalCosId) && cosLimitMap.containsKey(desiredCosId) && cosCountMap.containsKey(desiredCosId) && cosCountMap.get(desiredCosId) >= cosLimitMap.get(desiredCosId)) {
                    throw AccountServiceException.TOO_MANY_ACCOUNTS(String.format("domain=%s[cos=%s,count=%d,limit=%d]", domainName, desiredCosId, cosCountMap.get(desiredCosId), cosLimitMap.get(desiredCosId)));
                }
                if (desiredFeatures.size() > 0) {
                    for (String feature : desiredFeatures) {
                        if (!featureCountMap.containsKey(feature) || featureCountMap.get(feature) < featureLimitMap.get(feature)) continue;
                        throw AccountServiceException.TOO_MANY_ACCOUNTS(String.format("domain=%s[%s,count=%d,limit=%d]", domainName, feature, featureCountMap.get(feature), featureLimitMap.get(feature)));
                    }
                }
            }
        }

        private static Set<String> getCosFeatures(LdapProvisioning prov, Map<String, Set<String>> cosFeatureMap, String cosId, String defaultCosId) throws ServiceException {
            if (!cosFeatureMap.containsKey(cosId)) {
                Cos cos = null;
                if (cosId != null) {
                    cos = prov.get(Provisioning.CosBy.id, cosId);
                }
                if (cos == null) {
                    if (defaultCosId != null) {
                        ZimbraLog.account.debug("COS id %s not found, reverting to %s", cosId, defaultCosId);
                        return DomainMaxAccountsValidator.getCosFeatures(prov, cosFeatureMap, defaultCosId, null);
                    }
                    ZimbraLog.account.debug("COS %s not found, bailing!", cosId);
                    return null;
                }
                Map<String, Object> cosAttrs = cos.getAttrs(true);
                HashSet<String> features = new HashSet<String>();
                for (Map.Entry<String, Object> entry : cosAttrs.entrySet()) {
                    Object value;
                    String name = entry.getKey();
                    if (!name.toLowerCase().startsWith("zimbrafeature") || !name.toLowerCase().endsWith("enabled") || (value = entry.getValue()) == null || !"true".equalsIgnoreCase(value.toString())) continue;
                    features.add(name);
                }
                cosFeatureMap.put(cosId, features);
            }
            return cosFeatureMap.get(cosId);
        }

        private static void parseLimit(HashMap<String, Integer> map, String limit) {
            String[] parts = limit.split(":");
            int max = -1;
            try {
                max = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (max < 0) {
                return;
            }
            map.put(parts[0], max);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void buildDomainCounts(LdapProvisioning prov, String domain, String defaultCos, Map<String, Integer> cosCount, Map<String, Integer> featureCount, Map<String, Set<String>> cosFeatureMap) throws ServiceException {
            String query = LdapFilter.allNonSystemAccounts();
            ZimbraLdapContext zlc = null;
            try {
                try {
                    zlc = new ZimbraLdapContext();
                    SearchControls searchControls = new SearchControls(2, 0L, 0, null, false, false);
                    NamingEnumeration<SearchResult> ne = null;
                    String searchDN = prov.getDIT().domainToAccountSearchDN(domain);
                    int pageSize = 1000;
                    byte[] cookie = null;
                    do {
                        Object var28_29;
                        try {
                            zlc.setPagedControl(pageSize, cookie, true);
                            ne = zlc.searchDir(searchDN, query, searchControls);
                            while (ne != null && ne.hasMore()) {
                                SearchResult sr = (SearchResult)ne.nextElement();
                                String dn = sr.getNameInNamespace();
                                if (dn.endsWith("cn=zimbra")) continue;
                                Attributes attrs = sr.getAttributes();
                                Attribute objectclass = attrs.get("objectclass");
                                if (objectclass == null) {
                                    ZimbraLog.account.error("DN: " + dn + ": does not have objectclass!");
                                    continue;
                                }
                                if (!objectclass.contains("zimbraAccount")) continue;
                                String cosId = defaultCos;
                                Attribute cosIdAttr = attrs.get("zimbracosid");
                                if (cosIdAttr != null) {
                                    cosId = (String)cosIdAttr.get();
                                }
                                DomainMaxAccountsValidator.incrementCount(cosCount, cosId);
                                Set<String> cosFeatures = DomainMaxAccountsValidator.getCosFeatures(prov, cosFeatureMap, cosId, defaultCos);
                                NamingEnumeration<? extends Attribute> e = attrs.getAll();
                                HashSet<String> acctFeatures = new HashSet<String>();
                                while (e.hasMore()) {
                                    Attribute at = e.next();
                                    String name = at.getID();
                                    Object atValue = at.get();
                                    String value = null;
                                    if (atValue != null) {
                                        value = at.get().toString();
                                    }
                                    if (!name.toLowerCase().startsWith("zimbrafeature") || !name.toLowerCase().endsWith("enabled") || !"true".equalsIgnoreCase(value)) continue;
                                    acctFeatures.add(name);
                                }
                                if (cosFeatures != null) {
                                    acctFeatures.addAll(cosFeatures);
                                }
                                for (String feature : acctFeatures) {
                                    DomainMaxAccountsValidator.incrementCount(featureCount, feature);
                                }
                            }
                            var28_29 = null;
                            if (ne == null) continue;
                        }
                        catch (Throwable throwable) {
                            var28_29 = null;
                            if (ne != null) {
                                ne.close();
                            }
                            throw throwable;
                        }
                        ne.close();
                        {
                        }
                    } while ((cookie = zlc.getCookie()) != null);
                }
                catch (NamingException e) {
                    throw ServiceException.FAILURE("unable to count the users", e);
                }
                catch (IOException e) {
                    throw ServiceException.FAILURE("unable to count all the users", e);
                }
                Object var30_31 = null;
            }
            catch (Throwable throwable) {
                Object var30_32 = null;
                ZimbraLdapContext.closeContext(zlc);
                throw throwable;
            }
            ZimbraLdapContext.closeContext(zlc);
            if (ZimbraLog.account.isDebugEnabled()) {
                ZimbraLog.account.debug("COS/Feature counts: %s + %s", cosCount, featureCount);
            }
        }

        private static void incrementCount(Map<String, Integer> map, String key) {
            if (key == null || !map.containsKey(key)) {
                return;
            }
            map.put(key, map.get(key) + 1);
        }
    }

    private static class DomainAccountValidator
    implements LdapProvisioning.ProvisioningValidator {
        private static final long LDAP_CHECK_INTERVAL = 60000L;
        private static final long NUM_ACCT_THRESHOLD = 5L;
        private long mNextCheck;
        private long mLastUserCount;

        private DomainAccountValidator() {
        }

        public void refresh() {
            this.setNextCheck(0L);
        }

        private synchronized void setNextCheck(long nextCheck) {
            this.mNextCheck = nextCheck;
        }

        private synchronized long getNextCheck() {
            return this.mNextCheck;
        }

        public void validate(LdapProvisioning prov, String action, Object ... args) throws ServiceException {
            Map acctAttrs;
            if (args.length < 1) {
                return;
            }
            if (!action.equals("createAccount") || !(args[0] instanceof String)) {
                return;
            }
            if (args.length > 1 && args[1] instanceof String[] && Arrays.asList((String[])args[1]).contains("zimbraCalendarResource")) {
                return;
            }
            if (args.length > 2 && args[2] instanceof Map && Validators.isSystemProperty(acctAttrs = (Map)args[2])) {
                return;
            }
            String emailAddr = (String)args[0];
            String domain = null;
            int index = emailAddr.indexOf(64);
            if (index != -1) {
                domain = emailAddr.substring(index + 1);
            }
            if (domain == null) {
                return;
            }
            Domain d = prov.get(Provisioning.DomainBy.name, domain);
            if (d == null) {
                return;
            }
            String limit = d.getAttr("zimbraDomainMaxAccounts");
            if (limit == null) {
                return;
            }
            long maxAccount = Long.parseLong(limit);
            long now = System.currentTimeMillis();
            if (now > this.getNextCheck()) {
                this.mLastUserCount = prov.countAccounts(domain);
                long nextCheck = maxAccount - this.mLastUserCount > 5L ? 60000L : 0L;
                this.setNextCheck(nextCheck);
            }
            if (maxAccount <= this.mLastUserCount) {
                throw AccountServiceException.TOO_MANY_ACCOUNTS("domain=" + domain + " (" + maxAccount + ")");
            }
        }
    }
}

