/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.ldap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.ldap.LdapUtil;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecialAttrs {
    public static final String SA_zimbraId = "zimbraId";
    public static final String PA_ldapBase = "ldap.baseDN";
    private String mZimbraId;
    private String mLdapBaseDn;

    public String getZimbraId() {
        return this.mZimbraId;
    }

    public String getLdapBaseDn() {
        return this.mLdapBaseDn;
    }

    public static String getSingleValuedAttr(Map<String, Object> attrs, String attr) throws ServiceException {
        Object value = attrs.get(attr);
        if (value == null) {
            return null;
        }
        if (!(value instanceof String)) {
            throw ServiceException.INVALID_REQUEST(attr + " is a single-valued attribute", null);
        }
        return (String)value;
    }

    public void handleZimbraId(Map<String, Object> attrs) throws ServiceException {
        String zimbraId = SpecialAttrs.getSingleValuedAttr(attrs, SA_zimbraId);
        if (zimbraId != null) {
            try {
                if (!LdapUtil.isValidUUID(zimbraId)) {
                    throw ServiceException.INVALID_REQUEST(zimbraId + " is not a valid UUID", null);
                }
            }
            catch (IllegalArgumentException e) {
                throw ServiceException.INVALID_REQUEST(zimbraId + " is not a valid UUID", e);
            }
            attrs.remove(SA_zimbraId);
            this.mZimbraId = zimbraId;
        }
    }

    public void handleLdapBaseDn(Map<String, Object> attrs) throws ServiceException {
        String baseDn = SpecialAttrs.getSingleValuedAttr(attrs, PA_ldapBase);
        if (baseDn != null) {
            attrs.remove(PA_ldapBase);
            this.mLdapBaseDn = baseDn;
        }
    }
}

