/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.ldap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.EmailUtil;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.StringUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Alias;
import com.zimbra.cs.account.Config;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.XMPPComponent;
import com.zimbra.cs.account.ldap.LdapDomain;
import com.zimbra.cs.account.ldap.LdapEntry;
import com.zimbra.cs.account.ldap.LdapProvisioning;
import com.zimbra.cs.account.ldap.LdapUtil;
import com.zimbra.cs.account.ldap.ZimbraLdapContext;
import com.zimbra.cs.account.soap.SoapProvisioning;
import com.zimbra.cs.httpclient.URLUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.naming.directory.BasicAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RenameDomain {
    private static final Log sRenameDomainLog = LogFactory.getLog("zimbra.provisioning.renamedomain");
    private ZimbraLdapContext mZlc;
    private LdapProvisioning mProv;
    private Domain mOldDomain;
    private String mOldDomainId;
    private String mOldDomainName;
    private String mNewDomainName;

    RenameDomain(ZimbraLdapContext zlc, LdapProvisioning prov, Domain oldDomain, String newDomainName) {
        this.mZlc = zlc;
        this.mProv = prov;
        this.mOldDomain = oldDomain;
        this.mOldDomainId = this.mOldDomain.getId();
        this.mOldDomainName = this.mOldDomain.getName();
        this.mNewDomainName = newDomainName;
    }

    private RenameDomainVisitor getVisitor(RenamePhase phase) {
        return new RenameDomainVisitor(this.mZlc, this.mProv, this.mOldDomainName, this.mNewDomainName, phase);
    }

    public void execute() throws ServiceException {
        RenameDomainVisitor visitor;
        RenameDomain.debug("Renaming domain %s(%s) to %s", this.mOldDomainName, this.mOldDomainId, this.mNewDomainName);
        RenameInfo renameInfo = this.beginRenameDomain();
        RenamePhase startingPhase = renameInfo.phase();
        RenamePhase phase = RenamePhase.FIX_FOREIGN_DL_MEMBERS;
        Domain newDomain = this.createNewDomain();
        RenameDomain.debug("new domain: %s(%s)", newDomain.getName(), newDomain.getId());
        String searchBase = this.mProv.mDIT.domainDNToAccountSearchDN(((LdapDomain)this.mOldDomain).getDN());
        int flags = 0;
        phase = RenamePhase.RENAME_ENTRIES;
        if (phase.ordinal() >= startingPhase.ordinal()) {
            RenameDomain.debug("Entering phase " + phase.toString(), new Object[0]);
            visitor = this.getVisitor(phase);
            flags = 13;
            this.mProv.searchObjects(null, null, searchBase, flags, visitor, 0);
        }
        if ((phase = RenamePhase.FIX_FOREIGN_ALIASES).ordinal() >= startingPhase.ordinal()) {
            RenameDomain.debug("Entering phase " + phase.toString(), new Object[0]);
            renameInfo.setPhase(phase);
            renameInfo.write(this.mProv, this.mOldDomain);
            visitor = this.getVisitor(phase);
            flags = 2;
            this.mProv.searchObjects(null, null, searchBase, flags, visitor, 0);
        }
        if ((phase = RenamePhase.FIX_FOREIGN_DL_MEMBERS).ordinal() >= startingPhase.ordinal()) {
            RenameDomain.debug("Entering phase " + phase.toString(), new Object[0]);
            renameInfo.setPhase(phase);
            renameInfo.write(this.mProv, this.mOldDomain);
            visitor = this.getVisitor(phase);
            searchBase = this.mProv.mDIT.domainDNToAccountSearchDN(((LdapDomain)newDomain).getDN());
            flags = 13;
            this.mProv.searchObjects(null, null, searchBase, flags, visitor, 0);
        }
        RenameDomain.debug("Deleting old domain %s(%s)", this.mOldDomainName, this.mOldDomainId);
        String curDefaultDomain = this.mProv.getConfig().getAttr("zimbraDefaultDomainName");
        this.mProv.deleteDomain(this.mOldDomainId);
        this.updateGlobalConfigSettings(curDefaultDomain);
        this.endRenameDomain(newDomain, this.mOldDomainId);
        this.fixupXMPPComponents();
        this.flushCacheOnAllServers(Provisioning.CacheEntryType.account);
    }

    private RenameInfo beginRenameDomain() throws ServiceException {
        boolean domainIsShutdown = this.mOldDomain.isShutdown();
        RenameInfo renameInfo = RenameInfo.load(this.mOldDomain, true);
        if (domainIsShutdown && renameInfo == null) {
            throw ServiceException.INVALID_REQUEST("domain " + this.mOldDomainName + " is shutdown without rename domain info", null);
        }
        if (renameInfo != null && !renameInfo.destDomainName().equals(this.mNewDomainName)) {
            throw ServiceException.INVALID_REQUEST("domain " + this.mOldDomainName + " was being renamed to " + renameInfo.destDomainName() + " it cannot be renamed to " + this.mNewDomainName + " until the previous rename is finished", null);
        }
        RenameDomain.debug("Locking old domain %s(%s)", this.mOldDomainName, this.mOldDomainId);
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraDomainStatus", "shutdown");
        attrs.put("zimbraMailStatus", "disabled");
        this.mProv.modifyAttrs((Entry)this.mOldDomain, attrs, false, false);
        RenamePhase phase = RenamePhase.RENAME_ENTRIES;
        if (renameInfo == null) {
            renameInfo = new RenameInfo(null, this.mNewDomainName, phase);
            renameInfo.write(this.mProv, this.mOldDomain);
        } else {
            phase = renameInfo.phase();
        }
        this.flushCacheOnAllServers(Provisioning.CacheEntryType.domain);
        return renameInfo;
    }

    private Domain createNewDomain() throws ServiceException {
        HashMap<String, Object> domainAttrs = new HashMap<String, Object>(this.mOldDomain.getAttrs(false));
        domainAttrs.remove("o");
        domainAttrs.remove("dc");
        domainAttrs.remove("objectClass");
        domainAttrs.remove("zimbraId");
        domainAttrs.remove("zimbraDomainName");
        domainAttrs.remove("zimbraMailStatus");
        domainAttrs.remove("zimbraCreateTimestamp");
        String curNotebookAcctName = (String)domainAttrs.get("zimbraNotebookAccount");
        String newNotebookAcctName = this.getNewAddress(curNotebookAcctName);
        if (curNotebookAcctName != null && newNotebookAcctName != null) {
            domainAttrs.remove("zimbraNotebookAccount");
            domainAttrs.put("zimbraNotebookAccount", newNotebookAcctName);
        }
        domainAttrs.put("zimbraDomainStatus", "shutdown");
        domainAttrs.put("zimbraMailStatus", "disabled");
        Domain newDomain = null;
        try {
            RenameDomain.debug("Creating new domain %s", this.mNewDomainName);
            newDomain = this.mProv.createDomain(this.mNewDomainName, domainAttrs);
        }
        catch (AccountServiceException e) {
            if (e.getCode().equals("account.DOMAIN_EXISTS")) {
                newDomain = this.mProv.get(Provisioning.DomainBy.name, this.mNewDomainName);
                if (newDomain == null) {
                    throw ServiceException.FAILURE("failed to load existing domain " + this.mNewDomainName, null);
                }
                RenameInfo renameInfo = RenameInfo.load(newDomain, false);
                if (renameInfo == null) {
                    this.endRenameDomain(this.mOldDomain, null);
                    throw ServiceException.INVALID_REQUEST("domain " + this.mNewDomainName + " already exists", null);
                }
                if (!renameInfo.srcDomainName().equals(this.mOldDomainName)) {
                    throw ServiceException.INVALID_REQUEST("domain " + this.mNewDomainName + " was being renamed from " + renameInfo.srcDomainName() + " it cannot be renamed from " + this.mOldDomainName + " until the previous rename is finished", null);
                }
                return newDomain;
            }
            throw e;
        }
        RenameInfo renameInfo = new RenameInfo(this.mOldDomainName, null, null);
        renameInfo.write(this.mProv, newDomain);
        return newDomain;
    }

    private void endRenameDomain(Domain domain, String domainId) throws ServiceException {
        RenameDomain.debug("endRenameDomain domain=%s(%s), domainId=%s", domain.getName(), domain.getId(), domainId == null ? "null" : domainId);
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (domainId != null) {
            attrs.put("zimbraId", domainId);
        }
        attrs.put("zimbraDomainRenameInfo", "");
        attrs.put("zimbraDomainStatus", "active");
        attrs.put("zimbraMailStatus", "enabled");
        this.mProv.modifyAttrsInternal(domain, this.mZlc, attrs);
        this.flushCacheOnAllServers(Provisioning.CacheEntryType.domain);
    }

    private String getNewAddress(String addr) {
        if (addr != null) {
            String[] parts = EmailUtil.getLocalPartAndDomain(addr);
            if (parts == null) {
                RenameDomain.warn("getNewAccountName", "encountered invalid address", "addr=[%s]", addr);
                return null;
            }
            String localPart = parts[0];
            String domain = parts[1];
            if (!domain.equals(this.mOldDomainName)) {
                return null;
            }
            return localPart + "@" + this.mNewDomainName;
        }
        return null;
    }

    private String getNewDomain(String domainName) {
        if (domainName != null) {
            if (!domainName.equals(this.mOldDomainName)) {
                return null;
            }
            return this.mNewDomainName;
        }
        return null;
    }

    private void updateSystemAccount(Entry entry, String attrName, Map<String, Object> attrMap) {
        String curAddr = entry.getAttr(attrName);
        String newAddr = this.getNewAddress(curAddr);
        if (curAddr != null && newAddr != null) {
            attrMap.put(attrName, newAddr);
        }
    }

    private void updateGlobalConfigSettings(String curDefaultDomainName) {
        try {
            Config config = this.mProv.getConfig();
            HashMap<String, Object> attrMap = new HashMap<String, Object>();
            this.updateSystemAccount(config, "zimbraNotebookAccount", attrMap);
            this.updateSystemAccount(config, "zimbraSpamIsSpamAccount", attrMap);
            this.updateSystemAccount(config, "zimbraSpamIsNotSpamAccount", attrMap);
            String newDomainName = this.getNewDomain(curDefaultDomainName);
            if (curDefaultDomainName != null && newDomainName != null) {
                attrMap.put("zimbraDefaultDomainName", newDomainName);
            }
            this.mProv.modifyAttrs(config, attrMap);
            this.flushCacheOnAllServers(Provisioning.CacheEntryType.config);
        }
        catch (ServiceException e) {
            RenameDomain.warn("failed to update system accounts on global config", e);
        }
    }

    private void fixupXMPPComponents() throws ServiceException {
        int domainLen = this.mOldDomainName.length();
        for (XMPPComponent xmpp : this.mProv.getAllXMPPComponents()) {
            String curName;
            if (!this.mOldDomainId.equals(xmpp.getDomainId()) || !(curName = xmpp.getName()).endsWith(this.mOldDomainName)) continue;
            String newName = curName.substring(0, curName.length() - domainLen) + this.mNewDomainName;
            RenameDomain.debug("Renaming XMPP component " + curName + " to " + newName, new Object[0]);
            this.mProv.renameXMPPComponent(xmpp.getId(), newName);
        }
    }

    private void flushCacheOnAllServers(Provisioning.CacheEntryType type) throws ServiceException {
        SoapProvisioning soapProv = new SoapProvisioning();
        String adminUrl = null;
        for (Server server : this.mProv.getAllServers("mailbox")) {
            try {
                adminUrl = URLUtil.getAdminURL(server, "/service/admin/soap/", true);
            }
            catch (ServiceException e) {
                RenameDomain.warn(e, "flushCacheOnAllServers", "", "type=[%s]", new Object[]{type});
                continue;
            }
            soapProv.soapSetURI(adminUrl);
            try {
                soapProv.soapZimbraAdminAuthenticate();
                soapProv.flushCache(type, null);
            }
            catch (ServiceException e) {
                RenameDomain.warn(e, "flushCacheOnAllServers", "", "type=[%s] server=[%s]", new Object[]{type, server.getName()});
            }
        }
    }

    private static void warn(Object o, Throwable t) {
        sRenameDomainLog.warn(o, t);
    }

    private static void warn(String funcName, String desc, String format, Object ... objects) {
        RenameDomain.warn(null, funcName, desc, format, objects);
    }

    private static void warn(Throwable t, String funcName, String desc, String format, Object ... objects) {
        if (sRenameDomainLog.isWarnEnabled()) {
            sRenameDomainLog.warn(String.format(funcName + "(" + desc + "):" + format, objects));
        }
    }

    private static void debug(String format, Object ... objects) {
        if (sRenameDomainLog.isDebugEnabled()) {
            sRenameDomainLog.debug(String.format(format, objects));
        }
    }

    private static void info(String format, Object ... objects) {
        sRenameDomainLog.info(String.format(format, objects));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RenameDomainVisitor
    implements NamedEntry.Visitor {
        private ZimbraLdapContext mZlc;
        private LdapProvisioning mProv;
        private String mOldDomainName;
        private String mNewDomainName;
        private RenamePhase mPhase;
        private static final Set<String> sAddrContainsDomainOnly = new HashSet<String>();
        private static final String[] sDLAttrsNeedRename;
        private static final String[] sAcctAttrsNeedRename;

        private static boolean addrContainsDomainOnly(String addr) {
            return sAddrContainsDomainOnly.contains(addr);
        }

        private RenameDomainVisitor(ZimbraLdapContext zlc, LdapProvisioning prov, String oldDomainName, String newDomainName, RenamePhase phase) {
            this.mZlc = zlc;
            this.mProv = prov;
            this.mOldDomainName = oldDomainName;
            this.mNewDomainName = newDomainName;
            this.mPhase = phase;
        }

        @Override
        public void visit(NamedEntry entry) throws ServiceException {
            RenameDomain.debug("(" + this.mPhase.toString() + ") visiting " + entry.getName(), new Object[0]);
            if (this.mPhase == RenamePhase.RENAME_ENTRIES) {
                if (entry instanceof DistributionList) {
                    this.handleEntry(entry, true);
                } else if (entry instanceof Account) {
                    this.handleEntry(entry, false);
                }
            } else if (this.mPhase == RenamePhase.FIX_FOREIGN_ALIASES) {
                if (entry instanceof Alias) {
                    this.handleForeignAlias(entry);
                } else assert (false);
            } else if (this.mPhase == RenamePhase.FIX_FOREIGN_DL_MEMBERS) {
                this.handleForeignDLMembers(entry);
            }
        }

        private void handleEntry(NamedEntry entry, boolean isDL) throws ServiceException {
            LdapEntry ldapEntry = (LdapEntry)((Object)entry);
            String[] parts = EmailUtil.getLocalPartAndDomain(entry.getName());
            String newDn = null;
            try {
                newDn = isDL ? this.mProv.mDIT.distributionListDNRename(ldapEntry.getDN(), parts[0], this.mNewDomainName) : this.mProv.mDIT.accountDNRename(ldapEntry.getDN(), parts[0], this.mNewDomainName);
            }
            catch (NamingException e) {
                RenameDomain.warn(e, "handleEntry", "cannot get new DN, entry not handled", "entry=[%s]", new Object[]{entry.getName()});
                return;
            }
            catch (ServiceException e) {
                RenameDomain.warn(e, "handleEntry", "cannot get new DN, entry not handled", "entry=[%s]", new Object[]{entry.getName()});
                return;
            }
            String[] aliases = isDL ? ((DistributionList)entry).getAliases() : ((Account)entry).getMailAlias();
            this.handleAliases(entry, aliases, newDn);
            String oldDn = ((LdapEntry)((Object)entry)).getDN();
            if (isDL) {
                this.handleDistributionList(entry, oldDn, newDn);
            } else {
                this.handleAccount(entry, oldDn, newDn);
            }
        }

        private void handleAliases(NamedEntry targetEntry, String[] aliases, String newTargetDn) {
            LdapEntry ldapEntry = (LdapEntry)((Object)targetEntry);
            String oldDn = ldapEntry.getDN();
            for (int i = 0; i < aliases.length; ++i) {
                if (aliases[i].equals(targetEntry.getName())) continue;
                String[] parts = EmailUtil.getLocalPartAndDomain(aliases[i]);
                if (parts == null) {
                    assert (false);
                    RenameDomain.warn("moveEntry", "encountered invalid alias address", "alias=[%s], entry=[%s]", new Object[]{aliases[i], targetEntry.getName()});
                    continue;
                }
                String aliasLocal = parts[0];
                String aliasDomain = parts[1];
                if (!aliasDomain.equals(this.mOldDomainName)) continue;
                String oldAliasDn = "";
                String newAliasDn = "";
                try {
                    oldAliasDn = this.mProv.mDIT.aliasDN(oldDn, this.mOldDomainName, aliasLocal, this.mOldDomainName);
                    newAliasDn = this.mProv.mDIT.aliasDNRename(newTargetDn, this.mNewDomainName, aliasLocal + "@" + this.mNewDomainName);
                    if (oldAliasDn.equals(newAliasDn)) continue;
                    this.mZlc.renameEntry(oldAliasDn, newAliasDn);
                    continue;
                }
                catch (NamingException e) {
                    RenameDomain.warn(e, "moveEntry", "alias not moved", "alias=[%s], entry=[%s], oldAliasDn=[%s], newAliasDn=[%s]", new Object[]{aliases[i], targetEntry.getName(), oldAliasDn, newAliasDn});
                    continue;
                }
                catch (ServiceException e) {
                    RenameDomain.warn(e, "moveEntry", "alias not moved", "alias=[%s], entry=[%s], oldAliasDn=[%s], newAliasDn=[%s]", new Object[]{aliases[i], targetEntry.getName(), oldAliasDn, newAliasDn});
                }
            }
        }

        private void handleDistributionList(NamedEntry entry, String oldDn, String newDn) {
            NamedEntry refreshedEntry = entry;
            if (!oldDn.equals(newDn)) {
                try {
                    this.mZlc.renameEntry(oldDn, newDn);
                }
                catch (NamingException e) {
                    RenameDomain.warn(e, "moveDistributionList", "renameEntry", "entry=[%s], oldDn=[%s], newDn=[%s]", new Object[]{entry.getName(), oldDn, newDn});
                }
                try {
                    refreshedEntry = this.mProv.get(Provisioning.DistributionListBy.id, entry.getId());
                }
                catch (ServiceException e) {
                    RenameDomain.warn(e, "moveDistributionList", "getDistributionListById, entry not modified", "entry=[%s], oldDn=[%s], newDn=[%s]", new Object[]{entry.getName(), oldDn, newDn});
                    return;
                }
            }
            Map<String, Object> fixedAttrs = this.fixupAddrs(entry, sDLAttrsNeedRename);
            try {
                this.mProv.modifyAttrsInternal(refreshedEntry, this.mZlc, fixedAttrs);
            }
            catch (ServiceException e) {
                RenameDomain.warn(e, "moveDistributionList", "modifyAttrsInternal", "entry=[%s], oldDn=[%s], newDn=[%s]", new Object[]{entry.getName(), oldDn, newDn});
            }
        }

        private void handleAccount(NamedEntry entry, String oldDn, String newDn) {
            NamedEntry refreshedEntry = entry;
            Map<String, Object> fixedAttrs = this.fixupAddrs(entry, sAcctAttrsNeedRename);
            if (!oldDn.equals(newDn)) {
                BasicAttributes attributes = new BasicAttributes(true);
                LdapUtil.mapToAttrs(fixedAttrs, attributes);
                try {
                    this.mZlc.createEntry(newDn, attributes, "renameDomain-createAccount");
                }
                catch (NameAlreadyBoundException e) {
                    RenameDomain.warn(e, "moveAccount", "createEntry", "entry=[%s], oldDn=[%s], newDn=[%s]", new Object[]{entry.getName(), oldDn, newDn});
                }
                catch (ServiceException e) {
                    RenameDomain.warn(e, "moveAccount", "createEntry", "entry=[%s], oldDn=[%s], newDn=[%s]", new Object[]{entry.getName(), oldDn, newDn});
                }
                try {
                    this.mZlc.moveChildren(oldDn, newDn);
                }
                catch (ServiceException e) {
                    RenameDomain.warn(e, "moveAccount", "moveChildren", "entry=[%s], oldDn=[%s], newDn=[%s]", new Object[]{entry.getName(), oldDn, newDn});
                }
                try {
                    this.mZlc.unbindEntry(oldDn);
                }
                catch (NamingException e) {
                    RenameDomain.warn(e, "moveAccount", "unbindEntry", "entry=[%s], oldDn=[%s], newDn=[%s]", new Object[]{entry.getName(), oldDn, newDn});
                }
            } else {
                try {
                    this.mProv.modifyAttrsInternal(refreshedEntry, this.mZlc, fixedAttrs);
                }
                catch (ServiceException e) {
                    RenameDomain.warn(e, "moveAccount", "modifyAttrsInternal", "entry=[%s], oldDn=[%s], newDn=[%s]", new Object[]{entry.getName(), oldDn, newDn});
                }
            }
        }

        private Map<String, Object> fixupAddrs(NamedEntry entry, String[] attrsNeedRename) {
            Map<String, Object> attrs = entry.getAttrs(false);
            for (String attr : attrsNeedRename) {
                boolean addrCanBeDomainOnly = RenameDomainVisitor.addrContainsDomainOnly(attr);
                String[] values = entry.getMultiAttr(attr, false);
                if (values.length <= 0) continue;
                HashSet<String> newValues = new HashSet<String>();
                for (int i = 0; i < values.length; ++i) {
                    String newValue = this.convertToNewAddr(values[i], this.mOldDomainName, this.mNewDomainName, addrCanBeDomainOnly);
                    if (newValue == null) continue;
                    newValues.add(newValue);
                }
                if (newValues.size() <= 0) continue;
                attrs.put(attr, newValues.toArray(new String[newValues.size()]));
            }
            return attrs;
        }

        private String convertToNewAddr(String address, String oldDomain, String newDomain, boolean addrCanBeDomainOnly) {
            String addr = address.trim();
            String[] parts = EmailUtil.getLocalPartAndDomain(addr);
            if (parts == null && !addrCanBeDomainOnly) {
                RenameDomain.warn("convertToNewAddr", "encountered invalid address", "addr=[%s]", new Object[]{addr});
                return null;
            }
            String local = null;
            String domain = null;
            if (parts != null) {
                local = parts[0];
                domain = parts[1];
            } else if (addr.charAt(0) == '@') {
                domain = addr.substring(1);
            }
            if (domain == null) {
                RenameDomain.warn("convertToNewAddr", "encountered invalid address", "addr=[%s]", new Object[]{addr});
                return null;
            }
            if (domain.equals(oldDomain)) {
                if (local != null) {
                    return local + "@" + newDomain;
                }
                return "@" + newDomain;
            }
            return addr;
        }

        private void handleForeignAlias(NamedEntry entry) {
            Alias alias = (Alias)entry;
            NamedEntry targetEntry = null;
            try {
                targetEntry = this.mProv.searchAliasTarget(alias, false);
            }
            catch (ServiceException e) {
                RenameDomain.warn(e, "handleForeignAlias", "target entry not found for aliasalias=[%s], target=[%s]", alias.getName(), new Object[]{alias.getAttr("zimbraAliasTargetId")});
                return;
            }
            String targetName = targetEntry.getName();
            String[] targetParts = EmailUtil.getLocalPartAndDomain(targetName);
            if (targetParts == null) {
                RenameDomain.warn("handleForeignAlias", "encountered invalid alias target address", "target=[%s]", new Object[]{targetName});
                return;
            }
            String targetDomain = targetParts[1];
            if (!targetDomain.equals(this.mOldDomainName)) {
                String aliasOldAddr = alias.getName();
                String[] aliasParts = EmailUtil.getLocalPartAndDomain(aliasOldAddr);
                if (aliasParts == null) {
                    RenameDomain.warn("handleForeignAlias", "encountered invalid alias address", "alias=[%s]", new Object[]{aliasOldAddr});
                    return;
                }
                String aliasLocal = aliasParts[0];
                String aliasNewAddr = aliasLocal + "@" + this.mNewDomainName;
                if (targetEntry instanceof DistributionList) {
                    DistributionList dl = (DistributionList)targetEntry;
                    this.fixupForeignTarget(dl, aliasOldAddr, aliasNewAddr);
                } else if (targetEntry instanceof Account) {
                    Account acct = (Account)targetEntry;
                    this.fixupForeignTarget(acct, aliasOldAddr, aliasNewAddr);
                } else {
                    RenameDomain.warn("handleForeignAlias", "encountered invalid alias target type", "target=[%s]", new Object[]{targetName});
                    return;
                }
            }
        }

        private void fixupForeignTarget(DistributionList targetEntry, String aliasOldAddr, String aliasNewAddr) {
            try {
                this.mProv.removeAlias(targetEntry, aliasOldAddr);
            }
            catch (ServiceException e) {
                RenameDomain.warn("fixupTargetInOtherDomain", "cannot remove alias for dldl=[%s], aliasOldAddr=[%s], aliasNewAddr=[%s]", targetEntry.getName(), new Object[]{aliasOldAddr, aliasNewAddr});
            }
            try {
                this.mProv.addAlias(targetEntry, aliasNewAddr);
            }
            catch (ServiceException e) {
                RenameDomain.warn("fixupTargetInOtherDomain", "cannot add alias for dldl=[%s], aliasOldAddr=[%s], aliasNewAddr=[%s]", targetEntry.getName(), new Object[]{aliasOldAddr, aliasNewAddr});
            }
        }

        private void fixupForeignTarget(Account targetEntry, String aliasOldAddr, String aliasNewAddr) {
            try {
                this.mProv.removeAlias(targetEntry, aliasOldAddr);
            }
            catch (ServiceException e) {
                RenameDomain.warn("fixupTargetInOtherDomain", "cannot remove alias for accountacct=[%s], aliasOldAddr=[%s], aliasNewAddr=[%s]", targetEntry.getName(), new Object[]{aliasOldAddr, aliasNewAddr});
            }
            try {
                this.mProv.addAlias(targetEntry, aliasNewAddr);
            }
            catch (ServiceException e) {
                RenameDomain.warn("fixupTargetInOtherDomain", "cannot add alias for accountacct=[%s], aliasOldAddr=[%s], aliasNewAddr=[%s]", targetEntry.getName(), new Object[]{aliasOldAddr, aliasNewAddr});
            }
        }

        private void handleForeignDLMembers(NamedEntry entry) {
            String[] aliasesAddrs;
            HashMap<String, String> changedPairs = new HashMap<String, String>();
            String entryAddr = entry.getName();
            String[] oldNewPair = this.changedAddrPairs(entryAddr);
            if (oldNewPair != null) {
                changedPairs.put(oldNewPair[0], oldNewPair[1]);
            }
            for (String aliasAddr : aliasesAddrs = entry.getMultiAttr("zimbraMailAlias", false)) {
                oldNewPair = this.changedAddrPairs(aliasAddr);
                if (oldNewPair == null) continue;
                changedPairs.put(oldNewPair[0], oldNewPair[1]);
            }
            this.mProv.renameAddressesInAllDistributionLists(changedPairs);
        }

        private String[] changedAddrPairs(String addr) {
            String[] parts = EmailUtil.getLocalPartAndDomain(addr);
            if (parts == null) {
                RenameDomain.warn("changedAddrPairs", "encountered invalid address", "addr=[%s]", new Object[]{addr});
                return null;
            }
            String domain = parts[1];
            if (!domain.equals(this.mNewDomainName)) {
                return null;
            }
            String localPart = parts[0];
            String[] oldNewAddrPairs = new String[]{localPart + "@" + this.mOldDomainName, localPart + "@" + this.mNewDomainName};
            return oldNewAddrPairs;
        }

        static {
            sAddrContainsDomainOnly.add("zimbraMailCatchAllAddress");
            sAddrContainsDomainOnly.add("zimbraMailCatchAllCanonicalAddress");
            sAddrContainsDomainOnly.add("zimbraMailCatchAllForwardingAddress");
            sDLAttrsNeedRename = new String[]{"mail", "zimbraMailAlias", "zimbraMailForwardingAddress", "zimbraMailDeliveryAddress", "zimbraMailCanonicalAddress", "zimbraMailCatchAllAddress", "zimbraMailCatchAllCanonicalAddress", "zimbraMailCatchAllForwardingAddress"};
            sAcctAttrsNeedRename = new String[]{"mail", "zimbraMailAlias", "zimbraMailForwardingAddress", "zimbraMailDeliveryAddress", "zimbraMailCanonicalAddress", "zimbraMailCatchAllAddress", "zimbraMailCatchAllCanonicalAddress", "zimbraMailCatchAllForwardingAddress"};
        }
    }

    private static class RenameInfo {
        private static final String SRC = "SRC";
        private static final String DEST = "DEST";
        private static final char COLON = ':';
        private static final char COMMA = ',';
        private String mSrcDomainName;
        private String mDestDomainName;
        private RenamePhase mPhase;
        private boolean mIsSrc;

        private RenameInfo(String srcDomainName, String destDomainName, RenamePhase phase) {
            this.mSrcDomainName = srcDomainName;
            this.mDestDomainName = destDomainName;
            this.mPhase = phase;
            this.mIsSrc = srcDomainName == null;
        }

        String srcDomainName() {
            return this.mSrcDomainName;
        }

        String destDomainName() {
            return this.mDestDomainName;
        }

        RenamePhase phase() {
            return this.mPhase;
        }

        public void setPhase(RenamePhase phase) throws ServiceException {
            this.mPhase = phase;
        }

        private String encodeSrc() {
            return "SRC," + this.mPhase.toString() + ':' + this.mDestDomainName;
        }

        private String encodeDest() {
            return "DEST:" + this.mSrcDomainName;
        }

        static RenameInfo load(Domain domain, boolean expectingSrc) throws ServiceException {
            String renameInfo = domain.getAttr("zimbraDomainRenameInfo");
            if (StringUtil.isNullOrEmpty(renameInfo)) {
                RenameDomain.debug("RenameInfo.load: domain=%s(%s), %s=not set", new Object[]{domain.getName(), domain.getId(), "zimbraDomainRenameInfo"});
                return null;
            }
            RenameDomain.debug("RenameInfo.load: domain=%s(%s), %s=%s", new Object[]{domain.getName(), domain.getId(), "zimbraDomainRenameInfo", renameInfo});
            int idx = renameInfo.indexOf(58);
            if (idx == -1) {
                throw ServiceException.FAILURE("invalid value in zimbraDomainRenameInfo: " + renameInfo + " missing " + ':', null);
            }
            String statusPart = renameInfo.substring(0, idx);
            String domainName = renameInfo.substring(idx + 1);
            if (StringUtil.isNullOrEmpty(domainName)) {
                throw ServiceException.FAILURE("invalid value in zimbraDomainRenameInfo: " + renameInfo + " missing domain name", null);
            }
            idx = statusPart.indexOf(44);
            String srcOrDest = statusPart;
            RenamePhase phase = null;
            if (idx != -1) {
                srcOrDest = statusPart.substring(0, idx);
                phase = RenamePhase.fromString(statusPart.substring(idx + 1));
            }
            if (srcOrDest.equals(SRC)) {
                if (!expectingSrc) {
                    throw ServiceException.FAILURE("invalid value in zimbraDomainRenameInfo: " + renameInfo + " missing " + DEST + " keyword", null);
                }
                if (phase == null) {
                    throw ServiceException.FAILURE("invalid value in zimbraDomainRenameInfo: " + renameInfo + " missing phase info for source domain", null);
                }
                return new RenameInfo(null, domainName, phase);
            }
            if (expectingSrc) {
                throw ServiceException.FAILURE("invalid value in zimbraDomainRenameInfo: " + renameInfo + " missing " + SRC + " keyword", null);
            }
            return new RenameInfo(domainName, null, phase);
        }

        public void write(LdapProvisioning prov, Domain domain) throws ServiceException {
            HashMap<String, String> attrs = new HashMap<String, String>();
            String renameInfoStr = this.mIsSrc ? this.encodeSrc() : this.encodeDest();
            attrs.put("zimbraDomainRenameInfo", renameInfoStr);
            RenameDomain.debug("RenameInfo.write: domain=%s(%s), %s=%s", new Object[]{domain.getName(), domain.getId(), "zimbraDomainRenameInfo", renameInfoStr});
            prov.modifyAttrs(domain, attrs);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RenamePhase {
        RENAME_ENTRIES,
        FIX_FOREIGN_ALIASES,
        FIX_FOREIGN_DL_MEMBERS;


        public static RenamePhase fromString(String s) throws ServiceException {
            try {
                return RenamePhase.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ServiceException.FAILURE("unknown phase: " + s, e);
            }
        }
    }
}

