/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.ldap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.DateUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.GalContact;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.gal.GalOp;
import com.zimbra.cs.account.gal.GalParams;
import com.zimbra.cs.account.gal.GalUtil;
import com.zimbra.cs.account.krb5.Krb5Login;
import com.zimbra.cs.account.ldap.LdapDomain;
import com.zimbra.cs.account.ldap.LdapGalCredential;
import com.zimbra.cs.account.ldap.LdapGalMapRules;
import com.zimbra.cs.account.ldap.LdapProvisioning;
import com.zimbra.cs.account.ldap.ZimbraLdapContext;
import com.zimbra.cs.gal.GalSearchConfig;
import com.zimbra.cs.gal.GalSearchParams;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.SizeLimitExceededException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Rdn;
import javax.security.auth.login.LoginException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapUtil {
    public static final String LDAP_TRUE = "TRUE";
    public static final String LDAP_FALSE = "FALSE";
    static final String EARLIEST_SYNC_TOKEN = "19700101000000Z";
    private static String[] sEmptyMulti = new String[0];
    static final SearchControls sSubtreeSC = new SearchControls(2, 0L, 0, null, false, false);

    public static void closeEnumContext(NamingEnumeration ctxt) {
        try {
            if (ctxt != null) {
                ctxt.close();
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public static void ldapAuthenticate(String[] urls, boolean requireStartTLS, String principal, String password) throws NamingException, IOException {
        if (password == null || password.equals("")) {
            throw new AuthenticationException("empty password");
        }
        ZimbraLdapContext.ldapAuthenticate(urls, requireStartTLS, principal, password, "external LDAP auth");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ldapAuthenticate(String[] url, boolean requireStartTLS, String password, String searchBase, String searchFilter, String searchDn, String searchPassword) throws NamingException, IOException {
        if (password == null || password.equals("")) {
            throw new AuthenticationException("empty password");
        }
        ZimbraLdapContext zlc = null;
        String resultDn = null;
        String tooMany = null;
        NamingEnumeration<SearchResult> ne = null;
        try {
            zlc = new ZimbraLdapContext(url, requireStartTLS, searchDn, searchPassword, "external LDAP auth");
            ne = zlc.searchDir(searchBase, searchFilter, sSubtreeSC);
            while (ne.hasMore()) {
                SearchResult sr = ne.next();
                if (resultDn == null) {
                    resultDn = sr.getNameInNamespace();
                    continue;
                }
                tooMany = sr.getNameInNamespace();
            }
        }
        catch (Throwable throwable) {
            ZimbraLdapContext.closeContext(zlc);
            LdapUtil.closeEnumContext(ne);
            throw throwable;
        }
        ZimbraLdapContext.closeContext(zlc);
        LdapUtil.closeEnumContext(ne);
        if (tooMany != null) {
            ZimbraLog.account.warn(String.format("ldapAuthenticate searchFilter returned more then one result: (dn1=%s, dn2=%s, filter=%s)", resultDn, tooMany, searchFilter));
            throw new AuthenticationException("too many results from search filter!");
        }
        if (resultDn == null) {
            throw new AuthenticationException("empty search");
        }
        if (ZimbraLog.account.isDebugEnabled()) {
            ZimbraLog.account.debug("search filter matched: " + resultDn);
        }
        LdapUtil.ldapAuthenticate(url, requireStartTLS, resultDn, password);
    }

    public static String generateUUID() {
        return UUID.randomUUID().toString();
    }

    public static boolean isValidUUID(String strRep) throws IllegalArgumentException {
        if (strRep.length() > 127) {
            throw new IllegalArgumentException("uuid must be no longer than 127 characters");
        }
        if (strRep.contains(":")) {
            throw new IllegalArgumentException("uuid must not contain ':'");
        }
        return true;
    }

    public static String getAttrString(Attributes attrs, String name) throws NamingException {
        Attribute attr = attrs.get(name);
        if (attr != null) {
            Object o = attr.get();
            if (o instanceof String) {
                return (String)o;
            }
            return new String((byte[])o);
        }
        return null;
    }

    public static String[] getMultiAttrString(Attributes attrs, String name) throws NamingException {
        Attribute attr = attrs.get(name);
        if (attr != null) {
            String[] result = new String[attr.size()];
            for (int i = 0; i < attr.size(); ++i) {
                Object o = attr.get(i);
                result[i] = o instanceof String ? (String)o : new String((byte[])o);
            }
            return result;
        }
        return sEmptyMulti;
    }

    public static Map<String, Object> getAttrs(Attributes attrs) throws NamingException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        NamingEnumeration<? extends Attribute> ne = attrs.getAll();
        while (ne.hasMore()) {
            Attribute attr = ne.next();
            if (attr.size() == 1) {
                Object o = attr.get();
                if (o instanceof String) {
                    map.put(attr.getID(), o);
                    continue;
                }
                map.put(attr.getID(), new String((byte[])o));
                continue;
            }
            String[] result = new String[attr.size()];
            for (int i = 0; i < attr.size(); ++i) {
                Object o = attr.get(i);
                result[i] = o instanceof String ? (String)o : new String((byte[])o);
            }
            map.put(attr.getID(), result);
        }
        return map;
    }

    public static String escapeSearchFilterArg(String s) {
        if (s == null) {
            return null;
        }
        return s.replaceAll("([\\\\\\*\\(\\)])", "\\\\$0");
    }

    public static Attribute addAttr(Attributes attrs, String name, String value) {
        BasicAttribute a = new BasicAttribute(name);
        a.add(value);
        attrs.put(a);
        return a;
    }

    public static Attribute addAttr(Attributes attrs, String name, Set<String> values) {
        Attribute a = attrs.get(name);
        if (a == null) {
            a = new BasicAttribute(name);
            attrs.put(a);
        }
        for (String value : values) {
            a.add(value);
        }
        return a;
    }

    private static void modifyAttr(ArrayList<ModificationItem> modList, String name, String value, Entry entry) {
        int mod_op;
        int n = mod_op = value == null || value.equals("") ? 3 : 2;
        if (mod_op == 3 && entry.getAttr(name, false) == null) {
            return;
        }
        BasicAttribute ba = new BasicAttribute(name);
        if (mod_op == 2) {
            ba.add(value);
        }
        modList.add(new ModificationItem(mod_op, ba));
    }

    private static void removeAttr(ArrayList<ModificationItem> modList, String name, String value, Entry entry) {
        if (!LdapUtil.contains(entry.getMultiAttr(name, false), value)) {
            return;
        }
        BasicAttribute ba = new BasicAttribute(name);
        ba.add(value);
        modList.add(new ModificationItem(3, ba));
    }

    private static boolean contains(String[] values, String val) {
        if (values == null) {
            return false;
        }
        for (String s : values) {
            if (s.compareToIgnoreCase(val) != 0) continue;
            return true;
        }
        return false;
    }

    private static void removeAttr(ArrayList<ModificationItem> modList, String name, String[] value, Entry entry) {
        String[] currentValues = entry.getMultiAttr(name, false);
        if (currentValues == null || currentValues.length == 0) {
            return;
        }
        BasicAttribute ba = null;
        for (int i = 0; i < value.length; ++i) {
            if (!LdapUtil.contains(currentValues, value[i])) continue;
            if (ba == null) {
                ba = new BasicAttribute(name);
            }
            ba.add(value[i]);
        }
        if (ba != null) {
            modList.add(new ModificationItem(3, ba));
        }
    }

    private static void addAttr(ArrayList<ModificationItem> modList, String name, String value, Entry entry) {
        if (LdapUtil.contains(entry.getMultiAttr(name, false), value)) {
            return;
        }
        BasicAttribute ba = new BasicAttribute(name);
        ba.add(value);
        modList.add(new ModificationItem(1, ba));
    }

    private static void addAttr(ArrayList<ModificationItem> modList, String name, String[] value, Entry entry) {
        String[] currentValues = entry.getMultiAttr(name, false);
        BasicAttribute ba = null;
        for (int i = 0; i < value.length; ++i) {
            if (LdapUtil.contains(currentValues, value[i])) continue;
            if (ba == null) {
                ba = new BasicAttribute(name);
            }
            ba.add(value[i]);
        }
        if (ba != null) {
            modList.add(new ModificationItem(1, ba));
        }
    }

    public static void modifyAttrs(ZimbraLdapContext zlc, String dn, Map attrs, Entry entry) throws NamingException, ServiceException {
        ArrayList<ModificationItem> modlist = new ArrayList<ModificationItem>();
        for (Map.Entry me : attrs.entrySet()) {
            String s;
            boolean doRemove;
            Object v = me.getValue();
            String key = (String)me.getKey();
            boolean doAdd = key.charAt(0) == '+';
            boolean bl = doRemove = key.charAt(0) == '-';
            if ((doAdd || doRemove) && attrs.containsKey(key = key.substring(1))) {
                throw ServiceException.INVALID_REQUEST("can't mix +attrName/-attrName with attrName", null);
            }
            if (v instanceof Object[]) {
                v = Arrays.asList((Object[])v);
            }
            if (v instanceof Collection) {
                Collection c = (Collection)v;
                if (c.size() == 0) {
                    if (entry.getAttr(key, false) == null) continue;
                    BasicAttribute ba = new BasicAttribute(key);
                    modlist.add(new ModificationItem(3, ba));
                    continue;
                }
                String[] sa = new String[c.size()];
                int i = 0;
                for (Object o : c) {
                    sa[i++] = o == null ? null : o.toString();
                }
                if (doAdd) {
                    LdapUtil.addAttr(modlist, key, sa, entry);
                    continue;
                }
                if (doRemove) {
                    LdapUtil.removeAttr(modlist, key, sa, entry);
                    continue;
                }
                BasicAttribute ba = new BasicAttribute(key);
                for (i = 0; i < sa.length; ++i) {
                    ba.add(sa[i]);
                }
                modlist.add(new ModificationItem(2, ba));
                continue;
            }
            if (v instanceof Map) {
                throw ServiceException.FAILURE("Map is not a supported value type", null);
            }
            String string = s = v == null ? null : v.toString();
            if (doAdd) {
                LdapUtil.addAttr(modlist, key, s, entry);
                continue;
            }
            if (doRemove) {
                LdapUtil.removeAttr(modlist, key, s, entry);
                continue;
            }
            LdapUtil.modifyAttr(modlist, key, s, entry);
        }
        ModificationItem[] mods = new ModificationItem[modlist.size()];
        modlist.toArray(mods);
        zlc.modifyAttributes(dn, mods);
    }

    public static void mapToAttrs(Map mapAttrs, Attributes attrs) {
        for (Map.Entry me : mapAttrs.entrySet()) {
            BasicAttribute a;
            Object v = me.getValue();
            if (v instanceof String) {
                attrs.put((String)me.getKey(), (String)v);
                continue;
            }
            if (v instanceof String[]) {
                String[] sa = (String[])v;
                a = new BasicAttribute((String)me.getKey());
                for (int i = 0; i < sa.length; ++i) {
                    a.add(sa[i]);
                }
                attrs.put(a);
                continue;
            }
            if (!(v instanceof Collection)) continue;
            Collection c = (Collection)v;
            a = new BasicAttribute((String)me.getKey());
            for (Object o : c) {
                a.add(o.toString());
            }
            attrs.put(a);
        }
    }

    public static String domainToDN(String[] parts, int offset) {
        StringBuffer sb = new StringBuffer(128);
        for (int i = offset; i < parts.length; ++i) {
            if (i - offset > 0) {
                sb.append(",");
            }
            sb.append("dc=").append(LdapUtil.escapeRDNValue(parts[i]));
        }
        return sb.toString();
    }

    public static String domainToDN(String domain) {
        return LdapUtil.domainToDN(domain.split("\\."), 0);
    }

    public static String emailToDomainDN(String email) throws ServiceException {
        int index = email.indexOf(64);
        if (index == -1) {
            throw ServiceException.INVALID_REQUEST("must be an email address: " + email, null);
        }
        String domain = email.substring(index + 1);
        return LdapUtil.domainToDN(domain.split("\\."), 0);
    }

    public static String dnToDomain(String dn) {
        String[] parts = dn.split(",");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < parts.length; ++i) {
            if (!parts[i].startsWith("dc=")) continue;
            if (sb.length() > 0) {
                sb.append(".");
            }
            sb.append(LdapUtil.unescapeRDNValue(parts[i].substring(3)));
        }
        return sb.toString();
    }

    public static String[] dnToRdnAndBaseDn(String dn) {
        String[] values = new String[2];
        int baseDnIdx = dn.indexOf(",");
        if (baseDnIdx != -1 && dn.length() > baseDnIdx + 1) {
            values[0] = dn.substring(0, baseDnIdx);
            values[1] = dn.substring(baseDnIdx + 1);
        } else {
            values[0] = dn;
            values[1] = dn;
        }
        return values;
    }

    static String[] removeMultiValue(String[] values, String value) {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(values));
        boolean updated = list.remove(value);
        if (updated) {
            return list.toArray(new String[list.size()]);
        }
        return values;
    }

    public static String getBooleanString(boolean b) {
        if (b) {
            return LDAP_TRUE;
        }
        return LDAP_FALSE;
    }

    public static String computeAuthDn(String name, String bindDnRule) {
        if (bindDnRule == null || bindDnRule.equals("") || bindDnRule.equals("%n")) {
            return name;
        }
        int at = name.indexOf("@");
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("n", name);
        if (at == -1) {
            vars.put("u", name);
        } else {
            vars.put("u", name.substring(0, at));
            String d = name.substring(at + 1);
            vars.put("d", d);
            vars.put("D", LdapUtil.domainToDN(d));
        }
        return LdapProvisioning.expandStr(bindDnRule, vars);
    }

    public static void searchLdapOnMaster(String base, String query, String[] returnAttrs, SearchLdapVisitor visitor) throws ServiceException {
        LdapUtil.searchLdap(base, query, returnAttrs, true, visitor);
    }

    public static void searchLdapOnReplica(String base, String query, String[] returnAttrs, SearchLdapVisitor visitor) throws ServiceException {
        LdapUtil.searchLdap(base, query, returnAttrs, false, visitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void searchLdap(String base, String query, String[] returnAttrs, boolean useMaster, SearchLdapVisitor visitor) throws ServiceException {
        int maxResults = 0;
        ZimbraLdapContext zlc = null;
        boolean numModified = false;
        try {
            zlc = new ZimbraLdapContext(useMaster);
            SearchControls searchControls = new SearchControls(2, maxResults, 0, returnAttrs, false, false);
            int pageSize = LdapUtil.adjustPageSize(maxResults, 1000);
            byte[] cookie = null;
            NamingEnumeration<SearchResult> ne = null;
            try {
                do {
                    zlc.setPagedControl(pageSize, cookie, true);
                    ne = zlc.searchDir(base, query, searchControls);
                    while (ne != null && ne.hasMore()) {
                        SearchResult sr = (SearchResult)ne.nextElement();
                        String dn = sr.getNameInNamespace();
                        Attributes attrs = sr.getAttributes();
                        visitor.visit(dn, LdapUtil.getAttrs(attrs), attrs);
                    }
                } while ((cookie = zlc.getCookie()) != null);
            }
            finally {
                if (ne != null) {
                    ne.close();
                }
            }
        }
        catch (NamingException e) {
            try {
                throw ServiceException.FAILURE("unable to search ldap", e);
                catch (IOException e2) {
                    throw ServiceException.FAILURE("unable to search ldap", e2);
                }
            }
            catch (Throwable throwable) {
                ZimbraLdapContext.closeContext(zlc);
                throw throwable;
            }
        }
        ZimbraLdapContext.closeContext(zlc);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void searchGal(ZimbraLdapContext zlc, int pageSize, String base, String query, int maxResults, LdapGalMapRules rules, String token, Provisioning.SearchGalResult result) throws ServiceException {
        String tk = token != null && !token.equals("") ? token : EARLIEST_SYNC_TOKEN;
        result.setToken(tk);
        if (pageSize > 0) {
            pageSize = LdapUtil.adjustPageSize(maxResults, pageSize);
        }
        if (ZimbraLog.gal.isDebugEnabled()) {
            String[] attrs;
            StringBuffer returnAttrs = new StringBuffer();
            for (String a : attrs = rules.getLdapAttrs()) {
                returnAttrs.append(a + ",");
            }
            String url = null;
            String binddn = null;
            try {
                Hashtable<?, ?> ctxtEnv = zlc.getLdapContext().getEnvironment();
                zlc.getLdapContext();
                Object urlObj = ctxtEnv.get("java.naming.provider.url");
                if (urlObj != null) {
                    url = urlObj.toString();
                }
                zlc.getLdapContext();
                Object binddnObj = ctxtEnv.get("java.naming.security.principal");
                if (binddnObj != null) {
                    binddn = binddnObj.toString();
                }
            }
            catch (NamingException e) {
                ZimbraLog.gal.debug("cannot get DirContext environment for debug");
            }
            ZimbraLog.gal.debug("searchGal: url=" + url + ", binddn=" + binddn + ", page size=" + pageSize + ", max results=" + maxResults + ", base=" + base + ", query=" + query + ", attrs=" + returnAttrs);
        }
        SearchControls sc = new SearchControls(2, maxResults, 0, rules.getLdapAttrs(), false, false);
        NamingEnumeration<SearchResult> ne = null;
        int total = 0;
        byte[] cookie = null;
        try {
            try {
                try {}
                catch (Throwable throwable) {
                    Object var19_26 = null;
                    if (ne == null) throw throwable;
                    ne.close();
                    throw throwable;
                }
            }
            catch (SizeLimitExceededException sle) {
                result.setHadMore(true);
                Object var21_29 = null;
                boolean gotNewToken = true;
                String newToken = result.getToken();
                if (newToken == null || token != null && token.equals(newToken) || newToken.equals(EARLIEST_SYNC_TOKEN)) {
                    gotNewToken = false;
                }
                if (!gotNewToken) return;
                Date parsedToken = DateUtil.parseGeneralizedTime(newToken, false);
                if (parsedToken == null) return;
                long ts = parsedToken.getTime();
                result.setToken(DateUtil.toGeneralizedTime(new Date(ts += 1000L)));
                return;
            }
            catch (NamingException e) {
                throw ServiceException.FAILURE("unable to search gal", e);
            }
            catch (IOException e) {
                throw ServiceException.FAILURE("unable to search gal", e);
            }
        }
        catch (Throwable throwable) {
            Object var21_30 = null;
            boolean gotNewToken = true;
            String newToken = result.getToken();
            if (newToken == null || token != null && token.equals(newToken) || newToken.equals(EARLIEST_SYNC_TOKEN)) {
                gotNewToken = false;
            }
            if (!gotNewToken) throw throwable;
            Date parsedToken = DateUtil.parseGeneralizedTime(newToken, false);
            if (parsedToken == null) throw throwable;
            long ts = parsedToken.getTime();
            result.setToken(DateUtil.toGeneralizedTime(new Date(ts += 1000L)));
            throw throwable;
        }
        do {
            if (pageSize > 0) {
                zlc.setPagedControl(pageSize, cookie, false);
            }
            ne = zlc.searchDir(base, query, sc);
            while (ne != null && ne.hasMore()) {
                if (maxResults > 0 && total++ > maxResults) {
                    result.setHadMore(true);
                    break;
                }
                SearchResult sr = ne.next();
                String dn = sr.getNameInNamespace();
                GalContact lgc = new GalContact(dn, rules.apply(sr.getAttributes()));
                String mts = (String)lgc.getAttrs().get("modifyTimeStamp");
                result.setToken(LdapUtil.getLaterTimestamp(result.getToken(), mts));
                String cts = (String)lgc.getAttrs().get("createTimeStamp");
                result.setToken(LdapUtil.getLaterTimestamp(result.getToken(), cts));
                result.addMatch(lgc);
                ZimbraLog.gal.debug("dn=" + dn + ", mts=" + mts + ", cts=" + cts);
            }
            if (pageSize <= 0) continue;
            cookie = zlc.getCookie();
        } while (cookie != null);
        Object var19_25 = null;
        if (ne != null) {
            ne.close();
        }
        Object var21_28 = null;
        boolean gotNewToken = true;
        String newToken = result.getToken();
        if (newToken == null || token != null && token.equals(newToken) || newToken.equals(EARLIEST_SYNC_TOKEN)) {
            gotNewToken = false;
        }
        if (!gotNewToken) return;
        Date parsedToken = DateUtil.parseGeneralizedTime(newToken, false);
        if (parsedToken == null) return;
        long ts = parsedToken.getTime();
        result.setToken(DateUtil.toGeneralizedTime(new Date(ts += 1000L)));
    }

    public static Provisioning.SearchGalResult searchLdapGal(GalParams.ExternalGalParams galParams, GalOp galOp, String n, int maxResults, LdapGalMapRules rules, String token, GalContact.Visitor visitor) throws ServiceException, NamingException, IOException {
        String queryExpr;
        String[] url = galParams.url();
        String base = galParams.searchBase();
        String filter = galParams.filter();
        Provisioning.SearchGalResult result = Provisioning.SearchGalResult.newSearchGalResult(visitor);
        String tokenize = GalUtil.tokenizeKey(galParams, galOp);
        result.setTokenizeKey(tokenize);
        if (url == null || url.length == 0 || base == null || filter == null) {
            if (url == null || url.length == 0) {
                ZimbraLog.gal.warn("searchLdapGal url is null");
            }
            if (base == null) {
                ZimbraLog.gal.warn("searchLdapGal base is null");
            }
            if (filter == null) {
                ZimbraLog.gal.warn("searchLdapGal queryExpr is null");
            }
            return result;
        }
        if (filter.indexOf("(") == -1 && (queryExpr = LdapProvisioning.getFilterDef(filter)) != null) {
            filter = queryExpr;
        }
        String query = GalUtil.expandFilter(tokenize, filter, n, token, false);
        String authMech = galParams.credential().getAuthMech();
        if (authMech.equals("kerberos5")) {
            LdapUtil.searchLdapGalKrb5(galParams, query, maxResults, rules, token, result);
        } else {
            LdapUtil.searchLdapGal(galParams, query, maxResults, rules, token, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void searchLdapGal(GalParams.ExternalGalParams galParams, String query, int maxResults, LdapGalMapRules rules, String token, Provisioning.SearchGalResult result) throws ServiceException, NamingException, IOException {
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext(galParams.url(), galParams.requireStartTLS(), galParams.credential(), "external GAL");
            LdapUtil.searchGal(zlc, galParams.pageSize(), galParams.searchBase(), query, maxResults, rules, token, result);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            ZimbraLdapContext.closeContext(zlc);
            throw throwable;
        }
        ZimbraLdapContext.closeContext(zlc);
    }

    private static void searchLdapGalKrb5(GalParams.ExternalGalParams galParams, String query, int maxResults, LdapGalMapRules rules, String token, Provisioning.SearchGalResult result) throws NamingException, ServiceException {
        try {
            LdapGalCredential credential = galParams.credential();
            Krb5Login.performAs(credential.getKrb5Principal(), credential.getKrb5Keytab(), new SearchGalAction(galParams, query, maxResults, rules, token, result));
        }
        catch (LoginException le) {
            throw ServiceException.FAILURE("login failed, unable to search GAL", le);
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof NamingException) {
                throw (NamingException)e;
            }
            throw ServiceException.FAILURE("caught exception, unable to search GAL", e);
        }
    }

    public static void galSearch(GalSearchParams params) throws ServiceException, NamingException, IOException {
        String authMech = params.getConfig().getAuthMech();
        if (authMech.equals("kerberos5")) {
            LdapUtil.galSearchKrb5(params);
        } else {
            LdapUtil.doGalSearch(params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doGalSearch(GalSearchParams params) throws ServiceException, NamingException, IOException {
        ZimbraLdapContext zlc = null;
        try {
            GalSearchConfig cfg = params.getConfig();
            GalSearchConfig.GalType galType = params.getConfig().getGalType();
            zlc = galType == GalSearchConfig.GalType.zimbra ? new ZimbraLdapContext(false) : new ZimbraLdapContext(cfg.getUrl(), cfg.getStartTlsEnabled(), cfg.getAuthMech(), cfg.getBindDn(), cfg.getBindPassword(), "external GAL");
            LdapUtil.searchGal(zlc, cfg.getPageSize(), cfg.getSearchBase(), params.generateLdapQuery(), params.getLimit(), cfg.getRules(), params.getSyncToken(), params.getResult());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ZimbraLdapContext.closeContext(zlc);
            throw throwable;
        }
        ZimbraLdapContext.closeContext(zlc);
    }

    private static void galSearchKrb5(GalSearchParams params) throws NamingException, ServiceException {
        try {
            String krb5Principal = params.getConfig().getKerberosPrincipal();
            String krb5Keytab = params.getConfig().getKerberosKeytab();
            Krb5Login.performAs(krb5Principal, krb5Keytab, new GalSearchAction(params));
        }
        catch (LoginException le) {
            throw ServiceException.FAILURE("login failed, unable to search GAL", le);
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof NamingException) {
                throw (NamingException)e;
            }
            throw ServiceException.FAILURE("caught exception, unable to search GAL", e);
        }
    }

    public static String getLaterTimestamp(String timeA, String timeB) {
        if (timeA == null) {
            return timeB;
        }
        if (timeB == null) {
            return timeA;
        }
        return timeA.compareTo(timeB) > 0 ? timeA : timeB;
    }

    public static String getEarlierTimestamp(String timeA, String timeB) {
        if (timeA == null) {
            return timeB;
        }
        if (timeB == null) {
            return timeA;
        }
        return timeA.compareTo(timeB) < 0 ? timeA : timeB;
    }

    public static void main(String[] args) throws NamingException, ServiceException {
    }

    public static String escapeRDNValue(String rdn) {
        return Rdn.escapeValue(rdn);
    }

    public static String unescapeRDNValue(String rdn) {
        return (String)Rdn.unescapeValue(rdn);
    }

    public static String formatMultipleMatchedEntries(SearchResult first, NamingEnumeration rest) throws NamingException {
        StringBuffer dups = new StringBuffer();
        dups.append("[" + first.getNameInNamespace() + "] ");
        while (rest.hasMore()) {
            SearchResult dup = (SearchResult)rest.next();
            dups.append("[" + dup.getNameInNamespace() + "] ");
        }
        return new String(dups);
    }

    public static int adjustPageSize(int maxResults, int pageSize) {
        if (pageSize < 2) {
            return pageSize;
        }
        if (maxResults >= pageSize && maxResults % pageSize == 0) {
            return pageSize - 1;
        }
        return pageSize;
    }

    public static String getZimbraSearchBase(Domain domain, GalOp galOp) {
        String sb;
        if (galOp == GalOp.sync) {
            sb = domain.getAttr("zimbraGalSyncInternalSearchBase");
            if (sb == null) {
                sb = domain.getAttr("zimbraGalInternalSearchBase", "DOMAIN");
            }
        } else {
            sb = domain.getAttr("zimbraGalInternalSearchBase", "DOMAIN");
        }
        LdapDomain ld = (LdapDomain)domain;
        if (sb.equalsIgnoreCase("DOMAIN")) {
            return ld.getDN();
        }
        if (sb.equalsIgnoreCase("SUBDOMAINS")) {
            return ld.getDN();
        }
        if (sb.equalsIgnoreCase("ROOT")) {
            return "";
        }
        return "";
    }

    static class GalSearchAction
    implements PrivilegedExceptionAction {
        GalSearchParams mParams;

        GalSearchAction(GalSearchParams params) {
            this.mParams = params;
        }

        public Object run() throws ServiceException, NamingException, IOException {
            LdapUtil.doGalSearch(this.mParams);
            return null;
        }
    }

    static class SearchGalAction
    implements PrivilegedExceptionAction {
        GalParams.ExternalGalParams galParams;
        String query;
        int maxResults;
        LdapGalMapRules rules;
        String token;
        Provisioning.SearchGalResult result;

        SearchGalAction(GalParams.ExternalGalParams arg_galParams, String arg_query, int arg_maxResults, LdapGalMapRules arg_rules, String arg_token, Provisioning.SearchGalResult arg_result) {
            this.galParams = arg_galParams;
            this.query = arg_query;
            this.maxResults = arg_maxResults;
            this.rules = arg_rules;
            this.token = arg_token;
            this.result = arg_result;
        }

        public Object run() throws ServiceException, NamingException, IOException {
            LdapUtil.searchLdapGal(this.galParams, this.query, this.maxResults, this.rules, this.token, this.result);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SearchLdapVisitor {
        public void visit(String var1, Map<String, Object> var2, Attributes var3);
    }
}

