/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.ldap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AttributeClass;
import com.zimbra.cs.account.AttributeManager;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Signature;
import com.zimbra.cs.account.ldap.LdapEntry;
import com.zimbra.cs.account.ldap.LdapProvisioning;
import com.zimbra.cs.account.ldap.LdapUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LdapSignature
extends Signature
implements LdapEntry {
    private String mDn;

    LdapSignature(Account acct, String dn, Attributes attrs, Provisioning prov) throws NamingException {
        super(acct, LdapUtil.getAttrString(attrs, "zimbraSignatureName"), LdapUtil.getAttrString(attrs, "zimbraSignatureId"), LdapUtil.getAttrs(attrs), prov);
        this.mDn = dn;
    }

    @Override
    public String getDN() {
        return this.mDn;
    }

    public static boolean hasAccountSignature(Account acct) {
        return acct.getAttr("zimbraPrefMailSignature") != null || acct.getAttr("zimbraSignatureName") != null || acct.getAttr("zimbraSignatureId") != null;
    }

    public static Signature getAccountSignature(LdapProvisioning prov, Account acct) throws ServiceException {
        String sigId;
        if (!LdapSignature.hasAccountSignature(acct)) {
            return null;
        }
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        Set<String> signatureAttrs = AttributeManager.getInstance().getAttrsInClass(AttributeClass.signature);
        for (String name : signatureAttrs) {
            String value = acct.getAttr(name, null);
            if (value == null) continue;
            attrs.put(name, value);
        }
        HashMap<String, String> putbackAttrs = new HashMap<String, String>();
        String sigName = acct.getAttr("zimbraSignatureName");
        if (sigName == null) {
            sigName = acct.getName();
            putbackAttrs.put("zimbraSignatureName", sigName);
        }
        if ((sigId = acct.getAttr("zimbraSignatureId")) == null) {
            sigId = LdapUtil.generateUUID();
            putbackAttrs.put("zimbraSignatureId", sigId);
        }
        if (putbackAttrs.size() > 0) {
            prov.modifyAttrs(acct, putbackAttrs);
        }
        return new Signature(acct, sigName, sigId, attrs, (Provisioning)prov);
    }

    public static boolean isAccountSignature(Account acct, String signatureId) {
        String acctSigId = acct.getAttr("zimbraSignatureId");
        return signatureId.equals(acctSigId);
    }

    public static void modifyAccountSignature(LdapProvisioning prov, Account acct, Map<String, Object> signatureAttrs) throws ServiceException {
        prov.modifyAttrs(acct, signatureAttrs);
    }

    public static void createAccountSignature(LdapProvisioning prov, Account acct, Map<String, Object> signatureAttrs, boolean setAsDefault) throws ServiceException {
        if (setAsDefault) {
            String signatureId = (String)signatureAttrs.get("zimbraSignatureId");
            signatureAttrs.put("zimbraPrefDefaultSignatureId", signatureId);
        }
        prov.modifyAttrs(acct, signatureAttrs);
    }

    public static void deleteAccountSignature(LdapProvisioning prov, Account acct) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        Set<String> signatureAttrs = AttributeManager.getInstance().getAttrsInClass(AttributeClass.signature);
        for (String name : signatureAttrs) {
            String value = acct.getAttr(name, null);
            if (value == null) continue;
            attrs.put("-" + name, value);
        }
        prov.modifyAttrs(acct, attrs);
    }
}

