/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.ldap;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.DateUtil;
import com.zimbra.common.util.EmailUtil;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AccessManager;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountCache;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Alias;
import com.zimbra.cs.account.AttributeClass;
import com.zimbra.cs.account.AttributeManager;
import com.zimbra.cs.account.CalendarResource;
import com.zimbra.cs.account.Config;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.DomainCache;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.EntrySearchFilter;
import com.zimbra.cs.account.GalContact;
import com.zimbra.cs.account.GlobalGrant;
import com.zimbra.cs.account.IDNUtil;
import com.zimbra.cs.account.Identity;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.NamedEntryCache;
import com.zimbra.cs.account.PreAuthKey;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.Signature;
import com.zimbra.cs.account.XMPPComponent;
import com.zimbra.cs.account.ZAttrProvisioning;
import com.zimbra.cs.account.Zimlet;
import com.zimbra.cs.account.accesscontrol.GranteeType;
import com.zimbra.cs.account.accesscontrol.Right;
import com.zimbra.cs.account.accesscontrol.RightCommand;
import com.zimbra.cs.account.accesscontrol.RightModifier;
import com.zimbra.cs.account.auth.AuthContext;
import com.zimbra.cs.account.auth.AuthMechanism;
import com.zimbra.cs.account.auth.PasswordUtil;
import com.zimbra.cs.account.gal.GalNamedFilter;
import com.zimbra.cs.account.gal.GalOp;
import com.zimbra.cs.account.gal.GalParams;
import com.zimbra.cs.account.gal.GalUtil;
import com.zimbra.cs.account.krb5.Krb5Principal;
import com.zimbra.cs.account.ldap.ChangePasswordListener;
import com.zimbra.cs.account.ldap.LdapAccount;
import com.zimbra.cs.account.ldap.LdapAlias;
import com.zimbra.cs.account.ldap.LdapCalendarResource;
import com.zimbra.cs.account.ldap.LdapConfig;
import com.zimbra.cs.account.ldap.LdapCos;
import com.zimbra.cs.account.ldap.LdapDIT;
import com.zimbra.cs.account.ldap.LdapDataSource;
import com.zimbra.cs.account.ldap.LdapDistributionList;
import com.zimbra.cs.account.ldap.LdapDomain;
import com.zimbra.cs.account.ldap.LdapEntry;
import com.zimbra.cs.account.ldap.LdapEntrySearchFilter;
import com.zimbra.cs.account.ldap.LdapFilter;
import com.zimbra.cs.account.ldap.LdapGalMapRules;
import com.zimbra.cs.account.ldap.LdapGlobalGrant;
import com.zimbra.cs.account.ldap.LdapIdentity;
import com.zimbra.cs.account.ldap.LdapLockoutPolicy;
import com.zimbra.cs.account.ldap.LdapMimeType;
import com.zimbra.cs.account.ldap.LdapObjectClass;
import com.zimbra.cs.account.ldap.LdapServer;
import com.zimbra.cs.account.ldap.LdapSignature;
import com.zimbra.cs.account.ldap.LdapUtil;
import com.zimbra.cs.account.ldap.LdapXMPPComponent;
import com.zimbra.cs.account.ldap.LdapZimlet;
import com.zimbra.cs.account.ldap.RenameDomain;
import com.zimbra.cs.account.ldap.SpecialAttrs;
import com.zimbra.cs.account.ldap.Validators;
import com.zimbra.cs.account.ldap.ZimbraLdapContext;
import com.zimbra.cs.account.names.NameUtil;
import com.zimbra.cs.httpclient.URLUtil;
import com.zimbra.cs.mime.MimeTypeInfo;
import com.zimbra.cs.util.Zimbra;
import com.zimbra.cs.zimlet.ZimletException;
import com.zimbra.cs.zimlet.ZimletUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.naming.AuthenticationException;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.SizeLimitExceededException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InvalidAttributeIdentifierException;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.InvalidAttributesException;
import javax.naming.directory.SchemaViolationException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapProvisioning
extends Provisioning {
    public static final String C_zimbraAccount = "zimbraAccount";
    public static final String C_zimbraCOS = "zimbraCOS";
    public static final String C_zimbraDomain = "zimbraDomain";
    public static final String C_zimbraMailList = "zimbraDistributionList";
    public static final String C_zimbraMailRecipient = "zimbraMailRecipient";
    public static final String C_zimbraServer = "zimbraServer";
    public static final String C_zimbraCalendarResource = "zimbraCalendarResource";
    public static final String C_zimbraAlias = "zimbraAlias";
    public static final String C_zimbraMimeEntry = "zimbraMimeEntry";
    private static final long ONE_DAY_IN_MILLIS = 86400000L;
    private static final SearchControls sObjectSC = new SearchControls(0, 0L, 0, null, false, false);
    static final SearchControls sSubtreeSC = new SearchControls(2, 0L, 0, null, false, false);
    private static final Log mLog = LogFactory.getLog(LdapProvisioning.class);
    private static LdapConfig sConfig = null;
    private static GlobalGrant sGlobalGrant = null;
    private static final String[] sInvalidAccountCreateModifyAttrs = new String[]{"zimbraMailAlias", "zimbraMailDeliveryAddress", "uid"};
    private static final String[] sMinimalDlAttrs = new String[]{"zimbraMailAlias", "zimbraId", "uid", "zimbraACE", "zimbraIsAdminGroup", "zimbraAdminConsoleUIComponents"};
    private static AccountCache sAccountCache = new AccountCache(LC.ldap_cache_account_maxsize.intValue(), (long)LC.ldap_cache_account_maxage.intValue() * 60000L);
    private static NamedEntryCache<LdapCos> sCosCache = new NamedEntryCache(LC.ldap_cache_cos_maxsize.intValue(), (long)LC.ldap_cache_cos_maxage.intValue() * 60000L);
    private static DomainCache sDomainCache = new DomainCache(LC.ldap_cache_domain_maxsize.intValue(), (long)LC.ldap_cache_domain_maxage.intValue() * 60000L, LC.ldap_cache_external_domain_maxsize.intValue(), (long)LC.ldap_cache_external_domain_maxage.intValue() * 60000L);
    private static NamedEntryCache<Server> sServerCache = new NamedEntryCache(LC.ldap_cache_server_maxsize.intValue(), (long)LC.ldap_cache_server_maxage.intValue() * 60000L);
    private static NamedEntryCache<LdapZimlet> sZimletCache = new NamedEntryCache(LC.ldap_cache_zimlet_maxsize.intValue(), (long)LC.ldap_cache_zimlet_maxage.intValue() * 60000L);
    private static NamedEntryCache<DistributionList> sGroupCache = new NamedEntryCache(LC.ldap_cache_group_maxsize.intValue(), (long)LC.ldap_cache_group_maxage.intValue() * 60000L);
    private static NamedEntryCache<XMPPComponent> sXMPPComponentCache = new NamedEntryCache(LC.ldap_cache_xmppcomponent_maxsize.intValue(), (long)LC.ldap_cache_xmppcomponent_maxage.intValue() * 60000L);
    private static final int BY_ID = 1;
    private static final int BY_EMAIL = 2;
    private static final int BY_NAME = 3;
    protected LdapDIT mDIT;
    private static final Random sPoolRandom = new Random();
    private static Pattern sNamePattern = Pattern.compile("([/+])");
    private static List<ProvisioningValidator> sValidators = new ArrayList<ProvisioningValidator>();
    static final String DATA_ACLGROUP_LIST = "AG_LIST";
    static final String DATA_ACLGROUP_LIST_ADMINS_ONLY = "AG_LIST_ADMINS_ONLY";
    public static final long TIMESTAMP_WINDOW = 300000L;
    static final String DATA_DL_SET = "DL_SET";
    private static final int DEFAULT_GAL_MAX_RESULTS = 100;
    private static final String DATA_GAL_ATTR_MAP = "GAL_ATTRS_MAP";
    private static final String DATA_GAL_ATTR_LIST = "GAL_ATTR_LIST";
    private static final String DATA_GAL_RULES = "GAL_RULES";
    private static final String IDENTITY_LIST_CACHE_KEY = "LdapProvisioning.IDENTITY_CACHE";
    private static final String SIGNATURE_LIST_CACHE_KEY = "LdapProvisioning.SIGNATURE_CACHE";
    private static final String DATA_SOURCE_LIST_CACHE_KEY = "LdapProvisioning.DATA_SOURCE_CACHE";

    public int getAccountCacheSize() {
        return sAccountCache.getSize();
    }

    public double getAccountCacheHitRate() {
        return sAccountCache.getHitRate();
    }

    public int getCosCacheSize() {
        return sCosCache.getSize();
    }

    public double getCosCacheHitRate() {
        return sCosCache.getHitRate();
    }

    public int getDomainCacheSize() {
        return sDomainCache.getSize();
    }

    public double getDomainCacheHitRate() {
        return sDomainCache.getHitRate();
    }

    public int getServerCacheSize() {
        return sServerCache.getSize();
    }

    public double getServerCacheHitRate() {
        return sServerCache.getHitRate();
    }

    public int getZimletCacheSize() {
        return sZimletCache.getSize();
    }

    public double getZimletCacheHitRate() {
        return sZimletCache.getHitRate();
    }

    public int getGroupCacheSize() {
        return sGroupCache.getSize();
    }

    public double getGroupCacheHitRate() {
        return sGroupCache.getHitRate();
    }

    public int getXMPPCacheSize() {
        return sXMPPComponentCache.getSize();
    }

    public double getXMPPCacheHitRate() {
        return sXMPPComponentCache.getHitRate();
    }

    public LdapProvisioning() {
        this.setDIT();
    }

    protected void setDIT() {
        this.mDIT = new LdapDIT(this);
    }

    public LdapDIT getDIT() {
        return this.mDIT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(ProvisioningValidator validator) {
        List<ProvisioningValidator> list = sValidators;
        synchronized (list) {
            sValidators.add(validator);
        }
    }

    private void validate(String action, Object ... args) throws ServiceException {
        for (ProvisioningValidator v : sValidators) {
            v.validate(this, action, args);
        }
    }

    public static void refreshValidators() {
        for (ProvisioningValidator v : sValidators) {
            v.refresh();
        }
    }

    @Override
    public void modifyAttrs(Entry e, Map<String, ? extends Object> attrs, boolean checkImmutable) throws ServiceException {
        this.modifyAttrs(e, attrs, checkImmutable, true);
    }

    @Override
    public void modifyAttrs(Entry e, Map<String, ? extends Object> attrs, boolean checkImmutable, boolean allowCallback) throws ServiceException {
        HashMap context = new HashMap();
        AttributeManager.getInstance().preModify(attrs, e, context, false, checkImmutable, allowCallback);
        this.modifyAttrsInternal(e, null, attrs);
        AttributeManager.getInstance().postModify(attrs, e, context, false, allowCallback);
    }

    protected void modifyAttrsInternal(Entry entry, ZimbraLdapContext initZlc, Map attrs) throws ServiceException {
        ZimbraLdapContext zlc = initZlc;
        try {
            if (entry instanceof Account && !(entry instanceof CalendarResource)) {
                Account acct = (Account)entry;
                this.validate("modifyAccountCheckDomainCosAndFeature", acct.getAttr("zimbraMailDeliveryAddress"), attrs, acct);
            }
            if (zlc == null) {
                zlc = new ZimbraLdapContext(true);
            }
            LdapUtil.modifyAttrs(zlc, ((LdapEntry)((Object)entry)).getDN(), attrs, entry);
            this.refreshEntry(entry, zlc, this);
        }
        catch (InvalidAttributeIdentifierException e) {
            throw AccountServiceException.INVALID_ATTR_NAME("invalid attr name: " + e.getMessage(), e);
        }
        catch (InvalidAttributeValueException e) {
            throw AccountServiceException.INVALID_ATTR_VALUE("invalid attr value: " + e.getMessage(), e);
        }
        catch (InvalidAttributesException e) {
            throw ServiceException.INVALID_REQUEST("invalid set of attributes: " + e.getMessage(), e);
        }
        catch (SchemaViolationException e) {
            throw ServiceException.INVALID_REQUEST("LDAP schema violation: " + e.getMessage(), e);
        }
        catch (NamingException e) {
            throw ServiceException.FAILURE("unable to modify attrs: " + e.getMessage(), e);
        }
        finally {
            if (initZlc == null) {
                ZimbraLdapContext.closeContext(zlc);
            }
        }
    }

    @Override
    public void reload(Entry e) throws ServiceException {
        this.refreshEntry(e, null, this);
    }

    void refreshEntry(Entry entry, ZimbraLdapContext initZlc, LdapProvisioning prov) throws ServiceException {
        ZimbraLdapContext zlc = initZlc;
        try {
            if (zlc == null) {
                zlc = new ZimbraLdapContext();
            }
            String dn = ((LdapEntry)((Object)entry)).getDN();
            Attributes attributes = zlc.getAttributes(dn);
            Map<String, Object> attrs = LdapUtil.getAttrs(attributes);
            Map<String, Object> defaults = null;
            Map<String, Object> secondaryDefaults = null;
            if (entry instanceof Account) {
                Domain domain;
                Account temp = this.makeAccountNoDefaults(dn, attributes, prov);
                Cos cos = prov.getCOS(temp);
                if (cos != null) {
                    defaults = cos.getAccountDefaults();
                }
                if ((domain = prov.getDomain((Account)entry)) != null) {
                    secondaryDefaults = domain.getAccountDefaults();
                }
            } else if (entry instanceof Domain) {
                defaults = prov.getConfig().getDomainDefaults();
            } else if (entry instanceof Server) {
                defaults = prov.getConfig().getServerDefaults();
            }
            if (defaults == null && secondaryDefaults == null) {
                entry.setAttrs(attrs);
            } else {
                entry.setAttrs(attrs, defaults, secondaryDefaults);
            }
        }
        catch (NamingException e) {
            throw ServiceException.FAILURE("unable to refresh entry", e);
        }
        finally {
            if (initZlc == null) {
                ZimbraLdapContext.closeContext(zlc);
            }
        }
    }

    void refreshEntry_old(Entry entry, ZimbraLdapContext initZlc, LdapProvisioning prov) throws ServiceException {
        ZimbraLdapContext zlc = initZlc;
        try {
            Map<String, Object> defaults = null;
            Map<String, Object> secondaryDefaults = null;
            if (entry instanceof Account) {
                Domain domain;
                Cos cos = prov.getCOS((Account)entry);
                if (cos != null) {
                    defaults = cos.getAccountDefaults();
                }
                if ((domain = prov.getDomain((Account)entry)) != null) {
                    secondaryDefaults = domain.getAccountDefaults();
                }
            } else if (entry instanceof Domain) {
                defaults = prov.getConfig().getDomainDefaults();
            } else if (entry instanceof Server) {
                defaults = prov.getConfig().getServerDefaults();
            }
            if (zlc == null) {
                zlc = new ZimbraLdapContext();
            }
            String dn = ((LdapEntry)((Object)entry)).getDN();
            if (defaults == null && secondaryDefaults == null) {
                entry.setAttrs(LdapUtil.getAttrs(zlc.getAttributes(dn)));
            } else {
                entry.setAttrs(LdapUtil.getAttrs(zlc.getAttributes(dn)), defaults, secondaryDefaults);
            }
        }
        catch (NamingException e) {
            throw ServiceException.FAILURE("unable to refresh entry", e);
        }
        finally {
            if (initZlc == null) {
                ZimbraLdapContext.closeContext(zlc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean healthCheck() throws ServiceException {
        boolean result = false;
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext();
            Attributes attrs = zlc.getAttributes(this.mDIT.configDN());
            result = attrs != null;
        }
        catch (NamingException e) {
            mLog.warn((Object)"LDAP health check error", e);
        }
        catch (ServiceException e) {
            mLog.warn((Object)"LDAP health check error", e);
        }
        finally {
            ZimbraLdapContext.closeContext(zlc);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Config getConfig() throws ServiceException {
        if (sConfig != null) return sConfig;
        Class<LdapProvisioning> clazz = LdapProvisioning.class;
        synchronized (LdapProvisioning.class) {
            if (sConfig != null) return sConfig;
            ZimbraLdapContext zlc = null;
            try {
                String configDn = this.mDIT.configDN();
                zlc = new ZimbraLdapContext();
                Attributes attrs = zlc.getAttributes(configDn);
                sConfig = new LdapConfig(configDn, attrs, (Provisioning)this);
            }
            catch (NamingException e) {
                try {
                    throw ServiceException.FAILURE("unable to get config", e);
                }
                catch (Throwable throwable) {
                    ZimbraLdapContext.closeContext(zlc);
                    throw throwable;
                }
            }
            ZimbraLdapContext.closeContext(zlc);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sConfig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public GlobalGrant getGlobalGrant() throws ServiceException {
        if (sGlobalGrant != null) return sGlobalGrant;
        Class<LdapProvisioning> clazz = LdapProvisioning.class;
        synchronized (LdapProvisioning.class) {
            if (sGlobalGrant != null) return sGlobalGrant;
            ZimbraLdapContext zlc = null;
            try {
                String globalGrantDn = this.mDIT.globalGrantDN();
                zlc = new ZimbraLdapContext();
                Attributes attrs = zlc.getAttributes(globalGrantDn);
                sGlobalGrant = new LdapGlobalGrant(globalGrantDn, attrs, (Provisioning)this);
            }
            catch (NamingException e) {
                try {
                    throw ServiceException.FAILURE("unable to get globalgrant", e);
                }
                catch (Throwable throwable) {
                    ZimbraLdapContext.closeContext(zlc);
                    throw throwable;
                }
            }
            ZimbraLdapContext.closeContext(zlc);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sGlobalGrant;
        }
    }

    @Override
    public List<MimeTypeInfo> getMimeTypes(String mimeType) throws ServiceException {
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext();
            mimeType = LdapUtil.escapeSearchFilterArg(mimeType);
            NamingEnumeration<SearchResult> ne = zlc.searchDir(this.mDIT.mimeBaseDN(), LdapFilter.mimeEntryByMimeType(mimeType), sSubtreeSC);
            ArrayList<MimeTypeInfo> mimeTypes = new ArrayList<MimeTypeInfo>();
            while (ne.hasMore()) {
                SearchResult sr = ne.next();
                mimeTypes.add(new LdapMimeType(sr.getNameInNamespace(), sr.getAttributes(), (Provisioning)this));
            }
            ne.close();
            ArrayList<MimeTypeInfo> arrayList = mimeTypes;
            return arrayList;
        }
        catch (NameNotFoundException e) {
            List<MimeTypeInfo> list = Collections.emptyList();
            return list;
        }
        catch (InvalidNameException e) {
            List<MimeTypeInfo> list = Collections.emptyList();
            return list;
        }
        catch (NamingException e) {
            throw ServiceException.FAILURE("unable to get mime types for " + mimeType, e);
        }
        finally {
            ZimbraLdapContext.closeContext(zlc);
        }
    }

    @Override
    public List<MimeTypeInfo> getAllMimeTypes() throws ServiceException {
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext();
            ArrayList<MimeTypeInfo> mimeTypes = new ArrayList<MimeTypeInfo>();
            NamingEnumeration<SearchResult> ne = zlc.searchDir(this.mDIT.mimeBaseDN(), LdapFilter.allMimeEntries(), sSubtreeSC);
            while (ne.hasMore()) {
                SearchResult sr = ne.next();
                mimeTypes.add(new LdapMimeType(sr.getNameInNamespace(), sr.getAttributes(), (Provisioning)this));
            }
            ne.close();
            ArrayList<MimeTypeInfo> arrayList = mimeTypes;
            return arrayList;
        }
        catch (NameNotFoundException e) {
            List<MimeTypeInfo> list = Collections.emptyList();
            return list;
        }
        catch (InvalidNameException e) {
            List<MimeTypeInfo> list = Collections.emptyList();
            return list;
        }
        catch (NamingException e) {
            throw ServiceException.FAILURE("unable to get mime types", e);
        }
        finally {
            ZimbraLdapContext.closeContext(zlc);
        }
    }

    @Override
    public List<Zimlet> getObjectTypes() throws ServiceException {
        return this.listAllZimlets();
    }

    private Account getAccountByQuery(String base, String query, ZimbraLdapContext initZlc, boolean loadFromMaster) throws ServiceException {
        ZimbraLdapContext zlc = initZlc;
        try {
            NamingEnumeration<SearchResult> ne;
            if (zlc == null) {
                zlc = new ZimbraLdapContext(loadFromMaster);
            }
            if ((ne = zlc.searchDir(base, query, sSubtreeSC)).hasMore()) {
                SearchResult sr = ne.next();
                if (ne.hasMore()) {
                    String dups = LdapUtil.formatMultipleMatchedEntries(sr, ne);
                    throw AccountServiceException.MULTIPLE_ACCOUNTS_MATCHED("getAccountByQuery: " + query + " returned multiple entries at " + dups);
                }
                ne.close();
                Account account = this.makeAccount(sr.getNameInNamespace(), sr.getAttributes(), this);
                return account;
            }
        }
        catch (NameNotFoundException e) {
            Account account = null;
            return account;
        }
        catch (InvalidNameException e) {
            Account account = null;
            return account;
        }
        catch (NamingException e) {
            throw ServiceException.FAILURE("unable to lookup account via query: " + query + " message: " + e.getMessage(), e);
        }
        finally {
            if (initZlc == null) {
                ZimbraLdapContext.closeContext(zlc);
            }
        }
        return null;
    }

    private Account getAccountById(String zimbraId, ZimbraLdapContext zlc, boolean loadFromMaster) throws ServiceException {
        if (zimbraId == null) {
            return null;
        }
        Account a = sAccountCache.getById(zimbraId);
        if (a == null) {
            zimbraId = LdapUtil.escapeSearchFilterArg(zimbraId);
            String query = LdapFilter.accountById(zimbraId);
            a = this.getAccountByQuery(this.mDIT.mailBranchBaseDN(), query, zlc, loadFromMaster);
            if (a == null && !this.mDIT.isUnder(this.mDIT.mailBranchBaseDN(), this.mDIT.adminBaseDN())) {
                a = this.getAccountByQuery(this.mDIT.adminBaseDN(), query, zlc, loadFromMaster);
            }
            sAccountCache.put(a);
        }
        return a;
    }

    @Override
    public Account get(Provisioning.AccountBy keyType, String key) throws ServiceException {
        return this.get(keyType, key, false);
    }

    @Override
    public Account get(Provisioning.AccountBy keyType, String key, boolean loadFromMaster) throws ServiceException {
        switch (keyType) {
            case adminName: {
                return this.getAdminAccountByName(key, loadFromMaster);
            }
            case appAdminName: {
                return this.getAppAdminAccountByName(key, loadFromMaster);
            }
            case id: {
                return this.getAccountById(key, null, loadFromMaster);
            }
            case foreignPrincipal: {
                return this.getAccountByForeignPrincipal(key, loadFromMaster);
            }
            case name: {
                return this.getAccountByName(key, loadFromMaster);
            }
            case krb5Principal: {
                return Krb5Principal.getAccountFromKrb5Principal(key, loadFromMaster);
            }
        }
        return null;
    }

    public Account getFromCache(Provisioning.AccountBy keyType, String key) throws ServiceException {
        switch (keyType) {
            case adminName: {
                return sAccountCache.getByName(key);
            }
            case id: {
                return sAccountCache.getById(key);
            }
            case foreignPrincipal: {
                return sAccountCache.getByForeignPrincipal(key);
            }
            case name: {
                return sAccountCache.getByName(key);
            }
            case krb5Principal: {
                throw ServiceException.FAILURE("key type krb5Principal is not supported by getFromCache", null);
            }
        }
        return null;
    }

    private Account getAccountByForeignPrincipal(String foreignPrincipal, boolean loadFromMaster) throws ServiceException {
        Account a = sAccountCache.getByForeignPrincipal(foreignPrincipal);
        foreignPrincipal = LdapUtil.escapeSearchFilterArg(foreignPrincipal);
        Account acct = this.getAccountByQuery(this.mDIT.mailBranchBaseDN(), LdapFilter.accountByForeignPrincipal(foreignPrincipal), null, loadFromMaster);
        if (a == null) {
            a = acct;
            sAccountCache.put(a);
        }
        return a;
    }

    private Account getAdminAccountByName(String name, boolean loadFromMaster) throws ServiceException {
        Account a = sAccountCache.getByName(name);
        if (a == null) {
            name = LdapUtil.escapeSearchFilterArg(name);
            a = this.getAccountByQuery(this.mDIT.adminBaseDN(), LdapFilter.adminAccountByRDN(this.mDIT.accountNamingRdnAttr(), name), null, loadFromMaster);
            sAccountCache.put(a);
        }
        return a;
    }

    private Account getAppAdminAccountByName(String name, boolean loadFromMaster) throws ServiceException {
        Account a = sAccountCache.getByName(name);
        if (a == null) {
            name = LdapUtil.escapeSearchFilterArg(name);
            a = this.getAccountByQuery(this.mDIT.appAdminBaseDN(), LdapFilter.adminAccountByRDN(this.mDIT.accountNamingRdnAttr(), name), null, loadFromMaster);
            sAccountCache.put(a);
        }
        return a;
    }

    private String fixupAccountName(String emailAddress) throws ServiceException {
        int index = emailAddress.indexOf(64);
        String domain = null;
        if (index == -1) {
            domain = this.getConfig().getAttr("zimbraDefaultDomainName", null);
            if (domain == null) {
                throw ServiceException.INVALID_REQUEST("must be valid email address: " + emailAddress, null);
            }
            emailAddress = emailAddress + "@" + domain;
        } else {
            emailAddress = IDNUtil.toAsciiEmail(emailAddress);
        }
        return emailAddress;
    }

    private Account getAccountByName(String emailAddress, boolean loadFromMaster) throws ServiceException {
        String addrByDomainAlias;
        Account account = this.getAccountByNameInternal(emailAddress, loadFromMaster);
        if (account == null && (addrByDomainAlias = this.getEmailAddrByDomainAlias(emailAddress)) != null) {
            account = this.getAccountByNameInternal(addrByDomainAlias, loadFromMaster);
        }
        return account;
    }

    private Account getAccountByNameInternal(String emailAddress, boolean loadFromMaster) throws ServiceException {
        Account account = sAccountCache.getByName(emailAddress = this.fixupAccountName(emailAddress));
        if (account == null) {
            emailAddress = LdapUtil.escapeSearchFilterArg(emailAddress);
            account = this.getAccountByQuery(this.mDIT.mailBranchBaseDN(), LdapFilter.accountByName(emailAddress), null, loadFromMaster);
            sAccountCache.put(account);
        }
        return account;
    }

    private Cos lookupCos(String key, ZimbraLdapContext zlc) throws ServiceException {
        Cos c = null;
        c = this.getCosById(key, zlc);
        if (c == null) {
            c = this.getCosByName(key, zlc);
        }
        if (c == null) {
            throw AccountServiceException.NO_SUCH_COS(key);
        }
        return c;
    }

    @Override
    public Account createAccount(String emailAddress, String password, Map<String, Object> attrs) throws ServiceException {
        return this.createAccount(emailAddress, password, attrs, this.mDIT.handleSpecialAttrs(attrs), null, false, null);
    }

    @Override
    public Account restoreAccount(String emailAddress, String password, Map<String, Object> attrs, Map<String, Object> origAttrs) throws ServiceException {
        return this.createAccount(emailAddress, password, attrs, this.mDIT.handleSpecialAttrs(attrs), null, true, origAttrs);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Account createAccount(String emailAddress, String password, Map<String, Object> acctAttrs, SpecialAttrs specialAttrs, String[] additionalObjectClasses, boolean restoring, Map<String, Object> origAttrs) throws ServiceException {
        Account account;
        String uuid = specialAttrs.getZimbraId();
        String baseDn = specialAttrs.getLdapBaseDn();
        String[] parts = (emailAddress = emailAddress.toLowerCase().trim()).split("@");
        if (parts.length != 2) {
            throw ServiceException.INVALID_REQUEST("must be valid email address: " + emailAddress, null);
        }
        String localPart = parts[0];
        String domain = parts[1];
        domain = IDNUtil.toAsciiDomainName(domain);
        emailAddress = localPart + "@" + domain;
        LdapProvisioning.validEmailAddress(emailAddress);
        if (restoring) {
            this.validate("createAccount", emailAddress, additionalObjectClasses, origAttrs);
            this.validate("createAccountCheckDomainCosAndFeature", emailAddress, origAttrs);
        } else {
            this.validate("createAccount", emailAddress, additionalObjectClasses, acctAttrs);
            this.validate("createAccountCheckDomainCosAndFeature", emailAddress, acctAttrs);
        }
        HashMap attrManagerContext = new HashMap();
        if (acctAttrs == null) {
            acctAttrs = new HashMap<String, Object>();
        }
        AttributeManager.getInstance().preModify(acctAttrs, null, attrManagerContext, true, true);
        String dn = null;
        ZimbraLdapContext zlc = null;
        try {
            boolean hasMailTransport;
            Set<String> ocs;
            zlc = new ZimbraLdapContext(true);
            Domain d = this.getDomainByAsciiName(domain, zlc);
            if (d == null) {
                throw AccountServiceException.NO_SUCH_DOMAIN(domain);
            }
            String domainType = d.getAttr("zimbraDomainType", "local");
            if (!domainType.equals("local")) {
                throw ServiceException.INVALID_REQUEST("domain type must be local", null);
            }
            BasicAttributes attrs = new BasicAttributes(true);
            LdapUtil.mapToAttrs(acctAttrs, attrs);
            for (int i = 0; i < sInvalidAccountCreateModifyAttrs.length; ++i) {
                String a = sInvalidAccountCreateModifyAttrs[i];
                if (attrs.get(a) == null) continue;
                throw ServiceException.INVALID_REQUEST("invalid attribute for CreateAccount: " + a, null);
            }
            if (additionalObjectClasses == null) {
                ocs = LdapObjectClass.getAccountObjectClasses(this, restoring);
            } else {
                ocs = LdapObjectClass.getAccountObjectClasses(this, true);
                for (int i = 0; i < additionalObjectClasses.length; ++i) {
                    ocs.add(additionalObjectClasses[i]);
                }
            }
            Attribute oc = LdapUtil.addAttr((Attributes)attrs, "objectClass", ocs);
            String zimbraIdStr = uuid == null ? LdapUtil.generateUUID() : uuid;
            attrs.put("zimbraId", zimbraIdStr);
            attrs.put("zimbraCreateTimestamp", DateUtil.toGeneralizedTime(new Date()));
            if (attrs.get("zimbraAccountStatus") == null) {
                attrs.put("zimbraAccountStatus", "active");
            }
            Cos cos = null;
            Attribute cosIdAttr = attrs.get("zimbraCOSId");
            String cosId = null;
            if (cosIdAttr != null) {
                cosId = (String)cosIdAttr.get();
                cos = this.lookupCos(cosId, zlc);
                if (!cos.getId().equals(cosId)) {
                    cosId = cos.getId();
                }
                attrs.put("zimbraCOSId", cosId);
            } else {
                String domainCosId;
                String string = domainCosId = domain != null ? d.getAttr("zimbraDomainDefaultCOSId", null) : null;
                if (domainCosId != null) {
                    cos = this.get(Provisioning.CosBy.id, domainCosId);
                }
                if (cos == null) {
                    cos = this.getCosByName("default", zlc);
                }
            }
            boolean bl = hasMailTransport = attrs.get("zimbraMailTransport") != null;
            if (!hasMailTransport) {
                if (cos != null && attrs.get("zimbraMailHost") == null) {
                    String[] mailHostPool = cos.getMultiAttr("zimbraMailHostPool");
                    this.addMailHost(attrs, mailHostPool, cos.getName());
                }
                if (attrs.get("zimbraMailHost") == null) {
                    this.addDefaultMailHost(attrs);
                }
            }
            if (attrs.get("zimbraMailHost") == null && attrs.get("zimbraMailTransport") == null) {
                throw ServiceException.INVALID_REQUEST("missing zimbraMailHost or zimbraMailTransport for CreateAccount: " + emailAddress, null);
            }
            if (attrs.get("zimbraMailStatus") == null) {
                attrs.put("zimbraMailStatus", "enabled");
            }
            if (attrs.get("zimbraMailDeliveryAddress") == null) {
                attrs.put("zimbraMailDeliveryAddress", emailAddress);
            }
            attrs.put("mail", emailAddress);
            if (attrs.get("cn") == null) {
                Attribute a = attrs.get("displayName");
                if (a != null) {
                    attrs.put("cn", a.get());
                } else {
                    attrs.put("cn", localPart);
                }
            }
            if (attrs.get("sn") == null) {
                attrs.put("sn", localPart);
            }
            attrs.put("uid", localPart);
            this.setInitialPassword(cos, attrs, password);
            dn = this.mDIT.accountDNCreate(baseDn, attrs, localPart, domain);
            zlc.createEntry(dn, attrs, "createAccount");
            Account acct = this.getAccountById(zimbraIdStr, zlc, true);
            if (acct == null) {
                throw ServiceException.FAILURE("unable to get account after creating LDAP account entry: " + emailAddress + ", check ldap log for possible BDB deadlock", null);
            }
            AttributeManager.getInstance().postModify(acctAttrs, acct, attrManagerContext, true);
            this.validate("createAccountSucceeded", emailAddress, acct);
            account = acct;
        }
        catch (NameAlreadyBoundException nabe) {
            try {
                throw AccountServiceException.ACCOUNT_EXISTS(emailAddress, dn, nabe);
                catch (NamingException e) {
                    throw ServiceException.FAILURE("unable to create account: " + emailAddress, e);
                }
            }
            catch (Throwable throwable) {
                ZimbraLdapContext.closeContext(zlc);
                throw throwable;
            }
        }
        ZimbraLdapContext.closeContext(zlc);
        return account;
    }

    private boolean addDefaultMailHost(Attributes attrs, Server server) throws ServiceException {
        String localMailHost = server.getAttr("zimbraServiceHostname");
        boolean hasMailboxService = server.getMultiAttrSet("zimbraServiceEnabled").contains("mailbox");
        if (hasMailboxService && localMailHost != null) {
            attrs.put("zimbraMailHost", localMailHost);
            int lmtpPort = this.getLocalServer().getIntAttr("zimbraLmtpBindPort", 7025);
            String transport = "lmtp:" + localMailHost + ":" + lmtpPort;
            attrs.put("zimbraMailTransport", transport);
            return true;
        }
        return false;
    }

    private void addDefaultMailHost(Attributes attrs) throws ServiceException {
        if (!this.addDefaultMailHost(attrs, this.getLocalServer())) {
            for (Server server : this.getAllServers()) {
                if (!this.addDefaultMailHost(attrs, server)) continue;
                return;
            }
        }
    }

    private String addMailHost(Attributes attrs, String[] mailHostPool, String cosName) throws ServiceException {
        if (mailHostPool.length == 0) {
            return null;
        }
        if (mailHostPool.length > 1) {
            String[] pool = new String[mailHostPool.length];
            System.arraycopy(mailHostPool, 0, pool, 0, mailHostPool.length);
            mailHostPool = pool;
        }
        for (int max = mailHostPool.length; max > 0; --max) {
            Server s;
            int i = sPoolRandom.nextInt(max);
            String mailHostId = mailHostPool[i];
            Server server = s = mailHostId == null ? null : this.getServerByIdInternal(mailHostId);
            if (s != null) {
                String mailHost = s.getAttr("zimbraServiceHostname");
                if (mailHost != null) {
                    boolean hasMailboxService = s.getMultiAttrSet("zimbraServiceEnabled").contains("mailbox");
                    if (hasMailboxService) {
                        attrs.put("zimbraMailHost", mailHost);
                        int lmtpPort = s.getIntAttr("zimbraLmtpBindPort", 7025);
                        String transport = "lmtp:" + mailHost + ":" + lmtpPort;
                        attrs.put("zimbraMailTransport", transport);
                        return mailHost;
                    }
                    ZimbraLog.account.warn("cos(" + cosName + ") mailHostPool server(" + s.getName() + ") is not enabled for mailbox service");
                } else {
                    ZimbraLog.account.warn("cos(" + cosName + ") mailHostPool server(" + s.getName() + ") has no service hostname");
                }
            } else {
                ZimbraLog.account.warn("cos(" + cosName + ") has invalid server in pool: " + mailHostId);
            }
            if (i == max - 1) continue;
            mailHostPool[i] = mailHostPool[max - 1];
        }
        return null;
    }

    @Override
    public List<Account> getAllAdminAccounts() throws ServiceException {
        return this.searchAccountsInternal(LdapFilter.adminAccountByAdminFlag(), null, null, true, 1);
    }

    @Override
    public List<NamedEntry> searchAccounts(String query, String[] returnAttrs, String sortAttr, boolean sortAscending, int flags) throws ServiceException {
        return this.searchAccountsInternal(query, returnAttrs, sortAttr, sortAscending, flags);
    }

    private List<?> searchAccountsInternal(String query, String[] returnAttrs, String sortAttr, boolean sortAscending, int flags) throws ServiceException {
        return this.searchObjects(query, returnAttrs, sortAttr, sortAscending, this.mDIT.mailBranchBaseDN(), flags, 0);
    }

    private static String getObjectClassQuery(int flags) {
        boolean calendarResources;
        boolean coses;
        boolean domains;
        boolean lists;
        boolean aliases;
        boolean accounts = (flags & 1) != 0;
        int num = (accounts ? 1 : 0) + ((aliases = (flags & 2) != 0) ? 1 : 0) + ((lists = (flags & 4) != 0) ? 1 : 0) + ((domains = (flags & 0x10) != 0) ? 1 : 0) + ((coses = (flags & 0x20) != 0) ? 1 : 0) + ((calendarResources = (flags & 8) != 0) ? 1 : 0);
        if (num == 0) {
            accounts = true;
        }
        StringBuffer oc = new StringBuffer();
        if (accounts && !calendarResources) {
            oc.append("(&");
        }
        if (num > 1) {
            oc.append("(|");
        }
        if (accounts) {
            oc.append("(objectclass=zimbraAccount)");
        }
        if (aliases) {
            oc.append("(objectclass=zimbraAlias)");
        }
        if (lists) {
            oc.append("(objectclass=zimbraDistributionList)");
        }
        if (domains) {
            oc.append("(objectclass=zimbraDomain)");
        }
        if (coses) {
            oc.append("(objectclass=zimbraCos)");
        }
        if (calendarResources) {
            oc.append("(objectclass=zimbraCalendarResource)");
        }
        if (num > 1) {
            oc.append(")");
        }
        if (accounts && !calendarResources) {
            oc.append("(!(objectclass=zimbraCalendarResource)))");
        }
        return oc.toString();
    }

    List<NamedEntry> searchObjects(String query, String[] returnAttrs, String sortAttr, boolean sortAscending, String base, int flags, int maxResults) throws ServiceException {
        return this.searchObjects(query, returnAttrs, sortAttr, sortAscending, new String[]{base}, flags, maxResults, true, false);
    }

    List<NamedEntry> searchObjects(String query, String[] returnAttrs, String sortAttr, boolean sortAscending, String[] bases, int flags, int maxResults, boolean useConnPool, boolean useMaster) throws ServiceException {
        final ArrayList<NamedEntry> result = new ArrayList<NamedEntry>();
        NamedEntry.Visitor visitor = new NamedEntry.Visitor(){

            public void visit(NamedEntry entry) {
                result.add(entry);
            }
        };
        if (bases == null || bases.length == 0) {
            this.searchObjects(query, returnAttrs, "", flags, visitor, maxResults, useConnPool, useMaster);
        } else {
            for (String base : bases) {
                this.searchObjects(query, returnAttrs, base, flags, visitor, maxResults, useConnPool, useMaster);
            }
        }
        NamedEntryComparator comparator = new NamedEntryComparator(Provisioning.getInstance(), sortAttr, sortAscending);
        Collections.sort(result, comparator);
        return result;
    }

    void searchObjects(String query, String[] returnAttrs, String base, int flags, NamedEntry.Visitor visitor, int maxResults) throws ServiceException {
        this.searchObjects(query, returnAttrs, base, flags, visitor, maxResults, true, false);
    }

    /*
     * Exception decompiling
     */
    public void searchObjects(String query, String[] returnAttrs, String base, int flags, NamedEntry.Visitor visitor, int maxResults, boolean useConnPool, boolean useMaster) throws ServiceException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String[] fixReturnAttrs(String[] returnAttrs, int flags) {
        if (returnAttrs == null || returnAttrs.length == 0) {
            return null;
        }
        boolean needUID = true;
        boolean needID = true;
        boolean needCOSId = true;
        boolean needObjectClass = true;
        boolean needAliasTargetId = (flags & 2) != 0;
        boolean needCalendarUserType = (flags & 8) != 0;
        boolean needDomainName = true;
        boolean needZimbraACE = true;
        boolean needCn = (flags & 0x20) != 0;
        for (int i = 0; i < returnAttrs.length; ++i) {
            if ("uid".equalsIgnoreCase(returnAttrs[i])) {
                needUID = false;
                continue;
            }
            if ("zimbraId".equalsIgnoreCase(returnAttrs[i])) {
                needID = false;
                continue;
            }
            if ("zimbraCOSId".equalsIgnoreCase(returnAttrs[i])) {
                needCOSId = false;
                continue;
            }
            if ("zimbraAliasTargetId".equalsIgnoreCase(returnAttrs[i])) {
                needAliasTargetId = false;
                continue;
            }
            if ("objectClass".equalsIgnoreCase(returnAttrs[i])) {
                needObjectClass = false;
                continue;
            }
            if ("zimbraAccountCalendarUserType".equalsIgnoreCase(returnAttrs[i])) {
                needCalendarUserType = false;
                continue;
            }
            if ("zimbraDomainName".equalsIgnoreCase(returnAttrs[i])) {
                needDomainName = false;
                continue;
            }
            if ("zimbraACE".equalsIgnoreCase(returnAttrs[i])) {
                needZimbraACE = false;
                continue;
            }
            if (!"cn".equalsIgnoreCase(returnAttrs[i])) continue;
            needCn = false;
        }
        int num = (needUID ? 1 : 0) + (needID ? 1 : 0) + (needCOSId ? 1 : 0) + (needAliasTargetId ? 1 : 0) + (needObjectClass ? 1 : 0) + (needCalendarUserType ? 1 : 0) + (needDomainName ? 1 : 0) + (needZimbraACE ? 1 : 0) + (needCn ? 1 : 0);
        if (num == 0) {
            return returnAttrs;
        }
        String[] result = new String[returnAttrs.length + num];
        int i = 0;
        if (needUID) {
            result[i++] = "uid";
        }
        if (needID) {
            result[i++] = "zimbraId";
        }
        if (needCOSId) {
            result[i++] = "zimbraCOSId";
        }
        if (needAliasTargetId) {
            result[i++] = "zimbraAliasTargetId";
        }
        if (needObjectClass) {
            result[i++] = "objectClass";
        }
        if (needCalendarUserType) {
            result[i++] = "zimbraAccountCalendarUserType";
        }
        if (needDomainName) {
            result[i++] = "zimbraDomainName";
        }
        if (needZimbraACE) {
            result[i++] = "zimbraACE";
        }
        if (needCn) {
            result[i++] = "cn";
        }
        System.arraycopy(returnAttrs, 0, result, i, returnAttrs.length);
        return result;
    }

    @Override
    public void setCOS(Account acct, Cos cos) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCOSId", cos.getId());
        this.modifyAttrs(acct, attrs);
    }

    @Override
    public void modifyAccountStatus(Account acct, String newStatus) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAccountStatus", newStatus);
        this.modifyAttrs(acct, attrs);
    }

    static String[] addMultiValue(String[] values, String value) {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(values));
        list.add(value);
        return list.toArray(new String[list.size()]);
    }

    String[] addMultiValue(NamedEntry acct, String attr, String value) {
        return LdapProvisioning.addMultiValue(acct.getMultiAttr(attr), value);
    }

    String[] removeMultiValue(NamedEntry acct, String attr, String value) {
        return LdapUtil.removeMultiValue(acct.getMultiAttr(attr), value);
    }

    @Override
    public void addAlias(Account acct, String alias) throws ServiceException {
        this.addAliasInternal(acct, alias);
    }

    @Override
    public void removeAlias(Account acct, String alias) throws ServiceException {
        this.removeAliasInternal(acct, alias);
    }

    @Override
    public void addAlias(DistributionList dl, String alias) throws ServiceException {
        this.addAliasInternal(dl, alias);
    }

    @Override
    public void removeAlias(DistributionList dl, String alias) throws ServiceException {
        this.removeAliasInternal(dl, alias);
    }

    private boolean isEntryAlias(Attributes attrs) throws NamingException {
        Map<String, Object> entryAttrs = LdapUtil.getAttrs(attrs);
        Object ocs = entryAttrs.get("objectClass");
        if (ocs instanceof String) {
            return ((String)ocs).equalsIgnoreCase(C_zimbraAlias);
        }
        if (ocs instanceof String[]) {
            for (String oc : (String[])ocs) {
                if (!oc.equalsIgnoreCase(C_zimbraAlias)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addAliasInternal(NamedEntry entry, String alias) throws ServiceException {
        String targetDomainName = null;
        if (entry instanceof Account) {
            targetDomainName = ((Account)entry).getDomainName();
        } else if (entry instanceof DistributionList) {
            targetDomainName = ((DistributionList)entry).getDomainName();
        } else assert (false);
        alias = alias.toLowerCase().trim();
        alias = IDNUtil.toAsciiEmail(alias);
        LdapProvisioning.validEmailAddress(alias);
        String[] parts = alias.split("@");
        String aliasName = parts[0];
        String aliasDomain = parts[1];
        ZimbraLdapContext zlc = null;
        String aliasDn = null;
        try {
            zlc = new ZimbraLdapContext(true);
            Domain domain = this.getDomainByAsciiName(aliasDomain, zlc);
            if (domain == null) {
                throw AccountServiceException.NO_SUCH_DOMAIN(aliasDomain);
            }
            aliasDn = this.mDIT.aliasDN(((LdapEntry)((Object)entry)).getDN(), targetDomainName, aliasName, aliasDomain);
            String aliasUuid = LdapUtil.generateUUID();
            String targetEntryId = entry.getId();
            try {
                zlc.simpleCreate(aliasDn, C_zimbraAlias, new String[]{"uid", aliasName, "zimbraId", aliasUuid, "zimbraCreateTimestamp", DateUtil.toGeneralizedTime(new Date()), "zimbraAliasTargetId", targetEntryId});
            }
            catch (NameAlreadyBoundException e) {
                Attributes attrs = zlc.getAttributes(aliasDn);
                if (!this.isEntryAlias(attrs)) {
                    throw e;
                }
                Alias aliasEntry = this.makeAlias(aliasDn, attrs, this);
                NamedEntry targetEntry = this.searchAliasTarget(aliasEntry, false);
                if (targetEntry == null) {
                    try {
                        this.removeAliasInternal(null, alias);
                    }
                    catch (ServiceException se) {
                        // empty catch block
                    }
                    zlc.simpleCreate(aliasDn, C_zimbraAlias, new String[]{"uid", aliasName, "zimbraId", aliasUuid, "zimbraCreateTimestamp", DateUtil.toGeneralizedTime(new Date()), "zimbraAliasTargetId", targetEntryId});
                }
                if (!targetEntryId.equals(targetEntry.getId())) throw e;
                Set<String> mailAliases = entry.getMultiAttrSet("zimbraMailAlias");
                Set<String> mails = entry.getMultiAttrSet("mail");
                if (mailAliases != null && mailAliases.contains(alias) && mails != null && mails.contains(alias)) {
                    throw e;
                }
                ZimbraLog.account.warn("alias entry exists at " + aliasDn + ", but either mail or zimbraMailAlias of the target does not contain " + alias + ", adding " + alias + " to entry " + entry.getName());
            }
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put("+zimbraMailAlias", alias);
            attrs.put("+mail", alias);
            this.modifyAttrsInternal(entry, zlc, attrs);
        }
        catch (NameAlreadyBoundException nabe) {
            try {
                throw AccountServiceException.ACCOUNT_EXISTS(alias, aliasDn, nabe);
                catch (InvalidNameException e) {
                    throw ServiceException.INVALID_REQUEST("invalid alias name: " + e.getMessage(), e);
                }
                catch (NamingException e) {
                    throw ServiceException.FAILURE("unable to create alias: " + e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                ZimbraLdapContext.closeContext(zlc);
                throw throwable;
            }
        }
        ZimbraLdapContext.closeContext(zlc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAliasInternal(NamedEntry entry, String alias) throws ServiceException {
        ZimbraLdapContext zlc = null;
        try {
            boolean aliasPointsToNonExistingEntry;
            zlc = new ZimbraLdapContext(true);
            alias = alias.toLowerCase();
            alias = IDNUtil.toAsciiEmail(alias);
            String[] parts = alias.split("@");
            String aliasName = parts[0];
            String aliasDomain = parts[1];
            Domain domain = this.getDomainByAsciiName(aliasDomain, zlc);
            if (domain == null) {
                throw AccountServiceException.NO_SUCH_DOMAIN(aliasDomain);
            }
            String targetDn = entry == null ? null : ((LdapEntry)((Object)entry)).getDN();
            String targetDomainName = null;
            if (entry != null) {
                if (entry instanceof Account) {
                    targetDomainName = ((Account)entry).getDomainName();
                } else if (entry instanceof DistributionList) {
                    targetDomainName = ((DistributionList)entry).getDomainName();
                } else {
                    throw ServiceException.INVALID_REQUEST("invalid entry type for alias", null);
                }
            }
            String aliasDn = this.mDIT.aliasDN(targetDn, targetDomainName, aliasName, aliasDomain);
            Attributes aliasAttrs = null;
            Alias aliasEntry = null;
            try {
                aliasAttrs = zlc.getAttributes(aliasDn);
                if (!this.isEntryAlias(aliasAttrs)) {
                    throw AccountServiceException.NO_SUCH_ALIAS(alias);
                }
                aliasEntry = this.makeAlias(aliasDn, aliasAttrs, this);
            }
            catch (NamingException e) {
                ZimbraLog.account.warn("alias " + alias + " does not exist");
            }
            NamedEntry targetEntry = null;
            if (aliasEntry != null) {
                targetEntry = this.searchAliasTarget(aliasEntry, false);
            }
            boolean aliasPointsToEntry = entry != null && aliasEntry != null && entry.getId().equals(aliasEntry.getAttr("zimbraAliasTargetId"));
            boolean aliasPointsToOtherExistingEntry = aliasEntry != null && targetEntry != null && (entry == null || !entry.getId().equals(targetEntry.getId()));
            boolean bl = aliasPointsToNonExistingEntry = aliasEntry != null && targetEntry == null;
            if (entry != null) {
                try {
                    HashMap<String, String> attrs = new HashMap<String, String>();
                    attrs.put("-mail", alias);
                    attrs.put("-zimbraMailAlias", alias);
                    this.modifyAttrsInternal(entry, zlc, attrs);
                }
                catch (ServiceException e) {
                    ZimbraLog.account.warn("unable to remove zimbraMailAlias/mail attrs: " + alias);
                }
            }
            if (!aliasPointsToOtherExistingEntry) {
                this.removeAddressFromAllDistributionLists(alias);
            }
            if (aliasPointsToEntry || aliasPointsToNonExistingEntry) {
                try {
                    zlc.unbindEntry(aliasDn);
                }
                catch (NamingException e) {
                    ZimbraLog.account.warn("unable to remove alias entry at : " + aliasDn);
                }
            }
            if (entry != null && aliasEntry == null || entry != null && aliasEntry != null && !aliasPointsToEntry) {
                throw AccountServiceException.NO_SUCH_ALIAS(alias);
            }
        }
        catch (Throwable throwable) {
            ZimbraLdapContext.closeContext(zlc);
            throw throwable;
        }
        ZimbraLdapContext.closeContext(zlc);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Domain createDomain(String name, Map<String, Object> domainAttrs) throws ServiceException {
        Domain domain;
        name = name.toLowerCase().trim();
        name = IDNUtil.toAsciiDomainName(name);
        NameUtil.validNewDomainName(name);
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext(true);
            LdapDomain d = (LdapDomain)this.getDomainByAsciiName(name, zlc);
            if (d != null) {
                throw AccountServiceException.DOMAIN_EXISTS(name);
            }
            HashMap attrManagerContext = new HashMap();
            String domainType = (String)domainAttrs.get("zimbraDomainType");
            if (domainType == null) {
                domainType = "local";
            } else {
                domainAttrs.remove("zimbraDomainType");
            }
            String domainStatus = (String)domainAttrs.get("zimbraDomainStatus");
            if (domainStatus == null) {
                domainStatus = "active";
            } else {
                domainAttrs.remove("zimbraDomainStatus");
            }
            AttributeManager.getInstance().preModify(domainAttrs, null, attrManagerContext, true, true);
            domainAttrs.put("zimbraDomainType", domainType);
            domainAttrs.put("zimbraDomainStatus", domainStatus);
            String[] parts = name.split("\\.");
            String[] dns = this.mDIT.domainToDNs(parts);
            LdapProvisioning.createParentDomains(zlc, parts, dns);
            BasicAttributes attrs = new BasicAttributes(true);
            LdapUtil.mapToAttrs(domainAttrs, attrs);
            Set<String> ocs = LdapObjectClass.getDomainObjectClasses(this);
            Attribute oc = LdapUtil.addAttr((Attributes)attrs, "objectClass", ocs);
            String zimbraIdStr = LdapUtil.generateUUID();
            attrs.put("zimbraId", zimbraIdStr);
            attrs.put("zimbraCreateTimestamp", DateUtil.toGeneralizedTime(new Date()));
            attrs.put("zimbraDomainName", name);
            String mailStatus = (String)domainAttrs.get("zimbraMailStatus");
            if (mailStatus == null) {
                attrs.put("zimbraMailStatus", "enabled");
            }
            if (domainType.equalsIgnoreCase("alias")) {
                attrs.put("zimbraMailCatchAllAddress", "@" + name);
            }
            attrs.put("o", name + " domain");
            attrs.put("dc", parts[0]);
            String dn = dns[0];
            try {
                zlc.createEntry(dn, attrs, "createDomain");
            }
            catch (NameAlreadyBoundException e) {
                zlc.replaceAttributes(dn, attrs);
            }
            String acctBaseDn = this.mDIT.domainDNToAccountBaseDN(dn);
            if (!acctBaseDn.equals(dn)) {
                zlc.simpleCreate(this.mDIT.domainDNToAccountBaseDN(dn), "organizationalRole", new String[]{"ou", "people", "cn", "people"});
            }
            Domain domain2 = this.getDomainById(zimbraIdStr, zlc);
            AttributeManager.getInstance().postModify(domainAttrs, domain2, attrManagerContext, true);
            domain = domain2;
        }
        catch (NameAlreadyBoundException nabe) {
            try {
                throw AccountServiceException.DOMAIN_EXISTS(name);
                catch (NamingException e) {
                    throw ServiceException.FAILURE("unable to create domain: " + name, e);
                }
            }
            catch (Throwable throwable) {
                ZimbraLdapContext.closeContext(zlc);
                throw throwable;
            }
        }
        ZimbraLdapContext.closeContext(zlc);
        return domain;
    }

    private LdapDomain getDomainByQuery(String query, ZimbraLdapContext initZlc) throws ServiceException {
        ZimbraLdapContext zlc = initZlc;
        try {
            NamingEnumeration<SearchResult> ne;
            if (zlc == null) {
                zlc = new ZimbraLdapContext();
            }
            if ((ne = zlc.searchDir(this.mDIT.domainBaseDN(), query, sSubtreeSC)).hasMore()) {
                SearchResult sr = ne.next();
                if (ne.hasMore()) {
                    String dups = LdapUtil.formatMultipleMatchedEntries(sr, ne);
                    throw AccountServiceException.MULTIPLE_DOMAINS_MATCHED("getDomainByQuery: " + query + " returned multiple entries at " + dups);
                }
                ne.close();
                LdapDomain ldapDomain = new LdapDomain(sr.getNameInNamespace(), sr.getAttributes(), this.getConfig().getDomainDefaults(), (Provisioning)this);
                return ldapDomain;
            }
        }
        catch (NameNotFoundException e) {
            LdapDomain ldapDomain = null;
            return ldapDomain;
        }
        catch (InvalidNameException e) {
            LdapDomain ldapDomain = null;
            return ldapDomain;
        }
        catch (NamingException e) {
            throw ServiceException.FAILURE("unable to lookup domain via query: " + query + " message:" + e.getMessage(), e);
        }
        finally {
            if (initZlc == null) {
                ZimbraLdapContext.closeContext(zlc);
            }
        }
        return null;
    }

    @Override
    public Domain get(Provisioning.DomainBy keyType, String key) throws ServiceException {
        switch (keyType) {
            case name: {
                return this.getDomainByNameInternal(key);
            }
            case id: {
                return this.getDomainByIdInternal(key);
            }
            case virtualHostname: {
                return this.getDomainByVirtualHostnameInternal(key);
            }
            case krb5Realm: {
                return this.getDomainByKrb5RealmInternal(key);
            }
        }
        return null;
    }

    private Domain getFromCache(Provisioning.DomainBy keyType, String key) throws ServiceException {
        switch (keyType) {
            case name: {
                String asciiName = IDNUtil.toAsciiDomainName(key);
                return sDomainCache.getByName(asciiName);
            }
            case id: {
                return sDomainCache.getById(key);
            }
            case virtualHostname: {
                return sDomainCache.getByVirtualHostname(key);
            }
            case krb5Realm: {
                return sDomainCache.getByKrb5Realm(key);
            }
        }
        return null;
    }

    private Domain getDomainById(String zimbraId, ZimbraLdapContext zlc) throws ServiceException {
        if (zimbraId == null) {
            return null;
        }
        Domain d = sDomainCache.getById(zimbraId);
        if (d instanceof DomainCache.NonExistingDomain) {
            return null;
        }
        LdapDomain domain = (LdapDomain)d;
        if (domain == null) {
            zimbraId = LdapUtil.escapeSearchFilterArg(zimbraId);
            domain = this.getDomainByQuery(LdapFilter.domainById(zimbraId), zlc);
            sDomainCache.put(Provisioning.DomainBy.id, zimbraId, domain);
        }
        return domain;
    }

    private Domain getDomainByIdInternal(String zimbraId) throws ServiceException {
        return this.getDomainById(zimbraId, null);
    }

    private Domain getDomainByNameInternal(String name) throws ServiceException {
        String asciiName = IDNUtil.toAsciiDomainName(name);
        return this.getDomainByAsciiName(asciiName, null);
    }

    private Domain getDomainByAsciiName(String name, ZimbraLdapContext zlc) throws ServiceException {
        Domain d = sDomainCache.getByName(name);
        if (d instanceof DomainCache.NonExistingDomain) {
            return null;
        }
        LdapDomain domain = (LdapDomain)d;
        if (domain == null) {
            name = LdapUtil.escapeSearchFilterArg(name);
            domain = this.getDomainByQuery(LdapFilter.domainByName(name), zlc);
            sDomainCache.put(Provisioning.DomainBy.name, name, domain);
        }
        return domain;
    }

    private Domain getDomainByVirtualHostnameInternal(String virtualHostname) throws ServiceException {
        Domain d = sDomainCache.getByVirtualHostname(virtualHostname);
        if (d instanceof DomainCache.NonExistingDomain) {
            return null;
        }
        LdapDomain domain = (LdapDomain)d;
        if (domain == null) {
            virtualHostname = LdapUtil.escapeSearchFilterArg(virtualHostname);
            domain = this.getDomainByQuery(LdapFilter.domainByVirtualHostame(virtualHostname), null);
            sDomainCache.put(Provisioning.DomainBy.virtualHostname, virtualHostname, domain);
        }
        return domain;
    }

    private Domain getDomainByKrb5RealmInternal(String krb5Realm) throws ServiceException {
        Domain d = sDomainCache.getByKrb5Realm(krb5Realm);
        if (d instanceof DomainCache.NonExistingDomain) {
            return null;
        }
        LdapDomain domain = (LdapDomain)d;
        if (domain == null) {
            krb5Realm = LdapUtil.escapeSearchFilterArg(krb5Realm);
            domain = this.getDomainByQuery(LdapFilter.domainByKrb5Realm(krb5Realm), null);
            sDomainCache.put(Provisioning.DomainBy.krb5Realm, krb5Realm, domain);
        }
        return domain;
    }

    @Override
    public List<Domain> getAllDomains() throws ServiceException {
        final ArrayList<Domain> result = new ArrayList<Domain>();
        NamedEntry.Visitor visitor = new NamedEntry.Visitor(){

            public void visit(NamedEntry entry) {
                result.add((LdapDomain)entry);
            }
        };
        this.getAllDomains(visitor, null);
        Collections.sort(result);
        return result;
    }

    @Override
    public void getAllDomains(NamedEntry.Visitor visitor, String[] retAttrs) throws ServiceException {
        int flags = 16;
        if (retAttrs != null) {
            HashSet<String> attrs = new HashSet<String>(Arrays.asList(retAttrs));
            attrs.add("objectClass");
            attrs.add("zimbraId");
            attrs.add("zimbraDomainName");
            retAttrs = attrs.toArray(new String[attrs.size()]);
            flags |= 0x80;
        }
        this.searchObjects(null, retAttrs, this.mDIT.domainBaseDN(), flags, visitor, 0);
    }

    private static boolean domainDnExists(ZimbraLdapContext zlc, String dn) throws NamingException {
        try {
            NamingEnumeration<SearchResult> ne = zlc.searchDir(dn, LdapFilter.domainLabel(), sObjectSC);
            boolean result = ne.hasMore();
            ne.close();
            return result;
        }
        catch (InvalidNameException e) {
            return false;
        }
        catch (NameNotFoundException nnfe) {
            return false;
        }
    }

    private static void createParentDomains(ZimbraLdapContext zlc, String[] parts, String[] dns) throws NamingException {
        for (int i = dns.length - 1; i > 0; --i) {
            if (LdapProvisioning.domainDnExists(zlc, dns[i])) continue;
            String dn = dns[i];
            String domain = parts[i];
            zlc.simpleCreate(dn, new String[]{"dcObject", "organization"}, new String[]{"o", domain + " domain", "dc", domain});
        }
    }

    @Override
    public Cos createCos(String name, Map<String, Object> cosAttrs) throws ServiceException {
        String defaultCosId = this.getCosByName("default", null).getId();
        return this.copyCos(defaultCosId, name, cosAttrs);
    }

    @Override
    public Cos copyCos(String srcCosId, String destCosName) throws ServiceException {
        return this.copyCos(srcCosId, destCosName, null);
    }

    private Cos copyCos(String srcCosId, String destCosName, Map<String, Object> cosAttrs) throws ServiceException {
        Cos cos;
        destCosName = destCosName.toLowerCase().trim();
        HashMap<String, Object> allAttrs = new HashMap<String, Object>();
        Cos srcCos = this.getCosById(srcCosId, null);
        if (srcCos == null) {
            throw AccountServiceException.NO_SUCH_COS(srcCosId);
        }
        for (Map.Entry<String, Object> e : srcCos.getAttrs().entrySet()) {
            allAttrs.put(e.getKey(), e.getValue());
        }
        allAttrs.remove("objectClass");
        allAttrs.remove("zimbraId");
        allAttrs.remove("zimbraCreateTimestamp");
        allAttrs.remove("zimbraACE");
        allAttrs.remove("cn");
        allAttrs.remove("description");
        if (cosAttrs != null) {
            for (Map.Entry<String, Object> e : cosAttrs.entrySet()) {
                allAttrs.put(e.getKey(), e.getValue());
            }
        }
        HashMap attrManagerContext = new HashMap();
        AttributeManager.getInstance().preModify(allAttrs, null, attrManagerContext, true, true);
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext(true);
            BasicAttributes attrs = new BasicAttributes(true);
            LdapUtil.mapToAttrs(allAttrs, attrs);
            Set<String> ocs = LdapObjectClass.getCosObjectClasses(this);
            Attribute oc = LdapUtil.addAttr((Attributes)attrs, "objectClass", ocs);
            String zimbraIdStr = LdapUtil.generateUUID();
            attrs.put("zimbraId", zimbraIdStr);
            attrs.put("zimbraCreateTimestamp", DateUtil.toGeneralizedTime(new Date()));
            attrs.put("cn", destCosName);
            String dn = this.mDIT.cosNametoDN(destCosName);
            zlc.createEntry(dn, attrs, "createCos");
            Cos cos2 = this.getCosById(zimbraIdStr, zlc);
            AttributeManager.getInstance().postModify(allAttrs, cos2, attrManagerContext, true);
            cos = cos2;
        }
        catch (NameAlreadyBoundException nabe) {
            try {
                throw AccountServiceException.COS_EXISTS(destCosName);
            }
            catch (Throwable throwable) {
                ZimbraLdapContext.closeContext(zlc);
                throw throwable;
            }
        }
        ZimbraLdapContext.closeContext(zlc);
        return cos;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void renameCos(String zimbraId, String newName) throws ServiceException {
        LdapCos cos = (LdapCos)this.get(Provisioning.CosBy.id, zimbraId);
        if (cos == null) {
            throw AccountServiceException.NO_SUCH_COS(zimbraId);
        }
        if (cos.isDefaultCos()) {
            throw ServiceException.INVALID_REQUEST("unable to rename default cos", null);
        }
        newName = newName.toLowerCase().trim();
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext(true);
            String newDn = this.mDIT.cosNametoDN(newName);
            zlc.renameEntry(cos.getDN(), newDn);
            sCosCache.remove(cos);
        }
        catch (NameAlreadyBoundException nabe) {
            try {
                throw AccountServiceException.COS_EXISTS(newName);
                catch (NamingException e) {
                    throw ServiceException.FAILURE("unable to rename cos: " + zimbraId, e);
                }
            }
            catch (Throwable throwable) {
                ZimbraLdapContext.closeContext(zlc);
                throw throwable;
            }
        }
        ZimbraLdapContext.closeContext(zlc);
    }

    private LdapCos getCOSByQuery(String query, ZimbraLdapContext initZlc) throws ServiceException {
        ZimbraLdapContext zlc = initZlc;
        try {
            NamingEnumeration<SearchResult> ne;
            if (zlc == null) {
                zlc = new ZimbraLdapContext();
            }
            if ((ne = zlc.searchDir(this.mDIT.cosBaseDN(), query, sSubtreeSC)).hasMore()) {
                SearchResult sr = ne.next();
                ne.close();
                LdapCos ldapCos = new LdapCos(sr.getNameInNamespace(), sr.getAttributes(), (Provisioning)this);
                return ldapCos;
            }
        }
        catch (NameNotFoundException e) {
            LdapCos ldapCos = null;
            return ldapCos;
        }
        catch (InvalidNameException e) {
            LdapCos ldapCos = null;
            return ldapCos;
        }
        catch (NamingException e) {
            throw ServiceException.FAILURE("unable to lookup cos via query: " + query + " message: " + e.getMessage(), e);
        }
        finally {
            if (initZlc == null) {
                ZimbraLdapContext.closeContext(zlc);
            }
        }
        return null;
    }

    private Cos getCosById(String zimbraId, ZimbraLdapContext zlc) throws ServiceException {
        if (zimbraId == null) {
            return null;
        }
        LdapCos cos = sCosCache.getById(zimbraId);
        if (cos == null) {
            zimbraId = LdapUtil.escapeSearchFilterArg(zimbraId);
            cos = this.getCOSByQuery(LdapFilter.cosById(zimbraId), zlc);
            sCosCache.put(cos);
        }
        return cos;
    }

    @Override
    public Cos get(Provisioning.CosBy keyType, String key) throws ServiceException {
        switch (keyType) {
            case name: {
                return this.getCosByName(key, null);
            }
            case id: {
                return this.getCosById(key, null);
            }
        }
        return null;
    }

    private Cos getFromCache(Provisioning.CosBy keyType, String key) throws ServiceException {
        switch (keyType) {
            case name: {
                return sCosCache.getByName(key);
            }
            case id: {
                return sCosCache.getById(key);
            }
        }
        return null;
    }

    private Cos getCosByName(String name, ZimbraLdapContext initZlc) throws ServiceException {
        ZimbraLdapContext zlc = initZlc;
        LdapCos cos = sCosCache.getByName(name);
        if (cos != null) {
            return cos;
        }
        try {
            if (zlc == null) {
                zlc = new ZimbraLdapContext();
            }
            String dn = this.mDIT.cosNametoDN(name);
            Attributes attrs = zlc.getAttributes(dn);
            cos = new LdapCos(dn, attrs, (Provisioning)this);
            sCosCache.put(cos);
            LdapCos ldapCos = cos;
            return ldapCos;
        }
        catch (NameNotFoundException e) {
            Cos cos2 = null;
            return cos2;
        }
        catch (InvalidNameException e) {
            Cos cos3 = null;
            return cos3;
        }
        catch (NamingException e) {
            throw ServiceException.FAILURE("unable to lookup COS by name: " + name + " message: " + e.getMessage(), e);
        }
        finally {
            if (initZlc == null) {
                ZimbraLdapContext.closeContext(zlc);
            }
        }
    }

    @Override
    public List<Cos> getAllCos() throws ServiceException {
        ArrayList<Cos> result = new ArrayList<Cos>();
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext();
            NamingEnumeration<SearchResult> ne = zlc.searchDir(this.mDIT.cosBaseDN(), LdapFilter.allCoses(), sSubtreeSC);
            while (ne.hasMore()) {
                SearchResult sr = ne.next();
                result.add(new LdapCos(sr.getNameInNamespace(), sr.getAttributes(), (Provisioning)this));
            }
            ne.close();
        }
        catch (NamingException e) {
            throw ServiceException.FAILURE("unable to list all COS", e);
        }
        finally {
            ZimbraLdapContext.closeContext(zlc);
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public void deleteAccount(String zimbraId) throws ServiceException {
        Account acc = this.getAccountById(zimbraId);
        LdapEntry entry = (LdapEntry)((Object)this.getAccountById(zimbraId));
        if (acc == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(zimbraId);
        }
        this.removeAddressFromAllDistributionLists(acc.getName());
        String[] aliases = acc.getMailAlias();
        if (aliases != null) {
            for (int i = 0; i < aliases.length; ++i) {
                this.removeAlias(acc, aliases[i]);
            }
        }
        try {
            RightCommand.revokeAllRights(this, GranteeType.GT_USER, zimbraId);
        }
        catch (ServiceException e) {
            ZimbraLog.account.warn((Object)"cannot revoke grants", e);
        }
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext(true);
            zlc.deleteChildren(entry.getDN());
            zlc.unbindEntry(entry.getDN());
            sAccountCache.remove(acc);
        }
        catch (NamingException e) {
            try {
                throw ServiceException.FAILURE("unable to purge account: " + zimbraId, e);
            }
            catch (Throwable throwable) {
                ZimbraLdapContext.closeContext(zlc);
                throw throwable;
            }
        }
        ZimbraLdapContext.closeContext(zlc);
    }

    @Override
    public void renameAccount(String zimbraId, String newName) throws ServiceException {
        newName = IDNUtil.toAsciiEmail(newName);
        LdapProvisioning.validEmailAddress(newName);
        ZimbraLdapContext zlc = null;
        Account acct = this.getAccountById(zimbraId, zlc, true);
        LdapEntry entry = (LdapEntry)((Object)acct);
        if (acct == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(zimbraId);
        }
        String oldEmail = acct.getName();
        try {
            zlc = new ZimbraLdapContext(true);
            String oldDn = entry.getDN();
            String oldDomain = EmailUtil.getValidDomainPart(oldEmail);
            newName = newName.toLowerCase().trim();
            String[] parts = EmailUtil.getLocalPartAndDomain(newName);
            if (parts == null) {
                throw ServiceException.INVALID_REQUEST("bad value for newName", null);
            }
            String newLocal = parts[0];
            String newDomain = parts[1];
            Domain domain = this.getDomainByAsciiName(newDomain, zlc);
            if (domain == null) {
                throw AccountServiceException.NO_SUCH_DOMAIN(newDomain);
            }
            String newDn = this.mDIT.accountDNRename(oldDn, newLocal, domain.getName());
            boolean dnChanged = !newDn.equals(oldDn);
            Map<String, Object> newAttrs = acct.getAttrs(false);
            newAttrs.put("uid", newLocal);
            newAttrs.put("zimbraMailDeliveryAddress", newName);
            ReplaceAddressResult replacedMails = this.replaceMailAddresses(acct, "mail", oldEmail, newName);
            if (replacedMails.newAddrs().length == 0) {
                newAttrs.put("mail", newName);
            } else {
                newAttrs.put("mail", replacedMails.newAddrs());
            }
            boolean domainChanged = !oldDomain.equals(newDomain);
            ReplaceAddressResult replacedAliases = this.replaceMailAddresses(acct, "zimbraMailAlias", oldEmail, newName);
            if (replacedAliases.newAddrs().length > 0) {
                newAttrs.put("zimbraMailAlias", replacedAliases.newAddrs());
                String newDomainDN = this.mDIT.domainToAccountSearchDN(newDomain);
                String[] aliasNewAddrs = replacedAliases.newAddrs();
                if (domainChanged && this.addressExists(zlc, newDomainDN, aliasNewAddrs)) {
                    throw AccountServiceException.ACCOUNT_EXISTS(newName);
                }
                for (int i = 0; i < aliasNewAddrs.length; ++i) {
                    if (!newName.equalsIgnoreCase(aliasNewAddrs[i])) continue;
                    throw AccountServiceException.ACCOUNT_EXISTS(newName);
                }
            }
            BasicAttributes attributes = new BasicAttributes(true);
            LdapUtil.mapToAttrs(newAttrs, attributes);
            if (dnChanged) {
                zlc.createEntry(newDn, attributes, "createAccount");
            }
            try {
                if (dnChanged) {
                    zlc.moveChildren(oldDn, newDn);
                }
                this.renameAddressesInAllDistributionLists(oldEmail, newName, replacedAliases);
                if (domainChanged) {
                    this.moveAliases(zlc, replacedAliases, newDomain, null, oldDn, newDn, oldDomain, newDomain);
                }
                if (!dnChanged) {
                    this.modifyAttrs((Entry)acct, newAttrs, false, false);
                }
            }
            catch (ServiceException e) {
                throw e;
            }
            finally {
                if (dnChanged) {
                    zlc.unbindEntry(oldDn);
                }
            }
        }
        catch (NameAlreadyBoundException nabe) {
            throw AccountServiceException.ACCOUNT_EXISTS(newName);
        }
        catch (NamingException e) {
            throw ServiceException.FAILURE("unable to rename account: " + zimbraId, e);
        }
        finally {
            sAccountCache.remove(acct);
            ZimbraLdapContext.closeContext(zlc);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void deleteDomain(String zimbraId) throws ServiceException {
        ZimbraLdapContext zlc = null;
        LdapDomain d = null;
        String acctBaseDn = null;
        try {
            HashMap<String, String> attrs;
            zlc = new ZimbraLdapContext(true);
            d = (LdapDomain)this.getDomainById(zimbraId, zlc);
            if (d == null) {
                throw AccountServiceException.NO_SUCH_DOMAIN(zimbraId);
            }
            String name = d.getName();
            acctBaseDn = this.mDIT.domainDNToAccountBaseDN(d.getDN());
            if (!acctBaseDn.equals(d.getDN())) {
                zlc.unbindEntry(acctBaseDn);
            }
            try {
                zlc.unbindEntry(d.getDN());
                sDomainCache.remove(d);
            }
            catch (ContextNotEmptyException e) {
                sDomainCache.remove(d);
                attrs = new HashMap<String, String>();
                attrs.put("-objectClass", C_zimbraDomain);
                for (String key : d.getAttrs(false).keySet()) {
                    if (!key.startsWith("zimbra")) continue;
                    attrs.put(key, "");
                }
                this.modifyAttrs((Entry)d, attrs, false, false);
            }
            String defaultDomain = this.getConfig().getAttr("zimbraDefaultDomainName", null);
            if (name.equalsIgnoreCase(defaultDomain)) {
                try {
                    attrs = new HashMap();
                    attrs.put("zimbraDefaultDomainName", "");
                    this.modifyAttrs(this.getConfig(), attrs);
                }
                catch (Exception e) {
                    ZimbraLog.account.warn((Object)"unable to remove config attr:zimbraDefaultDomainName", e);
                }
            }
        }
        catch (ContextNotEmptyException e) {
            try {
                StringBuilder sb = new StringBuilder();
                sb.append(" (remaining entries: ");
                try {
                    int maxEntriesToGet = 5;
                    SearchControls searchControls = new SearchControls(2, maxEntriesToGet, 0, null, false, false);
                    NamingEnumeration<SearchResult> ne = zlc.searchDir(acctBaseDn, "(objectClass=*)", searchControls);
                    while (ne.hasMore()) {
                        SearchResult sr = ne.next();
                        if (sr.getNameInNamespace().equals(acctBaseDn)) continue;
                        sb.append("[" + sr.getNameInNamespace() + "] ");
                    }
                    ne.close();
                }
                catch (SizeLimitExceededException sle) {
                }
                catch (NamingException ne) {
                    ZimbraLog.account.warn((Object)("unable to get sample entries in non-empty domain " + d.getName() + " for reporting"), ne);
                }
                sb.append("...)");
                throw AccountServiceException.DOMAIN_NOT_EMPTY(d.getName() + sb.toString(), e);
                catch (NamingException e2) {
                    throw ServiceException.FAILURE("unable to purge domain: " + zimbraId, e2);
                }
            }
            catch (Throwable throwable) {
                ZimbraLdapContext.closeContext(zlc);
                throw throwable;
            }
        }
        ZimbraLdapContext.closeContext(zlc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameDomain(String zimbraId, String newDomainName) throws ServiceException {
        newDomainName = newDomainName.toLowerCase().trim();
        newDomainName = IDNUtil.toAsciiDomainName(newDomainName);
        NameUtil.validNewDomainName(newDomainName);
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext(true);
            Domain oldDomain = this.getDomainById(zimbraId, zlc);
            if (oldDomain == null) {
                throw AccountServiceException.NO_SUCH_DOMAIN(zimbraId);
            }
            String oldDomainName = oldDomain.getName();
            RenameDomain rd = new RenameDomain(zlc, this, oldDomain, newDomainName);
            rd.execute();
        }
        catch (Throwable throwable) {
            ZimbraLdapContext.closeContext(zlc);
            throw throwable;
        }
        ZimbraLdapContext.closeContext(zlc);
    }

    @Override
    public void deleteCos(String zimbraId) throws ServiceException {
        LdapCos c = (LdapCos)this.get(Provisioning.CosBy.id, zimbraId);
        if (c == null) {
            throw AccountServiceException.NO_SUCH_COS(zimbraId);
        }
        if (c.isDefaultCos()) {
            throw ServiceException.INVALID_REQUEST("unable to delete default cos", null);
        }
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext(true);
            zlc.unbindEntry(c.getDN());
            sCosCache.remove(c);
        }
        catch (NamingException e) {
            try {
                throw ServiceException.FAILURE("unable to purge cos: " + zimbraId, e);
            }
            catch (Throwable throwable) {
                ZimbraLdapContext.closeContext(zlc);
                throw throwable;
            }
        }
        ZimbraLdapContext.closeContext(zlc);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Server createServer(String name, Map<String, Object> serverAttrs) throws ServiceException {
        Server server;
        name = name.toLowerCase().trim();
        HashMap attrManagerContext = new HashMap();
        AttributeManager.getInstance().preModify(serverAttrs, null, attrManagerContext, true, true);
        String authHost = (String)serverAttrs.get("zimbraMtaAuthHost");
        if (authHost != null) {
            serverAttrs.put("zimbraMtaAuthURL", URLUtil.getMtaAuthURL(authHost));
        }
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext(true);
            BasicAttributes attrs = new BasicAttributes(true);
            LdapUtil.mapToAttrs(serverAttrs, attrs);
            Set<String> ocs = LdapObjectClass.getServerObjectClasses(this);
            Attribute oc = LdapUtil.addAttr((Attributes)attrs, "objectClass", ocs);
            String zimbraIdStr = LdapUtil.generateUUID();
            attrs.put("zimbraId", zimbraIdStr);
            attrs.put("zimbraCreateTimestamp", DateUtil.toGeneralizedTime(new Date()));
            attrs.put("cn", name);
            String dn = this.mDIT.serverNametoDN(name);
            String zimbraServerHostname = null;
            Attribute zimbraServiceHostnameAttr = attrs.get("zimbraServiceHostname");
            if (zimbraServiceHostnameAttr == null) {
                zimbraServerHostname = name;
                attrs.put("zimbraServiceHostname", name);
            } else {
                zimbraServerHostname = (String)zimbraServiceHostnameAttr.get();
            }
            zlc.createEntry(dn, attrs, "createServer");
            Server server2 = this.getServerById(zimbraIdStr, zlc, true);
            AttributeManager.getInstance().postModify(serverAttrs, server2, attrManagerContext, true);
            server = server2;
        }
        catch (NameAlreadyBoundException nabe) {
            try {
                throw AccountServiceException.SERVER_EXISTS(name);
                catch (NamingException e) {
                    throw ServiceException.FAILURE("unable to create server: " + name + " message: " + e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                ZimbraLdapContext.closeContext(zlc);
                throw throwable;
            }
        }
        ZimbraLdapContext.closeContext(zlc);
        return server;
    }

    private Server getServerByQuery(String query, ZimbraLdapContext initZlc) throws ServiceException {
        ZimbraLdapContext zlc = initZlc;
        try {
            NamingEnumeration<SearchResult> ne;
            if (zlc == null) {
                zlc = new ZimbraLdapContext();
            }
            if ((ne = zlc.searchDir(this.mDIT.serverBaseDN(), query, sSubtreeSC)).hasMore()) {
                SearchResult sr = ne.next();
                ne.close();
                LdapServer ldapServer = new LdapServer(sr.getNameInNamespace(), sr.getAttributes(), this.getConfig().getServerDefaults(), (Provisioning)this);
                return ldapServer;
            }
        }
        catch (NameNotFoundException e) {
            Server server = null;
            return server;
        }
        catch (InvalidNameException e) {
            Server server = null;
            return server;
        }
        catch (NamingException e) {
            throw ServiceException.FAILURE("unable to lookup server via query: " + query + " message: " + e.getMessage(), e);
        }
        finally {
            if (initZlc == null) {
                ZimbraLdapContext.closeContext(zlc);
            }
        }
        return null;
    }

    private Server getServerById(String zimbraId, ZimbraLdapContext zlc, boolean nocache) throws ServiceException {
        if (zimbraId == null) {
            return null;
        }
        Server s = null;
        if (!nocache) {
            s = sServerCache.getById(zimbraId);
        }
        if (s == null) {
            zimbraId = LdapUtil.escapeSearchFilterArg(zimbraId);
            s = this.getServerByQuery(LdapFilter.serverById(zimbraId), zlc);
            sServerCache.put(s);
        }
        return s;
    }

    @Override
    public Server get(Provisioning.ServerBy keyType, String key) throws ServiceException {
        switch (keyType) {
            case name: {
                return this.getServerByNameInternal(key);
            }
            case id: {
                return this.getServerByIdInternal(key);
            }
            case serviceHostname: {
                List<Server> servers = this.getAllServers();
                for (Server s : servers) {
                    if (!key.equalsIgnoreCase(s.getAttr("zimbraServiceHostname", ""))) continue;
                    return s;
                }
                return null;
            }
        }
        return null;
    }

    private Server getFromCache(Provisioning.ServerBy keyType, String key) throws ServiceException {
        switch (keyType) {
            case name: {
                return sServerCache.getByName(key);
            }
            case id: {
                return sServerCache.getById(key);
            }
        }
        return null;
    }

    private Server getServerByIdInternal(String zimbraId) throws ServiceException {
        return this.getServerById(zimbraId, null, false);
    }

    private Server getServerByNameInternal(String name) throws ServiceException {
        return this.getServerByName(name, false);
    }

    private Server getServerByName(String name, boolean nocache) throws ServiceException {
        Server s;
        if (!nocache && (s = sServerCache.getByName(name)) != null) {
            return s;
        }
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext();
            String dn = this.mDIT.serverNametoDN(name);
            Attributes attrs = zlc.getAttributes(dn);
            LdapServer s2 = new LdapServer(dn, attrs, this.getConfig().getServerDefaults(), (Provisioning)this);
            sServerCache.put(s2);
            LdapServer ldapServer = s2;
            return ldapServer;
        }
        catch (NameNotFoundException e) {
            Server server = null;
            return server;
        }
        catch (InvalidNameException e) {
            Server server = null;
            return server;
        }
        catch (NamingException e) {
            throw ServiceException.FAILURE("unable to lookup server by name: " + name + " message: " + e.getMessage(), e);
        }
        finally {
            ZimbraLdapContext.closeContext(zlc);
        }
    }

    @Override
    public List<Server> getAllServers() throws ServiceException {
        return this.getAllServers(null);
    }

    @Override
    public List<Server> getAllServers(String service) throws ServiceException {
        ArrayList<Server> result = new ArrayList<Server>();
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext();
            String filter = service != null ? LdapFilter.serverByService(LdapUtil.escapeSearchFilterArg(service)) : LdapFilter.allServers();
            NamingEnumeration<SearchResult> ne = zlc.searchDir(this.mDIT.serverBaseDN(), filter, sSubtreeSC);
            while (ne.hasMore()) {
                SearchResult sr = ne.next();
                LdapServer s = new LdapServer(sr.getNameInNamespace(), sr.getAttributes(), this.getConfig().getServerDefaults(), (Provisioning)this);
                result.add(s);
            }
            ne.close();
        }
        catch (NamingException e) {
            throw ServiceException.FAILURE("unable to list all servers", e);
        }
        finally {
            ZimbraLdapContext.closeContext(zlc);
        }
        if (result.size() > 0) {
            sServerCache.put(result, true);
        }
        Collections.sort(result);
        return result;
    }

    private List<Cos> searchCOS(String query, ZimbraLdapContext initZlc) throws ServiceException {
        ArrayList<Cos> result = new ArrayList<Cos>();
        ZimbraLdapContext zlc = initZlc;
        try {
            if (zlc == null) {
                zlc = new ZimbraLdapContext();
            }
            NamingEnumeration<SearchResult> ne = zlc.searchDir(this.mDIT.cosBaseDN(), query, sSubtreeSC);
            while (ne.hasMore()) {
                SearchResult sr = ne.next();
                result.add(new LdapCos(sr.getNameInNamespace(), sr.getAttributes(), (Provisioning)this));
            }
            ne.close();
        }
        catch (NameNotFoundException e) {
            List<Cos> list = null;
            return list;
        }
        catch (InvalidNameException e) {
            List<Cos> list = null;
            return list;
        }
        catch (NamingException e) {
            throw ServiceException.FAILURE("unable to lookup cos via query: " + query + " message: " + e.getMessage(), e);
        }
        finally {
            if (initZlc == null) {
                ZimbraLdapContext.closeContext(zlc);
            }
        }
        return result;
    }

    private void removeServerFromAllCOSes(String server, ZimbraLdapContext initZlc) {
        List<Cos> coses = null;
        try {
            coses = this.searchCOS(LdapFilter.cosesByMailHostPool(server), initZlc);
            for (Cos cos : coses) {
                HashMap<String, String> attrs = new HashMap<String, String>();
                attrs.put("-zimbraMailHostPool", server);
                this.modifyAttrs(cos, attrs);
                sCosCache.remove((LdapCos)cos);
            }
        }
        catch (ServiceException se) {
            ZimbraLog.account.warn((Object)("unable to remove " + server + " from all COSes "), se);
            return;
        }
    }

    @Override
    public void deleteServer(String zimbraId) throws ServiceException {
        LdapServer s = (LdapServer)this.getServerByIdInternal(zimbraId);
        if (s == null) {
            throw AccountServiceException.NO_SUCH_SERVER(zimbraId);
        }
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext(true);
            this.removeServerFromAllCOSes(zimbraId, zlc);
            zlc.unbindEntry(s.getDN());
            sServerCache.remove(s);
        }
        catch (NamingException e) {
            try {
                throw ServiceException.FAILURE("unable to purge server: " + zimbraId, e);
            }
            catch (Throwable throwable) {
                ZimbraLdapContext.closeContext(zlc);
                throw throwable;
            }
        }
        ZimbraLdapContext.closeContext(zlc);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DistributionList createDistributionList(String listAddress, Map<String, Object> listAttrs) throws ServiceException {
        DistributionList distributionList;
        SpecialAttrs specialAttrs = this.mDIT.handleSpecialAttrs(listAttrs);
        String baseDn = specialAttrs.getLdapBaseDn();
        String[] parts = (listAddress = listAddress.toLowerCase().trim()).split("@");
        if (parts.length != 2) {
            throw ServiceException.INVALID_REQUEST("must be valid list address: " + listAddress, null);
        }
        String localPart = parts[0];
        String domain = parts[1];
        domain = IDNUtil.toAsciiDomainName(domain);
        listAddress = localPart + "@" + domain;
        LdapProvisioning.validEmailAddress(listAddress);
        HashMap attrManagerContext = new HashMap();
        AttributeManager.getInstance().preModify(listAttrs, null, attrManagerContext, true, true);
        ZimbraLdapContext zlc = null;
        try {
            Attribute a;
            zlc = new ZimbraLdapContext(true);
            Domain d = this.getDomainByAsciiName(domain, zlc);
            if (d == null) {
                throw AccountServiceException.NO_SUCH_DOMAIN(domain);
            }
            String domainType = d.getAttr("zimbraDomainType", "local");
            if (!domainType.equals("local")) {
                throw ServiceException.INVALID_REQUEST("domain type must be local", null);
            }
            BasicAttributes attrs = new BasicAttributes(true);
            LdapUtil.mapToAttrs(listAttrs, attrs);
            Attribute oc = LdapUtil.addAttr((Attributes)attrs, "objectClass", C_zimbraMailList);
            oc.add(C_zimbraMailRecipient);
            String zimbraIdStr = LdapUtil.generateUUID();
            attrs.put("zimbraId", zimbraIdStr);
            attrs.put("zimbraCreateTimestamp", DateUtil.toGeneralizedTime(new Date()));
            attrs.put("zimbraMailAlias", listAddress);
            attrs.put("mail", listAddress);
            if (attrs.get("zimbraMailStatus") == null) {
                attrs.put("zimbraMailStatus", "enabled");
            }
            if ((a = attrs.get("displayName")) != null) {
                attrs.put("cn", a.get());
            }
            attrs.put("uid", localPart);
            String dn = this.mDIT.distributionListDNCreate(baseDn, attrs, localPart, domain);
            zlc.createEntry(dn, attrs, "createDistributionList");
            DistributionList dlist = this.getDistributionListById(zimbraIdStr, zlc);
            AttributeManager.getInstance().postModify(listAttrs, dlist, attrManagerContext, true);
            distributionList = dlist;
        }
        catch (NameAlreadyBoundException nabe) {
            try {
                throw AccountServiceException.DISTRIBUTION_LIST_EXISTS(listAddress);
                catch (NamingException e) {
                    throw ServiceException.FAILURE("unable to create distribution listt: " + listAddress, e);
                }
            }
            catch (Throwable throwable) {
                ZimbraLdapContext.closeContext(zlc);
                throw throwable;
            }
        }
        ZimbraLdapContext.closeContext(zlc);
        return distributionList;
    }

    @Override
    public List<DistributionList> getDistributionLists(DistributionList list, boolean directOnly, Map<String, String> via) throws ServiceException {
        String[] addrs = LdapProvisioning.getAllAddrsForDistributionList(list);
        return LdapProvisioning.getDistributionLists(addrs, directOnly, via, false);
    }

    public List<DistributionList> getDistributionLists(DistributionList list, boolean directOnly, Map<String, String> via, boolean minimalData) throws ServiceException {
        String[] addrs = LdapProvisioning.getAllAddrsForDistributionList(list);
        return LdapProvisioning.getDistributionLists(addrs, directOnly, via, minimalData);
    }

    private DistributionList getDistributionListByQuery(String base, String query, ZimbraLdapContext initZlc, String[] returnAttrs) throws ServiceException {
        ZimbraLdapContext zlc = initZlc;
        try {
            SearchControls searchControls;
            NamingEnumeration<SearchResult> ne;
            if (zlc == null) {
                zlc = new ZimbraLdapContext();
            }
            if ((ne = zlc.searchDir(base, query, searchControls = new SearchControls(2, 0L, 0, returnAttrs, false, false))).hasMore()) {
                SearchResult sr = ne.next();
                ne.close();
                DistributionList distributionList = this.makeDistributionList(sr.getNameInNamespace(), sr.getAttributes(), this);
                return distributionList;
            }
        }
        catch (NameNotFoundException e) {
            DistributionList distributionList = null;
            return distributionList;
        }
        catch (InvalidNameException e) {
            DistributionList distributionList = null;
            return distributionList;
        }
        catch (NamingException e) {
            throw ServiceException.FAILURE("unable to lookup distribution list via query: " + query + " message: " + e.getMessage(), e);
        }
        finally {
            if (initZlc == null) {
                ZimbraLdapContext.closeContext(zlc);
            }
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void renameDistributionList(String zimbraId, String newEmail) throws ServiceException {
        newEmail = IDNUtil.toAsciiEmail(newEmail);
        LdapProvisioning.validEmailAddress(newEmail);
        ZimbraLdapContext zlc = null;
        try {
            boolean dnChanged;
            zlc = new ZimbraLdapContext(true);
            LdapDistributionList dl = (LdapDistributionList)this.getDistributionListById(zimbraId, zlc);
            if (dl == null) {
                throw AccountServiceException.NO_SUCH_DISTRIBUTION_LIST(zimbraId);
            }
            String oldEmail = dl.getName();
            String oldDomain = EmailUtil.getValidDomainPart(oldEmail);
            String[] parts = EmailUtil.getLocalPartAndDomain(newEmail = newEmail.toLowerCase().trim());
            if (parts == null) {
                throw ServiceException.INVALID_REQUEST("bad value for newName", null);
            }
            String newLocal = parts[0];
            String newDomain = parts[1];
            boolean domainChanged = !oldDomain.equals(newDomain);
            Domain domain = this.getDomainByAsciiName(newDomain, zlc);
            if (domain == null) {
                throw AccountServiceException.NO_SUCH_DOMAIN(newDomain);
            }
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            ReplaceAddressResult replacedMails = this.replaceMailAddresses(dl, "mail", oldEmail, newEmail);
            if (replacedMails.newAddrs().length == 0) {
                attrs.put("mail", newEmail);
            } else {
                attrs.put("mail", replacedMails.newAddrs());
            }
            ReplaceAddressResult replacedAliases = this.replaceMailAddresses(dl, "zimbraMailAlias", oldEmail, newEmail);
            if (replacedAliases.newAddrs().length > 0) {
                attrs.put("zimbraMailAlias", replacedAliases.newAddrs());
                String newDomainDN = this.mDIT.domainToAccountSearchDN(newDomain);
                if (domainChanged && this.addressExists(zlc, newDomainDN, replacedAliases.newAddrs())) {
                    throw AccountServiceException.DISTRIBUTION_LIST_EXISTS(newEmail);
                }
            }
            attrs.put("uid", newLocal);
            String oldDn = dl.getDN();
            String newDn = this.mDIT.distributionListDNRename(oldDn, newLocal, domain.getName());
            boolean bl = dnChanged = !oldDn.equals(newDn);
            if (dnChanged) {
                zlc.renameEntry(oldDn, newDn);
            }
            dl = (LdapDistributionList)this.getDistributionListById(zimbraId, zlc);
            this.renameAddressesInAllDistributionLists(oldEmail, newEmail, replacedAliases);
            if (domainChanged) {
                String newUid = dl.getAttr("uid");
                this.moveAliases(zlc, replacedAliases, newDomain, newUid, oldDn, newDn, oldDomain, newDomain);
            }
            try {
                this.modifyAttrsInternal(dl, zlc, attrs);
            }
            catch (ServiceException e) {
                ZimbraLog.account.error((Object)("distribution list renamed to " + newLocal + " but failed to move old name's LDAP attributes"), e);
                throw ServiceException.FAILURE("unable to rename distribution list: " + zimbraId, e);
            }
        }
        catch (NameAlreadyBoundException nabe) {
            try {
                throw AccountServiceException.DISTRIBUTION_LIST_EXISTS(newEmail);
                catch (NamingException e) {
                    throw ServiceException.FAILURE("unable to rename distribution list: " + zimbraId, e);
                }
            }
            catch (Throwable throwable) {
                ZimbraLdapContext.closeContext(zlc);
                throw throwable;
            }
        }
        ZimbraLdapContext.closeContext(zlc);
    }

    @Override
    public DistributionList get(Provisioning.DistributionListBy keyType, String key) throws ServiceException {
        switch (keyType) {
            case id: {
                return this.getDistributionListByIdInternal(key);
            }
            case name: {
                return this.getDistributionListByNameInternal(key);
            }
        }
        return null;
    }

    private DistributionList getDistributionListById(String zimbraId, ZimbraLdapContext zlc) throws ServiceException {
        return this.getDistributionListByQuery(this.mDIT.mailBranchBaseDN(), LdapFilter.distributionListById(zimbraId), zlc, null);
    }

    private DistributionList getDistributionListByIdInternal(String zimbraId) throws ServiceException {
        return this.getDistributionListById(zimbraId, null);
    }

    @Override
    public void deleteDistributionList(String zimbraId) throws ServiceException {
        LdapDistributionList dl = (LdapDistributionList)this.getDistributionListByIdInternal(zimbraId);
        if (dl == null) {
            throw AccountServiceException.NO_SUCH_DISTRIBUTION_LIST(zimbraId);
        }
        this.removeAddressFromAllDistributionLists(dl.getName());
        String[] aliases = dl.getAliases();
        if (aliases != null) {
            String dlName = dl.getName();
            for (int i = 0; i < aliases.length; ++i) {
                if (dlName.equalsIgnoreCase(aliases[i])) continue;
                this.removeAlias(dl, aliases[i]);
            }
        }
        try {
            RightCommand.revokeAllRights(this, GranteeType.GT_GROUP, zimbraId);
        }
        catch (ServiceException e) {
            ZimbraLog.account.warn((Object)"cannot revoke grants", e);
        }
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext(true);
            zlc.unbindEntry(dl.getDN());
        }
        catch (NamingException e) {
            try {
                throw ServiceException.FAILURE("unable to purge distribution list: " + zimbraId, e);
            }
            catch (Throwable throwable) {
                ZimbraLdapContext.closeContext(zlc);
                throw throwable;
            }
        }
        ZimbraLdapContext.closeContext(zlc);
    }

    private DistributionList getDistributionListByNameInternal(String listAddress) throws ServiceException {
        listAddress = IDNUtil.toAsciiEmail(listAddress);
        listAddress = LdapUtil.escapeSearchFilterArg(listAddress);
        return this.getDistributionListByQuery(this.mDIT.mailBranchBaseDN(), LdapFilter.distributionListByName(listAddress), null, null);
    }

    @Override
    public DistributionList getAclGroup(Provisioning.DistributionListBy keyType, String key) throws ServiceException {
        switch (keyType) {
            case id: {
                return this.getAclGroupById(key);
            }
            case name: {
                return this.getAclGroupByName(key);
            }
        }
        return null;
    }

    public DistributionList getFromCache(Provisioning.DistributionListBy keyType, String key) throws ServiceException {
        switch (keyType) {
            case id: {
                return sGroupCache.getById(key);
            }
            case name: {
                return sGroupCache.getByName(key);
            }
        }
        return null;
    }

    private DistributionList getAclGroupById(String groupId) throws ServiceException {
        DistributionList dl = sGroupCache.getById(groupId);
        if (dl == null && (dl = this.getDistributionListByQuery(this.mDIT.mailBranchBaseDN(), LdapFilter.distributionListById(groupId), null, sMinimalDlAttrs)) != null) {
            Provisioning.AclGroups groups = this.computeUpwardMembership(dl);
            dl.setCachedData(DATA_ACLGROUP_LIST, groups);
            dl.turnToAclGroup();
            sGroupCache.put(dl);
        }
        return dl;
    }

    private DistributionList getAclGroupByName(String groupName) throws ServiceException {
        DistributionList dl = sGroupCache.getByName(groupName);
        if (dl == null && (dl = this.getDistributionListByQuery(this.mDIT.mailBranchBaseDN(), LdapFilter.distributionListByName(groupName), null, sMinimalDlAttrs)) != null) {
            Provisioning.AclGroups groups = this.computeUpwardMembership(dl);
            dl.setCachedData(DATA_ACLGROUP_LIST, groups);
            dl.turnToAclGroup();
            sGroupCache.put(dl);
        }
        return dl;
    }

    private Provisioning.AclGroups computeUpwardMembership(DistributionList list) throws ServiceException {
        HashMap<String, String> via = new HashMap<String, String>();
        List<DistributionList> lists = this.getDistributionLists(list, false, via, true);
        return this.computeUpwardMembership(lists, via);
    }

    private Provisioning.AclGroups computeUpwardMembership(List<DistributionList> lists, Map<String, String> via) {
        ArrayList<Provisioning.MemberOf> groups = new ArrayList();
        ArrayList<String> groupIds = new ArrayList();
        for (DistributionList dl : lists) {
            boolean isAdminGroup = dl.getBooleanAttr("zimbraIsAdminGroup", false);
            groups.add(new Provisioning.MemberOf(dl.getId(), isAdminGroup));
            groupIds.add(dl.getId());
        }
        groups = Collections.unmodifiableList(groups);
        groupIds = Collections.unmodifiableList(groupIds);
        return new Provisioning.AclGroups(groups, groupIds);
    }

    private Provisioning.AclGroups getAdminAclGroups(Provisioning.AclGroups aclGroups) {
        List<Provisioning.MemberOf> groups = new ArrayList();
        ArrayList<String> groupIds = new ArrayList();
        List<Provisioning.MemberOf> memberOf = aclGroups.memberOf();
        for (Provisioning.MemberOf mo : memberOf) {
            if (!mo.isAdminGroup()) continue;
            groups.add(mo);
            groupIds.add(mo.getId());
        }
        groups = Collections.unmodifiableList(groups);
        groupIds = Collections.unmodifiableList(groupIds);
        return new Provisioning.AclGroups(groups, groupIds);
    }

    @Override
    public Provisioning.AclGroups getAclGroups(Account acct, boolean adminGroupsOnly) throws ServiceException {
        String cacheKey = adminGroupsOnly ? DATA_ACLGROUP_LIST_ADMINS_ONLY : DATA_ACLGROUP_LIST;
        Provisioning.AclGroups dls = (Provisioning.AclGroups)acct.getCachedData(cacheKey);
        if (dls != null) {
            return dls;
        }
        HashMap<String, String> via = new HashMap<String, String>();
        List<DistributionList> lists = this.getDistributionLists(acct, false, via, true);
        dls = this.computeUpwardMembership(lists, via);
        if (adminGroupsOnly) {
            dls = this.getAdminAclGroups(dls);
        }
        acct.setCachedData(cacheKey, dls);
        return dls;
    }

    @Override
    public Provisioning.AclGroups getAclGroups(DistributionList list, boolean adminGroupsOnly) throws ServiceException {
        if (!list.isAclGroup()) {
            throw ServiceException.FAILURE("internal error", null);
        }
        String cacheKey = adminGroupsOnly ? DATA_ACLGROUP_LIST_ADMINS_ONLY : DATA_ACLGROUP_LIST;
        Provisioning.AclGroups dls = (Provisioning.AclGroups)list.getCachedData(cacheKey);
        if (dls != null) {
            return dls;
        }
        DistributionList dl = this.get(Provisioning.DistributionListBy.id, list.getId());
        if (dl == null) {
            throw AccountServiceException.NO_SUCH_DISTRIBUTION_LIST(list.getName());
        }
        dls = this.computeUpwardMembership(dl);
        if (adminGroupsOnly) {
            dls = this.getAdminAclGroups(dls);
        }
        dl.setCachedData(cacheKey, dls);
        return dls;
    }

    @Override
    public Server getLocalServer() throws ServiceException {
        Server local;
        String hostname = LC.zimbra_server_hostname.value();
        if (hostname == null) {
            Zimbra.halt("zimbra_server_hostname not specified in localconfig.xml");
        }
        if ((local = this.getServerByNameInternal(hostname)) == null) {
            Zimbra.halt("Could not find an LDAP entry for server '" + hostname + "'");
        }
        return local;
    }

    private void checkAccountStatus(Account acct, Map<String, Object> authCtxt) throws ServiceException {
        String accountStatus = acct.getAccountStatus(Provisioning.getInstance());
        if (accountStatus == null) {
            throw AccountServiceException.AuthFailedServiceException.AUTH_FAILED(acct.getName(), AuthMechanism.namePassedIn(authCtxt), "missing account status");
        }
        if (accountStatus.equals("maintenance")) {
            throw AccountServiceException.MAINTENANCE_MODE();
        }
        if (!accountStatus.equals("active") && !accountStatus.equals("lockout")) {
            throw AccountServiceException.AuthFailedServiceException.AUTH_FAILED(acct.getName(), AuthMechanism.namePassedIn(authCtxt), "account(or domain) status is " + accountStatus);
        }
    }

    @Override
    public void preAuthAccount(Account acct, String acctValue, String acctBy, long timestamp, long expires, String preAuth, Map<String, Object> authCtxt) throws ServiceException {
        this.preAuthAccount(acct, acctValue, acctBy, timestamp, expires, preAuth, false, authCtxt);
    }

    @Override
    public void preAuthAccount(Account acct, String acctValue, String acctBy, long timestamp, long expires, String preAuth, boolean admin, Map<String, Object> authCtxt) throws ServiceException {
        try {
            this.preAuth(acct, acctValue, acctBy, timestamp, expires, preAuth, admin, authCtxt);
            ZimbraLog.security.info(ZimbraLog.encodeAttrs(new String[]{"cmd", "PreAuth", "account", acct.getName(), "admin", admin + ""}));
        }
        catch (AccountServiceException.AuthFailedServiceException e) {
            ZimbraLog.security.warn(ZimbraLog.encodeAttrs(new String[]{"cmd", "PreAuth", "account", acct.getName(), "admin", admin + "", "error", e.getMessage() + e.getReason(", %s")}));
            throw e;
        }
        catch (ServiceException e) {
            ZimbraLog.security.warn(ZimbraLog.encodeAttrs(new String[]{"cmd", "PreAuth", "account", acct.getName(), "admin", admin + "", "error", e.getMessage()}));
            throw e;
        }
    }

    private void verifyPreAuth(Account acct, String acctValue, String acctBy, long timestamp, long expires, String preAuth, boolean admin, Map<String, Object> authCtxt) throws ServiceException {
        this.checkAccountStatus(acct, authCtxt);
        if (preAuth == null || preAuth.length() == 0) {
            throw ServiceException.INVALID_REQUEST("preAuth must not be empty", null);
        }
        Provisioning prov = Provisioning.getInstance();
        String domainPreAuthKey = prov.getDomain(acct).getAttr("zimbraPreAuthKey", null);
        if (domainPreAuthKey == null) {
            throw ServiceException.INVALID_REQUEST("domain is not configured for preauth", null);
        }
        long now = System.currentTimeMillis();
        long diff = Math.abs(now - timestamp);
        if (diff > 300000L) {
            Date nowDate = new Date(now);
            Date preauthDate = new Date(timestamp);
            throw AccountServiceException.AuthFailedServiceException.AUTH_FAILED(acct.getName(), AuthMechanism.namePassedIn(authCtxt), "preauth timestamp is too old, server time: " + nowDate.toString() + ", preauth timestamp: " + preauthDate.toString());
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("account", acctValue);
        if (admin) {
            params.put("admin", "1");
        }
        params.put("by", acctBy);
        params.put("timestamp", timestamp + "");
        params.put("expires", expires + "");
        String computedPreAuth = PreAuthKey.computePreAuth(params, domainPreAuthKey);
        if (!computedPreAuth.equalsIgnoreCase(preAuth)) {
            throw AccountServiceException.AuthFailedServiceException.AUTH_FAILED(acct.getName(), AuthMechanism.namePassedIn(authCtxt), "preauth mismatch");
        }
    }

    private void preAuth(Account acct, String acctValue, String acctBy, long timestamp, long expires, String preAuth, boolean admin, Map<String, Object> authCtxt) throws ServiceException {
        LdapLockoutPolicy lockoutPolicy = new LdapLockoutPolicy(this, acct);
        try {
            if (lockoutPolicy.isLockedOut()) {
                throw AccountServiceException.AuthFailedServiceException.AUTH_FAILED(acct.getName(), AuthMechanism.namePassedIn(authCtxt), "account lockout");
            }
            this.verifyPreAuth(acct, acctValue, acctBy, timestamp, expires, preAuth, admin, authCtxt);
            lockoutPolicy.successfulLogin();
        }
        catch (AccountServiceException e) {
            lockoutPolicy.failedLogin();
            throw e;
        }
        this.updateLastLogon(acct);
    }

    @Override
    public void authAccount(Account acct, String password, AuthContext.Protocol proto) throws ServiceException {
        this.authAccount(acct, password, proto, null);
    }

    @Override
    public void authAccount(Account acct, String password, AuthContext.Protocol proto, Map<String, Object> authCtxt) throws ServiceException {
        try {
            if (password == null || password.equals("")) {
                throw AccountServiceException.AuthFailedServiceException.AUTH_FAILED(acct.getName(), AuthMechanism.namePassedIn(authCtxt), "empty password");
            }
            if (authCtxt == null) {
                authCtxt = new HashMap<String, Object>();
            }
            authCtxt.put("proto", (Object)proto);
            this.authAccount(acct, password, true, authCtxt);
            ZimbraLog.security.info(ZimbraLog.encodeAttrs(new String[]{"cmd", "Auth", "account", acct.getName(), "protocol", proto.toString()}));
        }
        catch (AccountServiceException.AuthFailedServiceException e) {
            ZimbraLog.security.warn(ZimbraLog.encodeAttrs(new String[]{"cmd", "Auth", "account", acct.getName(), "protocol", proto.toString(), "error", e.getMessage() + e.getReason(", %s")}));
            throw e;
        }
        catch (ServiceException e) {
            ZimbraLog.security.warn(ZimbraLog.encodeAttrs(new String[]{"cmd", "Auth", "account", acct.getName(), "protocol", proto.toString(), "error", e.getMessage()}));
            throw e;
        }
    }

    private void authAccount(Account acct, String password, boolean checkPasswordPolicy, Map<String, Object> authCtxt) throws ServiceException {
        this.checkAccountStatus(acct, authCtxt);
        AuthMechanism authMech = AuthMechanism.makeInstance(acct);
        this.verifyPassword(acct, password, authMech, authCtxt);
        if (!checkPasswordPolicy) {
            return;
        }
        if (authMech.checkPasswordAging()) {
            long curr;
            long last;
            Date lastChange;
            int maxAge = acct.getIntAttr("zimbraPasswordMaxAge", 0);
            if (maxAge > 0 && (lastChange = acct.getGeneralizedTimeAttr("zimbraPasswordModifiedTime", null)) != null && (last = lastChange.getTime()) + 86400000L * (long)maxAge < (curr = System.currentTimeMillis())) {
                throw AccountServiceException.CHANGE_PASSWORD();
            }
            boolean mustChange = acct.getBooleanAttr("zimbraPasswordMustChange", false);
            if (mustChange) {
                throw AccountServiceException.CHANGE_PASSWORD();
            }
        }
        this.updateLastLogon(acct);
    }

    @Override
    public void accountAuthed(Account acct) throws ServiceException {
        this.updateLastLogon(acct);
    }

    private void updateLastLogon(Account acct) throws ServiceException {
        Config config = Provisioning.getInstance().getConfig();
        long freq = config.getTimeInterval("zimbraLastLogonTimestampFrequency", 604800000L);
        if (freq == 0L) {
            return;
        }
        Date lastLogon = acct.getGeneralizedTimeAttr("zimbraLastLogonTimestamp", null);
        if (lastLogon == null) {
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put("zimbraLastLogonTimestamp", DateUtil.toGeneralizedTime(new Date()));
            try {
                this.modifyAttrs(acct, attrs);
            }
            catch (ServiceException e) {
                ZimbraLog.account.warn((Object)"updating zimbraLastLogonTimestamp", e);
            }
        } else {
            long current = System.currentTimeMillis();
            if (current - freq >= lastLogon.getTime()) {
                HashMap<String, String> attrs = new HashMap<String, String>();
                attrs.put("zimbraLastLogonTimestamp", DateUtil.toGeneralizedTime(new Date()));
                try {
                    this.modifyAttrs(acct, attrs);
                }
                catch (ServiceException e) {
                    ZimbraLog.account.warn((Object)"updating zimbraLastLogonTimestamp", e);
                }
            }
        }
    }

    public void externalLdapAuth(Domain d, String authMech, Account acct, String password, Map<String, Object> authCtxt) throws ServiceException {
        String[] url = d.getMultiAttr("zimbraAuthLdapURL");
        if (url == null || url.length == 0) {
            String msg = "attr not set zimbraAuthLdapURL";
            ZimbraLog.account.fatal(msg);
            throw ServiceException.FAILURE(msg, null);
        }
        boolean requireStartTLS = d.getBooleanAttr("zimbraAuthLdapStartTlsEnabled", false);
        try {
            String externalDn = acct.getAttr("zimbraAuthLdapExternalDn");
            if (externalDn != null) {
                if (ZimbraLog.account.isDebugEnabled()) {
                    ZimbraLog.account.debug("auth with explicit dn of " + externalDn);
                }
                LdapUtil.ldapAuthenticate(url, requireStartTLS, externalDn, password);
                return;
            }
            String searchFilter = d.getAttr("zimbraAuthLdapSearchFilter");
            if (searchFilter != null && !"ad".equals(authMech)) {
                String searchPassword = d.getAttr("zimbraAuthLdapSearchBindPassword");
                String searchDn = d.getAttr("zimbraAuthLdapSearchBindDn");
                String searchBase = d.getAttr("zimbraAuthLdapSearchBase");
                if (searchBase == null) {
                    searchBase = "";
                }
                searchFilter = LdapUtil.computeAuthDn(acct.getName(), searchFilter);
                if (ZimbraLog.account.isDebugEnabled()) {
                    ZimbraLog.account.debug("auth with search filter of " + searchFilter);
                }
                LdapUtil.ldapAuthenticate(url, requireStartTLS, password, searchBase, searchFilter, searchDn, searchPassword);
                return;
            }
            String bindDn = d.getAttr("zimbraAuthLdapBindDn");
            if (bindDn != null) {
                String dn = LdapUtil.computeAuthDn(acct.getName(), bindDn);
                if (ZimbraLog.account.isDebugEnabled()) {
                    ZimbraLog.account.debug("auth with bind dn template of " + dn);
                }
                LdapUtil.ldapAuthenticate(url, requireStartTLS, dn, password);
                return;
            }
        }
        catch (AuthenticationException e) {
            throw AccountServiceException.AuthFailedServiceException.AUTH_FAILED(acct.getName(), AuthMechanism.namePassedIn(authCtxt), "external LDAP auth failed, " + e.getMessage(), e);
        }
        catch (AuthenticationNotSupportedException e) {
            throw AccountServiceException.AuthFailedServiceException.AUTH_FAILED(acct.getName(), AuthMechanism.namePassedIn(authCtxt), "external LDAP auth failed, " + e.getMessage(), e);
        }
        catch (NamingException e) {
            throw ServiceException.FAILURE(e.getMessage(), e);
        }
        catch (IOException e) {
            throw ServiceException.FAILURE(e.getMessage(), e);
        }
        String msg = "one of the following attrs must be set zimbraAuthLdapBindDn, zimbraAuthLdapSearchFilter";
        ZimbraLog.account.fatal(msg);
        throw ServiceException.FAILURE(msg, null);
    }

    private void verifyPassword(Account acct, String password, AuthMechanism authMech, Map<String, Object> authCtxt) throws ServiceException {
        LdapLockoutPolicy lockoutPolicy = new LdapLockoutPolicy(this, acct);
        try {
            if (lockoutPolicy.isLockedOut()) {
                throw AccountServiceException.AuthFailedServiceException.AUTH_FAILED(acct.getName(), AuthMechanism.namePassedIn(authCtxt), "account lockout");
            }
            this.verifyPasswordInternal(acct, password, authMech, authCtxt);
            lockoutPolicy.successfulLogin();
        }
        catch (AccountServiceException e) {
            lockoutPolicy.failedLogin();
            throw e;
        }
    }

    private void verifyPasswordInternal(Account acct, String password, AuthMechanism authMech, Map<String, Object> context) throws ServiceException {
        Domain domain = Provisioning.getInstance().getDomain(acct);
        boolean allowFallback = true;
        if (!authMech.isZimbraAuth()) {
            allowFallback = domain.getBooleanAttr("zimbraAuthFallbackToLocal", false) || acct.getBooleanAttr("zimbraIsAdminAccount", false) || acct.getBooleanAttr("zimbraIsDomainAdminAccount", false);
        }
        try {
            authMech.doAuth(this, domain, acct, password, context);
            return;
        }
        catch (ServiceException e) {
            if (!allowFallback || authMech.isZimbraAuth()) {
                throw e;
            }
            ZimbraLog.account.warn((Object)(authMech.getMechanism() + " auth for domain " + domain.getName() + " failed, fall back to zimbra default auth mechanism"), e);
            AuthMechanism.doZimbraAuth(this, domain, acct, password, context);
            return;
        }
    }

    public static String expandStr(String fmt, Map vars) {
        if (fmt == null || fmt.equals("")) {
            return fmt;
        }
        if (fmt.indexOf(37) == -1) {
            return fmt;
        }
        StringBuffer sb = new StringBuffer(fmt.length() + 32);
        for (int i = 0; i < fmt.length(); ++i) {
            char ch = fmt.charAt(i);
            if (ch == '%') {
                if (++i > fmt.length()) {
                    return sb.toString();
                }
                ch = fmt.charAt(i);
                if (ch != '%') {
                    String val = (String)vars.get(Character.toString(ch));
                    if (val != null) {
                        sb.append(val);
                        continue;
                    }
                    sb.append(ch);
                    continue;
                }
                sb.append(ch);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    @Override
    public void changePassword(Account acct, String currentPassword, String newPassword) throws ServiceException {
        this.authAccount(acct, currentPassword, false, null);
        boolean locked = acct.getBooleanAttr("zimbraPasswordLocked", false);
        if (locked) {
            throw AccountServiceException.PASSWORD_LOCKED();
        }
        this.setPassword(acct, newPassword, true);
    }

    private void checkHistory(String newPassword, String[] history) throws AccountServiceException {
        if (history == null) {
            return;
        }
        for (int i = 0; i < history.length; ++i) {
            String encoded;
            int sepIndex = history[i].indexOf(58);
            if (sepIndex == -1 || !PasswordUtil.SSHA.verifySSHA(encoded = history[i].substring(sepIndex + 1), newPassword)) continue;
            throw AccountServiceException.PASSWORD_RECENTLY_USED();
        }
    }

    private String[] updateHistory(String[] history, String currentPassword, int maxHistory) {
        String[] newHistory = history;
        if (currentPassword == null) {
            return null;
        }
        String currentHistory = System.currentTimeMillis() + ":" + currentPassword;
        if (history == null || history.length < maxHistory) {
            if (history == null) {
                newHistory = new String[1];
            } else {
                newHistory = new String[history.length + 1];
                System.arraycopy(history, 0, newHistory, 0, history.length);
            }
            newHistory[newHistory.length - 1] = currentHistory;
            return newHistory;
        }
        long min = Long.MAX_VALUE;
        int minIndex = -1;
        for (int i = 0; i < history.length; ++i) {
            int sepIndex = history[i].indexOf(58);
            if (sepIndex == -1) {
                minIndex = i;
                break;
            }
            long val = Long.parseLong(history[i].substring(0, sepIndex));
            if (val >= min) continue;
            min = val;
            minIndex = i;
        }
        if (minIndex == -1) {
            minIndex = 0;
        }
        history[minIndex] = currentHistory;
        return history;
    }

    @Override
    public void setPassword(Account acct, String newPassword) throws ServiceException {
        this.setPassword(acct, newPassword, false);
    }

    @Override
    public void checkPasswordStrength(Account acct, String password) throws ServiceException {
        this.checkPasswordStrength(password, acct, null, null);
    }

    private int getInt(Account acct, Cos cos, Attributes attrs, String name, int defaultValue) throws NamingException {
        if (acct != null) {
            return acct.getIntAttr(name, defaultValue);
        }
        String v = LdapUtil.getAttrString(attrs, name);
        if (v == null) {
            return cos.getIntAttr(name, defaultValue);
        }
        try {
            return Integer.parseInt(v);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private void checkPasswordStrength(String password, Account acct, Cos cos, Attributes attrs) throws ServiceException {
        try {
            int minLength = this.getInt(acct, cos, attrs, "zimbraPasswordMinLength", 0);
            if (minLength > 0 && password.length() < minLength) {
                throw AccountServiceException.INVALID_PASSWORD("too short", new ServiceException.Argument("zimbraPasswordMinLength", minLength, ServiceException.Argument.Type.NUM));
            }
            int maxLength = this.getInt(acct, cos, attrs, "zimbraPasswordMaxLength", 0);
            if (maxLength > 0 && password.length() > maxLength) {
                throw AccountServiceException.INVALID_PASSWORD("too long", new ServiceException.Argument("zimbraPasswordMaxLength", maxLength, ServiceException.Argument.Type.NUM));
            }
            int minUpperCase = this.getInt(acct, cos, attrs, "zimbraPasswordMinUpperCaseChars", 0);
            int minLowerCase = this.getInt(acct, cos, attrs, "zimbraPasswordMinLowerCaseChars", 0);
            int minNumeric = this.getInt(acct, cos, attrs, "zimbraPasswordMinNumericChars", 0);
            int minPunctuation = this.getInt(acct, cos, attrs, "zimbraPasswordMinPunctuationChars", 0);
            if (minUpperCase > 0 || minLowerCase > 0 || minPunctuation > 0 || minNumeric > 0) {
                int upper = 0;
                int lower = 0;
                int punctuation = 0;
                int numeric = 0;
                for (int i = 0; i < password.length(); ++i) {
                    char ch = password.charAt(i);
                    if (Character.isUpperCase((int)ch)) {
                        ++upper;
                        continue;
                    }
                    if (Character.isLowerCase((int)ch)) {
                        ++lower;
                        continue;
                    }
                    if (Character.isDigit((int)ch)) {
                        ++numeric;
                        continue;
                    }
                    if (!this.isAsciiPunc(ch)) continue;
                    ++punctuation;
                }
                if (upper < minUpperCase) {
                    throw AccountServiceException.INVALID_PASSWORD("not enough upper case characters", new ServiceException.Argument("zimbraPasswordMinUpperCaseChars", minUpperCase, ServiceException.Argument.Type.NUM));
                }
                if (lower < minLowerCase) {
                    throw AccountServiceException.INVALID_PASSWORD("not enough lower case characters", new ServiceException.Argument("zimbraPasswordMinLowerCaseChars", minLowerCase, ServiceException.Argument.Type.NUM));
                }
                if (numeric < minNumeric) {
                    throw AccountServiceException.INVALID_PASSWORD("not enough numeric characters", new ServiceException.Argument("zimbraPasswordMinNumericChars", minNumeric, ServiceException.Argument.Type.NUM));
                }
                if (punctuation < minPunctuation) {
                    throw AccountServiceException.INVALID_PASSWORD("not enough punctuation characters", new ServiceException.Argument("zimbraPasswordMinPunctuationChars", minPunctuation, ServiceException.Argument.Type.NUM));
                }
            }
        }
        catch (NamingException ne) {
            throw ServiceException.FAILURE(ne.getMessage(), ne);
        }
    }

    private boolean isAsciiPunc(int ch) {
        return ch >= 33 && ch <= 47 || ch >= 58 && ch <= 64 || ch >= 91 && ch <= 96 || ch >= 123 && ch <= 126;
    }

    private void setInitialPassword(Cos cos, Attributes attrs, String newPassword) throws ServiceException, NamingException {
        String userPassword = LdapUtil.getAttrString(attrs, "userPassword");
        if (userPassword == null && (newPassword == null || "".equals(newPassword))) {
            return;
        }
        if (userPassword == null) {
            this.checkPasswordStrength(newPassword, null, cos, attrs);
            userPassword = PasswordUtil.SSHA.generateSSHA(newPassword, null);
        }
        attrs.put("userPassword", userPassword);
        attrs.put("zimbraPasswordModifiedTime", DateUtil.toGeneralizedTime(new Date()));
    }

    void setPassword(Account acct, String newPassword, boolean enforcePolicy) throws ServiceException {
        boolean mustChange = acct.getBooleanAttr("zimbraPasswordMustChange", false);
        if (enforcePolicy) {
            long curr;
            long last;
            Date lastChange;
            int minAge;
            this.checkPasswordStrength(newPassword, acct, null, null);
            if (!mustChange && (minAge = acct.getIntAttr("zimbraPasswordMinAge", 0)) > 0 && (lastChange = acct.getGeneralizedTimeAttr("zimbraPasswordModifiedTime", null)) != null && (last = lastChange.getTime()) + 86400000L * (long)minAge > (curr = System.currentTimeMillis())) {
                throw AccountServiceException.PASSWORD_CHANGE_TOO_SOON();
            }
        }
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        int enforceHistory = acct.getIntAttr("zimbraPasswordEnforceHistory", 0);
        if (enforceHistory > 0) {
            String[] newHistory = this.updateHistory(acct.getMultiAttr("zimbraPasswordHistory"), acct.getAttr("userPassword"), enforceHistory);
            attrs.put("zimbraPasswordHistory", newHistory);
            this.checkHistory(newPassword, newHistory);
        }
        String encodedPassword = PasswordUtil.SSHA.generateSSHA(newPassword, null);
        if (mustChange) {
            attrs.put("zimbraPasswordMustChange", "");
        }
        attrs.put("userPassword", encodedPassword);
        attrs.put("zimbraPasswordModifiedTime", DateUtil.toGeneralizedTime(new Date()));
        acct.setAuthTokenValidityValue(acct.getAuthTokenValidityValue() + 1, attrs);
        ChangePasswordListener cpListener = ChangePasswordListener.getHandler(acct);
        HashMap context = null;
        if (cpListener != null) {
            context = new HashMap();
            cpListener.preModify(acct, newPassword, context, attrs);
        }
        this.modifyAttrs(acct, attrs);
        if (cpListener != null) {
            cpListener.postModify(acct, newPassword, context);
        }
    }

    @Override
    public Zimlet getZimlet(String name) throws ServiceException {
        return this.getZimlet(name, null, true);
    }

    private Zimlet getFromCache(Provisioning.ZimletBy keyType, String key) throws ServiceException {
        switch (keyType) {
            case name: {
                return sZimletCache.getByName(key);
            }
            case id: {
                return sZimletCache.getById(key);
            }
        }
        return null;
    }

    Zimlet lookupZimlet(String name, ZimbraLdapContext zlc) throws ServiceException {
        return this.getZimlet(name, zlc, false);
    }

    private Zimlet getZimlet(String name, ZimbraLdapContext initZlc, boolean useCache) throws ServiceException {
        LdapZimlet zimlet = sZimletCache.getByName(name);
        if (!useCache || zimlet == null) {
            ZimbraLdapContext zlc = initZlc;
            try {
                if (zlc == null) {
                    zlc = new ZimbraLdapContext();
                }
                String dn = this.mDIT.zimletNameToDN(name);
                Attributes attrs = zlc.getAttributes(dn);
                zimlet = new LdapZimlet(dn, attrs, (Provisioning)this);
                if (useCache) {
                    ZimletUtil.reloadZimlet(name);
                    sZimletCache.put(zimlet);
                }
            }
            catch (NameNotFoundException nnfe) {
                Zimlet zimlet2 = null;
                return zimlet2;
            }
            catch (NamingException ne) {
                throw ServiceException.FAILURE("unable to get zimlet: " + name, ne);
            }
            catch (ZimletException ze) {
                throw ServiceException.FAILURE("unable to load zimlet: " + name, ze);
            }
            finally {
                if (initZlc == null) {
                    ZimbraLdapContext.closeContext(zlc);
                }
            }
        }
        return zimlet;
    }

    @Override
    public List<Zimlet> listAllZimlets() throws ServiceException {
        ArrayList<Zimlet> result = new ArrayList<Zimlet>();
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext();
            NamingEnumeration<SearchResult> ne = zlc.searchDir(this.mDIT.zimletBaseDN(), LdapFilter.allZimlets(), sSubtreeSC);
            while (ne.hasMore()) {
                SearchResult sr = ne.next();
                result.add(new LdapZimlet(sr.getNameInNamespace(), sr.getAttributes(), (Provisioning)this));
            }
            ne.close();
        }
        catch (NamingException e) {
            throw ServiceException.FAILURE("unable to list all zimlets", e);
        }
        finally {
            ZimbraLdapContext.closeContext(zlc);
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public Zimlet createZimlet(String name, Map<String, Object> zimletAttrs) throws ServiceException {
        name = name.toLowerCase().trim();
        HashMap attrManagerContext = new HashMap();
        AttributeManager.getInstance().preModify(zimletAttrs, null, attrManagerContext, true, true);
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext();
            BasicAttributes attrs = new BasicAttributes(true);
            String hasKeyword = "FALSE";
            if (zimletAttrs.containsKey("zimbraZimletKeyword")) {
                hasKeyword = "TRUE";
            }
            LdapUtil.mapToAttrs(zimletAttrs, attrs);
            LdapUtil.addAttr((Attributes)attrs, "objectClass", "zimbraZimletEntry");
            LdapUtil.addAttr((Attributes)attrs, "zimbraZimletEnabled", "FALSE");
            LdapUtil.addAttr((Attributes)attrs, "zimbraZimletIndexingEnabled", hasKeyword);
            LdapUtil.addAttr((Attributes)attrs, "zimbraCreateTimestamp", DateUtil.toGeneralizedTime(new Date()));
            String dn = this.mDIT.zimletNameToDN(name);
            zlc.createEntry(dn, attrs, "createZimlet");
            Zimlet zimlet = this.lookupZimlet(name, zlc);
            AttributeManager.getInstance().postModify(zimletAttrs, zimlet, attrManagerContext, true);
            Zimlet zimlet2 = zimlet;
            return zimlet2;
        }
        catch (NameAlreadyBoundException nabe) {
            throw ServiceException.FAILURE("zimlet already exists: " + name, nabe);
        }
        catch (ServiceException se) {
            throw se;
        }
        finally {
            ZimbraLdapContext.closeContext(zlc);
        }
    }

    @Override
    public void deleteZimlet(String name) throws ServiceException {
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext();
            LdapZimlet zimlet = (LdapZimlet)this.getZimlet(name, zlc, true);
            if (zimlet != null) {
                sZimletCache.remove(zimlet);
                zlc.unbindEntry(zimlet.getDN());
            }
        }
        catch (NamingException e) {
            throw ServiceException.FAILURE("unable to delete zimlet: " + name, e);
        }
        finally {
            ZimbraLdapContext.closeContext(zlc);
        }
    }

    @Override
    public CalendarResource createCalendarResource(String emailAddress, String password, Map<String, Object> calResAttrs) throws ServiceException {
        emailAddress = emailAddress.toLowerCase().trim();
        calResAttrs.put("zimbraAccountCalendarUserType", ZAttrProvisioning.AccountCalendarUserType.RESOURCE.toString());
        SpecialAttrs specialAttrs = this.mDIT.handleSpecialAttrs(calResAttrs);
        HashMap attrManagerContext = new HashMap();
        Set<String> ocs = LdapObjectClass.getCalendarResourceObjectClasses(this);
        Account acct = this.createAccount(emailAddress, password, calResAttrs, specialAttrs, ocs.toArray(new String[0]), false, null);
        LdapCalendarResource resource = (LdapCalendarResource)this.getCalendarResourceById(acct.getId(), true);
        AttributeManager.getInstance().postModify(calResAttrs, resource, attrManagerContext, true);
        return resource;
    }

    @Override
    public void deleteCalendarResource(String zimbraId) throws ServiceException {
        this.deleteAccount(zimbraId);
    }

    @Override
    public void renameCalendarResource(String zimbraId, String newName) throws ServiceException {
        this.renameAccount(zimbraId, newName);
    }

    @Override
    public CalendarResource get(Provisioning.CalendarResourceBy keyType, String key) throws ServiceException {
        return this.get(keyType, key, false);
    }

    @Override
    public CalendarResource get(Provisioning.CalendarResourceBy keyType, String key, boolean loadFromMaster) throws ServiceException {
        switch (keyType) {
            case id: {
                return this.getCalendarResourceById(key, loadFromMaster);
            }
            case foreignPrincipal: {
                return this.getCalendarResourceByForeignPrincipal(key, loadFromMaster);
            }
            case name: {
                return this.getCalendarResourceByName(key, loadFromMaster);
            }
        }
        return null;
    }

    private CalendarResource getCalendarResourceById(String zimbraId, boolean loadFromMaster) throws ServiceException {
        if (zimbraId == null) {
            return null;
        }
        LdapCalendarResource resource = (LdapCalendarResource)sAccountCache.getById(zimbraId);
        if (resource == null) {
            zimbraId = LdapUtil.escapeSearchFilterArg(zimbraId);
            resource = (LdapCalendarResource)this.getAccountByQuery(this.mDIT.mailBranchBaseDN(), LdapFilter.calendarResourceById(zimbraId), null, loadFromMaster);
            sAccountCache.put(resource);
        }
        return resource;
    }

    private CalendarResource getCalendarResourceByName(String emailAddress, boolean loadFromMaster) throws ServiceException {
        LdapCalendarResource resource = (LdapCalendarResource)sAccountCache.getByName(emailAddress = this.fixupAccountName(emailAddress));
        if (resource == null) {
            emailAddress = LdapUtil.escapeSearchFilterArg(emailAddress);
            resource = (LdapCalendarResource)this.getAccountByQuery(this.mDIT.mailBranchBaseDN(), LdapFilter.calendarResourceByName(emailAddress), null, loadFromMaster);
            sAccountCache.put(resource);
        }
        return resource;
    }

    private CalendarResource getCalendarResourceByForeignPrincipal(String foreignPrincipal, boolean loadFromMaster) throws ServiceException {
        foreignPrincipal = LdapUtil.escapeSearchFilterArg(foreignPrincipal);
        LdapCalendarResource resource = (LdapCalendarResource)this.getAccountByQuery(this.mDIT.mailBranchBaseDN(), LdapFilter.calendarResourceByForeignPrincipal(foreignPrincipal), null, loadFromMaster);
        sAccountCache.put(resource);
        return resource;
    }

    @Override
    public List<NamedEntry> searchCalendarResources(EntrySearchFilter filter, String[] returnAttrs, String sortAttr, boolean sortAscending) throws ServiceException {
        return this.searchCalendarResources(filter, returnAttrs, sortAttr, sortAscending, this.mDIT.mailBranchBaseDN());
    }

    List<NamedEntry> searchCalendarResources(EntrySearchFilter filter, String[] returnAttrs, String sortAttr, boolean sortAscending, String base) throws ServiceException {
        String query = LdapEntrySearchFilter.toLdapCalendarResourcesFilter(filter);
        return this.searchObjects(query, returnAttrs, sortAttr, sortAscending, base, 8, 0);
    }

    private Account makeAccount(String dn, Attributes attrs, LdapProvisioning prov) throws NamingException, ServiceException {
        return this.makeAccount(dn, attrs, 0, prov);
    }

    private Account makeAccountNoDefaults(String dn, Attributes attrs, LdapProvisioning prov) throws NamingException, ServiceException {
        return this.makeAccount(dn, attrs, 768, prov);
    }

    private Account makeAccount(String dn, Attributes attrs, int flags, LdapProvisioning prov) throws NamingException, ServiceException {
        Attribute a = attrs.get("zimbraAccountCalendarUserType");
        boolean isAccount = a == null || a.contains(ZAttrProvisioning.AccountCalendarUserType.USER.toString());
        String emailAddress = LdapUtil.getAttrString(attrs, "zimbraMailDeliveryAddress");
        if (emailAddress == null) {
            emailAddress = this.mDIT.dnToEmail(dn, attrs);
        }
        Account acct = isAccount ? new LdapAccount(dn, emailAddress, attrs, null, (Provisioning)this) : new LdapCalendarResource(dn, emailAddress, attrs, null, (Provisioning)this);
        this.setAccountDefaults(acct, flags);
        return acct;
    }

    public void setAccountDefaults(Account acct, int flags) throws ServiceException {
        boolean dontSetDefaults;
        boolean bl = dontSetDefaults = (flags & 0x100) == 256;
        if (dontSetDefaults) {
            return;
        }
        boolean dontSetSecondaryDefaults = (flags & 0x200) == 512;
        Cos cos = this.getCOS(acct);
        Map<String, Object> defaults = null;
        if (cos != null) {
            defaults = cos.getAccountDefaults();
        }
        if (dontSetSecondaryDefaults) {
            acct.setDefaults(defaults);
        } else {
            Map<String, Object> secondaryDefaults = null;
            Domain domain = this.getDomain(acct);
            if (domain != null) {
                secondaryDefaults = domain.getAccountDefaults();
            }
            acct.setDefaults(defaults, secondaryDefaults);
        }
    }

    private Alias makeAlias(String dn, Attributes attrs, LdapProvisioning prov) throws NamingException, ServiceException {
        String emailAddress = this.mDIT.dnToEmail(dn, attrs);
        LdapAlias alias = new LdapAlias(dn, emailAddress, attrs, (Provisioning)prov);
        return alias;
    }

    private DistributionList makeDistributionList(String dn, Attributes attrs, LdapProvisioning prov) throws NamingException, ServiceException {
        String emailAddress = this.mDIT.dnToEmail(dn, attrs);
        LdapDistributionList dl = new LdapDistributionList(dn, emailAddress, attrs, (Provisioning)this);
        return dl;
    }

    protected void renameAddressesInAllDistributionLists(String oldName, String newName, ReplaceAddressResult replacedAliasPairs) {
        HashMap<String, String> changedPairs = new HashMap<String, String>();
        changedPairs.put(oldName, newName);
        for (int i = 0; i < replacedAliasPairs.oldAddrs().length; ++i) {
            String newAddr;
            String oldAddr = replacedAliasPairs.oldAddrs()[i];
            if (oldAddr.equals(newAddr = replacedAliasPairs.newAddrs()[i])) continue;
            changedPairs.put(oldAddr, newAddr);
        }
        this.renameAddressesInAllDistributionLists(changedPairs);
    }

    protected void renameAddressesInAllDistributionLists(Map<String, String> changedPairs) {
        String[] oldAddrs = changedPairs.keySet().toArray(new String[0]);
        String[] newAddrs = changedPairs.values().toArray(new String[0]);
        List<DistributionList> lists = null;
        HashMap<String, String[]> attrs = null;
        try {
            lists = this.getAllDistributionListsForAddresses(oldAddrs, false);
        }
        catch (ServiceException se) {
            ZimbraLog.account.warn((Object)("unable to rename addr " + oldAddrs.toString() + " in all DLs "), se);
            return;
        }
        for (DistributionList list : lists) {
            if (attrs == null) {
                attrs = new HashMap<String, String[]>();
                attrs.put("-zimbraMailForwardingAddress", oldAddrs);
                attrs.put("+zimbraMailForwardingAddress", newAddrs);
            }
            try {
                this.modifyAttrs(list, attrs);
            }
            catch (ServiceException se) {
                ZimbraLog.account.warn((Object)("unable to rename " + oldAddrs.toString() + " to " + newAddrs.toString() + " in DL " + list.getName()), se);
            }
        }
    }

    void removeAddressFromAllDistributionLists(String address) {
        String[] addrs = new String[]{address};
        this.removeAddressesFromAllDistributionLists(addrs);
    }

    public void removeAddressesFromAllDistributionLists(String[] addrs) {
        List<DistributionList> lists = null;
        try {
            lists = this.getAllDistributionListsForAddresses(addrs, false);
        }
        catch (ServiceException se) {
            StringBuilder sb = new StringBuilder();
            for (String addr : addrs) {
                sb.append(addr + ", ");
            }
            ZimbraLog.account.warn("unable to get all DLs for addrs " + sb.toString());
            return;
        }
        for (DistributionList list : lists) {
            try {
                this.removeMembers(list, addrs);
            }
            catch (ServiceException se) {
                StringBuilder sb = new StringBuilder();
                for (String addr : addrs) {
                    sb.append(addr + ", ");
                }
                ZimbraLog.account.warn((Object)("unable to remove " + sb.toString() + " from DL " + list.getName()), se);
            }
        }
    }

    static String[] getAllAddrsForDistributionList(DistributionList list) throws ServiceException {
        String[] aliases = list.getAliases();
        String[] addrs = new String[aliases.length + 1];
        addrs[0] = list.getName();
        for (int i = 0; i < aliases.length; ++i) {
            addrs[i + 1] = aliases[i];
        }
        return addrs;
    }

    private List<DistributionList> getAllDistributionListsForAddresses(String[] addrs, boolean minimalData) throws ServiceException {
        if (addrs == null || addrs.length == 0) {
            return new ArrayList<DistributionList>();
        }
        StringBuilder sb = new StringBuilder();
        if (addrs.length > 1) {
            sb.append("(|");
        }
        for (int i = 0; i < addrs.length; ++i) {
            sb.append(String.format("(%s=%s)", "zimbraMailForwardingAddress", addrs[i]));
        }
        if (addrs.length > 1) {
            sb.append(")");
        }
        String[] attrs = minimalData ? sMinimalDlAttrs : null;
        return this.searchAccountsInternal(sb.toString(), attrs, null, true, 4);
    }

    static List<DistributionList> getDistributionLists(String[] addrs, boolean directOnly, Map<String, String> via, boolean minimalData) throws ServiceException {
        LdapProvisioning prov = (LdapProvisioning)Provisioning.getInstance();
        List<DistributionList> directDLs = prov.getAllDistributionListsForAddresses(addrs, true);
        HashSet<String> directDLSet = new HashSet<String>();
        HashSet<String> checked = new HashSet<String>();
        ArrayList<DistributionList> result = new ArrayList<DistributionList>();
        Stack<DistributionList> dlsToCheck = new Stack<DistributionList>();
        for (DistributionList dl : directDLs) {
            dlsToCheck.push(dl);
            directDLSet.add(dl.getName());
        }
        while (!dlsToCheck.isEmpty()) {
            DistributionList dl = (DistributionList)dlsToCheck.pop();
            if (checked.contains(dl.getId())) continue;
            result.add(dl);
            checked.add(dl.getId());
            if (directOnly) continue;
            String[] dlAddrs = LdapProvisioning.getAllAddrsForDistributionList(dl);
            List<DistributionList> newLists = prov.getAllDistributionListsForAddresses(dlAddrs, true);
            for (DistributionList newDl : newLists) {
                if (directDLSet.contains(newDl.getName())) continue;
                if (via != null) {
                    via.put(newDl.getName(), dl.getName());
                }
                dlsToCheck.push(newDl);
            }
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public Set<String> getDistributionLists(Account acct) throws ServiceException {
        Set<String> dls = (HashSet)acct.getCachedData(DATA_DL_SET);
        if (dls != null) {
            return dls;
        }
        dls = new HashSet();
        List<DistributionList> lists = this.getDistributionLists(acct, false, null, true);
        for (DistributionList dl : lists) {
            dls.add(dl.getId());
        }
        dls = Collections.unmodifiableSet(dls);
        acct.setCachedData(DATA_DL_SET, dls);
        return dls;
    }

    @Override
    public boolean inDistributionList(Account acct, String zimbraId) throws ServiceException {
        return this.getDistributionLists(acct).contains(zimbraId);
    }

    @Override
    public boolean inDistributionList(DistributionList list, String zimbraId) throws ServiceException {
        DistributionList group = list;
        if (!list.isAclGroup()) {
            group = this.getAclGroup(Provisioning.DistributionListBy.id, list.getId());
        }
        Provisioning.AclGroups aclGroups = this.getAclGroups(group, false);
        return aclGroups.groupIds().contains(zimbraId);
    }

    @Override
    public List<DistributionList> getDistributionLists(Account acct, boolean directOnly, Map<String, String> via) throws ServiceException {
        return this.getDistributionLists(acct, directOnly, via, false);
    }

    private List<DistributionList> getDistributionLists(Account acct, boolean directOnly, Map<String, String> via, boolean minimal) throws ServiceException {
        String[] aliases = acct.getMailAlias();
        String[] addrs = new String[aliases.length + 1];
        addrs[0] = acct.getName();
        for (int i = 0; i < aliases.length; ++i) {
            addrs[i + 1] = aliases[i];
        }
        return LdapProvisioning.getDistributionLists(addrs, directOnly, via, minimal);
    }

    @Override
    public List getAllAccounts(Domain d) throws ServiceException {
        return this.searchAccounts(d, this.mDIT.filterAccountsByDomain(d, false), null, null, true, 1);
    }

    @Override
    public void getAllAccounts(Domain d, NamedEntry.Visitor visitor) throws ServiceException {
        LdapDomain ld = (LdapDomain)d;
        this.searchObjects(this.mDIT.filterAccountsByDomain(d, false), null, this.mDIT.domainDNToAccountSearchDN(ld.getDN()), 1, visitor, 0);
    }

    @Override
    public void getAllAccounts(Domain d, Server s, NamedEntry.Visitor visitor) throws ServiceException {
        this.getAllAccountsInternal(d, s, visitor, false);
    }

    public void getAllAccountsNoDefaults(Domain d, Server s, NamedEntry.Visitor visitor) throws ServiceException {
        this.getAllAccountsInternal(d, s, visitor, true);
    }

    private void getAllAccountsInternal(Domain d, Server s, NamedEntry.Visitor visitor, boolean noDefaults) throws ServiceException {
        LdapDomain ld = (LdapDomain)d;
        String filter = this.mDIT.filterAccountsByDomain(d, false);
        if (s != null) {
            String serverFilter = "(zimbraMailHost=" + s.getAttr("zimbraServiceHostname") + ")";
            filter = StringUtil.isNullOrEmpty(filter) ? serverFilter : "(&" + serverFilter + filter + ")";
        }
        int flags = 1;
        if (noDefaults) {
            flags |= 0x100;
        }
        this.searchObjects(filter, null, this.mDIT.domainDNToAccountSearchDN(ld.getDN()), flags, visitor, 0);
    }

    @Override
    public List getAllCalendarResources(Domain d) throws ServiceException {
        return this.searchAccounts(d, this.mDIT.filterCalendarResourcesByDomain(d, false), null, null, true, 8);
    }

    @Override
    public void getAllCalendarResources(Domain d, NamedEntry.Visitor visitor) throws ServiceException {
        LdapDomain ld = (LdapDomain)d;
        this.searchObjects(this.mDIT.filterCalendarResourcesByDomain(d, false), null, this.mDIT.domainDNToAccountSearchDN(ld.getDN()), 8, visitor, 0);
    }

    @Override
    public void getAllCalendarResources(Domain d, Server s, NamedEntry.Visitor visitor) throws ServiceException {
        LdapDomain ld = (LdapDomain)d;
        String filter = this.mDIT.filterCalendarResourcesByDomain(d, false);
        if (s != null) {
            String serverFilter = "(zimbraMailHost=" + s.getAttr("zimbraServiceHostname") + ")";
            filter = StringUtil.isNullOrEmpty(filter) ? serverFilter : "(&" + serverFilter + filter + ")";
        }
        this.searchObjects(filter, null, this.mDIT.domainDNToAccountSearchDN(ld.getDN()), 8, visitor, 0);
    }

    @Override
    public List getAllDistributionLists(Domain d) throws ServiceException {
        return this.searchAccounts(d, this.mDIT.filterDistributionListsByDomain(d, false), null, null, true, 4);
    }

    public List searchAccounts(Domain d, String query, String[] returnAttrs, String sortAttr, boolean sortAscending, int flags) throws ServiceException {
        LdapDomain ld = (LdapDomain)d;
        return this.searchObjects(query, returnAttrs, sortAttr, sortAscending, this.mDIT.domainDNToAccountSearchDN(ld.getDN()), flags, 0);
    }

    @Override
    public List<NamedEntry> searchDirectory(Provisioning.SearchOptions options) throws ServiceException {
        return this.searchDirectory(options, true);
    }

    private void addBase(Set<String> bases, String base) {
        boolean add = true;
        for (String b : bases) {
            if (!this.mDIT.isUnder(b, base)) continue;
            add = false;
            break;
        }
        if (add) {
            bases.add(base);
        }
    }

    public String[] getSearchBases(int flags) {
        boolean coses;
        HashSet<String> bases = new HashSet<String>();
        boolean accounts = (flags & 1) != 0;
        boolean aliases = (flags & 2) != 0;
        boolean lists = (flags & 4) != 0;
        boolean calendarResources = (flags & 8) != 0;
        boolean domains = (flags & 0x10) != 0;
        boolean bl = coses = (flags & 0x20) != 0;
        if (accounts || aliases || lists || calendarResources) {
            this.addBase(bases, this.mDIT.mailBranchBaseDN());
        }
        if (accounts) {
            this.addBase(bases, this.mDIT.adminBaseDN());
        }
        if (domains) {
            this.addBase(bases, this.mDIT.domainBaseDN());
        }
        if (coses) {
            this.addBase(bases, this.mDIT.cosBaseDN());
        }
        return bases.toArray(new String[bases.size()]);
    }

    @Override
    public List<NamedEntry> searchDirectory(Provisioning.SearchOptions options, boolean useConnPool) throws ServiceException {
        String base = null;
        LdapDomain ld = (LdapDomain)options.getDomain();
        if (ld != null) {
            base = this.mDIT.domainDNToAccountSearchDN(ld.getDN());
        } else {
            String bs = options.getBase();
            if (bs != null) {
                base = bs;
            }
        }
        String[] bases = base == null ? this.getSearchBases(options.getFlags()) : new String[]{base};
        String query = options.getQuery();
        if (options.getConvertIDNToAscii() && query != null && query.length() > 0) {
            query = LdapEntrySearchFilter.toLdapIDNFilter(query);
        }
        return this.searchObjects(query, options.getReturnAttrs(), options.getSortAttr(), options.isSortAscending(), bases, options.getFlags(), options.getMaxResults(), useConnPool, options.getOnMaster());
    }

    @Override
    public List<NamedEntry> searchCalendarResources(Domain d, EntrySearchFilter filter, String[] returnAttrs, String sortAttr, boolean sortAscending) throws ServiceException {
        return this.searchCalendarResources(filter, returnAttrs, sortAttr, sortAscending, LdapUtil.getZimbraSearchBase(d, GalOp.search));
    }

    @Override
    public Provisioning.SearchGalResult searchGal(Domain d, String n, Provisioning.GAL_SEARCH_TYPE type, String token) throws ServiceException {
        return this.searchGal(d, n, type, null, token, null);
    }

    @Override
    public Provisioning.SearchGalResult searchGal(Domain d, String n, Provisioning.GAL_SEARCH_TYPE type, String token, GalContact.Visitor visitor) throws ServiceException {
        return this.searchGal(d, n, type, null, token, visitor);
    }

    @Override
    public Provisioning.SearchGalResult searchGal(Domain d, String n, Provisioning.GAL_SEARCH_TYPE type, Provisioning.GalMode galMode, String token) throws ServiceException {
        return this.searchGal(d, n, type, galMode, token, null);
    }

    private Provisioning.SearchGalResult searchGal(Domain d, String n, Provisioning.GAL_SEARCH_TYPE type, Provisioning.GalMode galMode, String token, GalContact.Visitor visitor) throws ServiceException {
        int maxResults;
        GalOp galOp = token != null ? GalOp.sync : GalOp.search;
        n = LdapUtil.escapeSearchFilterArg(n);
        int n2 = maxResults = token != null ? 0 : d.getIntAttr("zimbraGalMaxResults", 100);
        if (type == Provisioning.GAL_SEARCH_TYPE.CALENDAR_RESOURCE) {
            return this.searchResourcesGal(d, n, maxResults, token, galOp, visitor);
        }
        Provisioning.GalMode mode = galMode != null ? galMode : Provisioning.GalMode.fromString(d.getAttr("zimbraGalMode"));
        Provisioning.SearchGalResult results = null;
        if (mode == null || mode == Provisioning.GalMode.zimbra) {
            results = this.searchZimbraGal(d, n, maxResults, token, galOp, visitor);
        } else if (mode == Provisioning.GalMode.ldap) {
            results = this.searchLdapGal(d, n, maxResults, token, galOp, visitor);
        } else if (mode == Provisioning.GalMode.both) {
            results = this.searchZimbraGal(d, n, maxResults / 2, token, galOp, visitor);
            Provisioning.SearchGalResult ldapResults = this.searchLdapGal(d, n, maxResults / 2, token, galOp, visitor);
            if (ldapResults != null) {
                results.addMatches(ldapResults);
                results.setToken(LdapUtil.getLaterTimestamp(results.getToken(), ldapResults.getToken()));
            }
        } else {
            results = this.searchZimbraGal(d, n, maxResults, token, galOp, visitor);
        }
        if (results == null) {
            results = Provisioning.SearchGalResult.newSearchGalResult(visitor);
        }
        if (type == Provisioning.GAL_SEARCH_TYPE.ALL) {
            Provisioning.SearchGalResult resourceResults = null;
            if (maxResults == 0) {
                resourceResults = this.searchResourcesGal(d, n, 0, token, galOp, visitor);
            } else {
                int room = maxResults - results.getNumMatches();
                if (room > 0) {
                    resourceResults = this.searchResourcesGal(d, n, room, token, galOp, visitor);
                }
            }
            if (resourceResults != null) {
                results.addMatches(resourceResults);
                results.setToken(LdapUtil.getLaterTimestamp(results.getToken(), resourceResults.getToken()));
            }
        }
        return results;
    }

    @Override
    public Provisioning.SearchGalResult autoCompleteGal(Domain d, String n, Provisioning.GAL_SEARCH_TYPE type, int max) throws ServiceException {
        GalOp galOp = GalOp.autocomplete;
        n = LdapUtil.escapeSearchFilterArg(n);
        int maxResults = Math.min(max, d.getIntAttr("zimbraGalMaxResults", 100));
        if (type == Provisioning.GAL_SEARCH_TYPE.CALENDAR_RESOURCE) {
            return this.searchResourcesGal(d, n, maxResults, null, galOp, null);
        }
        Provisioning.GalMode mode = Provisioning.GalMode.fromString(d.getAttr("zimbraGalMode"));
        Provisioning.SearchGalResult results = null;
        if (mode == null || mode == Provisioning.GalMode.zimbra) {
            results = this.searchZimbraGal(d, n, maxResults, null, galOp, null);
        } else if (mode == Provisioning.GalMode.ldap) {
            results = this.searchLdapGal(d, n, maxResults, null, galOp, null);
        } else if (mode == Provisioning.GalMode.both) {
            results = this.searchZimbraGal(d, n, maxResults / 2, null, galOp, null);
            Provisioning.SearchGalResult ldapResults = this.searchLdapGal(d, n, maxResults / 2, null, galOp, null);
            if (ldapResults != null) {
                results.addMatches(ldapResults);
                results.setToken(LdapUtil.getLaterTimestamp(results.getToken(), ldapResults.getToken()));
                results.setHadMore(results.getHadMore() || ldapResults.getHadMore());
            }
        } else {
            results = this.searchZimbraGal(d, n, maxResults, null, galOp, null);
        }
        if (results == null) {
            results = Provisioning.SearchGalResult.newSearchGalResult(null);
        }
        if (type == Provisioning.GAL_SEARCH_TYPE.ALL) {
            Provisioning.SearchGalResult resourceResults = null;
            if (maxResults == 0) {
                resourceResults = this.searchResourcesGal(d, n, 0, null, galOp, null);
            } else {
                int room = maxResults - results.getNumMatches();
                if (room > 0) {
                    resourceResults = this.searchResourcesGal(d, n, room, null, galOp, null);
                }
            }
            if (resourceResults != null) {
                results.addMatches(resourceResults);
                results.setToken(LdapUtil.getLaterTimestamp(results.getToken(), resourceResults.getToken()));
                results.setHadMore(results.getHadMore() || resourceResults.getHadMore());
            }
        }
        Collections.sort(results.getMatches());
        return results;
    }

    public static String getFilterDef(String name) throws ServiceException {
        String[] queryExprs = Provisioning.getInstance().getConfig().getMultiAttr("zimbraGalLdapFilterDef");
        String fname = name + ":";
        String queryExpr = null;
        for (int i = 0; i < queryExprs.length; ++i) {
            if (!queryExprs[i].startsWith(fname)) continue;
            queryExpr = queryExprs[i].substring(fname.length());
        }
        if (queryExpr == null) {
            ZimbraLog.gal.warn("missing filter def " + name + " in " + "zimbraGalLdapFilterDef");
        }
        return queryExpr;
    }

    private synchronized LdapGalMapRules getGalRules(Domain d) {
        LdapGalMapRules rules = (LdapGalMapRules)d.getCachedData(DATA_GAL_RULES);
        if (rules == null) {
            String[] attrs = d.getMultiAttr("zimbraGalLdapAttrMap");
            rules = new LdapGalMapRules(attrs);
            d.setCachedData(DATA_GAL_RULES, rules);
        }
        return rules;
    }

    private Provisioning.SearchGalResult searchResourcesGal(Domain d, String n, int maxResults, String token, GalOp galOp, GalContact.Visitor visitor) throws ServiceException {
        return this.searchZimbraWithNamedFilter(d, galOp, GalNamedFilter.getZimbraCalendarResourceFilter(galOp), n, maxResults, token, visitor);
    }

    private Provisioning.SearchGalResult searchZimbraGal(Domain d, String n, int maxResults, String token, GalOp galOp, GalContact.Visitor visitor) throws ServiceException {
        return this.searchZimbraWithNamedFilter(d, galOp, GalNamedFilter.getZimbraAcountFilter(galOp), n, maxResults, token, visitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Provisioning.SearchGalResult searchZimbraWithNamedFilter(Domain domain, GalOp galOp, String filterName, String n, int maxResults, String token, GalContact.Visitor visitor) throws ServiceException {
        GalParams.ZimbraGalParams galParams = new GalParams.ZimbraGalParams(domain, galOp);
        String queryExpr = LdapProvisioning.getFilterDef(filterName);
        String query = null;
        if (queryExpr != null) {
            if (token != null) {
                n = "";
            }
            query = GalUtil.expandFilter(null, queryExpr, n, token, true);
        }
        Provisioning.SearchGalResult result = Provisioning.SearchGalResult.newSearchGalResult(visitor);
        result.setTokenizeKey(GalUtil.tokenizeKey(galParams, galOp));
        if (query == null) {
            ZimbraLog.gal.warn("searchZimbraWithNamedFilter query is null");
            return result;
        }
        query = "(&(" + query + ")(!(zimbraHideInGal=TRUE)))";
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext(false);
            LdapUtil.searchGal(zlc, galParams.pageSize(), galParams.searchBase(), query, maxResults, this.getGalRules(domain), token, result);
        }
        catch (Throwable throwable) {
            ZimbraLdapContext.closeContext(zlc);
            throw throwable;
        }
        ZimbraLdapContext.closeContext(zlc);
        return result;
    }

    private Provisioning.SearchGalResult searchLdapGal(Domain domain, String n, int maxResults, String token, GalOp galOp, GalContact.Visitor visitor) throws ServiceException {
        GalParams.ExternalGalParams galParams = new GalParams.ExternalGalParams(domain, galOp);
        LdapGalMapRules rules = this.getGalRules(domain);
        String[] galAttrList = rules.getLdapAttrs();
        try {
            return LdapUtil.searchLdapGal(galParams, galOp, n, maxResults, rules, token, visitor);
        }
        catch (NamingException e) {
            throw ServiceException.FAILURE("unable to search GAL", e);
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("unable to search GAL", e);
        }
    }

    @Override
    public void addMembers(DistributionList list, String[] members) throws ServiceException {
        LdapDistributionList ldl = (LdapDistributionList)list;
        ldl.addMembers(members, this);
    }

    @Override
    public void removeMembers(DistributionList list, String[] members) throws ServiceException {
        LdapDistributionList ldl = (LdapDistributionList)list;
        ldl.removeMembers(members, this);
    }

    private List<Identity> getIdentitiesByQuery(LdapEntry entry, String query, ZimbraLdapContext initZlc) throws ServiceException {
        ZimbraLdapContext zlc = initZlc;
        ArrayList<Identity> result = new ArrayList<Identity>();
        try {
            if (zlc == null) {
                zlc = new ZimbraLdapContext();
            }
            String base = entry.getDN();
            NamingEnumeration<SearchResult> ne = zlc.searchDir(base, query, sSubtreeSC);
            while (ne.hasMore()) {
                SearchResult sr = ne.next();
                result.add(new LdapIdentity((Account)((Object)entry), sr.getNameInNamespace(), sr.getAttributes(), (Provisioning)this));
            }
            ne.close();
        }
        catch (NameNotFoundException e) {
            ZimbraLog.account.warn((Object)"caught NameNotFoundException", e);
            ArrayList<Identity> arrayList = result;
            return arrayList;
        }
        catch (InvalidNameException e) {
            ZimbraLog.account.warn((Object)"caught InvalidNameException", e);
            ArrayList<Identity> arrayList = result;
            return arrayList;
        }
        catch (NamingException e) {
            throw ServiceException.FAILURE("unable to lookup identity via query: " + query + " message: " + e.getMessage(), e);
        }
        finally {
            if (initZlc == null) {
                ZimbraLdapContext.closeContext(zlc);
            }
        }
        return result;
    }

    private Identity getIdentityByName(LdapEntry entry, String name, ZimbraLdapContext zlc) throws ServiceException {
        List<Identity> result = this.getIdentitiesByQuery(entry, LdapFilter.identityByName(name = LdapUtil.escapeSearchFilterArg(name)), zlc);
        return result.isEmpty() ? null : result.get(0);
    }

    private String getIdentityDn(LdapEntry entry, String name) {
        return "zimbraPrefIdentityName=" + LdapUtil.escapeRDNValue(name) + "," + entry.getDN();
    }

    private void validateIdentityAttrs(Map<String, Object> attrs) throws ServiceException {
        Set<String> validAttrs = AttributeManager.getInstance().getLowerCaseAttrsInClass(AttributeClass.identity);
        for (String key : attrs.keySet()) {
            if (validAttrs.contains(key.toLowerCase())) continue;
            throw ServiceException.INVALID_REQUEST("unable to modify attr: " + key, null);
        }
    }

    @Override
    public Identity createIdentity(Account account, String identityName, Map<String, Object> identityAttrs) throws ServiceException {
        return this.createIdentity(account, identityName, identityAttrs, false);
    }

    @Override
    public Identity restoreIdentity(Account account, String identityName, Map<String, Object> identityAttrs) throws ServiceException {
        return this.createIdentity(account, identityName, identityAttrs, true);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Identity createIdentity(Account account, String identityName, Map<String, Object> identityAttrs, boolean restoring) throws ServiceException {
        Identity identity;
        this.removeAttrIgnoreCase("objectclass", identityAttrs);
        this.validateIdentityAttrs(identityAttrs);
        LdapEntry ldapEntry = (LdapEntry)((Object)(account instanceof LdapEntry ? account : this.getAccountById(account.getId())));
        if (ldapEntry == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(account.getName());
        }
        if (identityName.equalsIgnoreCase("DEFAULT")) {
            throw AccountServiceException.IDENTITY_EXISTS(identityName);
        }
        List<Identity> existing = this.getAllIdentities(account);
        if ((long)existing.size() >= account.getLongAttr("zimbraIdentityMaxNumEntries", 20L)) {
            throw AccountServiceException.TOO_MANY_IDENTITIES();
        }
        account.setCachedData(IDENTITY_LIST_CACHE_KEY, null);
        HashMap attrManagerContext = new HashMap();
        boolean checkImmutable = !restoring;
        AttributeManager.getInstance().preModify(identityAttrs, null, attrManagerContext, true, checkImmutable);
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext(true);
            String dn = this.getIdentityDn(ldapEntry, identityName);
            BasicAttributes attrs = new BasicAttributes(true);
            LdapUtil.mapToAttrs(identityAttrs, attrs);
            Attribute oc = LdapUtil.addAttr((Attributes)attrs, "objectClass", "zimbraIdentity");
            String identityId = LdapUtil.getAttrString(attrs, "zimbraPrefIdentityId");
            if (identityId == null) {
                identityId = LdapUtil.generateUUID();
                attrs.put("zimbraPrefIdentityId", identityId);
            }
            attrs.put("zimbraCreateTimestamp", DateUtil.toGeneralizedTime(new Date()));
            zlc.createEntry(dn, attrs, "createIdentity");
            Identity identity2 = this.getIdentityByName(ldapEntry, identityName, zlc);
            AttributeManager.getInstance().postModify(identityAttrs, identity2, attrManagerContext, true);
            identity = identity2;
        }
        catch (NameAlreadyBoundException nabe) {
            try {
                throw AccountServiceException.IDENTITY_EXISTS(identityName);
                catch (NamingException e) {
                    throw ServiceException.FAILURE("unable to create identity", e);
                }
            }
            catch (Throwable throwable) {
                ZimbraLdapContext.closeContext(zlc);
                throw throwable;
            }
        }
        ZimbraLdapContext.closeContext(zlc);
        return identity;
    }

    @Override
    public void modifyIdentity(Account account, String identityName, Map<String, Object> identityAttrs) throws ServiceException {
        this.removeAttrIgnoreCase("objectclass", identityAttrs);
        this.validateIdentityAttrs(identityAttrs);
        LdapEntry ldapEntry = (LdapEntry)((Object)(account instanceof LdapEntry ? account : this.getAccountById(account.getId())));
        if (ldapEntry == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(account.getName());
        }
        account.setCachedData(IDENTITY_LIST_CACHE_KEY, null);
        if (identityName.equalsIgnoreCase("DEFAULT")) {
            this.modifyAttrs(account, identityAttrs);
        } else {
            boolean newName;
            LdapIdentity identity = (LdapIdentity)this.getIdentityByName(ldapEntry, identityName, null);
            if (identity == null) {
                throw AccountServiceException.NO_SUCH_IDENTITY(identityName);
            }
            String name = (String)identityAttrs.get("zimbraPrefIdentityName");
            boolean bl = newName = name != null && !name.equals(identityName);
            if (newName) {
                identityAttrs.remove("zimbraPrefIdentityName");
            }
            this.modifyAttrs(identity, identityAttrs, true);
            if (newName) {
                account.setCachedData(IDENTITY_LIST_CACHE_KEY, null);
                this.renameIdentity(ldapEntry, identity, name);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void renameIdentity(LdapEntry entry, LdapIdentity identity, String newIdentityName) throws ServiceException {
        if (identity.getName().equalsIgnoreCase("DEFAULT")) {
            throw ServiceException.INVALID_REQUEST("can't rename default identity", null);
        }
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext(true);
            String newDn = this.getIdentityDn(entry, newIdentityName);
            zlc.renameEntry(identity.getDN(), newDn);
        }
        catch (InvalidNameException e) {
            try {
                throw ServiceException.INVALID_REQUEST("invalid identity name: " + newIdentityName, e);
                catch (NamingException e2) {
                    throw ServiceException.FAILURE("unable to rename identity: " + newIdentityName, e2);
                }
            }
            catch (Throwable throwable) {
                ZimbraLdapContext.closeContext(zlc);
                throw throwable;
            }
        }
        ZimbraLdapContext.closeContext(zlc);
    }

    @Override
    public void deleteIdentity(Account account, String identityName) throws ServiceException {
        LdapEntry ldapEntry = (LdapEntry)((Object)(account instanceof LdapEntry ? account : this.getAccountById(account.getId())));
        if (ldapEntry == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(account.getName());
        }
        if (identityName.equalsIgnoreCase("DEFAULT")) {
            throw ServiceException.INVALID_REQUEST("can't delete default identity", null);
        }
        account.setCachedData(IDENTITY_LIST_CACHE_KEY, null);
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext(true);
            Identity identity = this.getIdentityByName(ldapEntry, identityName, zlc);
            if (identity == null) {
                throw AccountServiceException.NO_SUCH_IDENTITY(identityName);
            }
            String dn = this.getIdentityDn(ldapEntry, identityName);
            zlc.unbindEntry(dn);
        }
        catch (NamingException e) {
            try {
                throw ServiceException.FAILURE("unable to delete identity: " + identityName, e);
            }
            catch (Throwable throwable) {
                ZimbraLdapContext.closeContext(zlc);
                throw throwable;
            }
        }
        ZimbraLdapContext.closeContext(zlc);
    }

    @Override
    public List<Identity> getAllIdentities(Account account) throws ServiceException {
        LdapEntry ldapEntry = (LdapEntry)((Object)(account instanceof LdapEntry ? account : this.getAccountById(account.getId())));
        if (ldapEntry == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(account.getName());
        }
        List<Identity> result = (List<Identity>)account.getCachedData(IDENTITY_LIST_CACHE_KEY);
        if (result != null) {
            return result;
        }
        result = this.getIdentitiesByQuery(ldapEntry, LdapFilter.allIdentities(), null);
        for (Identity identity : result) {
            if (identity.getId() != null) continue;
            String id = LdapUtil.generateUUID();
            identity.setId(id);
            HashMap<String, Object> newAttrs = new HashMap<String, Object>();
            newAttrs.put("zimbraPrefIdentityId", id);
            try {
                this.modifyIdentity(account, identity.getName(), newAttrs);
            }
            catch (ServiceException se) {
                ZimbraLog.account.warn((Object)("error updating identity: " + account.getName() + " " + identity.getName() + " " + se.getMessage()), se);
            }
        }
        result.add(this.getDefaultIdentity(account));
        result = Collections.unmodifiableList(result);
        account.setCachedData(IDENTITY_LIST_CACHE_KEY, result);
        return result;
    }

    @Override
    public Identity get(Account account, Provisioning.IdentityBy keyType, String key) throws ServiceException {
        LdapEntry ldapEntry = (LdapEntry)((Object)(account instanceof LdapEntry ? account : this.getAccountById(account.getId())));
        if (ldapEntry == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(account.getName());
        }
        switch (keyType) {
            case id: {
                for (Identity identity : this.getAllIdentities(account)) {
                    if (!identity.getId().equals(key)) continue;
                    return identity;
                }
                return null;
            }
            case name: {
                for (Identity identity : this.getAllIdentities(account)) {
                    if (!identity.getName().equalsIgnoreCase(key)) continue;
                    return identity;
                }
                return null;
            }
        }
        return null;
    }

    private List<Signature> getSignaturesByQuery(Account acct, LdapEntry entry, String query, ZimbraLdapContext initZlc, List<Signature> result) throws ServiceException {
        ZimbraLdapContext zlc = initZlc;
        if (result == null) {
            result = new ArrayList<Signature>();
        }
        try {
            if (zlc == null) {
                zlc = new ZimbraLdapContext();
            }
            String base = entry.getDN();
            NamingEnumeration<SearchResult> ne = zlc.searchDir(base, query, sSubtreeSC);
            while (ne.hasMore()) {
                SearchResult sr = ne.next();
                result.add(new LdapSignature(acct, sr.getNameInNamespace(), sr.getAttributes(), (Provisioning)this));
            }
            ne.close();
        }
        catch (NameNotFoundException e) {
            ZimbraLog.account.warn((Object)"caught NameNotFoundException", e);
            List<Signature> list = result;
            return list;
        }
        catch (InvalidNameException e) {
            ZimbraLog.account.warn((Object)"caught InvalidNameException", e);
            List<Signature> list = result;
            return list;
        }
        catch (NamingException e) {
            throw ServiceException.FAILURE("unable to lookup signature via query: " + query + " message: " + e.getMessage(), e);
        }
        finally {
            if (initZlc == null) {
                ZimbraLdapContext.closeContext(zlc);
            }
        }
        return result;
    }

    private Signature getSignatureById(Account acct, LdapEntry entry, String id, ZimbraLdapContext zlc) throws ServiceException {
        List<Signature> result = this.getSignaturesByQuery(acct, entry, LdapFilter.signatureById(id = LdapUtil.escapeSearchFilterArg(id)), zlc, null);
        return result.isEmpty() ? null : result.get(0);
    }

    private String getSignatureDn(LdapEntry entry, String name) {
        return "zimbraSignatureName=" + LdapUtil.escapeRDNValue(name) + "," + entry.getDN();
    }

    private void validateSignatureAttrs(Map<String, Object> attrs) throws ServiceException {
        Set<String> validAttrs = AttributeManager.getInstance().getLowerCaseAttrsInClass(AttributeClass.signature);
        for (String key : attrs.keySet()) {
            if (validAttrs.contains(key.toLowerCase())) continue;
            throw ServiceException.INVALID_REQUEST("unable to modify attr: " + key, null);
        }
    }

    private void setDefaultSignature(Account acct, String signatureId) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPrefDefaultSignatureId", signatureId);
        this.modifyAttrs(acct, attrs);
    }

    @Override
    public Signature createSignature(Account account, String signatureName, Map<String, Object> signatureAttrs) throws ServiceException {
        return this.createSignature(account, signatureName, signatureAttrs, false);
    }

    @Override
    public Signature restoreSignature(Account account, String signatureName, Map<String, Object> signatureAttrs) throws ServiceException {
        return this.createSignature(account, signatureName, signatureAttrs, true);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Signature createSignature(Account account, String signatureName, Map<String, Object> signatureAttrs, boolean restoring) throws ServiceException {
        Signature signature;
        signatureName = signatureName.trim();
        this.removeAttrIgnoreCase("objectclass", signatureAttrs);
        this.validateSignatureAttrs(signatureAttrs);
        LdapEntry ldapEntry = (LdapEntry)((Object)(account instanceof LdapEntry ? account : this.getAccountById(account.getId())));
        if (ldapEntry == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(account.getName());
        }
        Signature acctSig = LdapSignature.getAccountSignature(this, account);
        if (acctSig != null && signatureName.equals(acctSig.getName())) {
            throw AccountServiceException.SIGNATURE_EXISTS(signatureName);
        }
        boolean setAsDefault = false;
        List<Signature> existing = this.getAllSignatures(account);
        int numSigs = existing.size();
        if ((long)numSigs >= account.getLongAttr("zimbraSignatureMaxNumEntries", 20L)) {
            throw AccountServiceException.TOO_MANY_SIGNATURES();
        }
        if (numSigs == 0) {
            setAsDefault = true;
        }
        account.setCachedData(SIGNATURE_LIST_CACHE_KEY, null);
        HashMap<String, String> attrManagerContext = new HashMap<String, String>();
        attrManagerContext.put("KEY_MAX_SIGNATURE_LEN", account.getAttr("zimbraMailSignatureMaxLength", "1024"));
        boolean checkImmutable = !restoring;
        AttributeManager.getInstance().preModify(signatureAttrs, null, attrManagerContext, true, checkImmutable);
        String signatureId = (String)signatureAttrs.get("zimbraSignatureId");
        if (signatureId == null) {
            signatureId = LdapUtil.generateUUID();
            signatureAttrs.put("zimbraSignatureId", signatureId);
        }
        if (acctSig == null) {
            signatureAttrs.put("zimbraSignatureName", signatureName);
            LdapSignature.createAccountSignature(this, account, signatureAttrs, setAsDefault);
            return LdapSignature.getAccountSignature(this, account);
        }
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext(true);
            String dn = this.getSignatureDn(ldapEntry, signatureName);
            BasicAttributes attrs = new BasicAttributes(true);
            LdapUtil.mapToAttrs(signatureAttrs, attrs);
            Attribute oc = LdapUtil.addAttr((Attributes)attrs, "objectClass", "zimbraSignature");
            attrs.put("zimbraCreateTimestamp", DateUtil.toGeneralizedTime(new Date()));
            zlc.createEntry(dn, attrs, "createSignature");
            Signature signature2 = this.getSignatureById(account, ldapEntry, signatureId, zlc);
            AttributeManager.getInstance().postModify(signatureAttrs, signature2, attrManagerContext, true);
            if (setAsDefault) {
                this.setDefaultSignature(account, signatureId);
            }
            signature = signature2;
        }
        catch (NameAlreadyBoundException nabe) {
            try {
                throw AccountServiceException.SIGNATURE_EXISTS(signatureName);
                catch (NamingException e) {
                    throw ServiceException.FAILURE("unable to create signature", e);
                }
            }
            catch (Throwable throwable) {
                ZimbraLdapContext.closeContext(zlc);
                throw throwable;
            }
        }
        ZimbraLdapContext.closeContext(zlc);
        return signature;
    }

    @Override
    public void modifySignature(Account account, String signatureId, Map<String, Object> signatureAttrs) throws ServiceException {
        this.removeAttrIgnoreCase("objectclass", signatureAttrs);
        this.validateSignatureAttrs(signatureAttrs);
        LdapEntry ldapEntry = (LdapEntry)((Object)(account instanceof LdapEntry ? account : this.getAccountById(account.getId())));
        if (ldapEntry == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(account.getName());
        }
        String newName = (String)signatureAttrs.get("zimbraSignatureName");
        if (newName != null) {
            if ((newName = newName.trim()).length() == 0) {
                throw ServiceException.INVALID_REQUEST("empty signature name is not allowed", null);
            }
            List<Signature> sigs = this.getAllSignatures(account);
            for (Signature sig : sigs) {
                if (!sig.getName().equals(newName) || sig.getId().equals(signatureId)) continue;
                throw AccountServiceException.SIGNATURE_EXISTS(newName);
            }
        }
        account.setCachedData(SIGNATURE_LIST_CACHE_KEY, null);
        if (LdapSignature.isAccountSignature(account, signatureId)) {
            LdapSignature.modifyAccountSignature(this, account, signatureAttrs);
        } else {
            boolean nameChanged;
            LdapSignature signature = (LdapSignature)this.getSignatureById(account, ldapEntry, signatureId, null);
            if (signature == null) {
                throw AccountServiceException.NO_SUCH_SIGNATURE(signatureId);
            }
            boolean bl = nameChanged = newName != null && !newName.equals(signature.getName());
            if (nameChanged) {
                signatureAttrs.remove("zimbraSignatureName");
            }
            this.modifyAttrs(signature, signatureAttrs, true);
            if (nameChanged) {
                account.setCachedData(SIGNATURE_LIST_CACHE_KEY, null);
                this.renameSignature(ldapEntry, signature, newName);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void renameSignature(LdapEntry entry, LdapSignature signature, String newSignatureName) throws ServiceException {
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext(true);
            String newDn = this.getSignatureDn(entry, newSignatureName);
            zlc.renameEntry(signature.getDN(), newDn);
        }
        catch (InvalidNameException e) {
            try {
                throw ServiceException.INVALID_REQUEST("invalid signature name: " + newSignatureName, e);
                catch (NamingException e2) {
                    throw ServiceException.FAILURE("unable to rename signature: " + newSignatureName, e2);
                }
            }
            catch (Throwable throwable) {
                ZimbraLdapContext.closeContext(zlc);
                throw throwable;
            }
        }
        ZimbraLdapContext.closeContext(zlc);
    }

    @Override
    public void deleteSignature(Account account, String signatureId) throws ServiceException {
        LdapEntry ldapEntry = (LdapEntry)((Object)(account instanceof LdapEntry ? account : this.getAccountById(account.getId())));
        if (ldapEntry == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(account.getName());
        }
        account.setCachedData(SIGNATURE_LIST_CACHE_KEY, null);
        if (LdapSignature.isAccountSignature(account, signatureId)) {
            LdapSignature.deleteAccountSignature(this, account);
            return;
        }
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext(true);
            Signature signature = this.getSignatureById(account, ldapEntry, signatureId, zlc);
            if (signature == null) {
                throw AccountServiceException.NO_SUCH_SIGNATURE(signatureId);
            }
            String dn = this.getSignatureDn(ldapEntry, signature.getName());
            zlc.unbindEntry(dn);
        }
        catch (NamingException e) {
            try {
                throw ServiceException.FAILURE("unable to delete signarure: " + signatureId, e);
            }
            catch (Throwable throwable) {
                ZimbraLdapContext.closeContext(zlc);
                throw throwable;
            }
        }
        ZimbraLdapContext.closeContext(zlc);
    }

    @Override
    public List<Signature> getAllSignatures(Account account) throws ServiceException {
        LdapEntry ldapEntry = (LdapEntry)((Object)(account instanceof LdapEntry ? account : this.getAccountById(account.getId())));
        if (ldapEntry == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(account.getName());
        }
        List<Signature> result = (ArrayList<Signature>)account.getCachedData(SIGNATURE_LIST_CACHE_KEY);
        if (result != null) {
            return result;
        }
        result = new ArrayList<Signature>();
        Signature acctSig = LdapSignature.getAccountSignature(this, account);
        if (acctSig != null) {
            result.add(acctSig);
        }
        result = this.getSignaturesByQuery(account, ldapEntry, LdapFilter.allSignatures(), null, result);
        result = Collections.unmodifiableList(result);
        account.setCachedData(SIGNATURE_LIST_CACHE_KEY, result);
        return result;
    }

    @Override
    public Signature get(Account account, Provisioning.SignatureBy keyType, String key) throws ServiceException {
        LdapEntry ldapEntry = (LdapEntry)((Object)(account instanceof LdapEntry ? account : this.getAccountById(account.getId())));
        if (ldapEntry == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(account.getName());
        }
        switch (keyType) {
            case id: {
                for (Signature signature : this.getAllSignatures(account)) {
                    if (!signature.getId().equals(key)) continue;
                    return signature;
                }
                return null;
            }
            case name: {
                for (Signature signature : this.getAllSignatures(account)) {
                    if (!signature.getName().equalsIgnoreCase(key)) continue;
                    return signature;
                }
                return null;
            }
        }
        return null;
    }

    private List<DataSource> getDataSourcesByQuery(LdapEntry entry, String query, ZimbraLdapContext initZlc) throws ServiceException {
        ZimbraLdapContext zlc = initZlc;
        ArrayList<DataSource> result = new ArrayList<DataSource>();
        try {
            if (zlc == null) {
                zlc = new ZimbraLdapContext();
            }
            String base = entry.getDN();
            NamingEnumeration<SearchResult> ne = zlc.searchDir(base, query, sSubtreeSC);
            while (ne.hasMore()) {
                SearchResult sr = ne.next();
                result.add(new LdapDataSource((Account)((Object)entry), sr.getNameInNamespace(), sr.getAttributes(), (Provisioning)this));
            }
            ne.close();
        }
        catch (NameNotFoundException e) {
            ZimbraLog.account.warn((Object)"caught NameNotFoundException", e);
            ArrayList<DataSource> arrayList = result;
            return arrayList;
        }
        catch (InvalidNameException e) {
            ZimbraLog.account.warn((Object)"caught InvalidNameException", e);
            ArrayList<DataSource> arrayList = result;
            return arrayList;
        }
        catch (NamingException e) {
            throw ServiceException.FAILURE("unable to lookup data source via query: " + query + " message: " + e.getMessage(), e);
        }
        finally {
            if (initZlc == null) {
                ZimbraLdapContext.closeContext(zlc);
            }
        }
        return result;
    }

    private DataSource getDataSourceById(LdapEntry entry, String id, ZimbraLdapContext zlc) throws ServiceException {
        List<DataSource> result = this.getDataSourcesByQuery(entry, LdapFilter.dataSourceById(id = LdapUtil.escapeSearchFilterArg(id)), zlc);
        return result.isEmpty() ? null : result.get(0);
    }

    private DataSource getDataSourceByName(LdapEntry entry, String name, ZimbraLdapContext zlc) throws ServiceException {
        List<DataSource> result = this.getDataSourcesByQuery(entry, LdapFilter.dataSourceByName(name = LdapUtil.escapeSearchFilterArg(name)), zlc);
        return result.isEmpty() ? null : result.get(0);
    }

    private String getDataSourceDn(LdapEntry entry, String name) {
        return "zimbraDataSourceName=" + LdapUtil.escapeRDNValue(name) + "," + entry.getDN();
    }

    protected ReplaceAddressResult replaceMailAddresses(Entry entry, String attrName, String oldAddr, String newAddr) throws ServiceException {
        String oldDomain = EmailUtil.getValidDomainPart(oldAddr);
        String newDomain = EmailUtil.getValidDomainPart(newAddr);
        String[] oldAddrs = entry.getMultiAttr(attrName);
        String[] newAddrs = new String[]{};
        for (int i = 0; i < oldAddrs.length; ++i) {
            String oldMail = oldAddrs[i];
            if (oldMail.equals(oldAddr)) {
                newAddrs = LdapProvisioning.addMultiValue(newAddrs, newAddr);
                continue;
            }
            String[] oldParts = EmailUtil.getLocalPartAndDomain(oldMail);
            if (oldParts == null) {
                throw ServiceException.FAILURE("bad value for " + attrName + " " + oldMail, null);
            }
            String oldL = oldParts[0];
            String oldD = oldParts[1];
            if (oldD.equals(oldDomain)) {
                String newMail = oldL + "@" + newDomain;
                newAddrs = LdapProvisioning.addMultiValue(newAddrs, newMail);
                continue;
            }
            newAddrs = LdapProvisioning.addMultiValue(newAddrs, oldMail);
        }
        return new ReplaceAddressResult(oldAddrs, newAddrs);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean addressExists(ZimbraLdapContext zlc, String baseDN, String[] addrs) throws ServiceException {
        StringBuilder query = new StringBuilder();
        query.append("(|");
        for (int i = 0; i < addrs.length; ++i) {
            query.append(String.format("(%s=%s)", "zimbraMailDeliveryAddress", addrs[i]));
            query.append(String.format("(%s=%s)", "zimbraMailAlias", addrs[i]));
        }
        query.append(")");
        try {
            NamingEnumeration<SearchResult> ne = zlc.searchDir(baseDN, query.toString(), sSubtreeSC);
            if (!ne.hasMore()) return false;
            return true;
        }
        catch (NameNotFoundException e) {
            return false;
        }
        catch (InvalidNameException e) {
            throw ServiceException.FAILURE("unable to lookup account via query: " + query.toString() + " message: " + e.getMessage(), e);
        }
        catch (NamingException e) {
            throw ServiceException.FAILURE("unable to lookup account via query: " + query.toString() + " message: " + e.getMessage(), e);
        }
    }

    private void moveAliases(ZimbraLdapContext zlc, ReplaceAddressResult addrs, String newDomain, String primaryUid, String targetOldDn, String targetNewDn, String targetOldDomain, String targetNewDomain) throws ServiceException {
        for (int i = 0; i < addrs.newAddrs().length; ++i) {
            String newAliasDN;
            String[] oldParts;
            String oldAliasDN;
            String oldAddr = addrs.oldAddrs()[i];
            String newAddr = addrs.newAddrs()[i];
            String aliasNewDomain = EmailUtil.getValidDomainPart(newAddr);
            if (!aliasNewDomain.equals(newDomain) || (oldAliasDN = this.mDIT.aliasDN(targetOldDn, targetOldDomain, (oldParts = EmailUtil.getLocalPartAndDomain(oldAddr))[0], oldParts[1])).equals(newAliasDN = this.mDIT.aliasDNRename(targetNewDn, targetNewDomain, newAddr))) continue;
            String[] newAliasParts = EmailUtil.getLocalPartAndDomain(newAddr);
            String newAliasLocal = newAliasParts[0];
            if (primaryUid != null && newAliasLocal.equals(primaryUid)) continue;
            try {
                zlc.renameEntry(oldAliasDN, newAliasDN);
                continue;
            }
            catch (NameAlreadyBoundException nabe) {
                ZimbraLog.account.warn((Object)("unable to move alias from " + oldAliasDN + " to " + newAliasDN), nabe);
                continue;
            }
            catch (NamingException ne) {
                throw ServiceException.FAILURE("unable to move aliases", null);
            }
        }
    }

    @Override
    public DataSource createDataSource(Account account, DataSource.Type dsType, String dsName, Map<String, Object> dataSourceAttrs) throws ServiceException {
        return this.createDataSource(account, dsType, dsName, dataSourceAttrs, false);
    }

    @Override
    public DataSource createDataSource(Account account, DataSource.Type type, String dataSourceName, Map<String, Object> attrs, boolean passwdAlreadyEncrypted) throws ServiceException {
        return this.createDataSource(account, type, dataSourceName, attrs, passwdAlreadyEncrypted, false);
    }

    @Override
    public DataSource restoreDataSource(Account account, DataSource.Type dsType, String dsName, Map<String, Object> dataSourceAttrs) throws ServiceException {
        return this.createDataSource(account, dsType, dsName, dataSourceAttrs, true, true);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DataSource createDataSource(Account account, DataSource.Type dsType, String dsName, Map<String, Object> dataSourceAttrs, boolean passwdAlreadyEncrypted, boolean restoring) throws ServiceException {
        DataSource dataSource;
        this.removeAttrIgnoreCase("objectclass", dataSourceAttrs);
        LdapEntry ldapEntry = (LdapEntry)((Object)(account instanceof LdapEntry ? account : this.getAccountById(account.getId())));
        if (ldapEntry == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(account.getName());
        }
        List<DataSource> existing = this.getAllDataSources(account);
        if ((long)existing.size() >= account.getLongAttr("zimbraDataSourceMaxNumEntries", 20L)) {
            throw AccountServiceException.TOO_MANY_DATA_SOURCES();
        }
        dataSourceAttrs.put("zimbraDataSourceName", dsName);
        dataSourceAttrs.put("zimbraDataSourceType", dsType.toString());
        account.setCachedData(DATA_SOURCE_LIST_CACHE_KEY, null);
        HashMap attrManagerContext = new HashMap();
        boolean checkImmutable = !restoring;
        AttributeManager.getInstance().preModify(dataSourceAttrs, null, attrManagerContext, true, checkImmutable);
        ZimbraLdapContext zlc = null;
        try {
            String password;
            String dsId;
            zlc = new ZimbraLdapContext(true);
            String dn = this.getDataSourceDn(ldapEntry, dsName);
            BasicAttributes attrs = new BasicAttributes(true);
            LdapUtil.mapToAttrs(dataSourceAttrs, attrs);
            Attribute oc = LdapUtil.addAttr((Attributes)attrs, "objectClass", "zimbraDataSource");
            String extraOc = LdapDataSource.getObjectClass(dsType);
            if (extraOc != null) {
                oc.add(extraOc);
            }
            if ((dsId = LdapUtil.getAttrString(attrs, "zimbraDataSourceId")) == null) {
                dsId = LdapUtil.generateUUID();
                attrs.put("zimbraDataSourceId", dsId);
            }
            if ((password = LdapUtil.getAttrString(attrs, "zimbraDataSourcePassword")) != null) {
                String encrypted = passwdAlreadyEncrypted ? password : DataSource.encryptData(dsId, password);
                attrs.put("zimbraDataSourcePassword", encrypted);
            }
            attrs.put("zimbraCreateTimestamp", DateUtil.toGeneralizedTime(new Date()));
            zlc.createEntry(dn, attrs, "createDataSource");
            DataSource ds = this.getDataSourceById(ldapEntry, dsId, zlc);
            AttributeManager.getInstance().postModify(dataSourceAttrs, ds, attrManagerContext, true);
            dataSource = ds;
        }
        catch (NameAlreadyBoundException nabe) {
            try {
                throw AccountServiceException.DATA_SOURCE_EXISTS(dsName);
                catch (NamingException e) {
                    throw ServiceException.FAILURE("unable to create data source", e);
                }
            }
            catch (Throwable throwable) {
                ZimbraLdapContext.closeContext(zlc);
                throw throwable;
            }
        }
        ZimbraLdapContext.closeContext(zlc);
        return dataSource;
    }

    @Override
    public void deleteDataSource(Account account, String dataSourceId) throws ServiceException {
        LdapEntry ldapEntry = (LdapEntry)((Object)(account instanceof LdapEntry ? account : this.getAccountById(account.getId())));
        if (ldapEntry == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(account.getName());
        }
        account.setCachedData(DATA_SOURCE_LIST_CACHE_KEY, null);
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext(true);
            DataSource dataSource = this.getDataSourceById(ldapEntry, dataSourceId, zlc);
            if (dataSource == null) {
                throw AccountServiceException.NO_SUCH_DATA_SOURCE(dataSourceId);
            }
            String dn = this.getDataSourceDn(ldapEntry, dataSource.getName());
            zlc.unbindEntry(dn);
        }
        catch (NamingException e) {
            try {
                throw ServiceException.FAILURE("unable to delete data source: " + dataSourceId, e);
            }
            catch (Throwable throwable) {
                ZimbraLdapContext.closeContext(zlc);
                throw throwable;
            }
        }
        ZimbraLdapContext.closeContext(zlc);
    }

    @Override
    public List<DataSource> getAllDataSources(Account account) throws ServiceException {
        List<DataSource> result = (List<DataSource>)account.getCachedData(DATA_SOURCE_LIST_CACHE_KEY);
        if (result != null) {
            return result;
        }
        LdapEntry ldapEntry = (LdapEntry)((Object)(account instanceof LdapEntry ? account : this.getAccountById(account.getId())));
        if (ldapEntry == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(account.getName());
        }
        result = this.getDataSourcesByQuery(ldapEntry, LdapFilter.allDataSources(), null);
        result = Collections.unmodifiableList(result);
        account.setCachedData(DATA_SOURCE_LIST_CACHE_KEY, result);
        return result;
    }

    public void removeAttrIgnoreCase(String attr, Map<String, Object> attrs) {
        for (String key : attrs.keySet()) {
            if (!key.equalsIgnoreCase(attr)) continue;
            attrs.remove(key);
            return;
        }
    }

    @Override
    public void modifyDataSource(Account account, String dataSourceId, Map<String, Object> attrs) throws ServiceException {
        String password;
        boolean newName;
        this.removeAttrIgnoreCase("objectclass", attrs);
        LdapEntry ldapEntry = (LdapEntry)((Object)(account instanceof LdapEntry ? account : this.getAccountById(account.getId())));
        if (ldapEntry == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(account.getName());
        }
        LdapDataSource ds = (LdapDataSource)this.getDataSourceById(ldapEntry, dataSourceId, null);
        if (ds == null) {
            throw AccountServiceException.NO_SUCH_DATA_SOURCE(dataSourceId);
        }
        account.setCachedData(DATA_SOURCE_LIST_CACHE_KEY, null);
        attrs.remove("zimbraDataSourceId");
        String name = (String)attrs.get("zimbraDataSourceName");
        boolean bl = newName = name != null && !name.equals(ds.getName());
        if (newName) {
            attrs.remove("zimbraDataSourceName");
        }
        if ((password = (String)attrs.get("zimbraDataSourcePassword")) != null) {
            attrs.put("zimbraDataSourcePassword", DataSource.encryptData(ds.getId(), password));
        }
        this.modifyAttrs(ds, attrs, true);
        if (newName) {
            account.setCachedData(DATA_SOURCE_LIST_CACHE_KEY, null);
            ZimbraLdapContext zlc = null;
            try {
                zlc = new ZimbraLdapContext(true);
                String newDn = this.getDataSourceDn(ldapEntry, name);
                zlc.renameEntry(ds.getDN(), newDn);
            }
            catch (NamingException e) {
                try {
                    throw ServiceException.FAILURE("unable to rename datasource: " + name, e);
                }
                catch (Throwable throwable) {
                    ZimbraLdapContext.closeContext(zlc);
                    throw throwable;
                }
            }
            ZimbraLdapContext.closeContext(zlc);
        }
    }

    @Override
    public DataSource get(Account account, Provisioning.DataSourceBy keyType, String key) throws ServiceException {
        LdapEntry ldapEntry = (LdapEntry)((Object)(account instanceof LdapEntry ? account : this.getAccountById(account.getId())));
        if (ldapEntry == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(account.getName());
        }
        switch (keyType) {
            case id: {
                for (DataSource source : this.getAllDataSources(account)) {
                    if (!source.getId().equals(key)) continue;
                    return source;
                }
                return null;
            }
            case name: {
                for (DataSource source : this.getAllDataSources(account)) {
                    if (!source.getName().equalsIgnoreCase(key)) continue;
                    return source;
                }
                return null;
            }
        }
        return null;
    }

    private String getXMPPComponentDn(LdapEntry entry, String name) {
        return "zimbraXMPPComponentName=" + LdapUtil.escapeRDNValue(name) + "," + entry.getDN();
    }

    private XMPPComponent getXMPPComponentByQuery(String query, ZimbraLdapContext initZlc) throws ServiceException {
        ZimbraLdapContext zlc = initZlc;
        try {
            NamingEnumeration<SearchResult> ne;
            if (zlc == null) {
                zlc = new ZimbraLdapContext();
            }
            if ((ne = zlc.searchDir(this.mDIT.xmppcomponentBaseDN(), query, sSubtreeSC)).hasMore()) {
                SearchResult sr = ne.next();
                ne.close();
                LdapXMPPComponent ldapXMPPComponent = new LdapXMPPComponent(sr.getNameInNamespace(), sr.getAttributes(), (Provisioning)this);
                return ldapXMPPComponent;
            }
        }
        catch (NameNotFoundException e) {
            XMPPComponent xMPPComponent = null;
            return xMPPComponent;
        }
        catch (InvalidNameException e) {
            XMPPComponent xMPPComponent = null;
            return xMPPComponent;
        }
        catch (NamingException e) {
            throw ServiceException.FAILURE("unable to lookup XMPPComponent via query: " + query + " message: " + e.getMessage(), e);
        }
        finally {
            if (initZlc == null) {
                ZimbraLdapContext.closeContext(zlc);
            }
        }
        return null;
    }

    private XMPPComponent getXMPPComponentByName(String name, boolean nocache) throws ServiceException {
        XMPPComponent x;
        if (!nocache && (x = sXMPPComponentCache.getByName(name)) != null) {
            return x;
        }
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext();
            String dn = this.mDIT.xmppcomponentNameToDN(name);
            Attributes attrs = zlc.getAttributes(dn);
            LdapXMPPComponent x2 = new LdapXMPPComponent(dn, attrs, (Provisioning)this);
            sXMPPComponentCache.put(x2);
            LdapXMPPComponent ldapXMPPComponent = x2;
            return ldapXMPPComponent;
        }
        catch (NameNotFoundException e) {
            XMPPComponent xMPPComponent = null;
            return xMPPComponent;
        }
        catch (InvalidNameException e) {
            XMPPComponent xMPPComponent = null;
            return xMPPComponent;
        }
        catch (NamingException e) {
            throw ServiceException.FAILURE("unable to lookup xmpp component by name: " + name + " message: " + e.getMessage(), e);
        }
        finally {
            ZimbraLdapContext.closeContext(zlc);
        }
    }

    private XMPPComponent getXMPPComponentById(String zimbraId, ZimbraLdapContext zlc, boolean nocache) throws ServiceException {
        if (zimbraId == null) {
            return null;
        }
        XMPPComponent x = null;
        if (!nocache) {
            x = sXMPPComponentCache.getById(zimbraId);
        }
        if (x == null) {
            zimbraId = LdapUtil.escapeSearchFilterArg(zimbraId);
            x = this.getXMPPComponentByQuery(LdapFilter.xmppComponentById(zimbraId), zlc);
            sXMPPComponentCache.put(x);
        }
        return x;
    }

    @Override
    public List<XMPPComponent> getAllXMPPComponents() throws ServiceException {
        ArrayList<XMPPComponent> result = new ArrayList<XMPPComponent>();
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext();
            String filter = LdapFilter.allXMPPComponents();
            NamingEnumeration<SearchResult> ne = zlc.searchDir(this.mDIT.xmppcomponentBaseDN(), filter, sSubtreeSC);
            while (ne.hasMore()) {
                SearchResult sr = ne.next();
                LdapXMPPComponent x = new LdapXMPPComponent(sr.getNameInNamespace(), sr.getAttributes(), (Provisioning)this);
                result.add(x);
            }
            ne.close();
        }
        catch (NamingException e) {
            throw ServiceException.FAILURE("unable to list all servers", e);
        }
        finally {
            ZimbraLdapContext.closeContext(zlc);
        }
        if (result.size() > 0) {
            sXMPPComponentCache.put(result, true);
        }
        Collections.sort(result);
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public XMPPComponent createXMPPComponent(String name, Domain domain, Server server, Map<String, Object> inAttrs) throws ServiceException {
        XMPPComponent xMPPComponent;
        name = name.toLowerCase().trim();
        this.removeAttrIgnoreCase("objectclass", inAttrs);
        this.removeAttrIgnoreCase("zimbraDomainId", inAttrs);
        this.removeAttrIgnoreCase("zimbraServerId", inAttrs);
        HashMap attrManagerContext = new HashMap();
        AttributeManager.getInstance().preModify(inAttrs, null, attrManagerContext, true, true);
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext(true);
            BasicAttributes attrs = new BasicAttributes(true);
            LdapUtil.mapToAttrs(inAttrs, attrs);
            LdapUtil.addAttr((Attributes)attrs, "objectClass", "zimbraXMPPComponent");
            String compId = LdapUtil.generateUUID();
            attrs.put("zimbraId", compId);
            attrs.put("zimbraCreateTimestamp", DateUtil.toGeneralizedTime(new Date()));
            attrs.put("cn", name);
            String dn = this.mDIT.xmppcomponentNameToDN(name);
            attrs.put("zimbraDomainId", domain.getId());
            attrs.put("zimbraServerId", server.getId());
            zlc.createEntry(dn, attrs, "createXMPPComponent");
            XMPPComponent comp = this.getXMPPComponentById(compId, zlc, true);
            AttributeManager.getInstance().postModify(inAttrs, comp, attrManagerContext, true);
            xMPPComponent = comp;
        }
        catch (NameAlreadyBoundException nabe) {
            try {
                throw AccountServiceException.IM_COMPONENT_EXISTS(name);
                catch (NamingException e) {
                    throw ServiceException.FAILURE("unable to create XMPPComponent", e);
                }
            }
            catch (Throwable throwable) {
                ZimbraLdapContext.closeContext(zlc);
                throw throwable;
            }
        }
        ZimbraLdapContext.closeContext(zlc);
        return xMPPComponent;
    }

    @Override
    public XMPPComponent get(Provisioning.XMPPComponentBy keyType, String key) throws ServiceException {
        switch (keyType) {
            case name: {
                return this.getXMPPComponentByName(key, false);
            }
            case id: {
                return this.getXMPPComponentById(key, null, false);
            }
            case serviceHostname: {
                throw new UnsupportedOperationException("Writeme!");
            }
        }
        return null;
    }

    @Override
    public void deleteXMPPComponent(XMPPComponent comp) throws ServiceException {
        String zimbraId = comp.getId();
        ZimbraLdapContext zlc = null;
        LdapXMPPComponent l = (LdapXMPPComponent)this.get(Provisioning.XMPPComponentBy.id, zimbraId);
        try {
            zlc = new ZimbraLdapContext(true);
            zlc.unbindEntry(l.getDN());
            sXMPPComponentCache.remove(l);
        }
        catch (NamingException e) {
            try {
                throw ServiceException.FAILURE("unable to purge XMPPComponent : " + zimbraId, e);
            }
            catch (Throwable throwable) {
                ZimbraLdapContext.closeContext(zlc);
                throw throwable;
            }
        }
        ZimbraLdapContext.closeContext(zlc);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void renameXMPPComponent(String zimbraId, String newName) throws ServiceException {
        LdapXMPPComponent comp = (LdapXMPPComponent)this.get(Provisioning.XMPPComponentBy.id, zimbraId);
        if (comp == null) {
            throw AccountServiceException.NO_SUCH_XMPP_COMPONENT(zimbraId);
        }
        newName = newName.toLowerCase().trim();
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext(true);
            String newDn = this.mDIT.xmppcomponentNameToDN(newName);
            zlc.renameEntry(comp.getDN(), newDn);
            sXMPPComponentCache.remove(comp);
        }
        catch (NameAlreadyBoundException nabe) {
            try {
                throw AccountServiceException.IM_COMPONENT_EXISTS(newName);
                catch (NamingException e) {
                    throw ServiceException.FAILURE("unable to rename XMPPComponent: " + zimbraId, e);
                }
            }
            catch (Throwable throwable) {
                ZimbraLdapContext.closeContext(zlc);
                throw throwable;
            }
        }
        ZimbraLdapContext.closeContext(zlc);
    }

    @Override
    public Right getRight(String rightName, boolean expandAllAttrs) throws ServiceException {
        if (expandAllAttrs) {
            throw ServiceException.FAILURE("expandAllAttrs == TRUE is not supported", null);
        }
        return RightCommand.getRight(rightName);
    }

    @Override
    public List<Right> getAllRights(String targetType, boolean expandAllAttrs) throws ServiceException {
        if (expandAllAttrs) {
            throw ServiceException.FAILURE("expandAllAttrs == TRUE is not supported", null);
        }
        return RightCommand.getAllRights(targetType);
    }

    @Override
    public boolean checkRight(String targetType, Provisioning.TargetBy targetBy, String target, Provisioning.GranteeBy granteeBy, String grantee, String right, Map<String, Object> attrs, AccessManager.ViaGrant via) throws ServiceException {
        return RightCommand.checkRight(this, targetType, targetBy, target, granteeBy, grantee, right, attrs, via);
    }

    @Override
    public RightCommand.AllEffectiveRights getAllEffectiveRights(String granteeType, Provisioning.GranteeBy granteeBy, String grantee, boolean expandSetAttrs, boolean expandGetAttrs) throws ServiceException {
        return RightCommand.getAllEffectiveRights(this, granteeType, granteeBy, grantee, expandSetAttrs, expandGetAttrs);
    }

    @Override
    public RightCommand.EffectiveRights getEffectiveRights(String targetType, Provisioning.TargetBy targetBy, String target, Provisioning.GranteeBy granteeBy, String grantee, boolean expandSetAttrs, boolean expandGetAttrs) throws ServiceException {
        return RightCommand.getEffectiveRights(this, targetType, targetBy, target, granteeBy, grantee, expandSetAttrs, expandGetAttrs);
    }

    @Override
    public RightCommand.EffectiveRights getCreateObjectAttrs(String targetType, Provisioning.DomainBy domainBy, String domainStr, Provisioning.CosBy cosBy, String cosStr, Provisioning.GranteeBy granteeBy, String grantee) throws ServiceException {
        return RightCommand.getCreateObjectAttrs(this, targetType, domainBy, domainStr, cosBy, cosStr, granteeBy, grantee);
    }

    @Override
    public RightCommand.Grants getGrants(String targetType, Provisioning.TargetBy targetBy, String target, String granteeType, Provisioning.GranteeBy granteeBy, String grantee, boolean granteeIncludeGroupsGranteeBelongs) throws ServiceException {
        return RightCommand.getGrants(this, targetType, targetBy, target, granteeType, granteeBy, grantee, granteeIncludeGroupsGranteeBelongs);
    }

    @Override
    public void grantRight(String targetType, Provisioning.TargetBy targetBy, String target, String granteeType, Provisioning.GranteeBy granteeBy, String grantee, String right, RightModifier rightModifier) throws ServiceException {
        RightCommand.grantRight(this, null, targetType, targetBy, target, granteeType, granteeBy, grantee, right, rightModifier);
    }

    @Override
    public void revokeRight(String targetType, Provisioning.TargetBy targetBy, String target, String granteeType, Provisioning.GranteeBy granteeBy, String grantee, String right, RightModifier rightModifier) throws ServiceException {
        RightCommand.revokeRight(this, null, targetType, targetBy, target, granteeType, granteeBy, grantee, right, rightModifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long countAccounts(String domain) throws ServiceException {
        String query = LdapFilter.allNonSystemAccounts();
        int numAccounts = 0;
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext();
            SearchControls searchControls = new SearchControls(2, 0L, 0, new String[]{"zimbraId", "objectclass"}, false, false);
            NamingEnumeration<SearchResult> ne = null;
            try {
                String dn = this.mDIT.domainToAccountSearchDN(domain);
                ne = zlc.searchDir(dn, query, searchControls);
                while (ne != null && ne.hasMore()) {
                    Attributes attrs;
                    Attribute objectclass;
                    SearchResult sr = (SearchResult)ne.nextElement();
                    dn = sr.getNameInNamespace();
                    if (dn.endsWith("cn=zimbra") || !(objectclass = (attrs = sr.getAttributes()).get("objectclass")).contains(C_zimbraAccount)) continue;
                    ++numAccounts;
                }
            }
            finally {
                if (ne != null) {
                    ne.close();
                }
            }
        }
        catch (NamingException e) {
            throw ServiceException.FAILURE("unable to count the users", e);
        }
        finally {
            ZimbraLdapContext.closeContext(zlc);
        }
        return numAccounts;
    }

    public String getNamingRdnAttr(Entry entry) throws ServiceException {
        return this.mDIT.getNamingRdnAttr(entry);
    }

    public String getDN(Entry entry) throws ServiceException {
        if (entry instanceof LdapMimeType) {
            return ((LdapMimeType)entry).getDN();
        }
        if (entry instanceof LdapCalendarResource) {
            return ((LdapCalendarResource)entry).getDN();
        }
        if (entry instanceof LdapAccount) {
            return ((LdapAccount)entry).getDN();
        }
        if (entry instanceof LdapAlias) {
            return ((LdapAlias)entry).getDN();
        }
        if (entry instanceof LdapCos) {
            return ((LdapCos)entry).getDN();
        }
        if (entry instanceof LdapDataSource) {
            return ((LdapDataSource)entry).getDN();
        }
        if (entry instanceof LdapDistributionList) {
            return ((LdapDistributionList)entry).getDN();
        }
        if (entry instanceof LdapDomain) {
            return ((LdapDomain)entry).getDN();
        }
        if (entry instanceof LdapIdentity) {
            return ((LdapIdentity)entry).getDN();
        }
        if (entry instanceof LdapSignature) {
            return ((LdapSignature)entry).getDN();
        }
        if (entry instanceof LdapServer) {
            return ((LdapServer)entry).getDN();
        }
        if (entry instanceof LdapZimlet) {
            return ((LdapZimlet)entry).getDN();
        }
        throw ServiceException.FAILURE("not a ldap entry", null);
    }

    @Override
    public void flushCache(Provisioning.CacheEntryType type, Provisioning.CacheEntry[] entries) throws ServiceException {
        switch (type) {
            case account: {
                if (entries != null) {
                    for (Provisioning.CacheEntry entry : entries) {
                        Provisioning.AccountBy accountBy = entry.mEntryBy == Provisioning.CacheEntryBy.id ? Provisioning.AccountBy.id : Provisioning.AccountBy.name;
                        Account account = this.getFromCache(accountBy, entry.mEntryIdentity);
                        if (account == null) continue;
                        this.removeFromCache(account);
                    }
                } else {
                    sAccountCache.clear();
                }
                return;
            }
            case group: {
                if (entries != null) {
                    for (Provisioning.CacheEntry entry : entries) {
                        Provisioning.DistributionListBy dlBy = entry.mEntryBy == Provisioning.CacheEntryBy.id ? Provisioning.DistributionListBy.id : Provisioning.DistributionListBy.name;
                        DistributionList aclGroup = this.getFromCache(dlBy, entry.mEntryIdentity);
                        if (aclGroup == null) continue;
                        this.removeFromCache(aclGroup);
                    }
                } else {
                    sGroupCache.clear();
                }
                return;
            }
            case config: {
                if (entries != null) {
                    throw ServiceException.INVALID_REQUEST("cannot specify entry for flushing global config", null);
                }
                Config config = this.getConfig();
                this.reload(config);
                return;
            }
            case cos: {
                if (entries != null) {
                    for (Provisioning.CacheEntry entry : entries) {
                        Provisioning.CosBy cosBy = entry.mEntryBy == Provisioning.CacheEntryBy.id ? Provisioning.CosBy.id : Provisioning.CosBy.name;
                        Cos cos = this.getFromCache(cosBy, entry.mEntryIdentity);
                        if (cos == null) continue;
                        this.reload(cos);
                    }
                } else {
                    sCosCache.clear();
                }
                return;
            }
            case domain: {
                if (entries != null) {
                    for (Provisioning.CacheEntry entry : entries) {
                        Provisioning.DomainBy domainBy = entry.mEntryBy == Provisioning.CacheEntryBy.id ? Provisioning.DomainBy.id : Provisioning.DomainBy.name;
                        Domain domain = this.getFromCache(domainBy, entry.mEntryIdentity);
                        if (domain == null) continue;
                        if (domain instanceof DomainCache.NonExistingDomain) {
                            sDomainCache.removeNonExisting(domainBy, entry.mEntryIdentity);
                            continue;
                        }
                        this.reload(domain);
                    }
                } else {
                    sDomainCache.clear();
                }
                return;
            }
            case server: {
                if (entries != null) {
                    for (Provisioning.CacheEntry entry : entries) {
                        Provisioning.ServerBy serverBy = entry.mEntryBy == Provisioning.CacheEntryBy.id ? Provisioning.ServerBy.id : Provisioning.ServerBy.name;
                        Server server = this.get(serverBy, entry.mEntryIdentity);
                        if (server == null) continue;
                        this.reload(server);
                    }
                } else {
                    sServerCache.clear();
                }
                return;
            }
            case zimlet: {
                if (entries != null) {
                    for (Provisioning.CacheEntry entry : entries) {
                        Provisioning.ZimletBy zimletBy = entry.mEntryBy == Provisioning.CacheEntryBy.id ? Provisioning.ZimletBy.id : Provisioning.ZimletBy.name;
                        Zimlet zimlet = this.getFromCache(zimletBy, entry.mEntryIdentity);
                        if (zimlet == null) continue;
                        this.reload(zimlet);
                    }
                } else {
                    sZimletCache.clear();
                }
                return;
            }
        }
        throw ServiceException.INVALID_REQUEST("invalid cache type " + (Object)((Object)type), null);
    }

    public void removeFromCache(Entry entry) {
        if (entry instanceof Account) {
            sAccountCache.remove((Account)entry);
        } else if (entry instanceof DistributionList) {
            sGroupCache.remove((DistributionList)entry);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public Provisioning.CountAccountResult countAccount(Domain domain) throws ServiceException {
        CountAccountVisitor visitor = new CountAccountVisitor(this);
        this.searchObjects(this.mDIT.filterAccountsByDomain(domain, false), new String[]{"zimbraCOSId", "zimbraIsSystemResource"}, this.mDIT.domainDNToAccountSearchDN(((LdapDomain)domain).getDN()), 1, visitor, 0);
        return visitor.getResult();
    }

    @Override
    public Map<String, String> getNamesForIds(Set<String> ids, Provisioning.EntryType type) throws ServiceException {
        String objectClass;
        String base;
        String nameAttr;
        Set<String> unresolvedIds;
        final HashMap<String, String> result = new HashMap<String, String>();
        final Provisioning.EntryType entryType = type;
        switch (entryType) {
            case account: {
                unresolvedIds = new HashSet<String>();
                for (String id : ids) {
                    Account entry = sAccountCache.getById(id);
                    if (entry != null) {
                        result.put(id, entry.getName());
                        continue;
                    }
                    unresolvedIds.add(id);
                }
                nameAttr = "zimbraMailDeliveryAddress";
                base = this.mDIT.mailBranchBaseDN();
                objectClass = C_zimbraAccount;
                break;
            }
            case group: {
                unresolvedIds = ids;
                nameAttr = "uid";
                base = this.mDIT.mailBranchBaseDN();
                objectClass = C_zimbraMailList;
                break;
            }
            case cos: {
                unresolvedIds = new HashSet<String>();
                for (String id : ids) {
                    LdapCos entry = sCosCache.getById(id);
                    if (entry != null) {
                        result.put(id, entry.getName());
                        continue;
                    }
                    unresolvedIds.add(id);
                }
                nameAttr = "cn";
                base = this.mDIT.cosBaseDN();
                objectClass = C_zimbraCOS;
                break;
            }
            case domain: {
                unresolvedIds = new HashSet<String>();
                for (String id : ids) {
                    Domain entry = sDomainCache.getById(id);
                    if (entry != null) {
                        result.put(id, entry.getName());
                        continue;
                    }
                    unresolvedIds.add(id);
                }
                nameAttr = "zimbraDomainName";
                base = this.mDIT.domainBaseDN();
                objectClass = C_zimbraDomain;
                break;
            }
            default: {
                throw ServiceException.FAILURE("unsupported entry type for getNamesForIds" + type.name(), null);
            }
        }
        if (unresolvedIds.size() == 0) {
            return result;
        }
        LdapUtil.SearchLdapVisitor visitor = new LdapUtil.SearchLdapVisitor(){

            @Override
            public void visit(String dn, Map<String, Object> attrs, Attributes ldapAttrs) {
                String id = (String)attrs.get("zimbraId");
                String name = null;
                try {
                    switch (entryType) {
                        case account: {
                            name = LdapUtil.getAttrString(ldapAttrs, "zimbraMailDeliveryAddress");
                            if (name != null) break;
                            name = LdapProvisioning.this.mDIT.dnToEmail(dn, ldapAttrs);
                            break;
                        }
                        case group: {
                            name = LdapProvisioning.this.mDIT.dnToEmail(dn, ldapAttrs);
                            break;
                        }
                        case cos: {
                            name = LdapUtil.getAttrString(ldapAttrs, "cn");
                            break;
                        }
                        case domain: {
                            name = LdapUtil.getAttrString(ldapAttrs, "zimbraDomainName");
                        }
                    }
                }
                catch (ServiceException e) {
                    name = null;
                }
                catch (NamingException e) {
                    name = null;
                }
                if (name != null) {
                    result.put(id, name);
                }
            }
        };
        String[] returnAttrs = new String[]{"zimbraId", nameAttr};
        this.searchNamesForIds(unresolvedIds, base, objectClass, returnAttrs, visitor);
        return result;
    }

    public void searchNamesForIds(Set<String> unresolvedIds, String base, String objectClass, String[] returnAttrs, LdapUtil.SearchLdapVisitor visitor) throws ServiceException {
        int batchSize = 10;
        String queryStart = "(&(objectClass=" + objectClass + ")(";
        String queryEnd = "))";
        StringBuilder query = new StringBuilder();
        query.append(queryStart);
        int i = 0;
        for (String id : unresolvedIds) {
            query.append("|(zimbraId=" + id + ")");
            if (++i % 10 != 0) continue;
            query.append("))");
            LdapUtil.searchLdapOnReplica(base, query.toString(), returnAttrs, visitor);
            query.setLength(0);
            query.append(queryStart);
        }
        if (query.length() != queryStart.length()) {
            query.append("))");
            LdapUtil.searchLdapOnReplica(base, query.toString(), returnAttrs, visitor);
        }
    }

    public static void testAuthDN(String[] args) {
        System.out.println(LdapUtil.computeAuthDn("schemers@example.zimbra.com", null));
        System.out.println(LdapUtil.computeAuthDn("schemers@example.zimbra.com", ""));
        System.out.println(LdapUtil.computeAuthDn("schemers@example.zimbra.com", "WTF"));
        System.out.println(LdapUtil.computeAuthDn("schemers@example.zimbra.com", "%n"));
        System.out.println(LdapUtil.computeAuthDn("schemers@example.zimbra.com", "%u"));
        System.out.println(LdapUtil.computeAuthDn("schemers@example.zimbra.com", "%d"));
        System.out.println(LdapUtil.computeAuthDn("schemers@example.zimbra.com", "%D"));
        System.out.println(LdapUtil.computeAuthDn("schemers@example.zimbra.com", "uid=%u,ou=people,%D"));
        System.out.println(LdapUtil.computeAuthDn("schemers@example.zimbra.com", "n(%n)u(%u)d(%d)D(%D)(%%)"));
    }

    public static void main(String[] args) throws Exception {
        LdapProvisioning prov = (LdapProvisioning)Provisioning.getInstance();
    }

    static {
        Validators.init();
    }

    private static class CountAccountVisitor
    implements NamedEntry.Visitor {
        Provisioning mProv;
        Map<String, Result> mResult = new HashMap<String, Result>();

        CountAccountVisitor(Provisioning prov) {
            this.mProv = prov;
        }

        public void visit(NamedEntry entry) throws ServiceException {
            if (!(entry instanceof Account)) {
                return;
            }
            if (entry instanceof CalendarResource) {
                return;
            }
            Account acct = (Account)entry;
            if (acct.getBooleanAttr("zimbraIsSystemResource", false)) {
                return;
            }
            Cos cos = this.mProv.getCOS(acct);
            Result r = this.mResult.get(cos.getId());
            if (r == null) {
                r = new Result(cos.getName());
                this.mResult.put(cos.getId(), r);
            }
            ++r.mCount;
        }

        Provisioning.CountAccountResult getResult() {
            Provisioning.CountAccountResult result = new Provisioning.CountAccountResult();
            for (Map.Entry<String, Result> r : this.mResult.entrySet()) {
                result.addCountAccountByCosResult(r.getKey(), r.getValue().mName, r.getValue().mCount);
            }
            return result;
        }

        private static class Result {
            String mName;
            long mCount;

            Result(String name) {
                this.mName = name;
                this.mCount = 0L;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NamedEntryComparator
    implements Comparator<NamedEntry> {
        final Provisioning mProv;
        final String mSortAttr;
        final boolean mSortAscending;
        final boolean mByName;

        NamedEntryComparator(Provisioning prov, String sortAttr, boolean sortAscending) {
            this.mProv = prov;
            this.mSortAttr = sortAttr;
            this.mSortAscending = sortAscending;
            this.mByName = sortAttr == null || sortAttr.equals("name");
        }

        @Override
        public int compare(NamedEntry oa, NamedEntry ob) {
            NamedEntry a = oa;
            NamedEntry b = ob;
            int comp = 0;
            if (this.mByName) {
                comp = a.getName().compareToIgnoreCase(b.getName());
            } else {
                String sa = null;
                String sb = null;
                if ("targetName".equals(this.mSortAttr) && a instanceof Alias && b instanceof Alias) {
                    try {
                        sa = ((Alias)a).getTargetUnicodeName(this.mProv);
                    }
                    catch (ServiceException e) {
                        ZimbraLog.account.error((Object)("unable to get target name: " + a.getName()), e);
                    }
                    try {
                        sb = ((Alias)b).getTargetUnicodeName(this.mProv);
                    }
                    catch (ServiceException e) {
                        ZimbraLog.account.error((Object)("unable to get target name: " + b.getName()), e);
                    }
                } else {
                    sa = a.getAttr(this.mSortAttr);
                    sb = b.getAttr(this.mSortAttr);
                }
                if (sa == null) {
                    sa = "";
                }
                if (sb == null) {
                    sb = "";
                }
                comp = sa.compareToIgnoreCase(sb);
            }
            return this.mSortAscending ? comp : -comp;
        }
    }

    public static interface ProvisioningValidator {
        public void validate(LdapProvisioning var1, String var2, Object ... var3) throws ServiceException;

        public void refresh();
    }

    protected static class ReplaceAddressResult {
        private String[] mOldAddrs;
        private String[] mNewAddrs;

        ReplaceAddressResult(String[] oldAddrs, String[] newAddrs) {
            this.mOldAddrs = oldAddrs;
            this.mNewAddrs = newAddrs;
        }

        public String[] oldAddrs() {
            return this.mOldAddrs;
        }

        public String[] newAddrs() {
            return this.mNewAddrs;
        }
    }
}

