/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.ldap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.ldap.LdapProvisioning;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapObjectClass {
    private static void addExtraObjectClasses(Set<String> ocs, LdapProvisioning prov, String extraOCAttr) throws ServiceException {
        String[] extraObjectClasses;
        for (String eoc : extraObjectClasses = prov.getConfig().getMultiAttr(extraOCAttr)) {
            ocs.add(eoc);
        }
    }

    public static Set<String> getAccountObjectClasses(LdapProvisioning prov, boolean zimbraDefaultOnly) throws ServiceException {
        LinkedHashSet<String> ocs = new LinkedHashSet<String>();
        ocs.add("organizationalPerson");
        ocs.add("zimbraAccount");
        if (!zimbraDefaultOnly) {
            LdapObjectClass.addExtraObjectClasses(ocs, prov, "zimbraAccountExtraObjectClass");
        }
        return ocs;
    }

    public static Set<String> getAccountObjectClasses(LdapProvisioning prov) throws ServiceException {
        return LdapObjectClass.getAccountObjectClasses(prov, false);
    }

    public static Set<String> getCalendarResourceObjectClasses(LdapProvisioning prov) throws ServiceException {
        LinkedHashSet<String> ocs = new LinkedHashSet<String>();
        ocs.add("zimbraCalendarResource");
        LdapObjectClass.addExtraObjectClasses(ocs, prov, "zimbraCalendarResourceExtraObjectClass");
        return ocs;
    }

    public static Set<String> getCosObjectClasses(LdapProvisioning prov) throws ServiceException {
        LinkedHashSet<String> ocs = new LinkedHashSet<String>();
        ocs.add("zimbraCOS");
        LdapObjectClass.addExtraObjectClasses(ocs, prov, "zimbraCosExtraObjectClass");
        return ocs;
    }

    public static Set<String> getDomainObjectClasses(LdapProvisioning prov) throws ServiceException {
        LinkedHashSet<String> ocs = new LinkedHashSet<String>();
        ocs.add("dcObject");
        ocs.add("organization");
        ocs.add("zimbraDomain");
        LdapObjectClass.addExtraObjectClasses(ocs, prov, "zimbraDomainExtraObjectClass");
        return ocs;
    }

    public static Set<String> getServerObjectClasses(LdapProvisioning prov) throws ServiceException {
        LinkedHashSet<String> ocs = new LinkedHashSet<String>();
        ocs.add("zimbraServer");
        LdapObjectClass.addExtraObjectClasses(ocs, prov, "zimbraServerExtraObjectClass");
        return ocs;
    }

    public static void main(String[] args) throws ServiceException {
        LdapProvisioning prov = (LdapProvisioning)Provisioning.getInstance();
        Set<String> ocs = LdapObjectClass.getCalendarResourceObjectClasses(prov);
        for (String oc : ocs) {
            System.out.println(oc);
        }
    }
}

