/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.ldap;

import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.ldap.LdapEntry;
import com.zimbra.cs.account.ldap.LdapUtil;
import com.zimbra.cs.mime.MimeTypeInfo;
import java.util.Set;
import java.util.TreeSet;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LdapMimeType
extends Entry
implements LdapEntry,
MimeTypeInfo {
    private String mDn;

    LdapMimeType(String dn, Attributes attrs, Provisioning prov) throws NamingException {
        super(LdapUtil.getAttrs(attrs), null, prov);
        this.mDn = dn;
    }

    @Override
    public String getLabel() {
        return this.mDn;
    }

    @Override
    public String[] getMimeTypes() {
        return super.getMultiAttr("zimbraMimeType");
    }

    @Override
    public String getHandlerClass() {
        return super.getAttr("zimbraMimeHandlerClass", null);
    }

    @Override
    public boolean isIndexingEnabled() {
        return super.getBooleanAttr("zimbraMimeIndexingEnabled", true);
    }

    @Override
    public String getDescription() {
        return super.getAttr("description", "");
    }

    @Override
    public Set<String> getFileExtensions() {
        String[] extensions = super.getMultiAttr("zimbraMimeFileExtension");
        TreeSet<String> extSet = new TreeSet<String>();
        for (String ext : extensions) {
            if (ext == null) continue;
            extSet.add(ext.toLowerCase());
        }
        return extSet;
    }

    @Override
    public String getExtension() {
        return super.getAttr("zimbraMimeHandlerExtension", null);
    }

    @Override
    public String getDN() {
        return this.mDn;
    }

    @Override
    public int getPriority() {
        return super.getIntAttr("zimbraMimePriority", 0);
    }
}

