/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.ldap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.DateUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LdapLockoutPolicy {
    private String[] mFailures;
    private List<String> mFailuresToRemove;
    private Provisioning mProv;
    private Account mAccount;
    private boolean mEnabled;
    private long mMaxFailures;
    private boolean mLockoutExpired;
    private boolean mIsLockedOut;
    private String mAccountStatus;

    LdapLockoutPolicy(Provisioning prov, Account account) throws ServiceException {
        this.mAccount = account;
        this.mProv = prov;
        this.mAccountStatus = account.getAccountStatus(prov);
        this.mMaxFailures = this.mAccount.getLongAttr("zimbraPasswordLockoutMaxFailures", 0L);
        this.mEnabled = this.mMaxFailures > 0L && this.mAccount.getBooleanAttr("zimbraPasswordLockoutEnabled", false);
        this.mFailures = this.mAccount.getMultiAttr("zimbraPasswordLockoutFailureTime");
        this.mIsLockedOut = this.computeIsLockedOut();
    }

    private boolean computeIsLockedOut() throws ServiceException {
        if (!this.mEnabled) {
            return false;
        }
        Date locked = this.mAccount.getGeneralizedTimeAttr("zimbraPasswordLockoutLockedTime", null);
        if (locked == null) {
            return false;
        }
        long duration = this.mAccount.getTimeInterval("zimbraPasswordLockoutDuration", 0L);
        if (duration != 0L && System.currentTimeMillis() > locked.getTime() + duration) {
            this.mLockoutExpired = true;
            return false;
        }
        return this.mAccountStatus.equalsIgnoreCase("lockout");
    }

    public boolean isLockedOut() {
        return this.mIsLockedOut;
    }

    private int updateFailureTimes(Map<String, Object> attrs) {
        boolean removeOldest;
        long duration = this.mAccount.getTimeInterval("zimbraPasswordLockoutFailureLifetime", 0L);
        if (duration != 0L) {
            String expiredTime = DateUtil.toGeneralizedTime(new Date(System.currentTimeMillis() - duration));
            for (String failure : this.mFailures) {
                if (failure.compareTo(expiredTime) >= 0) continue;
                if (this.mFailuresToRemove == null) {
                    this.mFailuresToRemove = new ArrayList<String>();
                }
                this.mFailuresToRemove.add(failure);
            }
        }
        String currentFailure = DateUtil.toGeneralizedTime(new Date());
        boolean bl = removeOldest = (long)this.mFailures.length == this.mMaxFailures && this.mFailuresToRemove == null;
        if (removeOldest) {
            int j = 0;
            for (int i = 1; i < this.mFailures.length; ++i) {
                if (this.mFailures[i].compareTo(this.mFailures[j]) >= 0) continue;
                j = i;
            }
            for (String f : this.mFailures) {
                if (!f.equalsIgnoreCase(currentFailure)) continue;
                removeOldest = false;
                break;
            }
            if (removeOldest) {
                attrs.put("-zimbraPasswordLockoutFailureTime", this.mFailures[j]);
            }
        } else if (this.mFailuresToRemove != null) {
            attrs.put("-zimbraPasswordLockoutFailureTime", this.mFailuresToRemove);
        }
        attrs.put("+zimbraPasswordLockoutFailureTime", currentFailure);
        return 1 + this.mFailures.length - (removeOldest ? 1 : 0) - (this.mFailuresToRemove == null ? 0 : this.mFailuresToRemove.size());
    }

    public void successfulLogin() {
        if (!this.mEnabled) {
            return;
        }
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.mFailures.length > 0) {
            attrs.put("zimbraPasswordLockoutFailureTime", "");
        }
        if (this.mLockoutExpired) {
            if (this.mAccountStatus.equalsIgnoreCase("lockout")) {
                attrs.put("zimbraAccountStatus", "active");
            }
            attrs.put("zimbraPasswordLockoutLockedTime", "");
        }
        try {
            if (attrs.size() > 0) {
                this.mProv.modifyAttrs(this.mAccount, attrs);
            }
        }
        catch (Exception e) {
            ZimbraLog.account.warn((Object)("Unable to update account password lockout attrs: " + this.mAccount.getName()), e);
        }
    }

    public void failedLogin() {
        if (!this.mEnabled) {
            return;
        }
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        int totalFailures = this.updateFailureTimes(attrs);
        if ((long)totalFailures >= this.mMaxFailures && !this.mIsLockedOut) {
            ZimbraLog.security.info(ZimbraLog.encodeAttrs(new String[]{"cmd", "Auth", "account", this.mAccount.getName(), "error", "account lockout due to too many failed logins"}));
            attrs.put("zimbraPasswordLockoutLockedTime", DateUtil.toGeneralizedTime(new Date()));
            attrs.put("zimbraAccountStatus", "lockout");
        }
        try {
            this.mProv.modifyAttrs(this.mAccount, attrs);
        }
        catch (Exception e) {
            ZimbraLog.account.warn((Object)("Unable to update account password lockout attrs: " + this.mAccount.getName()), e);
        }
    }
}

