/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.ldap;

import com.zimbra.cs.account.ldap.LdapGalMapRule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.directory.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapGalMapRules {
    private List<LdapGalMapRule> mRules;
    private List<String> mLdapAttrs;

    public LdapGalMapRules(String[] rules) {
        this.mRules = new ArrayList<LdapGalMapRule>(rules.length);
        this.mLdapAttrs = new ArrayList<String>();
        for (String rule : rules) {
            this.add(rule);
        }
    }

    public String[] getLdapAttrs() {
        return this.mLdapAttrs.toArray(new String[this.mLdapAttrs.size()]);
    }

    public Map<String, Object> apply(Attributes ldapAttrs) {
        HashMap<String, Object> contactAttrs = new HashMap<String, Object>();
        for (LdapGalMapRule rule : this.mRules) {
            rule.apply(ldapAttrs, contactAttrs);
        }
        return contactAttrs;
    }

    public void add(String rule) {
        LdapGalMapRule lgmr = new LdapGalMapRule(rule);
        this.mRules.add(lgmr);
        for (String ldapattr : lgmr.getLdapAttrs()) {
            this.mLdapAttrs.add(ldapattr);
        }
    }
}

