/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.ldap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AttributeManager;
import com.zimbra.cs.account.IDNUtil;
import com.zimbra.cs.account.ldap.LdapUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LdapGalMapRule {
    private String[] mLdapAttrs;
    private String[] mContactAttrs;

    public LdapGalMapRule(String rule) {
        int p = rule.indexOf(61);
        if (p != -1) {
            String[] stringArray;
            String[] stringArray2;
            String ldapAttr = rule.substring(0, p);
            String contactAttr = rule.substring(p + 1);
            if (ldapAttr.indexOf(44) != -1) {
                stringArray2 = ldapAttr.split(",");
            } else {
                String[] stringArray3 = new String[1];
                stringArray2 = stringArray3;
                stringArray3[0] = ldapAttr;
            }
            this.mLdapAttrs = stringArray2;
            if (contactAttr.indexOf(44) != -1) {
                stringArray = contactAttr.split(",");
            } else {
                String[] stringArray4 = new String[1];
                stringArray = stringArray4;
                stringArray4[0] = contactAttr;
            }
            this.mContactAttrs = stringArray;
        }
    }

    public static List<LdapGalMapRule> parseRules(String[] rules) {
        ArrayList<LdapGalMapRule> result = new ArrayList<LdapGalMapRule>(rules.length);
        for (String rule : rules) {
            result.add(new LdapGalMapRule(rule));
        }
        return result;
    }

    public String[] getLdapAttrs() {
        return this.mLdapAttrs;
    }

    public String[] getContactAttrs() {
        return this.mContactAttrs;
    }

    private int addToContactAttrs(Map<String, Object> contactAttrs, Object value, int index) {
        if (index >= this.mContactAttrs.length) {
            return index;
        }
        for (int i = 0; i < index; ++i) {
            Object v = contactAttrs.get(this.mContactAttrs[i]);
            if (v == null || !v.equals(value)) continue;
            return index;
        }
        contactAttrs.put(this.mContactAttrs[index++], value);
        return index;
    }

    void apply(Attributes ldapAttrs, Map<String, Object> contactAttrs) {
        AttributeManager attrMgr = null;
        try {
            attrMgr = AttributeManager.getInstance();
        }
        catch (ServiceException se) {
            ZimbraLog.account.warn((Object)"failed to get AttributeManager instance", se);
        }
        int index = 0;
        for (String ldapAttr : this.mLdapAttrs) {
            String[] val;
            if (index >= this.mContactAttrs.length) {
                return;
            }
            try {
                val = LdapUtil.getMultiAttrString(ldapAttrs, ldapAttr);
            }
            catch (NamingException e) {
                return;
            }
            AttributeManager.IDNType idnType = AttributeManager.idnType(attrMgr, ldapAttr);
            if (val.length == 1) {
                index = this.addToContactAttrs(contactAttrs, IDNUtil.toUnicode(val[0], idnType), index);
                continue;
            }
            if (val.length <= 1) continue;
            if (this.mContactAttrs.length == 1) {
                index = this.addToContactAttrs(contactAttrs, val, index);
                return;
            }
            for (int i = 0; i < val.length; ++i) {
                if (index >= this.mContactAttrs.length) {
                    return;
                }
                index = this.addToContactAttrs(contactAttrs, IDNUtil.toUnicode(val[i], idnType), index);
            }
        }
    }
}

