/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.ldap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.StringUtil;

public class LdapGalCredential {
    String mAuthMech;
    String mBindDn;
    String mBindPassword;
    String mKrb5Principal;
    String mKrb5Keytab;

    public LdapGalCredential(String authMech, String bindDn, String bindPassword, String krb5Principal, String krb5Keytab) throws ServiceException {
        if (StringUtil.isNullOrEmpty(authMech)) {
            authMech = bindDn != null && bindPassword != null ? "simple" : "none";
        }
        if (!authMech.equals("none")) {
            if (authMech.equals("simple")) {
                if (bindDn == null || bindPassword == null) {
                    throw ServiceException.INVALID_REQUEST("missing bindDn or bindPassword for LDAP GAL auth mechenism " + authMech, null);
                }
            } else if (authMech.equals("kerberos5")) {
                if (krb5Principal == null || krb5Keytab == null) {
                    throw ServiceException.INVALID_REQUEST("missing krb5Principal or krb5Keytab for LDAP GAL auth mechenism " + authMech, null);
                }
            } else {
                throw ServiceException.INVALID_REQUEST("invalid LDAP GAL auth mechenism " + authMech, null);
            }
        }
        this.mAuthMech = authMech;
        this.mBindDn = bindDn;
        this.mBindPassword = bindPassword;
        this.mKrb5Principal = krb5Principal;
        this.mKrb5Keytab = krb5Keytab;
    }

    String getAuthMech() {
        return this.mAuthMech;
    }

    String getBindDn() {
        return this.mBindDn;
    }

    String getBindPassword() {
        return this.mBindPassword;
    }

    String getKrb5Principal() {
        return this.mKrb5Principal;
    }

    String getKrb5Keytab() {
        return this.mKrb5Keytab;
    }
}

