/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.ldap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.EntrySearchFilter;
import com.zimbra.cs.account.ldap.LdapEntrySearchFilter;

public class LdapFilterParser {
    public static EntrySearchFilter.Term parse(String filterStr) throws ServiceException {
        return LdapFilterParser.parse(filterStr, 0, filterStr.length());
    }

    private static EntrySearchFilter.Term parse(String filterStr, int startPos, int endPos) throws ServiceException {
        char c;
        String dbgInfo = "filter=" + filterStr + ", startPos=" + startPos + ", endPos=" + endPos;
        if (endPos - startPos <= 0) {
            throw ServiceException.PARSE_ERROR(dbgInfo, null);
        }
        if (filterStr.charAt(startPos) == '(') {
            if (filterStr.charAt(endPos - 1) == ')') {
                ++startPos;
                --endPos;
            } else {
                throw ServiceException.PARSE_ERROR("mising parentheses: " + dbgInfo, null);
            }
        }
        if ((c = filterStr.charAt(startPos)) == '&') {
            return LdapFilterParser.parseCompound(FilterType.AND, filterStr, startPos + 1, endPos);
        }
        if (c == '|') {
            return LdapFilterParser.parseCompound(FilterType.OR, filterStr, startPos + 1, endPos);
        }
        if (c == '!') {
            return LdapFilterParser.parseCompound(FilterType.NOT, filterStr, startPos + 1, endPos);
        }
        return LdapFilterParser.parseSimple(filterStr, startPos, endPos);
    }

    private static EntrySearchFilter.Multi parseCompound(FilterType filterType, String filterStr, int startPos, int endPos) throws ServiceException {
        String dbgInfo = "filter=" + filterStr + ", startPos=" + startPos + ", endPos=" + endPos;
        if (startPos == endPos) {
            throw ServiceException.PARSE_ERROR(dbgInfo, null);
        }
        if (filterStr.charAt(startPos) != '(' || filterStr.charAt(endPos - 1) != ')') {
            throw ServiceException.PARSE_ERROR("mising parentheses: " + dbgInfo, null);
        }
        EntrySearchFilter.AndOr andOr = filterType == FilterType.OR ? EntrySearchFilter.AndOr.or : EntrySearchFilter.AndOr.and;
        boolean negation = filterType == FilterType.NOT;
        EntrySearchFilter.Multi multi = new EntrySearchFilter.Multi(negation, andOr);
        int pendingOpens = 0;
        int openPos = -1;
        for (int i = startPos; i < endPos; ++i) {
            char c = filterStr.charAt(i);
            if (c == '(') {
                if (openPos < 0) {
                    openPos = i;
                }
                ++pendingOpens;
                continue;
            }
            if (c == ')') {
                if (--pendingOpens == 0) {
                    EntrySearchFilter.Term subTerm = LdapFilterParser.parse(filterStr, openPos, i + 1);
                    multi.add(subTerm);
                    openPos = -1;
                    continue;
                }
                if (pendingOpens >= 0) continue;
                throw ServiceException.PARSE_ERROR("mising open parentheses: " + dbgInfo, null);
            }
            if (pendingOpens > 0) continue;
            throw ServiceException.PARSE_ERROR("mising parentheses: " + dbgInfo, null);
        }
        if (pendingOpens != 0) {
            throw ServiceException.PARSE_ERROR("mising parentheses: " + dbgInfo, null);
        }
        return multi;
    }

    private static EntrySearchFilter.Single parseSimple(String filterStr, int startPos, int endPos) throws ServiceException {
        int attrEndPos;
        EntrySearchFilter.Operator op;
        String dbgInfo = "filter=" + filterStr + ", startPos=" + startPos + ", endPos=" + endPos;
        int equalPos = -1;
        for (int i = startPos; i < endPos; ++i) {
            if (filterStr.charAt(i) != '=') continue;
            equalPos = i;
            break;
        }
        if (equalPos == -1 || equalPos == startPos) {
            throw ServiceException.PARSE_ERROR(dbgInfo, null);
        }
        switch (filterStr.charAt(equalPos - 1)) {
            case '>': {
                op = EntrySearchFilter.Operator.ge;
                attrEndPos = equalPos - 1;
                break;
            }
            case '<': {
                op = EntrySearchFilter.Operator.le;
                attrEndPos = equalPos - 1;
                break;
            }
            case '~': {
                throw ServiceException.PARSE_ERROR("approx match not supported " + dbgInfo, null);
            }
            case ':': {
                throw ServiceException.PARSE_ERROR("extensible match not supported " + dbgInfo, null);
            }
            default: {
                op = EntrySearchFilter.Operator.eq;
                attrEndPos = equalPos;
            }
        }
        String attrName = filterStr.substring(startPos, attrEndPos);
        if (attrName.length() == 0) {
            throw ServiceException.PARSE_ERROR("missing attr name" + dbgInfo, null);
        }
        String attrValue = filterStr.substring(equalPos + 1, endPos);
        if (attrValue.length() == 0) {
            throw ServiceException.PARSE_ERROR("missing attr value" + dbgInfo, null);
        }
        if (op == EntrySearchFilter.Operator.eq && !attrValue.equals("*")) {
            if (attrValue.startsWith("*") && attrValue.endsWith("*")) {
                if (attrValue.length() > 2) {
                    op = EntrySearchFilter.Operator.has;
                    attrValue = attrValue.substring(1, attrValue.length() - 1);
                }
            } else if (attrValue.startsWith("*")) {
                op = EntrySearchFilter.Operator.endswith;
                attrValue = attrValue.substring(1, attrValue.length());
            } else if (attrValue.endsWith("*")) {
                op = EntrySearchFilter.Operator.startswith;
                attrValue = attrValue.substring(0, attrValue.length() - 1);
            }
        }
        return new EntrySearchFilter.Single(false, attrName, op, attrValue);
    }

    public static String test(String inFilterStr) {
        String outFilterStr = LdapEntrySearchFilter.toLdapIDNFilter(inFilterStr);
        System.out.println("In: " + inFilterStr);
        System.out.println("Out: " + outFilterStr);
        System.out.println();
        return outFilterStr;
    }

    public static void main(String[] args) {
        LdapFilterParser.test("!(zimbraDomainName=*\u4e2d\u6587*)");
        LdapFilterParser.test("!(objectClass=*)");
        LdapFilterParser.test("!(objectClass=**)");
        LdapFilterParser.test("!(objectClass=*abc)");
        LdapFilterParser.test("!(objectClass=abc*)");
        LdapFilterParser.test("!(objectClass=*abc*)");
        LdapFilterParser.test("(|(zimbraMailDeliveryAddress=*@test.\u4e2d\u6587.com)(zimbraMailAlias=*@test.\u4e2d\u6587.com))");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FilterType {
        AND,
        OR,
        NOT;

    }
}

