/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.ldap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.ldap.LdapProvisioning;

public class LdapFilter {
    private static final String FILTER_ACCOUNT_OBJECTCLASS = "(objectclass=zimbraAccount)";
    private static final String FILTER_CALENDAR_RESOURCE_OBJECTCLASS = "(objectclass=zimbraCalendarResource)";
    private static final String FILTER_DISTRIBUTION_LIST_OBJECTCLASS = "(objectclass=zimbraDistributionList)";

    public static String allNonSystemAccounts() {
        StringBuilder buf = new StringBuilder();
        buf.append("(&");
        buf.append("(!(zimbraIsSystemResource=TRUE))");
        buf.append("(objectclass=zimbraAccount)(!(objectclass=zimbraCalendarResource))");
        buf.append(")");
        return buf.toString();
    }

    public static String accountByForeignPrincipal(String foreignPrincipal) {
        return "(&(zimbraForeignPrincipal=" + foreignPrincipal + ")" + FILTER_ACCOUNT_OBJECTCLASS + ")";
    }

    public static String accountById(String id) {
        return "(&(zimbraId=" + id + ")" + FILTER_ACCOUNT_OBJECTCLASS + ")";
    }

    public static String accountByName(String name) {
        return "(&(|(zimbraMailDeliveryAddress=" + name + ")(zimbraMailAlias=" + name + "))" + FILTER_ACCOUNT_OBJECTCLASS + ")";
    }

    public static String adminAccountByRDN(String namingRdnAttr, String name) {
        return "(&(" + namingRdnAttr + "=" + name + ")" + FILTER_ACCOUNT_OBJECTCLASS + ")";
    }

    public static String adminAccountByAdminFlag() {
        return "(|(zimbraIsAdminAccount=TRUE)(zimbraIsDelegatedAdminAccount=TRUE)(zimbraIsDomainAdminAccount=TRUE))";
    }

    public static String allCalendarResources() {
        return FILTER_CALENDAR_RESOURCE_OBJECTCLASS;
    }

    public static String calendarResourceByForeignPrincipal(String foreignPrincipal) {
        return "(&(zimbraForeignPrincipal=" + foreignPrincipal + ")" + FILTER_CALENDAR_RESOURCE_OBJECTCLASS + ")";
    }

    public static String calendarResourceById(String id) {
        return "(&(zimbraId=" + id + ")" + FILTER_CALENDAR_RESOURCE_OBJECTCLASS + ")";
    }

    public static String calendarResourceByName(String name) {
        return "(&(|(zimbraMailDeliveryAddress=" + name + ")(zimbraMailAlias=" + name + "))" + FILTER_CALENDAR_RESOURCE_OBJECTCLASS + ")";
    }

    public static String allCoses() {
        return "(objectclass=zimbraCOS)";
    }

    public static String cosById(String id) {
        return "(&(zimbraId=" + id + ")(objectclass=zimbraCOS))";
    }

    public static String cosesByMailHostPool(String server) {
        return "(&(objectclass=zimbraCOS)(zimbraMailHostPool=" + server + "))";
    }

    public static String allDataSources() {
        return "(objectclass=zimbraDataSource)";
    }

    public static String dataSourceById(String id) {
        return "(&(objectclass=zimbraDataSource)(zimbraDataSourceId=" + id + "))";
    }

    public static String dataSourceByName(String name) {
        return "(&(objectclass=zimbraDataSource)(zimbraDataSourceName=" + name + "))";
    }

    public static String imComponentById(String id) {
        return "(&(objectclass=zimbraXMPPComponent)(zimbraXMPPComponentId=" + id + "))";
    }

    public static String allDistributionLists() {
        return FILTER_DISTRIBUTION_LIST_OBJECTCLASS;
    }

    public static String distributionListById(String id) {
        return "(&(zimbraId=" + id + ")" + FILTER_DISTRIBUTION_LIST_OBJECTCLASS + ")";
    }

    public static String distributionListByName(String name) {
        return "(&(zimbraMailAlias=" + name + ")" + FILTER_DISTRIBUTION_LIST_OBJECTCLASS + ")";
    }

    public static String allDomains() {
        return "(objectclass=zimbraDomain)";
    }

    public static String domainById(String id) {
        return "(&(zimbraId=" + id + ")(objectclass=zimbraDomain))";
    }

    public static String domainByName(String name) {
        return "(&(zimbraDomainName=" + name + ")(objectclass=zimbraDomain))";
    }

    public static String domainByKrb5Realm(String krb5Realm) {
        return "(&(zimbraAuthKerberos5Realm=" + krb5Realm + ")(objectclass=zimbraDomain))";
    }

    public static String domainByVirtualHostame(String virtualHostname) {
        return "(&(zimbraVirtualHostname=" + virtualHostname + ")(objectclass=zimbraDomain))";
    }

    public static String domainLabel() {
        return "objectclass=dcObject";
    }

    public static String allIdentities() {
        return "(objectclass=zimbraIdentity)";
    }

    public static String identityByName(String name) {
        return "(&(objectclass=zimbraIdentity)(zimbraPrefIdentityName=" + name + "))";
    }

    public static String allMimeEntries() {
        return "(objectclass=zimbraMimeEntry)";
    }

    public static String mimeEntryByMimeType(String mimeType) {
        return "(zimbraMimeType=" + mimeType + ")";
    }

    public static String allServers() {
        return "(objectclass=zimbraServer)";
    }

    public static String serverById(String id) {
        return "(&(zimbraId=" + id + ")(objectclass=zimbraServer))";
    }

    public static String serverByService(String service) {
        return "(&(objectclass=zimbraServer)(zimbraServiceEnabled=" + service + "))";
    }

    public static String allSignatures() {
        return "(objectclass=zimbraSignature)";
    }

    public static String signatureById(String id) {
        return "(&(objectclass=zimbraSignature)(zimbraSignatureId=" + id + "))";
    }

    public static String allZimlets() {
        return "(objectclass=zimbraZimletEntry)";
    }

    public static String xmppComponentById(String id) {
        return "(&(zimbraId=" + id + ")(objectclass=zimbraXMPPComponent))";
    }

    public static String allXMPPComponents() {
        return "(objectclass=zimbraXMPPComponent)";
    }

    private static void printFilter(String doc, String usage, String base, String filter) {
        System.out.println();
        System.out.println(doc);
        System.out.println("usage:  " + usage);
        System.out.println("base:   " + base);
        System.out.println("filter: " + filter);
    }

    private static void printFilters(LdapProvisioning prov) throws ServiceException {
        LdapFilter.printFilter("all non system accounts", "create account(count account for license)", prov.getDIT().domainToAccountSearchDN("example.com"), LdapFilter.allNonSystemAccounts());
        LdapFilter.printFilter("account by foreign principal", "general", prov.getDIT().mailBranchBaseDN(), LdapFilter.accountByForeignPrincipal("{foreign principal}"));
        LdapFilter.printFilter("account by id", "general", prov.getDIT().mailBranchBaseDN(), LdapFilter.accountById("{account id}"));
        LdapFilter.printFilter("account by email", "general", prov.getDIT().mailBranchBaseDN(), LdapFilter.accountByName("{account email}"));
        LdapFilter.printFilter("admin account by RDN", "admin account access", prov.getDIT().adminBaseDN(), LdapFilter.adminAccountByRDN(prov.getDIT().accountNamingRdnAttr(), "{admin name}"));
        LdapFilter.printFilter("all calendar resources", "admin console, zmprov", prov.getDIT().mailBranchBaseDN(), LdapFilter.allCalendarResources());
        LdapFilter.printFilter("calendar resource by foreign principal", "general", prov.getDIT().mailBranchBaseDN(), LdapFilter.calendarResourceByForeignPrincipal("{foreign principal}"));
        LdapFilter.printFilter("calendar resource by id", "general", prov.getDIT().mailBranchBaseDN(), LdapFilter.calendarResourceById("{calendar resource id}"));
        LdapFilter.printFilter("calendar resource by name", "general", prov.getDIT().mailBranchBaseDN(), LdapFilter.calendarResourceByName("{calendar resource name}"));
        LdapFilter.printFilter("all coses", "admin console, zmprov", prov.getDIT().cosBaseDN(), LdapFilter.allCoses());
        LdapFilter.printFilter("cos by id", "general", prov.getDIT().cosBaseDN(), LdapFilter.cosById("{cos id}"));
        LdapFilter.printFilter("coses have certain server in its server pool", "delete server (to remove the server from all coses)", prov.getDIT().cosBaseDN(), LdapFilter.cosesByMailHostPool("{server name}"));
        LdapFilter.printFilter("all data sources", "general", "account DN", LdapFilter.allDataSources());
        LdapFilter.printFilter("data source by id", "general", "account DN", LdapFilter.dataSourceById("{data source id}"));
        LdapFilter.printFilter("data source by name", "general", "account DN", LdapFilter.dataSourceByName("{data source name}"));
        LdapFilter.printFilter("all distribution lists", "admin console, zmprov", prov.getDIT().mailBranchBaseDN(), LdapFilter.allDistributionLists());
        LdapFilter.printFilter("distributuion list by id", "general", prov.getDIT().mailBranchBaseDN(), LdapFilter.distributionListById("{dist list id}"));
        LdapFilter.printFilter("distributuion list by name", "general", prov.getDIT().mailBranchBaseDN(), LdapFilter.distributionListByName("{dist list name}"));
        LdapFilter.printFilter("all domains", "admin console, zmprov", prov.getDIT().domainBaseDN(), LdapFilter.allDomains());
        LdapFilter.printFilter("domain by id", "general", prov.getDIT().domainBaseDN(), LdapFilter.domainById("{domain id}"));
        LdapFilter.printFilter("domain by krb5 realm", "general", prov.getDIT().domainBaseDN(), LdapFilter.domainByKrb5Realm("{krb5 realm}"));
        LdapFilter.printFilter("domain by name", "general", prov.getDIT().domainBaseDN(), LdapFilter.domainByName("{domain name}"));
        LdapFilter.printFilter("domain by virtual hostname", "general", prov.getDIT().domainBaseDN(), LdapFilter.domainByVirtualHostame("{virtual hostname}"));
        LdapFilter.printFilter("test if a domain label(dot separated segments) exists", "create domain", "{parent domain DN}", LdapFilter.domainLabel());
        LdapFilter.printFilter("all identities", "general", "account DN", LdapFilter.allIdentities());
        LdapFilter.printFilter("identity by name", "general", "account DN", LdapFilter.identityByName("{identity name}"));
        LdapFilter.printFilter("all mime entries", "general", prov.getDIT().mimeBaseDN(), LdapFilter.allMimeEntries());
        LdapFilter.printFilter("mime entry by mime type", "general", prov.getDIT().mimeBaseDN(), LdapFilter.mimeEntryByMimeType("{mime type}"));
        LdapFilter.printFilter("all signatures", "general", "account DN", LdapFilter.allSignatures());
        LdapFilter.printFilter("signature by id", "general", "account DN", LdapFilter.signatureById("{signature id}"));
        LdapFilter.printFilter("all servers", "admin console, zmprov", prov.getDIT().serverBaseDN(), LdapFilter.allServers());
        LdapFilter.printFilter("server by id", "general", prov.getDIT().serverBaseDN(), LdapFilter.serverById("{server id}"));
        LdapFilter.printFilter("server by service", "general", prov.getDIT().serverBaseDN(), LdapFilter.serverByService("{service}"));
        LdapFilter.printFilter("all zimlets", "general", prov.getDIT().zimletBaseDN(), LdapFilter.allZimlets());
    }

    public static void main(String[] args) throws Exception {
        LdapProvisioning prov = (LdapProvisioning)Provisioning.getInstance();
        LdapFilter.printFilters(prov);
    }
}

