/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.ldap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AttributeManager;
import com.zimbra.cs.account.EntrySearchFilter;
import com.zimbra.cs.account.IDNUtil;
import com.zimbra.cs.account.ldap.LdapFilterParser;
import com.zimbra.cs.account.ldap.LdapUtil;

public class LdapEntrySearchFilter {
    public static EntrySearchFilter sCalendarResourcesFilter;

    public static String toLdapIDNFilter(String filterStr) {
        String asciiQuery;
        try {
            EntrySearchFilter.Term term = LdapFilterParser.parse(filterStr);
            EntrySearchFilter filter = new EntrySearchFilter(term);
            asciiQuery = LdapEntrySearchFilter.toLdapIDNFilter(filter);
            ZimbraLog.account.debug("original query=[" + filterStr + "], converted ascii query=[" + asciiQuery + "]");
        }
        catch (ServiceException e) {
            ZimbraLog.account.warn((Object)("unable to convert query to ascii, using original query: " + filterStr), e);
            asciiQuery = filterStr;
        }
        return asciiQuery;
    }

    private static String toLdapIDNFilter(EntrySearchFilter filter) throws ServiceException {
        LdapQueryVisitorIDN visitor = new LdapQueryVisitorIDN();
        filter.traverse(visitor);
        return visitor.getFilter();
    }

    public static String toLdapCalendarResourcesFilter(EntrySearchFilter filter) throws ServiceException {
        filter.andWith(sCalendarResourcesFilter);
        if (!filter.usesIndex()) {
            throw ServiceException.INVALID_REQUEST("Search referring to no indexed attribute is not allowed: " + filter.toString(), null);
        }
        LdapQueryVisitor visitor = new LdapQueryVisitor();
        filter.traverse(visitor);
        return visitor.getFilter();
    }

    static {
        EntrySearchFilter.Single calResType = new EntrySearchFilter.Single(false, "objectClass", EntrySearchFilter.Operator.eq, "zimbraCalendarResource");
        sCalendarResourcesFilter = new EntrySearchFilter(calResType);
    }

    private static class LdapQueryVisitorIDN
    extends LdapQueryVisitor
    implements EntrySearchFilter.Visitor {
        private LdapQueryVisitorIDN() {
        }

        protected String getVal(EntrySearchFilter.Single term) {
            String rhs = term.getRhs();
            AttributeManager attrMgr = null;
            try {
                attrMgr = AttributeManager.getInstance();
            }
            catch (ServiceException e) {
                ZimbraLog.account.warn((Object)"failed to get AttributeManager instance", e);
            }
            AttributeManager.IDNType idnType = AttributeManager.idnType(attrMgr, term.getLhs());
            rhs = IDNUtil.toAscii(rhs, idnType);
            return rhs;
        }
    }

    private static class LdapQueryVisitor
    implements EntrySearchFilter.Visitor {
        StringBuilder mLdapFilter = new StringBuilder();

        public String getFilter() {
            return this.mLdapFilter.toString();
        }

        private static StringBuilder addCond(StringBuilder sb, String lhs, String op, String rhs) {
            sb.append('(');
            sb.append(lhs).append(op).append(rhs);
            sb.append(')');
            return sb;
        }

        public void visitSingle(EntrySearchFilter.Single term) {
            EntrySearchFilter.Operator op = term.getOperator();
            boolean negation = term.isNegation();
            if (op.equals((Object)EntrySearchFilter.Operator.gt)) {
                op = EntrySearchFilter.Operator.le;
                negation = !negation;
            } else if (op.equals((Object)EntrySearchFilter.Operator.lt)) {
                op = EntrySearchFilter.Operator.ge;
                boolean bl = negation = !negation;
            }
            if (negation) {
                this.mLdapFilter.append("(!");
            }
            String attr = term.getLhs();
            String val = this.getVal(term);
            if (op.equals((Object)EntrySearchFilter.Operator.has)) {
                this.mLdapFilter.append('(').append(attr);
                this.mLdapFilter.append("=*").append(val).append("*)");
            } else if (op.equals((Object)EntrySearchFilter.Operator.eq)) {
                LdapQueryVisitor.addCond(this.mLdapFilter, attr, "=", val);
            } else if (op.equals((Object)EntrySearchFilter.Operator.ge)) {
                LdapQueryVisitor.addCond(this.mLdapFilter, attr, ">=", val);
            } else if (op.equals((Object)EntrySearchFilter.Operator.le)) {
                LdapQueryVisitor.addCond(this.mLdapFilter, attr, "<=", val);
            } else if (op.equals((Object)EntrySearchFilter.Operator.startswith)) {
                this.mLdapFilter.append('(').append(attr);
                this.mLdapFilter.append('=').append(val).append("*)");
            } else if (op.equals((Object)EntrySearchFilter.Operator.endswith)) {
                this.mLdapFilter.append('(').append(attr);
                this.mLdapFilter.append("=*").append(val);
                this.mLdapFilter.append(')');
            } else {
                LdapQueryVisitor.addCond(this.mLdapFilter, attr, "=", val);
            }
            if (negation) {
                this.mLdapFilter.append(')');
            }
        }

        public void enterMulti(EntrySearchFilter.Multi term) {
            if (term.isNegation()) {
                this.mLdapFilter.append("(!");
            }
            if (term.getTerms().size() > 1) {
                if (term.isAnd()) {
                    this.mLdapFilter.append("(&");
                } else {
                    this.mLdapFilter.append("(|");
                }
            }
        }

        public void leaveMulti(EntrySearchFilter.Multi term) {
            if (term.getTerms().size() > 1) {
                this.mLdapFilter.append(')');
            }
            if (term.isNegation()) {
                this.mLdapFilter.append(')');
            }
        }

        protected String getVal(EntrySearchFilter.Single term) {
            return LdapUtil.escapeSearchFilterArg(term.getRhs());
        }
    }
}

