/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.ldap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.IDNUtil;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.ldap.LdapEntry;
import com.zimbra.cs.account.ldap.LdapProvisioning;
import com.zimbra.cs.account.ldap.LdapUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;

class LdapDistributionList
extends DistributionList
implements LdapEntry {
    private String mDn;

    LdapDistributionList(String dn, String email, Attributes attrs, Provisioning prov) throws NamingException {
        super(email, LdapUtil.getAttrString(attrs, "zimbraId"), LdapUtil.getAttrs(attrs), prov);
        this.mDn = dn;
    }

    void addMembers(String[] members, LdapProvisioning prov) throws ServiceException {
        Set<String> existing = this.getMultiAttrSet("zimbraMailForwardingAddress");
        HashSet<String> mods = new HashSet<String>();
        for (int i = 0; i < members.length; ++i) {
            String memberName = members[i].toLowerCase();
            memberName = IDNUtil.toAsciiEmail(members[i]);
            if (existing.contains(memberName)) continue;
            mods.add(memberName);
            Account acct = prov.get(Provisioning.AccountBy.name, memberName);
            if (acct != null) {
                this.clearUpwardMembershipCache(acct);
                continue;
            }
            DistributionList dl = prov.getFromCache(Provisioning.DistributionListBy.name, memberName);
            if (dl == null) continue;
            prov.removeFromCache(dl);
        }
        if (mods.isEmpty()) {
            return;
        }
        HashMap<String, String[]> modmap = new HashMap<String, String[]>();
        modmap.put("+zimbraMailForwardingAddress", mods.toArray(new String[0]));
        prov.modifyAttrs(this, modmap, true);
    }

    void removeMembers(String[] members, LdapProvisioning prov) throws ServiceException {
        Set<String> existing = this.getMultiAttrSet("zimbraMailForwardingAddress");
        HashSet<String> mods = new HashSet<String>();
        HashSet<String> failed = new HashSet<String>();
        for (int i = 0; i < members.length; ++i) {
            String primary;
            String memberName = members[i].toLowerCase();
            memberName = IDNUtil.toAsciiEmail(members[i]);
            if (memberName.length() == 0) {
                throw ServiceException.INVALID_REQUEST("invalid member email address: " + memberName, null);
            }
            AddrsOfEntry addrsOfEntry = this.getAllAddressesOfEntry(prov, memberName);
            List<String> allAddrs = addrsOfEntry.getAll();
            if (!mods.contains(memberName)) {
                if (existing.contains(memberName)) {
                    if (allAddrs.size() > 0) {
                        mods.addAll(allAddrs);
                    } else {
                        mods.add(memberName);
                    }
                } else {
                    boolean inList = false;
                    if (allAddrs.size() > 0) {
                        Iterator<String> it = allAddrs.iterator();
                        while (it.hasNext() && !inList) {
                            String addr = it.next();
                            if (!existing.contains(addr)) continue;
                            mods.addAll(allAddrs);
                            inList = true;
                        }
                    }
                    if (!inList) {
                        failed.add(memberName);
                    }
                }
            }
            if ((primary = addrsOfEntry.getPrimary()) == null) continue;
            if (addrsOfEntry.isAccount()) {
                Account acct = prov.getFromCache(Provisioning.AccountBy.name, primary);
                if (acct == null) continue;
                this.clearUpwardMembershipCache(acct);
                continue;
            }
            DistributionList dl = prov.getFromCache(Provisioning.DistributionListBy.name, primary);
            if (dl == null) continue;
            prov.removeFromCache(dl);
        }
        if (!failed.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            Iterator iter = failed.iterator();
            while (true) {
                sb.append((String)iter.next());
                if (!iter.hasNext()) break;
                sb.append(",");
            }
            throw AccountServiceException.NO_SUCH_MEMBER(this.getName(), sb.toString());
        }
        if (mods.isEmpty()) {
            throw ServiceException.INVALID_REQUEST("empty remove set", null);
        }
        HashMap<String, String[]> modmap = new HashMap<String, String[]>();
        modmap.put("-zimbraMailForwardingAddress", mods.toArray(new String[0]));
        prov.modifyAttrs(this, modmap);
    }

    private void clearUpwardMembershipCache(Account acct) {
        acct.setCachedData("DL_SET", null);
        acct.setCachedData("AG_LIST", null);
        acct.setCachedData("AG_LIST_ADMINS_ONLY", null);
    }

    public String getDN() {
        return this.mDn;
    }

    private AddrsOfEntry getAllAddressesOfEntry(LdapProvisioning prov, String name) {
        String primary = null;
        String[] aliases = null;
        AddrsOfEntry addrs = new AddrsOfEntry();
        try {
            Account acct = prov.get(Provisioning.AccountBy.name, name);
            if (acct != null) {
                addrs.setIsAccount(true);
                primary = acct.getName();
                aliases = acct.getMailAlias();
            } else {
                DistributionList dl = prov.get(Provisioning.DistributionListBy.name, name);
                if (dl != null) {
                    primary = dl.getName();
                    aliases = dl.getAliases();
                }
            }
        }
        catch (ServiceException se) {
            // empty catch block
        }
        if (primary != null) {
            addrs.setPrimary(primary);
        }
        if (aliases != null) {
            addrs.addAll(aliases);
        }
        return addrs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AddrsOfEntry {
        List<String> mAllAddrs = new ArrayList<String>();
        String mPrimary = null;
        boolean mIsAccount = false;

        AddrsOfEntry() {
        }

        void setPrimary(String primary) {
            this.mPrimary = primary;
            this.add(primary);
        }

        void setIsAccount(boolean isAccount) {
            this.mIsAccount = isAccount;
        }

        void add(String addr) {
            this.mAllAddrs.add(addr);
        }

        void addAll(String[] addrs) {
            this.mAllAddrs.addAll(Arrays.asList(addrs));
        }

        List<String> getAll() {
            return this.mAllAddrs;
        }

        String getPrimary() {
            return this.mPrimary;
        }

        boolean isAccount() {
            return this.mIsAccount;
        }

        int size() {
            return this.mAllAddrs.size();
        }
    }
}

