/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.ldap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.ldap.LdapEntry;
import com.zimbra.cs.account.ldap.LdapUtil;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;

class LdapDataSource
extends DataSource
implements LdapEntry {
    private String mDn;

    static String getObjectClass(DataSource.Type type) {
        switch (type) {
            case pop3: {
                return "zimbraPop3DataSource";
            }
            case imap: {
                return "zimbraImapDataSource";
            }
            case rss: {
                return "zimbraRssDataSource";
            }
            case gal: {
                return "zimbraGalDataSource";
            }
        }
        return null;
    }

    static DataSource.Type getObjectType(Attributes attrs) throws ServiceException {
        try {
            String dsType = LdapUtil.getAttrString(attrs, "zimbraDataSourceType");
            if (dsType != null) {
                return DataSource.Type.fromString(dsType);
            }
        }
        catch (NamingException e) {
            ZimbraLog.datasource.error((Object)"cannot get DataSource type", e);
        }
        Attribute attr = attrs.get("objectclass");
        if (attr.contains("zimbraPop3DataSource")) {
            return DataSource.Type.pop3;
        }
        if (attr.contains("zimbraImapDataSource")) {
            return DataSource.Type.imap;
        }
        if (attr.contains("zimbraRssDataSource")) {
            return DataSource.Type.rss;
        }
        if (attr.contains("zimbraGalDataSource")) {
            return DataSource.Type.gal;
        }
        throw ServiceException.FAILURE("unable to determine data source type from object class", null);
    }

    LdapDataSource(Account acct, String dn, Attributes attrs, Provisioning prov) throws NamingException, ServiceException {
        super(acct, LdapDataSource.getObjectType(attrs), LdapUtil.getAttrString(attrs, "zimbraDataSourceName"), LdapUtil.getAttrString(attrs, "zimbraDataSourceId"), LdapUtil.getAttrs(attrs), prov);
        this.mDn = dn;
    }

    public String getDN() {
        return this.mDn;
    }
}

