/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.ldap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.EmailUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Alias;
import com.zimbra.cs.account.Config;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.GlobalGrant;
import com.zimbra.cs.account.Identity;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.Zimlet;
import com.zimbra.cs.account.ldap.LdapProvisioning;
import com.zimbra.cs.account.ldap.LdapUtil;
import com.zimbra.cs.account.ldap.SpecialAttrs;
import com.zimbra.cs.util.Zimbra;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapDIT {
    protected Provisioning mProv;
    protected static final String ROOT_DN = "";
    protected final String DEFAULT_CONFIG_BASE_DN = "cn=zimbra";
    protected final String DEFAULT_MAIL_BASE_DN = "";
    protected final String DEFAULT_BASE_RDN_ADMIN = "cn=admins";
    protected final String DEFAULT_BASE_RDN_APPADMIN = "cn=appaccts";
    protected final String DEFAULT_BASE_RDN_ACCOUNT = "ou=people";
    protected final String DEFAULT_BASE_RDN_COS = "cn=cos";
    protected final String DEFAULT_BASE_RDN_MIME = "cn=mime";
    protected final String DEFAULT_BASE_RDN_SERVER = "cn=servers";
    protected final String DEFAULT_BASE_RDN_XMPPCOMPONENT = "cn=xmppcomponents";
    protected final String DEFAULT_BASE_RDN_ZIMLET = "cn=zimlets";
    protected final String DEFAULT_NAMING_RDN_ATTR_USER = "uid";
    protected final String DEFAULT_NAMING_RDN_ATTR_COS = "cn";
    protected final String DEFAULT_NAMING_RDN_ATTR_GLOBALCONFIG = "cn";
    protected final String DEFAULT_NAMING_RDN_ATTR_GLOBALGRANT = "cn";
    protected final String DEFAULT_NAMING_RDN_ATTR_MIME = "cn";
    protected final String DEFAULT_NAMING_RDN_ATTR_SERVER = "cn";
    protected final String DEFAULT_NAMING_RDN_ATTR_XMPPCOMPONENT = "cn";
    protected final String DEFAULT_NAMING_RDN_ATTR_ZIMLET = "cn";
    protected String BASE_DN_ZIMBRA;
    protected String BASE_DN_CONFIG_BRANCH;
    protected String BASE_DN_MAIL_BRANCH;
    protected String BASE_RDN_ACCOUNT;
    protected String BASE_DN_ADMIN;
    protected String BASE_DN_APPADMIN;
    protected String BASE_DN_ACCOUNT;
    protected String BASE_DN_COS;
    protected String BASE_DN_MIME;
    protected String BASE_DN_SERVER;
    protected String BASE_DN_XMPPCOMPONENT;
    protected String BASE_DN_ZIMLET;
    protected String NAMING_RDN_ATTR_USER;
    protected String NAMING_RDN_ATTR_COS;
    protected String NAMING_RDN_ATTR_GLOBALCONFIG;
    protected String NAMING_RDN_ATTR_GLOBALGRANT;
    protected String NAMING_RDN_ATTR_MIME;
    protected String NAMING_RDN_ATTR_SERVER;
    protected String NAMING_RDN_ATTR_XMPPCOMPONENT;
    protected String NAMING_RDN_ATTR_ZIMLET;
    protected String DN_GLOBALCONFIG;
    protected String DN_GLOBALGRANT;

    public LdapDIT(LdapProvisioning prov) {
        this.mProv = prov;
        this.init();
        this.verify();
    }

    protected void init() {
        this.BASE_DN_CONFIG_BRANCH = "cn=zimbra";
        this.BASE_DN_MAIL_BRANCH = ROOT_DN;
        this.BASE_RDN_ACCOUNT = "ou=people";
        this.NAMING_RDN_ATTR_USER = "uid";
        this.NAMING_RDN_ATTR_COS = "cn";
        this.NAMING_RDN_ATTR_GLOBALCONFIG = "cn";
        this.NAMING_RDN_ATTR_GLOBALGRANT = "cn";
        this.NAMING_RDN_ATTR_MIME = "cn";
        this.NAMING_RDN_ATTR_SERVER = "cn";
        this.NAMING_RDN_ATTR_XMPPCOMPONENT = "cn";
        this.NAMING_RDN_ATTR_ZIMLET = "cn";
        this.DN_GLOBALCONFIG = this.NAMING_RDN_ATTR_GLOBALCONFIG + "=config" + "," + this.BASE_DN_CONFIG_BRANCH;
        this.DN_GLOBALGRANT = this.NAMING_RDN_ATTR_GLOBALGRANT + "=globalgrant" + "," + this.BASE_DN_CONFIG_BRANCH;
        this.BASE_DN_ADMIN = "cn=admins," + this.BASE_DN_CONFIG_BRANCH;
        this.BASE_DN_APPADMIN = "cn=appaccts," + this.BASE_DN_CONFIG_BRANCH;
        this.BASE_DN_COS = "cn=cos," + this.BASE_DN_CONFIG_BRANCH;
        this.BASE_DN_MIME = "cn=mime," + this.DN_GLOBALCONFIG;
        this.BASE_DN_SERVER = "cn=servers," + this.BASE_DN_CONFIG_BRANCH;
        this.BASE_DN_XMPPCOMPONENT = "cn=xmppcomponents," + this.BASE_DN_CONFIG_BRANCH;
        this.BASE_DN_ZIMLET = "cn=zimlets," + this.BASE_DN_CONFIG_BRANCH;
        this.BASE_DN_ZIMBRA = ROOT_DN;
    }

    private final void verify() {
        if (this.BASE_DN_ZIMBRA == null || this.BASE_DN_CONFIG_BRANCH == null || this.BASE_DN_MAIL_BRANCH == null || this.BASE_RDN_ACCOUNT == null || this.NAMING_RDN_ATTR_USER == null || this.NAMING_RDN_ATTR_COS == null || this.NAMING_RDN_ATTR_GLOBALCONFIG == null || this.NAMING_RDN_ATTR_GLOBALGRANT == null || this.NAMING_RDN_ATTR_MIME == null || this.NAMING_RDN_ATTR_SERVER == null || this.NAMING_RDN_ATTR_ZIMLET == null || this.BASE_DN_ADMIN == null || this.BASE_DN_APPADMIN == null || this.BASE_DN_COS == null || this.BASE_DN_MIME == null || this.BASE_DN_SERVER == null || this.BASE_DN_XMPPCOMPONENT == null || this.BASE_DN_ZIMLET == null || this.DN_GLOBALCONFIG == null || this.DN_GLOBALGRANT == null) {
            Zimbra.halt("Unable to initialize LDAP DIT");
        }
    }

    public String zimbraBaseDN() {
        return this.BASE_DN_ZIMBRA;
    }

    public String configBranchBaseDN() {
        return this.BASE_DN_CONFIG_BRANCH;
    }

    public String mailBranchBaseDN() {
        return this.BASE_DN_MAIL_BRANCH;
    }

    public String accountNamingRdnAttr() {
        return this.NAMING_RDN_ATTR_USER;
    }

    private String emailToDN(String localPart, String domain) throws ServiceException {
        return this.NAMING_RDN_ATTR_USER + "=" + LdapUtil.escapeRDNValue(localPart) + "," + this.domainToAccountBaseDN(domain);
    }

    private String emailToDN(String email) throws ServiceException {
        String[] parts = EmailUtil.getLocalPartAndDomain(email);
        return this.emailToDN(parts[0], parts[1]);
    }

    public String accountDNCreate(String baseDn, Attributes attrs, String localPart, String domain) throws ServiceException, NamingException {
        if (baseDn != null) {
            throw ServiceException.INVALID_REQUEST("base dn is not supported in DIT impl " + this.getClass().getCanonicalName(), null);
        }
        return this.emailToDN(localPart, domain);
    }

    public String accountDNRename(String oldDn, String newLocalPart, String newDomain) throws ServiceException, NamingException {
        return this.emailToDN(newLocalPart, newDomain);
    }

    public String dnToEmail(String dn, Attributes attrs) throws ServiceException, NamingException {
        String[] parts = dn.split(",");
        StringBuffer domain = new StringBuffer(dn.length());
        String namingAttr = this.accountNamingRdnAttr() + "=";
        String namingAttrValue = null;
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].startsWith("dc=")) {
                if (domain.length() > 0) {
                    domain.append(".");
                }
                domain.append(LdapUtil.unescapeRDNValue(parts[i].substring(3)));
                continue;
            }
            if (i != 0 || !parts[i].startsWith(namingAttr)) continue;
            namingAttrValue = LdapUtil.unescapeRDNValue(parts[i].substring(namingAttr.length()));
        }
        if (namingAttrValue == null) {
            throw ServiceException.FAILURE("unable to map dn [" + dn + "] to email", null);
        }
        if (domain.length() == 0) {
            return namingAttrValue;
        }
        return new StringBuffer(namingAttrValue).append('@').append(domain).toString();
    }

    public String filterAccountsByDomain(Domain domain, boolean includeObjectClass) {
        if (includeObjectClass) {
            return "(objectclass=zimbraAccount)";
        }
        return ROOT_DN;
    }

    public String adminBaseDN() {
        return this.BASE_DN_ADMIN;
    }

    public String appAdminBaseDN() {
        return this.BASE_DN_APPADMIN;
    }

    public String aliasDN(String targetDn, String targetDomain, String aliasLocalPart, String aliasDomain) throws ServiceException {
        return this.emailToDN(aliasLocalPart, aliasDomain);
    }

    public String aliasDNRename(String targetNewDn, String targetNewDomain, String newAliasEmail) throws ServiceException {
        return this.emailToDN(newAliasEmail);
    }

    public String filterCalendarResourcesByDomain(Domain domain, boolean includeObjectClass) {
        if (includeObjectClass) {
            return "(objectclass=zimbraCalendarResource)";
        }
        return ROOT_DN;
    }

    public String cosBaseDN() {
        return this.BASE_DN_COS;
    }

    public String cosNametoDN(String name) {
        return this.NAMING_RDN_ATTR_COS + "=" + LdapUtil.escapeRDNValue(name) + "," + this.BASE_DN_COS;
    }

    public String distributionListDNCreate(String baseDn, Attributes attrs, String localPart, String domain) throws ServiceException, NamingException {
        if (baseDn != null) {
            throw ServiceException.INVALID_REQUEST("base dn is not supported in DIT impl " + this.getClass().getCanonicalName(), null);
        }
        return this.emailToDN(localPart, domain);
    }

    public String distributionListDNRename(String oldDn, String newLocalPart, String newDomain) throws ServiceException, NamingException {
        return this.emailToDN(newLocalPart, newDomain);
    }

    public String filterDistributionListsByDomain(Domain domain, boolean includeObjectClass) {
        if (includeObjectClass) {
            return "(objectclass=zimbraDistributionList)";
        }
        return ROOT_DN;
    }

    public String domainBaseDN() {
        return this.mailBranchBaseDN();
    }

    public String[] domainToDNs(String[] parts) {
        return this.domainToDNsInternal(parts, null);
    }

    protected String[] domainToDNsInternal(String[] parts, String base) {
        String[] dns = new String[parts.length];
        for (int i = parts.length - 1; i >= 0; --i) {
            dns[i] = LdapUtil.domainToDN(parts, i);
            if (base == null) continue;
            dns[i] = dns[i] + "," + base;
        }
        return dns;
    }

    public String domainToAccountSearchDN(String domain) throws ServiceException {
        return this.domainDNToAccountBaseDN(LdapUtil.domainToDN(domain));
    }

    public String domainDNToAccountSearchDN(String domainDN) throws ServiceException {
        return this.domainDNToAccountBaseDN(domainDN);
    }

    private String domainToAccountBaseDN(String domain) throws ServiceException {
        return this.domainDNToAccountBaseDN(LdapUtil.domainToDN(domain));
    }

    public String domainDNToAccountBaseDN(String domainDN) throws ServiceException {
        if (this.BASE_RDN_ACCOUNT.length() == 0) {
            return domainDN;
        }
        return this.BASE_RDN_ACCOUNT + "," + domainDN;
    }

    public String configDN() {
        return this.DN_GLOBALCONFIG;
    }

    public String globalGrantDN() {
        return this.DN_GLOBALGRANT;
    }

    public String mimeBaseDN() {
        return this.BASE_DN_MIME;
    }

    public String serverBaseDN() {
        return this.BASE_DN_SERVER;
    }

    public String serverNametoDN(String name) {
        return this.NAMING_RDN_ATTR_SERVER + "=" + LdapUtil.escapeRDNValue(name) + "," + this.BASE_DN_SERVER;
    }

    public String xmppcomponentBaseDN() {
        return this.BASE_DN_XMPPCOMPONENT;
    }

    public String xmppcomponentNameToDN(String name) {
        return this.NAMING_RDN_ATTR_XMPPCOMPONENT + "=" + LdapUtil.escapeRDNValue(name) + "," + this.BASE_DN_XMPPCOMPONENT;
    }

    public String zimletBaseDN() {
        return this.BASE_DN_ZIMLET;
    }

    public String zimletNameToDN(String name) {
        return this.NAMING_RDN_ATTR_ZIMLET + "=" + LdapUtil.escapeRDNValue(name) + "," + this.BASE_DN_ZIMLET;
    }

    protected SpecialAttrs handleSpecialAttrs(Map<String, Object> attrs) throws ServiceException {
        SpecialAttrs specialAttrs = new SpecialAttrs();
        if (attrs != null) {
            specialAttrs.handleZimbraId(attrs);
        }
        return specialAttrs;
    }

    public String getNamingRdnAttr(Entry entry) throws ServiceException {
        if (entry instanceof Account || entry instanceof DistributionList || entry instanceof Alias) {
            return this.NAMING_RDN_ATTR_USER;
        }
        if (entry instanceof Cos) {
            return this.NAMING_RDN_ATTR_COS;
        }
        if (entry instanceof Config) {
            return this.NAMING_RDN_ATTR_GLOBALCONFIG;
        }
        if (entry instanceof DataSource) {
            return "zimbraDataSourceName";
        }
        if (entry instanceof Domain) {
            return "dc";
        }
        if (entry instanceof Identity) {
            return "zimbraPrefIdentityName";
        }
        if (entry instanceof GlobalGrant) {
            return this.NAMING_RDN_ATTR_GLOBALGRANT;
        }
        if (entry instanceof Server) {
            return this.NAMING_RDN_ATTR_SERVER;
        }
        if (entry instanceof Zimlet) {
            return this.NAMING_RDN_ATTR_ZIMLET;
        }
        throw ServiceException.FAILURE("entry type " + entry.getClass().getCanonicalName() + " is not supported by getNamingRdnAttr", null);
    }

    public boolean isUnder(String parentDn, String dn) {
        return parentDn.equals(ROOT_DN) || dn.toLowerCase().endsWith(parentDn.toLowerCase());
    }
}

