/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.ldap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ExceptionToString;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.GalContact;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.gal.GalOp;
import com.zimbra.cs.account.gal.GalParams;
import com.zimbra.cs.account.ldap.LdapGalMapRules;
import com.zimbra.cs.account.ldap.LdapUtil;
import com.zimbra.cs.account.ldap.ZimbraLdapContext;
import com.zimbra.cs.fb.ExchangeFreeBusyProvider;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.AuthenticationException;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.CommunicationException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.directory.InvalidSearchFilterException;
import javax.net.ssl.SSLHandshakeException;

public class Check {
    public static final String STATUS_OK = "check.OK";
    public static final String STATUS_UNKNOWN_HOST = "check.UNKNOWN_HOST";
    public static final String STATUS_CONNECTION_REFUSED = "check.CONNECTION_REFUSED";
    public static final String STATUS_SSL_HANDSHAKE_FAILURE = "check.SSL_HANDSHAKE_FAILURE";
    public static final String STATUS_COMMUNICATION_FAILURE = "check.COMMUNICATION_FAILURE";
    public static final String STATUS_AUTH_FAILED = "check.AUTH_FAILED";
    public static final String STATUS_AUTH_NOT_SUPPORTED = "check.AUTH_NOT_SUPPORTED";
    public static final String STATUS_NAME_NOT_FOUND = "check.NAME_NOT_FOUND";
    public static final String STATUS_INVALID_SEARCH_FILTER = "check.INVALID_SEARCH_FILTER";
    public static final String STATUS_FAILURE = "check.FAILURE";
    public static final String STATUS_BAD_URL = "check.BAD_URL";
    public static final String STATUS_FORBIDDEN = "check.FORBIDDEN";

    private static String getRequiredAttr(Map attrs, String name) throws ServiceException {
        String value = (String)attrs.get(name);
        if (value == null) {
            throw ServiceException.INVALID_REQUEST("must specifiy: " + name, null);
        }
        return value;
    }

    private static String[] getRequiredMultiAttr(Map attrs, String name) throws ServiceException {
        String[] value;
        Object v = attrs.get(name);
        if (v instanceof String) {
            return new String[]{(String)v};
        }
        if (v instanceof String[] && (value = (String[])v) != null && value.length > 0) {
            return value;
        }
        throw ServiceException.INVALID_REQUEST("must specifiy: " + name, null);
    }

    public static Result checkHostnameResolve(String hostname) {
        try {
            InetAddress.getByName(hostname);
        }
        catch (UnknownHostException e) {
            return new Result(STATUS_UNKNOWN_HOST, e, (String)null);
        }
        return new Result(STATUS_OK, "", (String)null);
    }

    public static Result checkAuthConfig(Map attrs, String name, String password) throws ServiceException {
        String mech = Check.getRequiredAttr(attrs, "zimbraAuthMech");
        if (!mech.equals("ldap") && !mech.equals("ad")) {
            throw ServiceException.INVALID_REQUEST("auth mech must be: ldap or ad", null);
        }
        String[] url = Check.getRequiredMultiAttr(attrs, "zimbraAuthLdapURL");
        String startTLSEnabled = (String)attrs.get("zimbraAuthLdapStartTlsEnabled");
        boolean startTLS = startTLSEnabled == null ? false : "TRUE".equals(startTLSEnabled);
        boolean requireStartTLS = ZimbraLdapContext.requireStartTLS(url, startTLS);
        try {
            String searchFilter = (String)attrs.get("zimbraAuthLdapSearchFilter");
            if (searchFilter != null) {
                String searchPassword = (String)attrs.get("zimbraAuthLdapSearchBindPassword");
                String searchDn = (String)attrs.get("zimbraAuthLdapSearchBindDn");
                String searchBase = (String)attrs.get("zimbraAuthLdapSearchBase");
                if (searchBase == null) {
                    searchBase = "";
                }
                searchFilter = LdapUtil.computeAuthDn(name, searchFilter);
                if (ZimbraLog.account.isDebugEnabled()) {
                    ZimbraLog.account.debug("auth with search filter of " + searchFilter);
                }
                LdapUtil.ldapAuthenticate(url, requireStartTLS, password, searchBase, searchFilter, searchDn, searchPassword);
                return new Result(STATUS_OK, "", searchFilter);
            }
            String bindDn = (String)attrs.get("zimbraAuthLdapBindDn");
            if (bindDn != null) {
                String dn = LdapUtil.computeAuthDn(name, bindDn);
                if (ZimbraLog.account.isDebugEnabled()) {
                    ZimbraLog.account.debug("auth with bind dn template of " + dn);
                }
                LdapUtil.ldapAuthenticate(url, requireStartTLS, dn, password);
                return new Result(STATUS_OK, "", dn);
            }
            throw ServiceException.INVALID_REQUEST("must specify zimbraAuthLdapSearchFilter or zimbraAuthLdapBindDn", null);
        }
        catch (NamingException e) {
            return Check.toResult(e, "");
        }
        catch (IOException e) {
            return Check.toResult(e, "");
        }
    }

    public static Result checkGalConfig(Map attrs, String query, int limit, GalOp galOp) throws ServiceException {
        Provisioning.GalMode mode = Provisioning.GalMode.fromString(Check.getRequiredAttr(attrs, "zimbraGalMode"));
        if (mode != Provisioning.GalMode.ldap) {
            throw ServiceException.INVALID_REQUEST("gal mode must be: " + Provisioning.GalMode.ldap.toString(), null);
        }
        GalParams.ExternalGalParams galParams = new GalParams.ExternalGalParams(attrs, galOp);
        String[] galAttrs = Provisioning.getInstance().getConfig().getMultiAttr("zimbraGalLdapAttrMap");
        LdapGalMapRules rules = new LdapGalMapRules(galAttrs);
        try {
            Provisioning.SearchGalResult result = null;
            if (galOp == GalOp.autocomplete) {
                result = LdapUtil.searchLdapGal(galParams, GalOp.autocomplete, query, limit, rules, null, null);
            } else if (galOp == GalOp.search) {
                result = LdapUtil.searchLdapGal(galParams, GalOp.search, query, limit, rules, null, null);
            } else if (galOp == GalOp.sync) {
                result = LdapUtil.searchLdapGal(galParams, GalOp.sync, query, limit, rules, "", null);
            } else {
                throw ServiceException.INVALID_REQUEST("invalid GAL op: " + galOp.toString(), null);
            }
            return new GalResult(STATUS_OK, "", result.getMatches());
        }
        catch (NamingException e) {
            return Check.toResult(e, "");
        }
        catch (IOException e) {
            return Check.toResult(e, "");
        }
    }

    public static Result checkExchangeAuth(ExchangeFreeBusyProvider.ServerInfo sinfo, Account acct) throws ServiceException {
        try {
            int code = ExchangeFreeBusyProvider.checkAuth(sinfo, acct);
            switch (code) {
                case 400: 
                case 404: {
                    return new Result(STATUS_BAD_URL, "", null);
                }
                case 401: 
                case 403: {
                    return new Result(STATUS_AUTH_FAILED, "", null);
                }
            }
        }
        catch (IOException e) {
            return Check.toResult(e, "");
        }
        return new Result(STATUS_OK, "", null);
    }

    private static Result toResult(IOException e, String dn) {
        if (e instanceof UnknownHostException) {
            return new Result(STATUS_UNKNOWN_HOST, e, dn);
        }
        if (e instanceof ConnectException) {
            return new Result(STATUS_CONNECTION_REFUSED, e, dn);
        }
        if (e instanceof SSLHandshakeException) {
            return new Result(STATUS_SSL_HANDSHAKE_FAILURE, e, dn);
        }
        return new Result(STATUS_COMMUNICATION_FAILURE, e, dn);
    }

    private static Result toResult(NamingException e, String dn) {
        if (e instanceof CommunicationException) {
            if (e.getRootCause() instanceof UnknownHostException) {
                return new Result(STATUS_UNKNOWN_HOST, e, dn);
            }
            if (e.getRootCause() instanceof ConnectException) {
                return new Result(STATUS_CONNECTION_REFUSED, e, dn);
            }
            if (e.getRootCause() instanceof SSLHandshakeException) {
                return new Result(STATUS_SSL_HANDSHAKE_FAILURE, e, dn);
            }
            return new Result(STATUS_COMMUNICATION_FAILURE, e, dn);
        }
        if (e instanceof AuthenticationException) {
            return new Result(STATUS_AUTH_FAILED, e, dn);
        }
        if (e instanceof AuthenticationNotSupportedException) {
            return new Result(STATUS_AUTH_NOT_SUPPORTED, e, dn);
        }
        if (e instanceof NameNotFoundException) {
            return new Result(STATUS_NAME_NOT_FOUND, e, dn);
        }
        if (e instanceof InvalidSearchFilterException) {
            return new Result(STATUS_INVALID_SEARCH_FILTER, e, dn);
        }
        return new Result(STATUS_FAILURE, e, dn);
    }

    private static void testCheckAuth() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAuthMech", "ldap");
        attrs.put("zimbraAuthLdapURL", "ldap://exch1.example.zimbra.com/");
        attrs.put("zimbraAuthLdapBindDn", "%u@example.zimbra.com");
        try {
            Result r = Check.checkAuthConfig(attrs, "schemers", "xxxxx");
            System.out.println(r);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    private static void testCheckHostnameResolve() {
        Result r = Check.checkHostnameResolve("slapshot");
        System.out.println(r);
    }

    private static void testCheckGal() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraGalMode", Provisioning.GalMode.ldap.toString());
        attrs.put("zimbraGalLdapURL", "ldap://exch1.example.zimbra.com/");
        attrs.put("zimbraGalLdapBindDn", "zz_gal");
        attrs.put("zimbraGalLdapBindPassword", "zz_gal");
        attrs.put("zimbraGalLdapSearchBase", "dc=example,dc=zimbra,dc=com");
        attrs.put("zimbraGalLdapFilter", "ad");
        try {
            Result r = Check.checkGalConfig(attrs, "sam", 10, GalOp.search);
            System.out.println(r);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Check.testCheckHostnameResolve();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GalResult
    extends Result {
        private List<GalContact> mResult;

        public GalResult(String status, String message, List<GalContact> result) {
            super(status, message, null);
            this.mResult = result;
        }

        public List<GalContact> getContacts() {
            return this.mResult;
        }
    }

    public static class Result {
        String code;
        String message;
        String detail;

        public String getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public String getComputedDn() {
            return this.detail;
        }

        public Object getDetail() {
            return this.detail;
        }

        public Result(String status, String message, String detail) {
            this.code = status;
            this.message = message;
            this.detail = detail;
        }

        public Result(String status, Exception e, String detail) {
            this.code = status;
            this.message = ExceptionToString.ToString(e);
            this.detail = detail;
        }

        public String toString() {
            return "Result { code: " + this.code + " detail: " + this.detail + " message: " + this.message + " }";
        }
    }
}

