/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.ldap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChangePasswordListener {
    private static Map<String, ChangePasswordListener> mListeners = new HashMap<String, ChangePasswordListener>();

    public static synchronized void register(String listenerName, ChangePasswordListener listener) {
        ChangePasswordListener obj = mListeners.get(listenerName);
        if (obj != null) {
            ZimbraLog.account.warn("listener name " + listenerName + " is already registered, " + "registering of " + obj.getClass().getCanonicalName() + " is ignored");
            return;
        }
        mListeners.put(listenerName, listener);
    }

    public static synchronized ChangePasswordListener getHandler(Account acct) throws ServiceException {
        Domain domain = Provisioning.getInstance().getDomain(acct);
        String listenerName = domain.getAttr("zimbraPasswordChangeListener");
        if (listenerName == null) {
            return null;
        }
        ChangePasswordListener listener = mListeners.get(listenerName);
        if (listener == null) {
            throw ServiceException.FAILURE("change password listener " + listenerName + " for account " + acct.getName() + " not found", null);
        }
        return listener;
    }

    public abstract void preModify(Account var1, String var2, Map var3, Map<String, Object> var4) throws ServiceException;

    public abstract void postModify(Account var1, String var2, Map var3);

    public static void main(String[] args) throws Exception {
        ChangePasswordListener.register("dummy", new DummyChangePasswordListener());
        Provisioning prov = Provisioning.getInstance();
        Account acct = prov.get(Provisioning.AccountBy.name, "user1");
        Domain domain = prov.getDomain(acct);
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPasswordChangeListener", "dummy");
        prov.modifyAttrs(domain, attrs);
        prov.changePassword(acct, "test123", "test123-new");
        attrs.clear();
        attrs.put("zimbraPasswordChangeListener", "");
        prov.modifyAttrs(domain, attrs);
        prov.changePassword(acct, "test123-new", "test123");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DummyChangePasswordListener
    extends ChangePasswordListener {
        DummyChangePasswordListener() {
        }

        @Override
        public void preModify(Account acct, String newPassword, Map context, Map<String, Object> attrsToModify) throws ServiceException {
            attrsToModify.put("zimbraNotes", "password changed to " + newPassword);
            context.put("foo", "bar");
        }

        @Override
        public void postModify(Account acct, String newPassword, Map context) {
            String foo = (String)context.get("foo");
            System.out.println("foo is " + foo);
            System.out.println("new password is " + newPassword);
        }
    }
}

