/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.krb5;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.EmailUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;

public class Krb5Principal {
    public static Account getAccountFromKrb5Principal(String principal, boolean loadFromMaster) throws ServiceException {
        String realm;
        Domain domain;
        int idx;
        Provisioning prov = Provisioning.getInstance();
        Account acct = null;
        acct = prov.get(Provisioning.AccountBy.foreignPrincipal, "kerberos5:" + principal, loadFromMaster);
        if (acct == null && (idx = principal.indexOf(64)) != -1 && (domain = prov.get(Provisioning.DomainBy.krb5Realm, realm = principal.substring(idx + 1))) != null) {
            String localPart = principal.substring(0, idx);
            String acctName = localPart + "@" + domain.getName();
            acct = prov.get(Provisioning.AccountBy.name, acctName, loadFromMaster);
        }
        return acct;
    }

    public static String getKrb5Principal(Account acct) throws ServiceException {
        Domain domain = Provisioning.getInstance().getDomain(acct);
        return Krb5Principal.getKrb5Principal(domain, acct);
    }

    public static String getKrb5Principal(Domain domain, Account acct) {
        String realm;
        String principal = null;
        String[] fps = acct.getMultiAttr("zimbraForeignPrincipal");
        if (fps != null && fps.length > 0) {
            for (String fp : fps) {
                int idx;
                if (!fp.startsWith("kerberos5:") || (idx = fp.indexOf(58)) == -1) continue;
                principal = fp.substring(idx + 1);
                break;
            }
        }
        if (principal == null && (realm = domain.getAttr("zimbraAuthKerberos5Realm")) != null) {
            String[] parts = EmailUtil.getLocalPartAndDomain(acct.getName());
            principal = parts != null ? parts[0] + "@" + realm : acct.getName() + "@" + realm;
        }
        return principal;
    }
}

