/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.krb5;

import com.zimbra.common.util.ZimbraLog;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class Krb5Login {
    private static String S_CONFIG_NAME = "krb5";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void verifyPassword(String principal, String password) throws LoginException {
        LoginContext lc = null;
        try {
            lc = Krb5Login.withPassword(principal, password);
            lc.login();
            Object var4_3 = null;
            if (lc == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (lc == null) throw throwable;
            try {
                lc.logout();
                throw throwable;
            }
            catch (LoginException le) {
                ZimbraLog.account.warn((Object)"krb5 logout failed", le);
            }
            throw throwable;
        }
        try {
            lc.logout();
            return;
        }
        catch (LoginException le) {
            ZimbraLog.account.warn((Object)"krb5 logout failed", le);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void performAs(String principal, String keytab, PrivilegedExceptionAction action) throws PrivilegedActionException, LoginException {
        LoginContext lc = null;
        try {
            lc = Krb5Login.withKeyTab(principal, keytab);
            lc.login();
            Subject.doAs(lc.getSubject(), action);
            Object var5_4 = null;
            if (lc == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (lc == null) throw throwable;
            try {
                lc.logout();
                throw throwable;
            }
            catch (LoginException le) {
                ZimbraLog.account.warn((Object)"krb5 logout failed", le);
            }
            throw throwable;
        }
        try {
            lc.logout();
            return;
        }
        catch (LoginException le) {
            ZimbraLog.account.warn((Object)"krb5 logout failed", le);
        }
    }

    private Krb5Login() {
    }

    public static LoginContext withKeyTab(String principal, String keytab) throws LoginException {
        Krb5Config kc = Krb5Config.getInstance();
        kc.setPrincipal(principal);
        kc.setKeyTab(keytab);
        kc.setStoreKey(true);
        kc.setDoNotPrompt(true);
        kc.setUseTicketCache(true);
        DynamicConfiguration dc = new DynamicConfiguration(S_CONFIG_NAME, new AppConfigurationEntry[]{kc});
        return new LoginContext(S_CONFIG_NAME, null, null, dc);
    }

    public static LoginContext withTicketCache(String cache) throws LoginException {
        Krb5Config kc = Krb5Config.getInstance();
        if (cache != null) {
            kc.setTicketCache(cache);
        } else {
            kc.setUseTicketCache(true);
        }
        DynamicConfiguration dc = new DynamicConfiguration(S_CONFIG_NAME, new AppConfigurationEntry[]{kc});
        return new LoginContext(S_CONFIG_NAME, null, null, dc);
    }

    public static LoginContext withPassword(String name, final String password) throws LoginException {
        Krb5Config kc = Krb5Config.getInstance();
        kc.setPrincipal(name);
        kc.setUseTicketCache(false);
        kc.setStoreKey(false);
        DynamicConfiguration dc = new DynamicConfiguration(S_CONFIG_NAME, new AppConfigurationEntry[]{kc});
        CallbackHandler handler = new CallbackHandler(){

            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback callback : callbacks) {
                    if (!(callback instanceof PasswordCallback)) continue;
                    PasswordCallback pc = (PasswordCallback)callback;
                    pc.setPassword(password.toCharArray());
                }
            }
        };
        return new LoginContext(S_CONFIG_NAME, null, handler, dc);
    }

    private static void testPerformAs() {
        try {
            Krb5Login.performAs("ldap/phoebe.local@PHOEBE.LOCAL", "/etc/krb5.keytab", new SearchAction());
        }
        catch (LoginException le) {
            le.printStackTrace();
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            System.out.println("exception msg is: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void main(String[] arsg) throws LoginException {
        Krb5Login.testPerformAs();
        System.out.println("succeeded");
    }

    static class SearchAction
    implements PrivilegedExceptionAction {
        SearchAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object run() {
            NamingEnumeration<SearchResult> answer;
            Hashtable<String, String> env = new Hashtable<String, String>(11);
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", "ldap://localhost:389/");
            env.put("java.naming.security.authentication", "GSSAPI");
            env.put("javax.security.sasl.qop", "auth-conf");
            InitialDirContext ctx = null;
            ctx = new InitialDirContext(env);
            SearchControls ctls = new SearchControls();
            ctls.setReturningAttributes(new String[]{"displayName", "mail", "description"});
            NamingEnumeration<SearchResult> namingEnumeration = answer = ctx.search("", "(cn=*)", ctls);
            Object var7_7 = null;
            if (ctx == null) return namingEnumeration;
            try {
                ctx.close();
                return namingEnumeration;
            }
            catch (Exception closeProblem) {
                System.err.println("error closing Context - " + closeProblem.getMessage());
            }
            return namingEnumeration;
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    Object var7_8 = null;
                    if (ctx == null) return null;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    if (ctx == null) throw throwable;
                    try {
                        ctx.close();
                        throw throwable;
                    }
                    catch (Exception closeProblem) {
                        System.err.println("error closing Context - " + closeProblem.getMessage());
                    }
                    throw throwable;
                }
                try {
                    ctx.close();
                    return null;
                }
                catch (Exception closeProblem) {
                    System.err.println("error closing Context - " + closeProblem.getMessage());
                }
                return null;
            }
        }
    }

    static class DummyAction
    implements PrivilegedExceptionAction {
        String mArg;

        DummyAction(String arg) {
            this.mArg = arg;
        }

        public Object run() throws Exception {
            System.out.println("arg is " + this.mArg);
            throw new Exception("exception thrown from run");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Krb5Config
    extends AppConfigurationEntry {
        private Map<String, String> mOptions;
        public static final AppConfigurationEntry.LoginModuleControlFlag DEFAULT_CONTROL_FLAG = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        private static final String DEFAULT_LOGIN_MODULE_NAME = "com.sun.security.auth.module.Krb5LoginModule";

        private Krb5Config(String loginModuleName, AppConfigurationEntry.LoginModuleControlFlag controlFlag, Map<String, ?> options) {
            super(loginModuleName, controlFlag, options);
        }

        public static Krb5Config getInstance() {
            HashMap<String, String> options = new HashMap<String, String>();
            Krb5Config kc = new Krb5Config(DEFAULT_LOGIN_MODULE_NAME, DEFAULT_CONTROL_FLAG, options);
            kc.mOptions = options;
            return kc;
        }

        public Krb5Config setDebug(boolean value) {
            this.mOptions.put("debug", value ? "true" : "false");
            return this;
        }

        public Krb5Config setDoNotPrompt(boolean value) {
            this.mOptions.put("doNotPrompt", value ? "true" : "false");
            return this;
        }

        public Krb5Config setKeyTab(String filename) {
            this.mOptions.put("keyTab", filename);
            this.setUseKeyTab(true);
            return this;
        }

        public Krb5Config setPrincipal(String principal) {
            this.mOptions.put("principal", principal);
            return this;
        }

        public Krb5Config setStoreKey(boolean value) {
            this.mOptions.put("storeKey", value ? "true" : "false");
            return this;
        }

        public Krb5Config setTicketCache(String filename) {
            this.mOptions.put("ticketCache", filename);
            this.setUseTicketCache(true);
            return this;
        }

        public Krb5Config setUseKeyTab(boolean value) {
            this.mOptions.put("useKeyTab", value ? "true" : "false");
            return this;
        }

        public Krb5Config setUseTicketCache(boolean value) {
            this.mOptions.put("useTicketCache", value ? "true" : "false");
            return this;
        }
    }

    static class DynamicConfiguration
    extends Configuration {
        private String mName;
        private AppConfigurationEntry[] mEntry;

        DynamicConfiguration(String name, AppConfigurationEntry[] entry) {
            this.mName = name;
            this.mEntry = entry;
        }

        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            return name.equals(this.mName) ? this.mEntry : null;
        }

        public void refresh() {
        }
    }
}

