/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.gal;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.gal.GalConstants;
import com.zimbra.cs.account.gal.GalOp;
import com.zimbra.cs.account.gal.GalParams;
import com.zimbra.cs.account.ldap.LdapProvisioning;
import com.zimbra.cs.account.ldap.LdapUtil;
import java.util.HashMap;

public class GalUtil {
    public static String expandFilter(String tokenize, String filterTemplate, String key, String token, boolean internal) throws ServiceException {
        String query;
        if (key != null) {
            while (key.startsWith("*")) {
                key = key.substring(1);
            }
            while (key.endsWith("*")) {
                key = key.substring(0, key.length() - 1);
            }
        }
        if ((query = GalUtil.expandKey(tokenize, filterTemplate, key)).indexOf("**") > 0) {
            query = query.replaceAll("\\*\\*", "*");
        }
        if (token != null && token.length() > 0) {
            String arg = LdapUtil.escapeSearchFilterArg(token);
            query = "(&(|(modifyTimeStamp>=" + arg + ")(createTimeStamp>=" + arg + "))" + query + ")";
        }
        return query;
    }

    public static String tokenizeKey(GalParams galParams, GalOp galOp) {
        if (galParams == null) {
            return null;
        }
        if (galOp == GalOp.autocomplete) {
            return galParams.tokenizeAutoCompleteKey();
        }
        if (galOp == GalOp.search) {
            return galParams.tokenizeSearchKey();
        }
        return null;
    }

    private static String expandKey(String tokenize, String filterTemplate, String key) throws ServiceException {
        String[] tokens;
        if (!filterTemplate.startsWith("(")) {
            if (filterTemplate.endsWith(")")) {
                throw ServiceException.INVALID_REQUEST("Unbalanced parenthesis in filter:" + filterTemplate, null);
            }
            filterTemplate = "(" + filterTemplate + ")";
        }
        String query = null;
        HashMap<String, String> vars = new HashMap<String, String>();
        if (tokenize != null && (tokens = key.split("\\s+")).length > 1) {
            String q;
            if (GalConstants.TOKENIZE_KEY_AND.equals(tokenize)) {
                q = "(&";
            } else if (GalConstants.TOKENIZE_KEY_OR.equals(tokenize)) {
                q = "(|";
            } else {
                throw ServiceException.FAILURE("invalid attribute value for tokenize key: " + tokenize, null);
            }
            for (String t : tokens) {
                vars.clear();
                vars.put("s", t);
                q = q + LdapProvisioning.expandStr(filterTemplate, vars);
            }
            query = q = q + ")";
        }
        if (query == null) {
            vars.put("s", key);
            query = LdapProvisioning.expandStr(filterTemplate, vars);
        }
        return query;
    }
}

