/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.gal;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.gal.GalOp;
import com.zimbra.cs.account.ldap.LdapGalCredential;
import com.zimbra.cs.account.ldap.LdapUtil;
import com.zimbra.cs.account.ldap.ZimbraLdapContext;
import java.util.Map;

public abstract class GalParams {
    int mPageSize;
    String mTokenizeAutoCompleteKey;
    String mTokenizeSearchKey;

    GalParams(Entry ldapEntry, GalOp galOp) throws ServiceException {
        String pageSize = null;
        if (galOp == GalOp.sync) {
            pageSize = ldapEntry.getAttr("zimbraGalSyncLdapPageSize");
            if (pageSize == null) {
                pageSize = ldapEntry.getAttr("zimbraGalLdapPageSize");
            }
        } else {
            pageSize = ldapEntry.getAttr("zimbraGalLdapPageSize");
        }
        this.setPageSize(pageSize);
        this.mTokenizeAutoCompleteKey = ldapEntry.getAttr("zimbraGalTokenizeAutoCompleteKey");
        this.mTokenizeSearchKey = ldapEntry.getAttr("zimbraGalTokenizeSearchKey");
    }

    GalParams(Map attrs, GalOp galOp) {
        String pageSize = null;
        if (galOp == GalOp.sync) {
            pageSize = (String)attrs.get("zimbraGalSyncLdapPageSize");
            if (pageSize == null) {
                pageSize = (String)attrs.get("zimbraGalLdapPageSize");
            }
        } else {
            pageSize = (String)attrs.get("zimbraGalLdapPageSize");
        }
        this.setPageSize(pageSize);
        this.mTokenizeAutoCompleteKey = (String)attrs.get("zimbraGalTokenizeAutoCompleteKey");
        this.mTokenizeSearchKey = (String)attrs.get("zimbraGalTokenizeSearchKey");
    }

    private void setPageSize(String pageSize) {
        if (pageSize == null) {
            pageSize = "1000";
        }
        try {
            this.mPageSize = Integer.parseInt(pageSize);
        }
        catch (NumberFormatException e) {
            this.mPageSize = 0;
        }
    }

    public int pageSize() {
        return this.mPageSize;
    }

    public String tokenizeAutoCompleteKey() {
        return this.mTokenizeAutoCompleteKey;
    }

    public String tokenizeSearchKey() {
        return this.mTokenizeSearchKey;
    }

    public static class ExternalGalParams
    extends GalParams {
        String[] mUrl;
        boolean mRequireStartTLS;
        String mSearchBase;
        String mFilter;
        LdapGalCredential mCredential;

        public ExternalGalParams(Entry ldapEntry, GalOp galOp) throws ServiceException {
            super(ldapEntry, galOp);
            String krb5Keytab;
            String krb5Principal;
            String bindPassword;
            String bindDn;
            String authMech;
            String startTlsEnabled;
            if (galOp == GalOp.sync) {
                this.mUrl = ldapEntry.getMultiAttr("zimbraGalSyncLdapURL");
                this.mSearchBase = ldapEntry.getAttr("zimbraGalSyncLdapSearchBase");
                this.mFilter = ldapEntry.getAttr("zimbraGalSyncLdapFilter");
                startTlsEnabled = ldapEntry.getAttr("zimbraGalSyncLdapStartTlsEnabled");
                authMech = ldapEntry.getAttr("zimbraGalSyncLdapAuthMech");
                bindDn = ldapEntry.getAttr("zimbraGalSyncLdapBindDn");
                bindPassword = ldapEntry.getAttr("zimbraGalSyncLdapBindPassword");
                krb5Principal = ldapEntry.getAttr("zimbraGalSyncLdapKerberos5Principal");
                krb5Keytab = ldapEntry.getAttr("zimbraGalSyncLdapKerberos5Keytab");
                if (this.mUrl == null || this.mUrl.length == 0) {
                    this.mUrl = ldapEntry.getMultiAttr("zimbraGalLdapURL");
                }
                if (this.mSearchBase == null) {
                    this.mSearchBase = ldapEntry.getAttr("zimbraGalLdapSearchBase", "");
                }
                if (this.mFilter == null) {
                    this.mFilter = ldapEntry.getAttr("zimbraGalLdapFilter");
                }
                if (startTlsEnabled == null) {
                    startTlsEnabled = ldapEntry.getAttr("zimbraGalLdapStartTlsEnabled");
                }
                if (authMech == null) {
                    authMech = ldapEntry.getAttr("zimbraGalLdapAuthMech");
                }
                if (bindDn == null) {
                    bindDn = ldapEntry.getAttr("zimbraGalLdapBindDn");
                }
                if (bindPassword == null) {
                    bindPassword = ldapEntry.getAttr("zimbraGalLdapBindPassword");
                }
                if (krb5Principal == null) {
                    krb5Principal = ldapEntry.getAttr("zimbraGalLdapKerberos5Principal");
                }
                if (krb5Keytab == null) {
                    krb5Keytab = ldapEntry.getAttr("zimbraGalLdapKerberos5Keytab");
                }
            } else {
                this.mUrl = ldapEntry.getMultiAttr("zimbraGalLdapURL");
                this.mSearchBase = ldapEntry.getAttr("zimbraGalLdapSearchBase", "");
                this.mFilter = galOp == GalOp.autocomplete ? ldapEntry.getAttr("zimbraGalAutoCompleteLdapFilter") : ldapEntry.getAttr("zimbraGalLdapFilter");
                startTlsEnabled = ldapEntry.getAttr("zimbraGalLdapStartTlsEnabled");
                authMech = ldapEntry.getAttr("zimbraGalLdapAuthMech");
                bindDn = ldapEntry.getAttr("zimbraGalLdapBindDn");
                bindPassword = ldapEntry.getAttr("zimbraGalLdapBindPassword");
                krb5Principal = ldapEntry.getAttr("zimbraGalLdapKerberos5Principal");
                krb5Keytab = ldapEntry.getAttr("zimbraGalLdapKerberos5Keytab");
            }
            boolean startTLS = startTlsEnabled == null ? false : "TRUE".equals(startTlsEnabled);
            this.mRequireStartTLS = ZimbraLdapContext.requireStartTLS(this.mUrl, startTLS);
            this.mCredential = new LdapGalCredential(authMech, bindDn, bindPassword, krb5Principal, krb5Keytab);
        }

        public ExternalGalParams(Map attrs, GalOp galOp) throws ServiceException {
            super(attrs, galOp);
            String krb5Keytab;
            String krb5Principal;
            String bindPassword;
            String bindDn;
            String authMech;
            String startTlsEnabled;
            if (galOp == GalOp.sync) {
                this.mUrl = ExternalGalParams.getMultiAttr(attrs, "zimbraGalSyncLdapURL", false);
                this.mSearchBase = (String)attrs.get("zimbraGalSyncLdapSearchBase");
                this.mFilter = (String)attrs.get("zimbraGalSyncLdapFilter");
                startTlsEnabled = (String)attrs.get("zimbraGalSyncLdapStartTlsEnabled");
                authMech = (String)attrs.get("zimbraGalSyncLdapAuthMech");
                bindDn = (String)attrs.get("zimbraGalSyncLdapBindDn");
                bindPassword = (String)attrs.get("zimbraGalSyncLdapBindPassword");
                krb5Principal = (String)attrs.get("zimbraGalSyncLdapKerberos5Principal");
                krb5Keytab = (String)attrs.get("zimbraGalSyncLdapKerberos5Keytab");
                if (this.mUrl == null || this.mUrl.length == 0) {
                    this.mUrl = ExternalGalParams.getMultiAttr(attrs, "zimbraGalLdapURL", true);
                }
                if (this.mSearchBase == null) {
                    this.mSearchBase = ExternalGalParams.getRequiredAttr(attrs, "zimbraGalLdapSearchBase");
                }
                if (this.mFilter == null) {
                    this.mFilter = ExternalGalParams.getRequiredAttr(attrs, "zimbraGalLdapFilter");
                }
                if (startTlsEnabled == null) {
                    startTlsEnabled = (String)attrs.get("zimbraGalLdapStartTlsEnabled");
                }
                if (authMech == null) {
                    authMech = (String)attrs.get("zimbraGalLdapAuthMech");
                }
                if (bindDn == null) {
                    bindDn = (String)attrs.get("zimbraGalLdapBindDn");
                }
                if (bindPassword == null) {
                    bindPassword = (String)attrs.get("zimbraGalLdapBindPassword");
                }
                if (krb5Principal == null) {
                    krb5Principal = (String)attrs.get("zimbraGalLdapKerberos5Principal");
                }
                if (krb5Keytab == null) {
                    krb5Keytab = (String)attrs.get("zimbraGalLdapKerberos5Keytab");
                }
            } else {
                this.mUrl = ExternalGalParams.getMultiAttr(attrs, "zimbraGalLdapURL", true);
                this.mSearchBase = ExternalGalParams.getRequiredAttr(attrs, "zimbraGalLdapSearchBase");
                this.mFilter = galOp == GalOp.autocomplete ? ExternalGalParams.getRequiredAttr(attrs, "zimbraGalAutoCompleteLdapFilter") : ExternalGalParams.getRequiredAttr(attrs, "zimbraGalLdapFilter");
                startTlsEnabled = (String)attrs.get("zimbraGalLdapStartTlsEnabled");
                authMech = (String)attrs.get("zimbraGalLdapAuthMech");
                bindDn = (String)attrs.get("zimbraGalLdapBindDn");
                bindPassword = (String)attrs.get("zimbraGalLdapBindPassword");
                krb5Principal = (String)attrs.get("zimbraGalLdapKerberos5Principal");
                krb5Keytab = (String)attrs.get("zimbraGalLdapKerberos5Keytab");
            }
            boolean startTLS = startTlsEnabled == null ? false : "TRUE".equals(startTlsEnabled);
            this.mRequireStartTLS = ZimbraLdapContext.requireStartTLS(this.mUrl, startTLS);
            this.mCredential = new LdapGalCredential(authMech, bindDn, bindPassword, krb5Principal, krb5Keytab);
        }

        private static String[] getMultiAttr(Map attrs, String name, boolean required) throws ServiceException {
            String[] value;
            Object v = attrs.get(name);
            if (v instanceof String) {
                return new String[]{(String)v};
            }
            if (v instanceof String[] && (value = (String[])v) != null && value.length > 0) {
                return value;
            }
            if (required) {
                throw ServiceException.INVALID_REQUEST("must specifiy: " + name, null);
            }
            return null;
        }

        private static String getRequiredAttr(Map attrs, String name) throws ServiceException {
            String value = (String)attrs.get(name);
            if (value == null) {
                throw ServiceException.INVALID_REQUEST("must specifiy: " + name, null);
            }
            return value;
        }

        public String[] url() {
            return this.mUrl;
        }

        public boolean requireStartTLS() {
            return this.mRequireStartTLS;
        }

        public String searchBase() {
            return this.mSearchBase;
        }

        public String filter() {
            return this.mFilter;
        }

        public LdapGalCredential credential() {
            return this.mCredential;
        }
    }

    public static class ZimbraGalParams
    extends GalParams {
        String mSearchBase;

        public ZimbraGalParams(Domain domain, GalOp galOp) throws ServiceException {
            super(domain, galOp);
            this.mSearchBase = LdapUtil.getZimbraSearchBase(domain, galOp);
        }

        public String searchBase() {
            return this.mSearchBase;
        }
    }
}

