/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.callback;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AttributeCallback;
import com.zimbra.cs.account.Entry;
import java.util.Map;
import java.util.Set;

public class WhiteBlackList
extends AttributeCallback {
    public static final String CALLBACK_KEY_zimbraMailWhitelistMaxNumEntries = "CALLBACK_KEY_zimbraMailWhitelistMaxNumEntries";
    public static final String CALLBACK_KEY_zimbraMailBlacklistMaxNumEntries = "CALLBACK_KEY_zimbraMailBlacklistMaxNumEntries";

    public void preModify(Map context, String attrName, Object attrValue, Map attrsToModify, Entry entry, boolean isCreate) throws ServiceException {
        if (entry != null && !(entry instanceof Account)) {
            return;
        }
        Account acct = (Account)entry;
        String max = isCreate || entry == null ? ("amavisWhitelistSender".equals(attrName) ? (String)context.get(CALLBACK_KEY_zimbraMailWhitelistMaxNumEntries) : (String)context.get(CALLBACK_KEY_zimbraMailBlacklistMaxNumEntries)) : ("amavisWhitelistSender".equals(attrName) ? acct.getAttr("zimbraMailWhitelistMaxNumEntries") : acct.getAttr("zimbraMailBlacklistMaxNumEntries"));
        if (max != null) {
            this.check(max, acct, attrName, attrsToModify);
        }
    }

    public void postModify(Map context, String attrName, Entry entry, boolean isCreate) {
    }

    private void check(String max, Account acct, String attrName, Map attrsToModify) throws ServiceException {
        int numMax = Integer.valueOf(max);
        Object replace = attrsToModify.get(attrName);
        Object add = attrsToModify.get("+" + attrName);
        Object remove = attrsToModify.get("-" + attrName);
        if ((add != null || remove != null) && replace != null) {
            throw ServiceException.INVALID_REQUEST("can't mix +attrName/-attrName with attrName", null);
        }
        if (replace != null) {
            Set<String> mods = this.getMultiValueSet(replace);
            if (mods.size() > numMax) {
                this.throwLimitExceeded(attrName, numMax);
            }
        } else if (acct == null) {
            Set<String> mods = this.getMultiValueSet(add);
            if (mods.size() > numMax) {
                this.throwLimitExceeded(attrName, numMax);
            }
        } else {
            Set<String> mods;
            Set<String> curValues = acct.getMultiAttrSet(attrName);
            int curNum = curValues.size();
            int numToAdd = 0;
            if (add != null) {
                mods = this.getMultiValueSet(add);
                for (String s : mods) {
                    if (curValues.contains(s)) continue;
                    ++numToAdd;
                }
            }
            int numToRemove = 0;
            if (remove != null) {
                mods = this.getMultiValueSet(remove);
                for (String s : mods) {
                    if (!curValues.contains(s)) continue;
                    ++numToRemove;
                }
            }
            if (curNum > numMax) {
                if (add != null) {
                    ZimbraLog.account.warn("number of values for " + attrName + " already exceeded the limit: " + numMax + ", additional values are ignored");
                    attrsToModify.remove("+" + attrName);
                    if (remove == null) {
                        this.throwLimitExceeded(attrName, numMax);
                    }
                }
            } else {
                int newNum = curNum + numToAdd - numToRemove;
                if (newNum > numMax) {
                    this.throwLimitExceeded(attrName, numMax);
                }
            }
        }
    }

    private void throwLimitExceeded(String attrName, int numMax) throws ServiceException {
        throw ServiceException.INVALID_REQUEST("exceed limit for " + attrName + ", max is " + numMax, null);
    }
}

