/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.callback;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AttributeCallback;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.mailbox.MessageCache;
import com.zimbra.cs.store.BlobInputStream;
import com.zimbra.cs.store.StorageCallback;
import com.zimbra.cs.util.JMSession;
import java.util.Map;

public class ServerConfig
extends AttributeCallback {
    public void postModify(Map context, String attrName, Entry entry, boolean isCreate) {
        try {
            if (attrName.equals("zimbraMailUncompressedCacheMaxBytes") || attrName.equals("zimbraMailUncompressedCacheMaxFiles") || attrName.equals("zimbraMailFileDescriptorCacheSize")) {
                BlobInputStream.getFileDescriptorCache().loadSettings();
            } else if (attrName.equals("zimbraMailDiskStreamingThreshold")) {
                StorageCallback.loadSettings();
            } else if (attrName.equals("zimbraMessageCacheSize")) {
                MessageCache.loadSettings();
            } else if (attrName.equals("zimbraSmtpHostname")) {
                JMSession.resetSmtpHosts();
            } else if (attrName.equals("zimbraDatabaseSlowSqlThreshold")) {
                DbPool.loadSettings();
            }
        }
        catch (ServiceException e) {
            ZimbraLog.account.warn("Unable to update %s.", (Object)attrName, e);
        }
    }

    public void preModify(Map context, String attrName, Object attrValue, Map attrsToModify, Entry entry, boolean isCreate) throws ServiceException {
    }
}

