/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.callback;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AttributeCallback;
import com.zimbra.cs.account.Entry;
import java.util.Map;

public class PrefMailForwardingAddress
extends AttributeCallback {
    public static final String CALLBACK_KEY_PREF_MAIL_FORWARDING_ADDRESS_MAX_LEN = "CALLBACK_KEY_PREF_MAIL_FORWARDING_ADDRESS_MAX_LEN";
    public static final String CALLBACK_KEY_PREF_MAIL_FORWARDING_ADDRESS_MAX_NUM_ADDRS = "CALLBACK_KEY_PREF_MAIL_FORWARDING_ADDRESS_MAX_NUM_ADDRS";

    public void preModify(Map context, String attrName, Object attrValue, Map attrsToModify, Entry entry, boolean isCreate) throws ServiceException {
        String newValue;
        String maxAddrsInCtxt;
        if (entry != null && !(entry instanceof Account)) {
            return;
        }
        AttributeCallback.SingleValueMod mod = this.singleValueMod(attrsToModify, attrName);
        if (mod.unsetting()) {
            return;
        }
        int maxLen = -1;
        int maxAddrs = -1;
        String maxLenInCtxt = (String)context.get(CALLBACK_KEY_PREF_MAIL_FORWARDING_ADDRESS_MAX_LEN);
        if (maxLenInCtxt != null) {
            try {
                maxLen = Integer.parseInt(maxLenInCtxt);
            }
            catch (NumberFormatException e) {
                ZimbraLog.account.warn("encountered invalid CALLBACK_KEY_PREF_MAIL_FORWARDING_ADDRESS_MAX_LEN: " + maxLenInCtxt);
            }
        }
        if ((maxAddrsInCtxt = (String)context.get(CALLBACK_KEY_PREF_MAIL_FORWARDING_ADDRESS_MAX_NUM_ADDRS)) != null) {
            try {
                maxLen = Integer.parseInt(maxAddrsInCtxt);
            }
            catch (NumberFormatException e) {
                ZimbraLog.account.warn("encountered invalid CALLBACK_KEY_PREF_MAIL_FORWARDING_ADDRESS_MAX_NUM_ADDRS: " + maxAddrsInCtxt);
            }
        }
        if (entry == null) {
            return;
        }
        Account account = (Account)entry;
        if (maxLen == -1) {
            maxLen = account.getMailForwardingAddressMaxLength();
        }
        if (maxAddrs == -1) {
            maxAddrs = account.getMailForwardingAddressMaxNumAddrs();
        }
        if ((newValue = mod.value()).length() > maxLen) {
            throw ServiceException.INVALID_REQUEST("value is too long, the limit(zimbraMailForwardingAddressMaxLength) is " + maxLen, null);
        }
        String[] addrs = newValue.split(",");
        if (addrs.length > maxAddrs) {
            throw ServiceException.INVALID_REQUEST("value is too long, the limit(zimbraMailForwardingAddressMaxNumAddrs) is " + maxAddrs, null);
        }
    }

    public void postModify(Map context, String attrName, Entry entry, boolean isCreate) {
    }
}

