/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.callback;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AttributeCallback;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.db.DbMailbox;
import com.zimbra.cs.db.DbOutOfOffice;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import java.util.Map;

public class OutOfOfficeCallback
extends AttributeCallback {
    private static final String KEY = OutOfOfficeCallback.class.getName();

    public void preModify(Map context, String attrName, Object value, Map attrsToModify, Entry entry, boolean isCreate) {
    }

    public void postModify(Map context, String attrName, Entry entry, boolean isCreate) {
        Object done;
        if (!isCreate && (done = context.get(KEY)) == null) {
            context.put(KEY, KEY);
            ZimbraLog.misc.info("need to reset vacation info");
            if (entry instanceof Account) {
                this.handleOutOfOffice((Account)entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleOutOfOffice(Account account) {
        try {
            Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(account);
            Object object = DbMailbox.getZimbraSynchronizer(mbox);
            synchronized (object) {
                block8: {
                    DbPool.Connection conn = null;
                    try {
                        try {
                            conn = DbPool.getConnection(mbox);
                            DbOutOfOffice.clear(conn, mbox);
                            conn.commit();
                            ZimbraLog.misc.info("reset vacation info");
                            long interval = account.getTimeInterval("zimbraPrefOutOfOfficeCacheDuration", 604800000L);
                            DbOutOfOffice.prune(conn, interval);
                            conn.commit();
                        }
                        catch (ServiceException e) {
                            DbPool.quietRollback(conn);
                            Object var8_9 = null;
                            DbPool.quietClose(conn);
                            break block8;
                        }
                        Object var8_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        DbPool.quietClose(conn);
                        throw throwable;
                    }
                    DbPool.quietClose(conn);
                }
                return;
            }
        }
        catch (ServiceException e) {
            ZimbraLog.misc.warn((Object)"error handling out-of-office", e);
        }
    }
}

